# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # ExascaleDbStorageVault represents a storage vault exadb vm cluster resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/ExascaleDbStorageVault/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the ExascaleDbStorageVault.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/exascaleDbStorageVaults/\\{exascale_db_storage_vault}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name for the ExascaleDbStorageVault. The name does
        #     not have to be unique within your project. The name must be 1-255
        #     characters long and can only contain alphanumeric characters.
        # @!attribute [rw] gcp_oracle_zone
        #   @return [::String]
        #     Optional. The GCP Oracle zone where Oracle ExascaleDbStorageVault is
        #     hosted. Example: us-east4-b-r2. If not specified, the system will pick a
        #     zone based on availability.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVaultProperties]
        #     Required. The properties of the ExascaleDbStorageVault.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time when the ExascaleDbStorageVault was created.
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. The ID of the subscription entitlement associated with the
        #     ExascaleDbStorageVault.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels or tags associated with the ExascaleDbStorageVault.
        class ExascaleDbStorageVault
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The properties of the ExascaleDbStorageVault.
        # next ID: 12
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. The OCID for the ExascaleDbStorageVault.
        # @!attribute [r] time_zone
        #   @return [::Google::Type::TimeZone]
        #     Output only. The time zone of the ExascaleDbStorageVault.
        # @!attribute [rw] exascale_db_storage_details
        #   @return [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageDetails]
        #     Required. The storage details of the ExascaleDbStorageVault.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVaultProperties::State]
        #     Output only. The state of the ExascaleDbStorageVault.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the ExascaleDbStorageVault.
        # @!attribute [r] vm_cluster_ids
        #   @return [::Array<::String>]
        #     Output only. The list of VM cluster OCIDs associated with the
        #     ExascaleDbStorageVault.
        # @!attribute [r] vm_cluster_count
        #   @return [::Integer]
        #     Output only. The number of VM clusters associated with the
        #     ExascaleDbStorageVault.
        # @!attribute [rw] additional_flash_cache_percent
        #   @return [::Integer]
        #     Optional. The size of additional flash cache in percentage of high capacity
        #     database storage.
        # @!attribute [r] oci_uri
        #   @return [::String]
        #     Output only. Deep link to the OCI console to view this resource.
        # @!attribute [r] attached_shape_attributes
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVaultProperties::ShapeAttribute>]
        #     Output only. The shape attributes of the VM clusters attached to the
        #     ExascaleDbStorageVault.
        # @!attribute [r] available_shape_attributes
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVaultProperties::ShapeAttribute>]
        #     Output only. The shape attributes available for the VM clusters to be
        #     attached to the ExascaleDbStorageVault.
        class ExascaleDbStorageVaultProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The state of the ExascaleDbStorageVault.
          module State
            # The state of the ExascaleDbStorageVault is unspecified.
            STATE_UNSPECIFIED = 0

            # The ExascaleDbStorageVault is being provisioned.
            PROVISIONING = 1

            # The ExascaleDbStorageVault is available.
            AVAILABLE = 2

            # The ExascaleDbStorageVault is being updated.
            UPDATING = 3

            # The ExascaleDbStorageVault is being deleted.
            TERMINATING = 4

            # The ExascaleDbStorageVault has been deleted.
            TERMINATED = 5

            # The ExascaleDbStorageVault has failed.
            FAILED = 6
          end

          # The shape attribute of the VM clusters attached to the
          # ExascaleDbStorageVault.
          module ShapeAttribute
            # Default unspecified value.
            SHAPE_ATTRIBUTE_UNSPECIFIED = 0

            # Indicates that the resource is in smart storage.
            SMART_STORAGE = 1

            # Indicates that the resource is in block storage.
            BLOCK_STORAGE = 2
          end
        end

        # The storage details of the ExascaleDbStorageVault.
        # @!attribute [r] available_size_gbs
        #   @return [::Integer]
        #     Output only. The available storage capacity for the ExascaleDbStorageVault,
        #     in gigabytes (GB).
        # @!attribute [rw] total_size_gbs
        #   @return [::Integer]
        #     Required. The total storage allocation for the ExascaleDbStorageVault, in
        #     gigabytes (GB).
        class ExascaleDbStorageDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `ExascaleDbStorageVault.Get`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ExascaleDbStorageVault in the following format:
        #     projects/\\{project}/locations/\\{location}/exascaleDbStorageVaults/\\{exascale_db_storage_vault}.
        class GetExascaleDbStorageVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `ExascaleDbStorageVault.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for ExascaleDbStorageVault in the following
        #     format: projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, at most 50 ExascaleDbStorageVaults will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request. Filter
        #     the list as specified in https://google.aip.dev/160.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. An expression for ordering the results of the request. Order
        #     results as specified in https://google.aip.dev/132.
        class ListExascaleDbStorageVaultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `ExascaleDbStorageVault.List`.
        # @!attribute [rw] exascale_db_storage_vaults
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault>]
        #     The ExascaleDbStorageVaults.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return. If present,
        #     the next page token can be provided to a subsequent
        #     ListExascaleDbStorageVaults call to list the next page.
        #     If empty, there are no more pages.
        class ListExascaleDbStorageVaultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `ExascaleDbStorageVault.Create`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The value for parent of the ExascaleDbStorageVault in the
        #     following format: projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] exascale_db_storage_vault_id
        #   @return [::String]
        #     Required. The ID of the ExascaleDbStorageVault to create. This value is
        #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
        #     63 characters in length. The value must start with a letter and end with a
        #     letter or a number.
        # @!attribute [rw] exascale_db_storage_vault
        #   @return [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateExascaleDbStorageVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for `ExascaleDbStorageVault.Delete`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ExascaleDbStorageVault in the following format:
        #     projects/\\{project}/locations/\\{location}/exascaleDbStorageVaults/\\{exascale_db_storage_vault}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional ID to identify the request. This value is used to
        #     identify duplicate requests. If you make a request with the same request ID
        #     and the original request is still in progress or completed, the server
        #     ignores the second request. This prevents clients from
        #     accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteExascaleDbStorageVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
