# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # ExadbVmCluster represents a cluster of VMs that are used to run Exadata
        # workloads.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/ExadbVmCluster/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the ExadbVmCluster resource in the following
        #     format:
        #     projects/\\{project}/locations/\\{region}/exadbVmClusters/\\{exadb_vm_cluster}
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::ExadbVmClusterProperties]
        #     Required. The properties of the ExadbVmCluster.
        # @!attribute [r] gcp_oracle_zone
        #   @return [::String]
        #     Output only. Immutable. The GCP Oracle zone where Oracle ExadbVmCluster is
        #     hosted. Example: us-east4-b-r2. During creation, the system will pick the
        #     zone assigned to the ExascaleDbStorageVault.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels or tags associated with the ExadbVmCluster.
        # @!attribute [rw] odb_network
        #   @return [::String]
        #     Optional. Immutable. The name of the OdbNetwork associated with the
        #     ExadbVmCluster. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network} It is
        #     optional but if specified, this should match the parent ODBNetwork of the
        #     OdbSubnet.
        # @!attribute [rw] odb_subnet
        #   @return [::String]
        #     Required. Immutable. The name of the OdbSubnet associated with the
        #     ExadbVmCluster for IP allocation. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}
        # @!attribute [rw] backup_odb_subnet
        #   @return [::String]
        #     Required. Immutable. The name of the backup OdbSubnet associated with the
        #     ExadbVmCluster. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Immutable. The display name for the ExadbVmCluster. The name does
        #     not have to be unique within your project. The name must be 1-255
        #     characters long and can only contain alphanumeric characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the ExadbVmCluster was created.
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. The ID of the subscription entitlement associated with the
        #     ExadbVmCluster.
        class ExadbVmCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The storage allocation for the exadbvmcluster, in gigabytes (GB).
        # @!attribute [rw] size_in_gbs_per_node
        #   @return [::Integer]
        #     Required. The storage allocation for the exadbvmcluster per node, in
        #     gigabytes (GB). This field is used to calculate the total storage
        #     allocation for the exadbvmcluster.
        class ExadbVmClusterStorageDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The properties of an ExadbVmCluster.
        # @!attribute [rw] cluster_name
        #   @return [::String]
        #     Optional. Immutable. The cluster name for Exascale vm cluster. The cluster
        #     name must begin with an alphabetic character and may contain hyphens(-) but
        #     can not contain underscores(_). It should be not more than 11 characters
        #     and is not case sensitive. OCI Cluster name.
        # @!attribute [rw] grid_image_id
        #   @return [::String]
        #     Required. Immutable. Grid Infrastructure Version.
        # @!attribute [rw] node_count
        #   @return [::Integer]
        #     Required. The number of nodes/VMs in the ExadbVmCluster.
        # @!attribute [rw] enabled_ecpu_count_per_node
        #   @return [::Integer]
        #     Required. Immutable. The number of ECPUs enabled per node for an exadata vm
        #     cluster on exascale infrastructure.
        # @!attribute [rw] additional_ecpu_count_per_node
        #   @return [::Integer]
        #     Optional. Immutable. The number of additional ECPUs per node for an Exadata
        #     VM cluster on exascale infrastructure.
        # @!attribute [rw] vm_file_system_storage
        #   @return [::Google::Cloud::OracleDatabase::V1::ExadbVmClusterStorageDetails]
        #     Required. Immutable. Total storage details for the ExadbVmCluster.
        # @!attribute [rw] license_model
        #   @return [::Google::Cloud::OracleDatabase::V1::ExadbVmClusterProperties::LicenseModel]
        #     Optional. Immutable. The license type of the ExadbVmCluster.
        # @!attribute [rw] exascale_db_storage_vault
        #   @return [::String]
        #     Required. Immutable. The name of ExascaleDbStorageVault associated with the
        #     ExadbVmCluster. It can refer to an existing ExascaleDbStorageVault. Or a
        #     new one can be created during the ExadbVmCluster creation (requires
        #     storage_vault_properties to be set).
        #     Format:
        #     projects/\\{project}/locations/\\{location}/exascaleDbStorageVaults/\\{exascale_db_storage_vault}
        # @!attribute [rw] hostname_prefix
        #   @return [::String]
        #     Required. Immutable. Prefix for VM cluster host names.
        # @!attribute [r] hostname
        #   @return [::String]
        #     Output only. The hostname of the ExadbVmCluster.
        # @!attribute [rw] ssh_public_keys
        #   @return [::Array<::String>]
        #     Required. Immutable. The SSH public keys for the ExadbVmCluster.
        # @!attribute [rw] data_collection_options
        #   @return [::Google::Cloud::OracleDatabase::V1::DataCollectionOptionsCommon]
        #     Optional. Immutable. Indicates user preference for data collection options.
        # @!attribute [rw] time_zone
        #   @return [::Google::Type::TimeZone]
        #     Optional. Immutable. The time zone of the ExadbVmCluster.
        # @!attribute [r] lifecycle_state
        #   @return [::Google::Cloud::OracleDatabase::V1::ExadbVmClusterProperties::ExadbVmClusterLifecycleState]
        #     Output only. State of the cluster.
        # @!attribute [rw] shape_attribute
        #   @return [::Google::Cloud::OracleDatabase::V1::ExadbVmClusterProperties::ShapeAttribute]
        #     Required. Immutable. The shape attribute of the VM cluster. The type of
        #     Exascale storage used for Exadata VM cluster. The default is SMART_STORAGE
        #     which supports Oracle Database 23ai and later
        # @!attribute [r] memory_size_gb
        #   @return [::Integer]
        #     Output only. Memory per VM (GB) (Read-only): Shows the amount of memory
        #     allocated to each VM. Memory is calculated based on 2.75 GB per Total
        #     ECPUs.
        # @!attribute [rw] scan_listener_port_tcp
        #   @return [::Integer]
        #     Optional. Immutable. SCAN listener port - TCP
        # @!attribute [r] oci_uri
        #   @return [::String]
        #     Output only. Deep link to the OCI console to view this resource.
        # @!attribute [r] gi_version
        #   @return [::String]
        #     Output only. The Oracle Grid Infrastructure (GI) software version.
        class ExadbVmClusterProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Oracle license model that applies to the ExaScale VM cluster
          module LicenseModel
            # Unspecified.
            LICENSE_MODEL_UNSPECIFIED = 0

            # Default is license included.
            LICENSE_INCLUDED = 1

            # Bring your own license.
            BRING_YOUR_OWN_LICENSE = 2
          end

          # The various lifecycle states of the VM cluster.
          module ExadbVmClusterLifecycleState
            # Default unspecified value.
            EXADB_VM_CLUSTER_LIFECYCLE_STATE_UNSPECIFIED = 0

            # Indicates that the resource is in provisioning state.
            PROVISIONING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in updating state.
            UPDATING = 3

            # Indicates that the resource is in terminating state.
            TERMINATING = 4

            # Indicates that the resource is in terminated state.
            TERMINATED = 5

            # Indicates that the resource is in failed state.
            FAILED = 6

            # Indicates that the resource is in maintenance in progress state.
            MAINTENANCE_IN_PROGRESS = 7
          end

          # The shape attribute of the VM cluster. The type of Exascale storage used
          # for Exadata VM cluster. The default is SMART_STORAGE which supports Oracle
          # Database 23ai and later
          module ShapeAttribute
            # Default unspecified value.
            SHAPE_ATTRIBUTE_UNSPECIFIED = 0

            # Indicates that the resource is in smart storage.
            SMART_STORAGE = 1

            # Indicates that the resource is in block storage.
            BLOCK_STORAGE = 2
          end
        end
      end
    end
  end
end
