# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Represents CloudExadataInfrastructure resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudExadataInfrastructure/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Exadata Infrastructure resource with the
        #     format:
        #     projects/\\{project}/locations/\\{region}/cloudExadataInfrastructures/\\{cloud_exadata_infrastructure}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly name for this resource.
        # @!attribute [rw] gcp_oracle_zone
        #   @return [::String]
        #     Optional. The GCP Oracle zone where Oracle Exadata Infrastructure is
        #     hosted. Example: us-east4-b-r2. If not specified, the system will pick a
        #     zone based on availability.
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. Entitlement ID of the private offer against which this
        #     infrastructure resource is provisioned.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructureProperties]
        #     Optional. Various properties of the infra.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels or tags associated with the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the Exadata Infrastructure was created.
        class CloudExadataInfrastructure
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Various properties of Exadata Infrastructure.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. OCID of created infra.
        #     https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
        # @!attribute [rw] compute_count
        #   @return [::Integer]
        #     Optional. The number of compute servers for the Exadata Infrastructure.
        # @!attribute [rw] storage_count
        #   @return [::Integer]
        #     Optional. The number of Cloud Exadata storage servers for the Exadata
        #     Infrastructure.
        # @!attribute [rw] total_storage_size_gb
        #   @return [::Integer]
        #     Optional. The total storage allocated to the Exadata Infrastructure
        #     resource, in gigabytes (GB).
        # @!attribute [r] available_storage_size_gb
        #   @return [::Integer]
        #     Output only. The available storage can be allocated to the Exadata
        #     Infrastructure resource, in gigabytes (GB).
        # @!attribute [rw] maintenance_window
        #   @return [::Google::Cloud::OracleDatabase::V1::MaintenanceWindow]
        #     Optional. Maintenance window for repair.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructureProperties::State]
        #     Output only. The current lifecycle state of the Exadata Infrastructure.
        # @!attribute [rw] shape
        #   @return [::String]
        #     Required. The shape of the Exadata Infrastructure. The shape determines the
        #     amount of CPU, storage, and memory resources allocated to the instance.
        # @!attribute [r] oci_url
        #   @return [::String]
        #     Output only. Deep link to the OCI console to view this resource.
        # @!attribute [r] cpu_count
        #   @return [::Integer]
        #     Output only. The number of enabled CPU cores.
        # @!attribute [r] max_cpu_count
        #   @return [::Integer]
        #     Output only. The total number of CPU cores available.
        # @!attribute [r] memory_size_gb
        #   @return [::Integer]
        #     Output only. The memory allocated in GBs.
        # @!attribute [r] max_memory_gb
        #   @return [::Integer]
        #     Output only. The total memory available in GBs.
        # @!attribute [r] db_node_storage_size_gb
        #   @return [::Integer]
        #     Output only. The local node storage allocated in GBs.
        # @!attribute [r] max_db_node_storage_size_gb
        #   @return [::Integer]
        #     Output only. The total local node storage available in GBs.
        # @!attribute [r] data_storage_size_tb
        #   @return [::Float]
        #     Output only. Size, in terabytes, of the DATA disk group.
        # @!attribute [r] max_data_storage_tb
        #   @return [::Float]
        #     Output only. The total available DATA disk group size.
        # @!attribute [r] activated_storage_count
        #   @return [::Integer]
        #     Output only. The requested number of additional storage servers activated
        #     for the Exadata Infrastructure.
        # @!attribute [r] additional_storage_count
        #   @return [::Integer]
        #     Output only. The requested number of additional storage servers for the
        #     Exadata Infrastructure.
        # @!attribute [r] db_server_version
        #   @return [::String]
        #     Output only. The software version of the database servers (dom0) in the
        #     Exadata Infrastructure.
        # @!attribute [r] storage_server_version
        #   @return [::String]
        #     Output only. The software version of the storage servers (cells) in the
        #     Exadata Infrastructure.
        # @!attribute [r] next_maintenance_run_id
        #   @return [::String]
        #     Output only. The OCID of the next maintenance run.
        # @!attribute [r] next_maintenance_run_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the next maintenance run will occur.
        # @!attribute [r] next_security_maintenance_run_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the next security maintenance run will occur.
        # @!attribute [rw] customer_contacts
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::CustomerContact>]
        #     Optional. The list of customer contacts.
        # @!attribute [r] monthly_storage_server_version
        #   @return [::String]
        #     Output only. The monthly software version of the storage servers (cells)
        #     in the Exadata Infrastructure. Example: 20.1.15
        # @!attribute [r] monthly_db_server_version
        #   @return [::String]
        #     Output only. The monthly software version of the database servers (dom0)
        #     in the Exadata Infrastructure. Example: 20.1.15
        # @!attribute [r] compute_model
        #   @return [::Google::Cloud::OracleDatabase::V1::ComputeModel]
        #     Output only. The compute model of the Exadata Infrastructure.
        # @!attribute [r] database_server_type
        #   @return [::String]
        #     Output only. The database server type of the Exadata Infrastructure.
        # @!attribute [r] storage_server_type
        #   @return [::String]
        #     Output only. The storage server type of the Exadata Infrastructure.
        class CloudExadataInfrastructureProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various lifecycle states of the Exadata Infrastructure.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # The Exadata Infrastructure is being provisioned.
            PROVISIONING = 1

            # The Exadata Infrastructure is available for use.
            AVAILABLE = 2

            # The Exadata Infrastructure is being updated.
            UPDATING = 3

            # The Exadata Infrastructure is being terminated.
            TERMINATING = 4

            # The Exadata Infrastructure is terminated.
            TERMINATED = 5

            # The Exadata Infrastructure is in failed state.
            FAILED = 6

            # The Exadata Infrastructure is in maintenance.
            MAINTENANCE_IN_PROGRESS = 7
          end
        end

        # Maintenance window as defined by Oracle.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/MaintenanceWindow
        # @!attribute [rw] preference
        #   @return [::Google::Cloud::OracleDatabase::V1::MaintenanceWindow::MaintenanceWindowPreference]
        #     Optional. The maintenance window scheduling preference.
        # @!attribute [rw] months
        #   @return [::Array<::Google::Type::Month>]
        #     Optional. Months during the year when maintenance should be performed.
        # @!attribute [rw] weeks_of_month
        #   @return [::Array<::Integer>]
        #     Optional. Weeks during the month when maintenance should be performed.
        #     Weeks start on the 1st, 8th, 15th, and 22nd days of the month, and have a
        #     duration of 7 days. Weeks start and end based on calendar dates, not days
        #     of the week.
        # @!attribute [rw] days_of_week
        #   @return [::Array<::Google::Type::DayOfWeek>]
        #     Optional. Days during the week when maintenance should be performed.
        # @!attribute [rw] hours_of_day
        #   @return [::Array<::Integer>]
        #     Optional. The window of hours during the day when maintenance should be
        #     performed. The window is a 4 hour slot. Valid values are:
        #       0 - represents time slot 0:00 - 3:59 UTC
        #       4 - represents time slot 4:00 - 7:59 UTC
        #       8 - represents time slot 8:00 - 11:59 UTC
        #       12 - represents time slot 12:00 - 15:59 UTC
        #       16 - represents time slot 16:00 - 19:59 UTC
        #       20 - represents time slot 20:00 - 23:59 UTC
        # @!attribute [rw] lead_time_week
        #   @return [::Integer]
        #     Optional. Lead time window allows user to set a lead time to prepare for a
        #     down time. The lead time is in weeks and valid value is between 1 to 4.
        # @!attribute [rw] patching_mode
        #   @return [::Google::Cloud::OracleDatabase::V1::MaintenanceWindow::PatchingMode]
        #     Optional. Cloud CloudExadataInfrastructure node patching method, either
        #     "ROLLING" or "NONROLLING". Default value is ROLLING.
        # @!attribute [rw] custom_action_timeout_mins
        #   @return [::Integer]
        #     Optional. Determines the amount of time the system will wait before the
        #     start of each database server patching operation. Custom action timeout is
        #     in minutes and valid value is between 15 to 120 (inclusive).
        # @!attribute [rw] is_custom_action_timeout_enabled
        #   @return [::Boolean]
        #     Optional. If true, enables the configuration of a custom action timeout
        #     (waiting period) between database server patching operations.
        class MaintenanceWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Maintenance window preference.
          module MaintenanceWindowPreference
            # Default unspecified value.
            MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED = 0

            # Custom preference.
            CUSTOM_PREFERENCE = 1

            # No preference.
            NO_PREFERENCE = 2
          end

          # Patching mode.
          module PatchingMode
            # Default unspecified value.
            PATCHING_MODE_UNSPECIFIED = 0

            # Updates the Cloud Exadata database server hosts in a rolling fashion.
            ROLLING = 1

            # The non-rolling maintenance method first updates your storage servers at
            # the same time, then your database servers at the same time.
            NON_ROLLING = 2
          end
        end
      end
    end
  end
end
