# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Entitlement resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Entitlement resource with the format:
        #     projects/\\{project}/locations/\\{region}/entitlements/\\{entitlement}
        # @!attribute [rw] cloud_account_details
        #   @return [::Google::Cloud::OracleDatabase::V1::CloudAccountDetails]
        #     Details of the OCI Cloud Account.
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. Google Cloud Marketplace order ID (aka entitlement ID)
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::Entitlement::State]
        #     Output only. Entitlement State.
        class Entitlement
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various lifecycle states of the subscription.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # Account not linked.
            ACCOUNT_NOT_LINKED = 1

            # Account is linked but not active.
            ACCOUNT_NOT_ACTIVE = 2

            # Entitlement and Account are active.
            ACTIVE = 3

            # Account is suspended.
            ACCOUNT_SUSPENDED = 4

            # Entitlement is not approved in private marketplace.
            NOT_APPROVED_IN_PRIVATE_MARKETPLACE = 5
          end
        end

        # Details of the OCI Cloud Account.
        # @!attribute [r] cloud_account
        #   @return [::String]
        #     Output only. OCI account name.
        # @!attribute [r] cloud_account_home_region
        #   @return [::String]
        #     Output only. OCI account home region.
        # @!attribute [r] link_existing_account_uri
        #   @return [::String]
        #     Output only. URL to link an existing account.
        # @!attribute [r] account_creation_uri
        #   @return [::String]
        #     Output only. URL to create a new account and link.
        class CloudAccountDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
