# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # A valid Oracle Database version.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the DbVersion resource in the following format:
        #     projects/\\{project}/locations/\\{region}/dbVersions/\\{db_version}
        # @!attribute [r] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::DbVersionProperties]
        #     Output only. The properties of the DbVersion.
        class DbVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The properties of a DbVersion.
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. A valid Oracle Database version.
        # @!attribute [r] is_latest_for_major_version
        #   @return [::Boolean]
        #     Output only. True if this version of the Oracle Database software is the
        #     latest version for a release.
        # @!attribute [r] supports_pdb
        #   @return [::Boolean]
        #     Output only. True if this version of the Oracle Database software supports
        #     pluggable databases.
        # @!attribute [r] is_preview_db_version
        #   @return [::Boolean]
        #     Output only. True if this version of the Oracle Database software is the
        #     preview version.
        # @!attribute [r] is_upgrade_supported
        #   @return [::Boolean]
        #     Output only. True if this version of the Oracle Database software is
        #     supported for Upgrade.
        class DbVersionProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `DbVersions.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for the DbVersion resource with the
        #     format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, a maximum of 50 DbVersions will be returned.
        #     The maximum value is 1000; values above 1000 will be reset to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying the requested page of results to return. All
        #     fields except the filter should remain the same as in the request that
        #     provided this page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter expression that matches a subset of the DbVersions to
        #     show. The supported filter for dbSystem creation is `db_system_shape =
        #     \\{db_system_shape} AND storage_management = \\{storage_management}`. If no
        #     filter is provided, all DbVersions will be returned.
        class ListDbVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `DbVersions.List`.
        # @!attribute [rw] db_versions
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::DbVersion>]
        #     The list of DbVersions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListDbVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
