# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Database System Shapes resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbSystemShapeSummary/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Database System Shape resource with the format:
        #     projects/\\{project}/locations/\\{region}/dbSystemShapes/\\{db_system_shape}
        # @!attribute [rw] shape
        #   @return [::String]
        #     Optional. shape
        # @!attribute [rw] min_node_count
        #   @return [::Integer]
        #     Optional. Minimum number of database servers.
        # @!attribute [rw] max_node_count
        #   @return [::Integer]
        #     Optional. Maximum number of database servers.
        # @!attribute [rw] min_storage_count
        #   @return [::Integer]
        #     Optional. Minimum number of storage servers.
        # @!attribute [rw] max_storage_count
        #   @return [::Integer]
        #     Optional. Maximum number of storage servers.
        # @!attribute [rw] available_core_count_per_node
        #   @return [::Integer]
        #     Optional. Number of cores per node.
        # @!attribute [rw] available_memory_per_node_gb
        #   @return [::Integer]
        #     Optional. Memory per database server node in gigabytes.
        # @!attribute [rw] available_data_storage_tb
        #   @return [::Integer]
        #     Optional. Storage per storage server in terabytes.
        # @!attribute [rw] min_core_count_per_node
        #   @return [::Integer]
        #     Optional. Minimum core count per node.
        # @!attribute [rw] min_memory_per_node_gb
        #   @return [::Integer]
        #     Optional. Minimum memory per node in gigabytes.
        # @!attribute [rw] min_db_node_storage_per_node_gb
        #   @return [::Integer]
        #     Optional. Minimum node storage per database server in gigabytes.
        class DbSystemShape
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
