# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Summary of the DbSystem initial storage size.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the resource.
        # @!attribute [r] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSizeProperties]
        #     Output only. The properties of the DbSystem initial storage size summary.
        class DbSystemInitialStorageSize
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The properties of a DbSystem initial storage size summary.
        # @!attribute [r] storage_management
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSizeProperties::StorageManagement]
        #     Output only. The storage option used in DB system.
        # @!attribute [r] shape_type
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSizeProperties::ShapeType]
        #     Output only. VM shape platform type
        # @!attribute [r] storage_size_details
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::StorageSizeDetails>]
        #     Output only. List of storage disk details.
        # @!attribute [r] launch_from_backup_storage_size_details
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::StorageSizeDetails>]
        #     Output only. List of storage disk details available for launches from
        #     backup.
        class DbSystemInitialStorageSizeProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The storage option used in the DB system.
          module StorageManagement
            # Unspecified storage management.
            STORAGE_MANAGEMENT_UNSPECIFIED = 0

            # Automatic Storage Management.
            ASM = 1

            # Logical Volume Management.
            LVM = 2
          end

          # The shape type of the DB system.
          module ShapeType
            # Unspecified shape type.
            SHAPE_TYPE_UNSPECIFIED = 0

            # Standard X86.
            STANDARD_X86 = 1
          end
        end

        # The initial storage size, in gigabytes, that is applicable for virtual
        # machine DBSystem.
        # @!attribute [r] data_storage_size_in_gbs
        #   @return [::Integer]
        #     Output only. The data storage size, in gigabytes, that is applicable for
        #     virtual machine DBSystem.
        # @!attribute [r] reco_storage_size_in_gbs
        #   @return [::Integer]
        #     Output only. The RECO/REDO storage size, in gigabytes, that is applicable
        #     for virtual machine DBSystem.
        class StorageSizeDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `DbSystemInitialStorageSizes.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for the DbSystemInitialStorageSize resource with
        #     the format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, a maximum of 50 DbSystemInitialStorageSizes will be
        #     returned. The maximum value is 1000; values above 1000 will be reset to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying the requested page of results to return. All
        #     fields except the filter should remain the same as in the request that
        #     provided this page token.
        class ListDbSystemInitialStorageSizesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `DbSystemInitialStorageSizes.List`.
        # @!attribute [rw] db_system_initial_storage_sizes
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSize>]
        #     The list of DbSystemInitialStorageSizes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListDbSystemInitialStorageSizesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
