# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the DbSystem (BaseDB) resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbSystem/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the DbSystem resource in the following format:
        #     projects/\\{project}/locations/\\{region}/dbSystems/\\{db_system}
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemProperties]
        #     Optional. The properties of the DbSystem.
        # @!attribute [rw] gcp_oracle_zone
        #   @return [::String]
        #     Optional. The GCP Oracle zone where Oracle DbSystem is hosted.
        #     Example: us-east4-b-r2.
        #     If not specified, the system will pick a zone based on availability.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels or tags associated with the DbSystem.
        # @!attribute [rw] odb_network
        #   @return [::String]
        #     Optional. The name of the OdbNetwork associated with the DbSystem.
        #     Format: projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}
        #     It is optional but if specified, this should match the parent ODBNetwork of
        #     the OdbSubnet.
        # @!attribute [rw] odb_subnet
        #   @return [::String]
        #     Required. The name of the OdbSubnet associated with the DbSystem for IP
        #     allocation. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. The ID of the subscription entitlement associated with the
        #     DbSystem
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name for the System db. The name does not have to
        #     be unique within your project.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the DbSystem was created.
        # @!attribute [r] oci_url
        #   @return [::String]
        #     Output only. HTTPS link to OCI resources exposed to Customer via UI
        #     Interface.
        class DbSystem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The properties of a DbSystem.
        # @!attribute [rw] shape
        #   @return [::String]
        #     Required. Shape of DB System.
        # @!attribute [rw] compute_count
        #   @return [::Integer]
        #     Required. The number of CPU cores to enable for the DbSystem.
        # @!attribute [rw] initial_data_storage_size_gb
        #   @return [::Integer]
        #     Required. The initial data storage size in GB.
        # @!attribute [rw] database_edition
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemProperties::DbSystemDatabaseEdition]
        #     Required. The database edition of the DbSystem.
        # @!attribute [rw] license_model
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemProperties::LicenseModel]
        #     Required. The license model of the DbSystem.
        # @!attribute [rw] ssh_public_keys
        #   @return [::Array<::String>]
        #     Required. SSH public keys to be stored with the DbSystem.
        # @!attribute [rw] hostname_prefix
        #   @return [::String]
        #     Optional. Prefix for DB System host names.
        # @!attribute [r] hostname
        #   @return [::String]
        #     Output only. The hostname of the DbSystem.
        # @!attribute [rw] private_ip
        #   @return [::String]
        #     Optional. The private IP address of the DbSystem.
        # @!attribute [rw] data_collection_options
        #   @return [::Google::Cloud::OracleDatabase::V1::DataCollectionOptionsDbSystem]
        #     Optional. Data collection options for diagnostics.
        # @!attribute [rw] time_zone
        #   @return [::Google::Type::TimeZone]
        #     Optional. Time zone of the DbSystem.
        # @!attribute [r] lifecycle_state
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemProperties::DbSystemLifecycleState]
        #     Output only. State of the DbSystem.
        # @!attribute [rw] db_home
        #   @return [::Google::Cloud::OracleDatabase::V1::DbHome]
        #     Optional. Details for creating a Database Home.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. OCID of the DbSystem.
        # @!attribute [rw] memory_size_gb
        #   @return [::Integer]
        #     Optional. The memory size in GB.
        # @!attribute [rw] compute_model
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemProperties::ComputeModel]
        #     Optional. The compute model of the DbSystem.
        # @!attribute [rw] data_storage_size_gb
        #   @return [::Integer]
        #     Optional. The data storage size in GB that is currently available to
        #     DbSystems.
        # @!attribute [rw] reco_storage_size_gb
        #   @return [::Integer]
        #     Optional. The reco/redo storage size in GB.
        # @!attribute [rw] domain
        #   @return [::String]
        #     Optional. The host domain name of the DbSystem.
        # @!attribute [rw] node_count
        #   @return [::Integer]
        #     Optional. The number of nodes in the DbSystem.
        # @!attribute [rw] db_system_options
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemOptions]
        #     Optional. The options for the DbSystem.
        class DbSystemProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The editions available for DbSystem.
          module DbSystemDatabaseEdition
            # The database edition is unspecified.
            DB_SYSTEM_DATABASE_EDITION_UNSPECIFIED = 0

            # The database edition is Standard.
            STANDARD_EDITION = 1

            # The database edition is Enterprise.
            ENTERPRISE_EDITION = 2

            # The database edition is Enterprise Edition.
            ENTERPRISE_EDITION_HIGH_PERFORMANCE = 3
          end

          # The license model of the DbSystem.
          module LicenseModel
            # The license model is unspecified.
            LICENSE_MODEL_UNSPECIFIED = 0

            # The license model is included.
            LICENSE_INCLUDED = 1

            # The license model is bring your own license.
            BRING_YOUR_OWN_LICENSE = 2
          end

          # The various lifecycle states of the DbSystem.
          module DbSystemLifecycleState
            # Default unspecified value.
            DB_SYSTEM_LIFECYCLE_STATE_UNSPECIFIED = 0

            # Indicates that the resource is in provisioning state.
            PROVISIONING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in updating state.
            UPDATING = 3

            # Indicates that the resource is in terminating state.
            TERMINATING = 4

            # Indicates that the resource is in terminated state.
            TERMINATED = 5

            # Indicates that the resource is in failed state.
            FAILED = 6

            # Indicates that the resource has been migrated.
            MIGRATED = 7

            # Indicates that the resource is in maintenance in progress state.
            MAINTENANCE_IN_PROGRESS = 8

            # Indicates that the resource needs attention.
            NEEDS_ATTENTION = 9

            # Indicates that the resource is upgrading.
            UPGRADING = 10
          end

          # The compute model of the DbSystem.
          module ComputeModel
            # The compute model is unspecified.
            COMPUTE_MODEL_UNSPECIFIED = 0

            # The compute model is virtual.
            ECPU = 1

            # The compute model is physical.
            OCPU = 2
          end
        end

        # Data collection options for DbSystem.
        # @!attribute [rw] is_diagnostics_events_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether to enable data collection for diagnostics.
        # @!attribute [rw] is_incident_logs_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether to enable incident logs and trace collection.
        class DataCollectionOptionsDbSystem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of the DbSystem Options.
        # @!attribute [rw] storage_management
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystemOptions::StorageManagement]
        #     Optional. The storage option used in DB system.
        class DbSystemOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The storage option used in DB system.
          module StorageManagement
            # The storage management is unspecified.
            STORAGE_MANAGEMENT_UNSPECIFIED = 0

            # Automatic storage management.
            ASM = 1

            # Logical Volume management.
            LVM = 2
          end
        end

        # Details of the Database Home resource.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name for the Database Home. The name does not have to
        #     be unique within your project.
        # @!attribute [rw] db_version
        #   @return [::String]
        #     Required. A valid Oracle Database version. For a list of supported
        #     versions, use the ListDbVersions operation.
        # @!attribute [rw] database
        #   @return [::Google::Cloud::OracleDatabase::V1::Database]
        #     Required. The Database resource.
        # @!attribute [rw] is_unified_auditing_enabled
        #   @return [::Boolean]
        #     Optional. Whether unified auditing is enabled for the Database Home.
        class DbHome
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `DbSystem.Create`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The value for parent of the DbSystem in the following format:
        #     projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] db_system_id
        #   @return [::String]
        #     Required. The ID of the DbSystem to create. This value is
        #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
        #     63 characters in length. The value must start with a letter and end with a
        #     letter or a number.
        # @!attribute [rw] db_system
        #   @return [::Google::Cloud::OracleDatabase::V1::DbSystem]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDbSystemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `DbSystem.Delete`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DbSystem in the following format:
        #     projects/\\{project}/locations/\\{location}/dbSystems/\\{db_system}.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional ID to identify the request. This value is used to
        #     identify duplicate requests. If you make a request with the same request ID
        #     and the original request is still in progress or completed, the server
        #     ignores the second request. This prevents clients from
        #     accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteDbSystemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `DbSystem.Get`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DbSystem in the following format:
        #     projects/\\{project}/locations/\\{location}/dbSystems/\\{db_system}.
        class GetDbSystemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `DbSystem.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for DbSystems in the following format:
        #     projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, at most 50 DbSystems will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. An expression for ordering the results of the request.
        class ListDbSystemsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `DbSystem.List`.
        # @!attribute [rw] db_systems
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::DbSystem>]
        #     The list of DbSystems.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListDbSystemsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
