# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the database server resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbServer/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the database server resource with the format:
        #     projects/\\{project}/locations/\\{location}/cloudExadataInfrastructures/\\{cloud_exadata_infrastructure}/dbServers/\\{db_server}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly name for this resource.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::DbServerProperties]
        #     Optional. Various properties of the database server.
        class DbServer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Various properties and settings associated with Exadata database server.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. OCID of database server.
        # @!attribute [rw] ocpu_count
        #   @return [::Integer]
        #     Optional. OCPU count per database.
        # @!attribute [rw] max_ocpu_count
        #   @return [::Integer]
        #     Optional. Maximum OCPU count per database.
        # @!attribute [rw] memory_size_gb
        #   @return [::Integer]
        #     Optional. Memory allocated in GBs.
        # @!attribute [rw] max_memory_size_gb
        #   @return [::Integer]
        #     Optional. Maximum memory allocated in GBs.
        # @!attribute [rw] db_node_storage_size_gb
        #   @return [::Integer]
        #     Optional. Local storage per VM.
        # @!attribute [rw] max_db_node_storage_size_gb
        #   @return [::Integer]
        #     Optional. Maximum local storage per VM.
        # @!attribute [rw] vm_count
        #   @return [::Integer]
        #     Optional. Vm count per database.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::DbServerProperties::State]
        #     Output only. State of the database server.
        # @!attribute [r] db_node_ids
        #   @return [::Array<::String>]
        #     Output only. OCID of database nodes associated with the database server.
        class DbServerProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various lifecycle states of the database server.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # Indicates that the resource is in creating state.
            CREATING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in unavailable state.
            UNAVAILABLE = 3

            # Indicates that the resource is in deleting state.
            DELETING = 4

            # Indicates that the resource is in deleted state.
            DELETED = 5
          end
        end
      end
    end
  end
end
