# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the database node resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbNode/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the database node resource in the following format:
        #     projects/\\{project}/locations/\\{location}/cloudVmClusters/\\{cloud_vm_cluster}/dbNodes/\\{db_node}
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::DbNodeProperties]
        #     Optional. Various properties of the database node.
        class DbNode
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Various properties and settings associated with Db node.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. OCID of database node.
        # @!attribute [rw] ocpu_count
        #   @return [::Integer]
        #     Optional. OCPU count per database node.
        # @!attribute [rw] memory_size_gb
        #   @return [::Integer]
        #     Memory allocated in GBs.
        # @!attribute [rw] db_node_storage_size_gb
        #   @return [::Integer]
        #     Optional. Local storage per database node.
        # @!attribute [rw] db_server_ocid
        #   @return [::String]
        #     Optional. Database server OCID.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Optional. DNS
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::DbNodeProperties::State]
        #     Output only. State of the database node.
        # @!attribute [rw] total_cpu_core_count
        #   @return [::Integer]
        #     Total CPU core count of the database node.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the database node was created.
        class DbNodeProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various lifecycle states of the database node.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # Indicates that the resource is in provisioning state.
            PROVISIONING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in updating state.
            UPDATING = 3

            # Indicates that the resource is in stopping state.
            STOPPING = 4

            # Indicates that the resource is in stopped state.
            STOPPED = 5

            # Indicates that the resource is in starting state.
            STARTING = 6

            # Indicates that the resource is in terminating state.
            TERMINATING = 7

            # Indicates that the resource is in terminated state.
            TERMINATED = 8

            # Indicates that the resource is in failed state.
            FAILED = 9
          end
        end
      end
    end
  end
end
