# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Database character set resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Database Character Set resource in the
        #     following format:
        #     projects/\\{project}/locations/\\{region}/databaseCharacterSets/\\{database_character_set}
        # @!attribute [r] character_set_type
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseCharacterSet::CharacterSetType]
        #     Output only. The character set type for the Database.
        # @!attribute [r] character_set
        #   @return [::String]
        #     Output only. The character set name for the Database which is the ID in the
        #     resource name.
        class DatabaseCharacterSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of character set a Database can have.
          module CharacterSetType
            # Character set type is not specified.
            CHARACTER_SET_TYPE_UNSPECIFIED = 0

            # Character set type is set to database.
            DATABASE = 1

            # Character set type is set to national.
            NATIONAL = 2
          end
        end

        # The request for `DatabaseCharacterSet.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for DatabaseCharacterSets in the following
        #     format: projects/\\{project}/locations/\\{location}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of DatabaseCharacterSets to return. The
        #     service may return fewer than this value. If unspecified, at most 50
        #     DatabaseCharacterSets will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListDatabaseCharacterSets` call. Provide this to retrieve the subsequent
        #     page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDatabaseCharacterSets` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request. Only the
        #     **character_set_type** field is supported in the following format:
        #     `character_set_type="{characterSetType}"`. Accepted values include
        #     `DATABASE` and `NATIONAL`.
        class ListDatabaseCharacterSetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `DatabaseCharacterSet.List`.
        # @!attribute [rw] database_character_sets
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::DatabaseCharacterSet>]
        #     The list of DatabaseCharacterSets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListDatabaseCharacterSetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
