# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Database resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/Database/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Database resource in the following format:
        #     projects/\\{project}/locations/\\{region}/databases/\\{database}
        # @!attribute [rw] db_name
        #   @return [::String]
        #     Optional. The database name. The name must begin with an alphabetic
        #     character and can contain a maximum of eight alphanumeric characters.
        #     Special characters are not permitted.
        # @!attribute [rw] db_unique_name
        #   @return [::String]
        #     Optional. The DB_UNIQUE_NAME of the Oracle Database being backed up.
        # @!attribute [rw] admin_password
        #   @return [::String]
        #     Required. The password for the default ADMIN user.
        # @!attribute [rw] tde_wallet_password
        #   @return [::String]
        #     Optional. The TDE wallet password for the database.
        # @!attribute [rw] character_set
        #   @return [::String]
        #     Optional. The character set for the database. The default is AL32UTF8.
        # @!attribute [rw] ncharacter_set
        #   @return [::String]
        #     Optional. The national character set for the database. The default is
        #     AL16UTF16.
        # @!attribute [r] oci_url
        #   @return [::String]
        #     Output only. HTTPS link to OCI resources exposed to Customer via UI
        #     Interface.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the Database was created.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseProperties]
        #     Optional. The properties of the Database.
        # @!attribute [rw] database_id
        #   @return [::String]
        #     Optional. The database ID of the Database.
        # @!attribute [rw] db_home_name
        #   @return [::String]
        #     Optional. The name of the DbHome resource associated with the Database.
        # @!attribute [r] gcp_oracle_zone
        #   @return [::String]
        #     Output only. The GCP Oracle zone where the Database is created.
        # @!attribute [r] ops_insights_status
        #   @return [::Google::Cloud::OracleDatabase::V1::Database::OperationsInsightsStatus]
        #     Output only. The Status of Operations Insights for this Database.
        class Database
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Status of Operations Insights for this Database.
          module OperationsInsightsStatus
            # Default unspecified value.
            OPERATIONS_INSIGHTS_STATUS_UNSPECIFIED = 0

            # Indicates that the operations insights are being enabled.
            ENABLING = 1

            # Indicates that the operations insights are enabled.
            ENABLED = 2

            # Indicates that the operations insights are being disabled.
            DISABLING = 3

            # Indicates that the operations insights are not enabled.
            NOT_ENABLED = 4

            # Indicates that the operations insights failed to enable.
            FAILED_ENABLING = 5

            # Indicates that the operations insights failed to disable.
            FAILED_DISABLING = 6
          end
        end

        # The properties of a Database.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseProperties::DatabaseLifecycleState]
        #     Output only. State of the Database.
        # @!attribute [rw] db_version
        #   @return [::String]
        #     Required. The Oracle Database version.
        # @!attribute [rw] db_backup_config
        #   @return [::Google::Cloud::OracleDatabase::V1::DbBackupConfig]
        #     Optional. Backup options for the Database.
        # @!attribute [r] database_management_config
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseManagementConfig]
        #     Output only. The Database Management config.
        class DatabaseProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various lifecycle states of the Database.
          module DatabaseLifecycleState
            # Default unspecified value.
            DATABASE_LIFECYCLE_STATE_UNSPECIFIED = 0

            # Indicates that the resource is in provisioning state.
            PROVISIONING = 1

            # Indicates that the resource is in available state.
            AVAILABLE = 2

            # Indicates that the resource is in updating state.
            UPDATING = 3

            # Indicates that the resource is in backup in progress state.
            BACKUP_IN_PROGRESS = 4

            # Indicates that the resource is in upgrading state.
            UPGRADING = 5

            # Indicates that the resource is in converting state.
            CONVERTING = 6

            # Indicates that the resource is in terminating state.
            TERMINATING = 7

            # Indicates that the resource is in terminated state.
            TERMINATED = 8

            # Indicates that the resource is in restore failed state.
            RESTORE_FAILED = 9

            # Indicates that the resource is in failed state.
            FAILED = 10
          end
        end

        # Backup Options for the Database.
        # @!attribute [rw] auto_backup_enabled
        #   @return [::Boolean]
        #     Optional. If set to true, enables automatic backups on the database.
        # @!attribute [rw] backup_destination_details
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::DbBackupConfig::BackupDestinationDetails>]
        #     Optional. Details of the database backup destinations.
        # @!attribute [rw] retention_period_days
        #   @return [::Integer]
        #     Optional. The number of days an automatic backup is retained before being
        #     automatically deleted. This value determines the earliest point in time to
        #     which a database can be restored. Min: 1, Max: 60.
        # @!attribute [rw] backup_deletion_policy
        #   @return [::Google::Cloud::OracleDatabase::V1::DbBackupConfig::BackupDeletionPolicy]
        #     Optional. This defines when the backups will be deleted after Database
        #     termination.
        # @!attribute [rw] auto_full_backup_day
        #   @return [::Google::Type::DayOfWeek]
        #     Optional. The day of the week on which the full backup should be performed
        #     on the database. If no value is provided, it will default to Sunday.
        # @!attribute [rw] auto_full_backup_window
        #   @return [::Google::Cloud::OracleDatabase::V1::DbBackupConfig::BackupWindow]
        #     Optional. The window in which the full backup should be performed on the
        #     database. If no value is provided, the default is anytime.
        # @!attribute [rw] auto_incremental_backup_window
        #   @return [::Google::Cloud::OracleDatabase::V1::DbBackupConfig::BackupWindow]
        #     Optional. The window in which the incremental backup should be performed on
        #     the database. If no value is provided, the default is anytime except the
        #     auto full backup day.
        class DbBackupConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The details of the database backup destination.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::OracleDatabase::V1::DbBackupConfig::BackupDestinationType]
          #     Optional. The type of the database backup destination.
          class BackupDestinationDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the database backup destination.
          module BackupDestinationType
            # Default unspecified value.
            BACKUP_DESTINATION_TYPE_UNSPECIFIED = 0

            # Backup destination type is NFS.
            NFS = 1

            # Backup destination type is Recovery Appliance.
            RECOVERY_APPLIANCE = 2

            # Backup destination type is Object Store.
            OBJECT_STORE = 3

            # Backup destination type is Local.
            LOCAL = 4

            # Backup destination type is DBRS.
            DBRS = 5
          end

          # The 2 hour window in which the backup should be performed on the database.
          module BackupWindow
            # Default unspecified value.
            BACKUP_WINDOW_UNSPECIFIED = 0

            # 12:00 AM - 2:00 AM
            SLOT_ONE = 1

            # 2:00 AM - 4:00 AM
            SLOT_TWO = 2

            # 4:00 AM - 6:00 AM
            SLOT_THREE = 3

            # 6:00 AM - 8:00 AM
            SLOT_FOUR = 4

            # 8:00 AM - 10:00 AM
            SLOT_FIVE = 5

            # 10:00 AM - 12:00 PM
            SLOT_SIX = 6

            # 12:00 PM - 2:00 PM
            SLOT_SEVEN = 7

            # 2:00 PM - 4:00 PM
            SLOT_EIGHT = 8

            # 4:00 PM - 6:00 PM
            SLOT_NINE = 9

            # 6:00 PM - 8:00 PM
            SLOT_TEN = 10

            # 8:00 PM - 10:00 PM
            SLOT_ELEVEN = 11

            # 10:00 PM - 12:00 AM
            SLOT_TWELVE = 12
          end

          # This defines when the backups will be deleted after Database termination.
          module BackupDeletionPolicy
            # Default unspecified value.
            BACKUP_DELETION_POLICY_UNSPECIFIED = 0

            # Keeps the backup for predefined time
            # i.e. 72 hours and then delete permanently.
            DELETE_IMMEDIATELY = 1

            # Keeps the backups as per the policy defined
            # for database backups.
            DELETE_AFTER_RETENTION_PERIOD = 2
          end
        end

        # The request for `Database.Get`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Database resource in the following format:
        #     projects/\\{project}/locations/\\{region}/databases/\\{database}
        class GetDatabaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for `Database.List`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name in the following format:
        #     projects/\\{project}/locations/\\{region}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #     If unspecified, a maximum of 50 Databases will be returned.
        #     The maximum value is 1000; values above 1000 will be reset to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying the requested page of results to return. All
        #     fields except the filter should remain the same as in the request that
        #     provided this page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request. list for
        #     container databases is supported only with a valid dbSystem (full resource
        #     name) filter in this format:
        #     `dbSystem="projects/{project}/locations/{location}/dbSystems/{dbSystemId}"`
        class ListDatabasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for `Database.List`.
        # @!attribute [rw] databases
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::Database>]
        #     The list of Databases.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListDatabasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
