# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # The CustomerContact reference as defined by Oracle.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/CustomerContact
        # @!attribute [rw] email
        #   @return [::String]
        #     Required. The email address used by Oracle to send notifications regarding
        #     databases and infrastructure.
        class CustomerContact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The identity connector details which will allow OCI to securely access
        # the resources in the customer project.
        # @!attribute [r] service_agent_email
        #   @return [::String]
        #     Output only. A google managed service account on which customers can grant
        #     roles to access resources in the customer project. Example:
        #     `p176944527254-55-75119d87fd8f@gcp-sa-oci.iam.gserviceaccount.com`
        # @!attribute [r] connection_state
        #   @return [::Google::Cloud::OracleDatabase::V1::IdentityConnector::ConnectionState]
        #     Output only. The connection state of the identity connector.
        class IdentityConnector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various connection states of the WorkloadIdentityPoolConnection.
          module ConnectionState
            # Default unspecified value.
            CONNECTION_STATE_UNSPECIFIED = 0

            # The identity pool connection is connected.
            CONNECTED = 1

            # The identity pool connection is partially connected.
            PARTIALLY_CONNECTED = 2

            # The identity pool connection is disconnected.
            DISCONNECTED = 3

            # The identity pool connection is in an unknown state.
            UNKNOWN = 4
          end
        end

        # Data collection options for diagnostics.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/DataCollectionOptions
        # @!attribute [rw] is_diagnostics_events_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether to enable data collection for diagnostics.
        # @!attribute [rw] is_health_monitoring_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether to enable health monitoring.
        # @!attribute [rw] is_incident_logs_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether to enable incident logs and trace collection.
        class DataCollectionOptionsCommon
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The compute model of the Exadata Infrastructure, VM Cluster and Autonomous
        # Database.
        module ComputeModel
          # Unspecified compute model.
          COMPUTE_MODEL_UNSPECIFIED = 0

          # Abstract measure of compute resources. ECPUs are based on the number of
          # cores elastically allocated from a pool of compute and storage servers.
          COMPUTE_MODEL_ECPU = 1

          # Physical measure of compute resources. OCPUs are based on the physical
          # core of a processor.
          COMPUTE_MODEL_OCPU = 2
        end
      end
    end
  end
end
