# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Autonomous Database version.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDbVersionSummary/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Autonomous Database Version resource with the
        #     format:
        #     projects/\\{project}/locations/\\{region}/autonomousDbVersions/\\{autonomous_db_version}
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. An Oracle Database version for Autonomous Database.
        # @!attribute [r] db_workload
        #   @return [::Google::Cloud::OracleDatabase::V1::DBWorkload]
        #     Output only. The Autonomous Database workload type.
        # @!attribute [r] workload_uri
        #   @return [::String]
        #     Output only. A URL that points to a detailed description of the Autonomous
        #     Database version.
        class AutonomousDbVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
