# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Autonomous Database Backup resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseBackup/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Autonomous Database Backup resource with the
        #     format:
        #     projects/\\{project}/locations/\\{region}/autonomousDatabaseBackups/\\{autonomous_database_backup}
        # @!attribute [rw] autonomous_database
        #   @return [::String]
        #     Required. The name of the Autonomous Database resource for which the backup
        #     is being created. Format:
        #     projects/\\{project}/locations/\\{region}/autonomousDatabases/\\{autonomous_database}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly name for the Backup. The name does not have to be
        #     unique.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseBackupProperties]
        #     Optional. Various properties of the backup.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. labels or tags associated with the resource.
        class AutonomousDatabaseBackup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Properties of the Autonomous Database Backup resource.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. OCID of the Autonomous Database backup.
        #     https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
        # @!attribute [rw] retention_period_days
        #   @return [::Integer]
        #     Optional. Retention period in days for the backup.
        # @!attribute [r] compartment_id
        #   @return [::String]
        #     Output only. The OCID of the compartment.
        # @!attribute [r] database_size_tb
        #   @return [::Float]
        #     Output only. The quantity of data in the database, in terabytes.
        # @!attribute [r] db_version
        #   @return [::String]
        #     Output only. A valid Oracle Database version for Autonomous Database.
        # @!attribute [r] is_long_term_backup
        #   @return [::Boolean]
        #     Output only. Indicates if the backup is long term backup.
        # @!attribute [r] is_automatic_backup
        #   @return [::Boolean]
        #     Output only. Indicates if the backup is automatic or user initiated.
        # @!attribute [r] is_restorable
        #   @return [::Boolean]
        #     Output only. Indicates if the backup can be used to restore the Autonomous
        #     Database.
        # @!attribute [rw] key_store_id
        #   @return [::String]
        #     Optional. The OCID of the key store of Oracle Vault.
        # @!attribute [rw] key_store_wallet
        #   @return [::String]
        #     Optional. The wallet name for Oracle Key Vault.
        # @!attribute [rw] kms_key_id
        #   @return [::String]
        #     Optional. The OCID of the key container that is used as the master
        #     encryption key in database transparent data encryption (TDE) operations.
        # @!attribute [rw] kms_key_version_id
        #   @return [::String]
        #     Optional. The OCID of the key container version that is used in database
        #     transparent data encryption (TDE) operations KMS Key can have multiple key
        #     versions. If none is specified, the current key version (latest) of the Key
        #     Id is used for the operation. Autonomous Database Serverless does not use
        #     key versions, hence is not applicable for Autonomous Database Serverless
        #     instances.
        # @!attribute [r] lifecycle_details
        #   @return [::String]
        #     Output only. Additional information about the current lifecycle state.
        # @!attribute [r] lifecycle_state
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseBackupProperties::State]
        #     Output only. The lifecycle state of the backup.
        # @!attribute [r] size_tb
        #   @return [::Float]
        #     Output only. The backup size in terabytes.
        # @!attribute [r] available_till_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp until when the backup will be available.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time the backup completed.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time the backup started.
        # @!attribute [r] type
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseBackupProperties::Type]
        #     Output only. The type of the backup.
        # @!attribute [rw] vault_id
        #   @return [::String]
        #     Optional. The OCID of the vault.
        class AutonomousDatabaseBackupProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # // The various lifecycle states of the Autonomous Database Backup.
          module State
            # Default unspecified value.
            STATE_UNSPECIFIED = 0

            # Indicates that the resource is in creating state.
            CREATING = 1

            # Indicates that the resource is in active state.
            ACTIVE = 2

            # Indicates that the resource is in deleting state.
            DELETING = 3

            # Indicates that the resource is in deleted state.
            DELETED = 4

            # Indicates that the resource is in failed state.
            FAILED = 6

            # Indicates that the resource is in updating state.
            UPDATING = 7
          end

          # The type of the backup.
          module Type
            # Default unspecified value.
            TYPE_UNSPECIFIED = 0

            # Incremental backups.
            INCREMENTAL = 1

            # Full backups.
            FULL = 2

            # Long term backups.
            LONG_TERM = 3
          end
        end
      end
    end
  end
end
