# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        # Details of the Autonomous Database resource.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabase/
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Autonomous Database resource in the following
        #     format:
        #     projects/\\{project}/locations/\\{region}/autonomousDatabases/\\{autonomous_database}
        # @!attribute [rw] database
        #   @return [::String]
        #     Optional. The name of the Autonomous Database. The database name must be
        #     unique in the project. The name must begin with a letter and can contain a
        #     maximum of 30 alphanumeric characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name for the Autonomous Database. The name does not
        #     have to be unique within your project.
        # @!attribute [r] entitlement_id
        #   @return [::String]
        #     Output only. The ID of the subscription entitlement associated with the
        #     Autonomous Database.
        # @!attribute [rw] admin_password
        #   @return [::String]
        #     Optional. The password for the default ADMIN user.
        # @!attribute [rw] properties
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties]
        #     Optional. The properties of the Autonomous Database.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels or tags associated with the Autonomous Database.
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. The name of the VPC network used by the Autonomous Database in
        #     the following format: projects/\\{project}/global/networks/\\{network}
        # @!attribute [rw] cidr
        #   @return [::String]
        #     Optional. The subnet CIDR range for the Autonomous Database.
        # @!attribute [rw] odb_network
        #   @return [::String]
        #     Optional. The name of the OdbNetwork associated with the Autonomous
        #     Database. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network} It is
        #     optional but if specified, this should match the parent ODBNetwork of the
        #     OdbSubnet.
        # @!attribute [rw] odb_subnet
        #   @return [::String]
        #     Optional. The name of the OdbSubnet associated with the Autonomous
        #     Database. Format:
        #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}
        # @!attribute [rw] source_config
        #   @return [::Google::Cloud::OracleDatabase::V1::SourceConfig]
        #     Optional. The source Autonomous Database configuration for the standby
        #     Autonomous Database. The source Autonomous Database is configured while
        #     creating the Peer Autonomous Database and can't be updated after creation.
        # @!attribute [r] peer_autonomous_databases
        #   @return [::Array<::String>]
        #     Output only. The peer Autonomous Database names of the given Autonomous
        #     Database.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time that the Autonomous Database was created.
        # @!attribute [r] disaster_recovery_supported_locations
        #   @return [::Array<::String>]
        #     Output only. List of supported GCP region to clone the Autonomous Database
        #     for disaster recovery. Format: `project/{project}/locations/{location}`.
        class AutonomousDatabase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The source configuration for the standby Autonomous Database.
        # @!attribute [rw] autonomous_database
        #   @return [::String]
        #     Optional. The name of the primary Autonomous Database that is used to
        #     create a Peer Autonomous Database from a source.
        # @!attribute [rw] automatic_backups_replication_enabled
        #   @return [::Boolean]
        #     Optional. This field specifies if the replication of automatic backups is
        #     enabled when creating a Data Guard.
        class SourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The properties of an Autonomous Database.
        # @!attribute [r] ocid
        #   @return [::String]
        #     Output only. OCID of the Autonomous Database.
        #     https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
        # @!attribute [rw] compute_count
        #   @return [::Float]
        #     Optional. The number of compute servers for the Autonomous Database.
        # @!attribute [rw] cpu_core_count
        #   @return [::Integer]
        #     Optional. The number of CPU cores to be made available to the database.
        # @!attribute [rw] data_storage_size_tb
        #   @return [::Integer]
        #     Optional. The size of the data stored in the database, in terabytes.
        # @!attribute [rw] data_storage_size_gb
        #   @return [::Integer]
        #     Optional. The size of the data stored in the database, in gigabytes.
        # @!attribute [rw] db_workload
        #   @return [::Google::Cloud::OracleDatabase::V1::DBWorkload]
        #     Required. The workload type of the Autonomous Database.
        # @!attribute [rw] db_edition
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::DatabaseEdition]
        #     Optional. The edition of the Autonomous Databases.
        # @!attribute [rw] character_set
        #   @return [::String]
        #     Optional. The character set for the Autonomous Database. The default is
        #     AL32UTF8.
        # @!attribute [rw] n_character_set
        #   @return [::String]
        #     Optional. The national character set for the Autonomous Database. The
        #     default is AL16UTF16.
        # @!attribute [rw] private_endpoint_ip
        #   @return [::String]
        #     Optional. The private endpoint IP address for the Autonomous Database.
        # @!attribute [rw] private_endpoint_label
        #   @return [::String]
        #     Optional. The private endpoint label for the Autonomous Database.
        # @!attribute [rw] db_version
        #   @return [::String]
        #     Optional. The Oracle Database version for the Autonomous Database.
        # @!attribute [rw] is_auto_scaling_enabled
        #   @return [::Boolean]
        #     Optional. This field indicates if auto scaling is enabled for the
        #     Autonomous Database CPU core count.
        # @!attribute [rw] is_storage_auto_scaling_enabled
        #   @return [::Boolean]
        #     Optional. This field indicates if auto scaling is enabled for the
        #     Autonomous Database storage.
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::LicenseType]
        #     Required. The license type used for the Autonomous Database.
        # @!attribute [rw] customer_contacts
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::CustomerContact>]
        #     Optional. The list of customer contacts.
        # @!attribute [rw] secret_id
        #   @return [::String]
        #     Optional. The ID of the Oracle Cloud Infrastructure vault secret.
        # @!attribute [rw] vault_id
        #   @return [::String]
        #     Optional. The ID of the Oracle Cloud Infrastructure vault.
        # @!attribute [rw] maintenance_schedule_type
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::MaintenanceScheduleType]
        #     Optional. The maintenance schedule of the Autonomous Database.
        # @!attribute [rw] mtls_connection_required
        #   @return [::Boolean]
        #     Optional. This field specifies if the Autonomous Database requires mTLS
        #     connections.
        # @!attribute [rw] backup_retention_period_days
        #   @return [::Integer]
        #     Optional. The retention period for the Autonomous Database. This field is
        #     specified in days, can range from 1 day to 60 days, and has a default value
        #     of 60 days.
        # @!attribute [r] actual_used_data_storage_size_tb
        #   @return [::Float]
        #     Output only. The amount of storage currently being used for user and system
        #     data, in terabytes.
        # @!attribute [r] allocated_storage_size_tb
        #   @return [::Float]
        #     Output only. The amount of storage currently allocated for the database
        #     tables and billed for, rounded up in terabytes.
        # @!attribute [r] apex_details
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseApex]
        #     Output only. The details for the Oracle APEX Application Development.
        # @!attribute [r] are_primary_allowlisted_ips_used
        #   @return [::Boolean]
        #     Output only. This field indicates the status of Data Guard and Access
        #     control for the Autonomous Database. The field's value is null if Data
        #     Guard is disabled or Access Control is disabled. The field's value is TRUE
        #     if both Data Guard and Access Control are enabled, and the Autonomous
        #     Database is using primary IP access control list (ACL) for standby. The
        #     field's value is FALSE if both Data Guard and Access Control are enabled,
        #     and the Autonomous Database is using a different IP access control list
        #     (ACL) for standby compared to primary.
        # @!attribute [r] lifecycle_details
        #   @return [::String]
        #     Output only. The details of the current lifestyle state of the Autonomous
        #     Database.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::State]
        #     Output only. The current lifecycle state of the Autonomous Database.
        # @!attribute [r] autonomous_container_database_id
        #   @return [::String]
        #     Output only. The Autonomous Container Database OCID.
        # @!attribute [r] available_upgrade_versions
        #   @return [::Array<::String>]
        #     Output only. The list of available Oracle Database upgrade versions for an
        #     Autonomous Database.
        # @!attribute [r] connection_strings
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseConnectionStrings]
        #     Output only. The connection strings used to connect to an Autonomous
        #     Database.
        # @!attribute [r] connection_urls
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseConnectionUrls]
        #     Output only. The Oracle Connection URLs for an Autonomous Database.
        # @!attribute [r] failed_data_recovery_duration
        #   @return [::Google::Protobuf::Duration]
        #     Output only. This field indicates the number of seconds of data loss during
        #     a Data Guard failover.
        # @!attribute [r] memory_table_gbs
        #   @return [::Integer]
        #     Output only. The memory assigned to in-memory tables in an Autonomous
        #     Database.
        # @!attribute [r] is_local_data_guard_enabled
        #   @return [::Boolean]
        #     Output only. This field indicates whether the Autonomous Database has local
        #     (in-region) Data Guard enabled.
        # @!attribute [r] local_adg_auto_failover_max_data_loss_limit
        #   @return [::Integer]
        #     Output only. This field indicates the maximum data loss limit for an
        #     Autonomous Database, in seconds.
        # @!attribute [r] local_standby_db
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseStandbySummary]
        #     Output only. The details of the Autonomous Data Guard standby database.
        # @!attribute [r] memory_per_oracle_compute_unit_gbs
        #   @return [::Integer]
        #     Output only. The amount of memory enabled per ECPU, in gigabytes.
        # @!attribute [r] local_disaster_recovery_type
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::LocalDisasterRecoveryType]
        #     Output only. This field indicates the local disaster recovery (DR) type of
        #     an Autonomous Database.
        # @!attribute [r] data_safe_state
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::DataSafeState]
        #     Output only. The current state of the Data Safe registration for the
        #     Autonomous Database.
        # @!attribute [r] database_management_state
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::DatabaseManagementState]
        #     Output only. The current state of database management for the Autonomous
        #     Database.
        # @!attribute [r] open_mode
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::OpenMode]
        #     Output only. This field indicates the current mode of the Autonomous
        #     Database.
        # @!attribute [r] operations_insights_state
        #   @return [::Google::Cloud::OracleDatabase::V1::OperationsInsightsState]
        #     Output only. This field indicates the state of Operations Insights for the
        #     Autonomous Database.
        # @!attribute [r] peer_db_ids
        #   @return [::Array<::String>]
        #     Output only. The list of OCIDs of standby databases located in Autonomous
        #     Data Guard remote regions that are associated with the source database.
        # @!attribute [r] permission_level
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::PermissionLevel]
        #     Output only. The permission level of the Autonomous Database.
        # @!attribute [r] private_endpoint
        #   @return [::String]
        #     Output only. The private endpoint for the Autonomous Database.
        # @!attribute [r] refreshable_mode
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::RefreshableMode]
        #     Output only. The refresh mode of the cloned Autonomous Database.
        # @!attribute [r] refreshable_state
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::RefreshableState]
        #     Output only. The refresh State of the clone.
        # @!attribute [r] role
        #   @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseProperties::Role]
        #     Output only. The Data Guard role of the Autonomous Database.
        # @!attribute [r] scheduled_operation_details
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::ScheduledOperationDetails>]
        #     Output only. The list and details of the scheduled operations of the
        #     Autonomous Database.
        # @!attribute [r] sql_web_developer_url
        #   @return [::String]
        #     Output only. The SQL Web Developer URL for the Autonomous Database.
        # @!attribute [r] supported_clone_regions
        #   @return [::Array<::String>]
        #     Output only. The list of available regions that can be used to create a
        #     clone for the Autonomous Database.
        # @!attribute [r] used_data_storage_size_tbs
        #   @return [::Integer]
        #     Output only. The storage space used by Autonomous Database, in gigabytes.
        # @!attribute [r] oci_url
        #   @return [::String]
        #     Output only. The Oracle Cloud Infrastructure link for the Autonomous
        #     Database.
        # @!attribute [r] total_auto_backup_storage_size_gbs
        #   @return [::Float]
        #     Output only. The storage space used by automatic backups of Autonomous
        #     Database, in gigabytes.
        # @!attribute [r] next_long_term_backup_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The long term backup schedule of the Autonomous Database.
        # @!attribute [r] data_guard_role_changed_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time the Autonomous Data Guard role was changed
        #     for the standby Autonomous Database.
        # @!attribute [r] disaster_recovery_role_changed_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time the Disaster Recovery role was changed for
        #     the standby Autonomous Database.
        # @!attribute [r] maintenance_begin_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time when maintenance will begin.
        # @!attribute [r] maintenance_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time when maintenance will end.
        # @!attribute [rw] allowlisted_ips
        #   @return [::Array<::String>]
        #     Optional. The list of allowlisted IP addresses for the Autonomous Database.
        # @!attribute [rw] encryption_key
        #   @return [::Google::Cloud::OracleDatabase::V1::EncryptionKey]
        #     Optional. The encryption key used to encrypt the Autonomous Database.
        #     Updating this field will add a new entry in the
        #     `encryption_key_history_entries` field with the former version.
        # @!attribute [r] encryption_key_history_entries
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::EncryptionKeyHistoryEntry>]
        #     Output only. The history of the encryption keys used to encrypt the
        #     Autonomous Database.
        # @!attribute [r] service_agent_email
        #   @return [::String]
        #     Output only. An Oracle-managed Google Cloud service account on which
        #     customers can grant roles to access resources in the customer project.
        class AutonomousDatabaseProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The editions available for the Autonomous Database.
          module DatabaseEdition
            # Default unspecified value.
            DATABASE_EDITION_UNSPECIFIED = 0

            # Standard Database Edition
            STANDARD_EDITION = 1

            # Enterprise Database Edition
            ENTERPRISE_EDITION = 2
          end

          # The license types available for the Autonomous Database.
          module LicenseType
            # Unspecified
            LICENSE_TYPE_UNSPECIFIED = 0

            # License included part of offer
            LICENSE_INCLUDED = 1

            # Bring your own license
            BRING_YOUR_OWN_LICENSE = 2
          end

          # The available maintenance schedules for the Autonomous Database.
          module MaintenanceScheduleType
            # Default unspecified value.
            MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED = 0

            # An EARLY maintenance schedule patches the database before
            # the regular scheduled maintenance.
            EARLY = 1

            # A REGULAR maintenance schedule follows the normal maintenance cycle.
            REGULAR = 2
          end

          # The types of local disaster recovery available for an Autonomous Database.
          module LocalDisasterRecoveryType
            # Default unspecified value.
            LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED = 0

            # Autonomous Data Guard recovery.
            ADG = 1

            # Backup based recovery.
            BACKUP_BASED = 2
          end

          # Varies states of the Data Safe registration for the Autonomous Database.
          module DataSafeState
            # Default unspecified value.
            DATA_SAFE_STATE_UNSPECIFIED = 0

            # Registering data safe state.
            REGISTERING = 1

            # Registered data safe state.
            REGISTERED = 2

            # Deregistering data safe state.
            DEREGISTERING = 3

            # Not registered data safe state.
            NOT_REGISTERED = 4

            # Failed data safe state.
            FAILED = 5
          end

          # The different states of database management for an Autonomous Database.
          module DatabaseManagementState
            # Default unspecified value.
            DATABASE_MANAGEMENT_STATE_UNSPECIFIED = 0

            # Enabling Database Management state
            ENABLING = 1

            # Enabled Database Management state
            ENABLED = 2

            # Disabling Database Management state
            DISABLING = 3

            # Not Enabled Database Management state
            NOT_ENABLED = 4

            # Failed enabling Database Management state
            FAILED_ENABLING = 5

            # Failed disabling Database Management state
            FAILED_DISABLING = 6
          end

          # This field indicates the modes of an Autonomous Database.
          module OpenMode
            # Default unspecified value.
            OPEN_MODE_UNSPECIFIED = 0

            # Read Only Mode
            READ_ONLY = 1

            # Read Write Mode
            READ_WRITE = 2
          end

          # The types of permission levels for an Autonomous Database.
          module PermissionLevel
            # Default unspecified value.
            PERMISSION_LEVEL_UNSPECIFIED = 0

            # Restricted mode allows access only by admin users.
            RESTRICTED = 1

            # Normal access.
            UNRESTRICTED = 2
          end

          # The refresh mode of the cloned Autonomous Database.
          module RefreshableMode
            # The default unspecified value.
            REFRESHABLE_MODE_UNSPECIFIED = 0

            # AUTOMATIC indicates that the cloned database is automatically
            # refreshed with data from the source Autonomous Database.
            AUTOMATIC = 1

            # MANUAL indicates that the cloned database is manually refreshed with
            # data from the source Autonomous Database.
            MANUAL = 2
          end

          # The refresh state of the cloned Autonomous Database.
          module RefreshableState
            # Default unspecified value.
            REFRESHABLE_STATE_UNSPECIFIED = 0

            # Refreshing
            REFRESHING = 1

            # Not refreshed
            NOT_REFRESHING = 2
          end

          # The Data Guard role of the Autonomous Database.
          module Role
            # Default unspecified value.
            ROLE_UNSPECIFIED = 0

            # Primary role
            PRIMARY = 1

            # Standby role
            STANDBY = 2

            # Disabled standby role
            DISABLED_STANDBY = 3

            # Backup copy role
            BACKUP_COPY = 4

            # Snapshot standby role
            SNAPSHOT_STANDBY = 5
          end
        end

        # The history of the encryption keys used to encrypt the Autonomous Database.
        # @!attribute [r] encryption_key
        #   @return [::Google::Cloud::OracleDatabase::V1::EncryptionKey]
        #     Output only. The encryption key used to encrypt the Autonomous Database.
        # @!attribute [r] activation_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time when the encryption key was activated on the
        #     Autonomous Database..
        class EncryptionKeyHistoryEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The encryption key used to encrypt the Autonomous Database.
        # @!attribute [rw] provider
        #   @return [::Google::Cloud::OracleDatabase::V1::EncryptionKey::Provider]
        #     Optional. The provider of the encryption key.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Optional. The KMS key used to encrypt the Autonomous Database.
        #     This field is required if the provider is GOOGLE_MANAGED.
        #     The name of the KMS key resource in the following format:
        #     `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        class EncryptionKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The provider of the encryption key.
          module Provider
            # Default unspecified value.
            PROVIDER_UNSPECIFIED = 0

            # Google Managed KMS key, if selected, please provide the KMS key name.
            GOOGLE_MANAGED = 1

            # Oracle Managed.
            ORACLE_MANAGED = 2
          end
        end

        # Oracle APEX Application Development.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseApex
        # @!attribute [r] apex_version
        #   @return [::String]
        #     Output only. The Oracle APEX Application Development version.
        # @!attribute [r] ords_version
        #   @return [::String]
        #     Output only. The Oracle REST Data Services (ORDS) version.
        class AutonomousDatabaseApex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The connection string used to connect to the Autonomous Database.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseConnectionStrings
        # @!attribute [r] all_connection_strings
        #   @return [::Google::Cloud::OracleDatabase::V1::AllConnectionStrings]
        #     Output only. Returns all connection strings that can be used to connect to
        #     the Autonomous Database.
        # @!attribute [r] dedicated
        #   @return [::String]
        #     Output only. The database service provides the least level of resources to
        #     each SQL statement, but supports the most number of concurrent SQL
        #     statements.
        # @!attribute [r] high
        #   @return [::String]
        #     Output only. The database service provides the highest level of resources
        #     to each SQL statement.
        # @!attribute [r] low
        #   @return [::String]
        #     Output only. The database service provides the least level of resources to
        #     each SQL statement.
        # @!attribute [r] medium
        #   @return [::String]
        #     Output only. The database service provides a lower level of resources to
        #     each SQL statement.
        # @!attribute [r] profiles
        #   @return [::Array<::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile>]
        #     Output only. A list of connection string profiles to allow clients to
        #     group, filter, and select values based on the structured metadata.
        class AutonomousDatabaseConnectionStrings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The connection string profile to allow clients to group.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/DatabaseConnectionStringProfile
        # @!attribute [r] consumer_group
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile::ConsumerGroup]
        #     Output only. The current consumer group being used by the connection.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name for the database connection.
        # @!attribute [r] host_format
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile::HostFormat]
        #     Output only. The host name format being currently used in connection
        #     string.
        # @!attribute [r] is_regional
        #   @return [::Boolean]
        #     Output only. This field indicates if the connection string is regional and
        #     is only applicable for cross-region Data Guard.
        # @!attribute [r] protocol
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile::Protocol]
        #     Output only. The protocol being used by the connection.
        # @!attribute [r] session_mode
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile::SessionMode]
        #     Output only. The current session mode of the connection.
        # @!attribute [r] syntax_format
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile::SyntaxFormat]
        #     Output only. The syntax of the connection string.
        # @!attribute [r] tls_authentication
        #   @return [::Google::Cloud::OracleDatabase::V1::DatabaseConnectionStringProfile::TLSAuthentication]
        #     Output only. This field indicates the TLS authentication type of the
        #     connection.
        # @!attribute [r] value
        #   @return [::String]
        #     Output only. The value of the connection string.
        class DatabaseConnectionStringProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The various consumer groups available in the connection string profile.
          module ConsumerGroup
            # Default unspecified value.
            CONSUMER_GROUP_UNSPECIFIED = 0

            # High consumer group.
            HIGH = 1

            # Medium consumer group.
            MEDIUM = 2

            # Low consumer group.
            LOW = 3

            # TP consumer group.
            TP = 4

            # TPURGENT consumer group.
            TPURGENT = 5
          end

          # The host name format being used in the connection string.
          module HostFormat
            # Default unspecified value.
            HOST_FORMAT_UNSPECIFIED = 0

            # FQDN
            FQDN = 1

            # IP
            IP = 2
          end

          # The protocol being used by the connection.
          module Protocol
            # Default unspecified value.
            PROTOCOL_UNSPECIFIED = 0

            # Tcp
            TCP = 1

            # Tcps
            TCPS = 2
          end

          # The session mode of the connection.
          module SessionMode
            # Default unspecified value.
            SESSION_MODE_UNSPECIFIED = 0

            # Direct
            DIRECT = 1

            # Indirect
            INDIRECT = 2
          end

          # Specifies syntax of the connection string.
          module SyntaxFormat
            # Default unspecified value.
            SYNTAX_FORMAT_UNSPECIFIED = 0

            # Long
            LONG = 1

            # Ezconnect
            EZCONNECT = 2

            # Ezconnectplus
            EZCONNECTPLUS = 3
          end

          # This field indicates the TLS authentication type of the connection.
          module TLSAuthentication
            # Default unspecified value.
            TLS_AUTHENTICATION_UNSPECIFIED = 0

            # Server
            SERVER = 1

            # Mutual
            MUTUAL = 2
          end
        end

        # A list of all connection strings that can be used to connect to the
        # Autonomous Database.
        # @!attribute [r] high
        #   @return [::String]
        #     Output only. The database service provides the highest level of resources
        #     to each SQL statement.
        # @!attribute [r] low
        #   @return [::String]
        #     Output only. The database service provides the least level of resources to
        #     each SQL statement.
        # @!attribute [r] medium
        #   @return [::String]
        #     Output only. The database service provides a lower level of resources to
        #     each SQL statement.
        class AllConnectionStrings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The URLs for accessing Oracle Application Express (APEX) and SQL Developer
        # Web with a browser from a Compute instance.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseConnectionUrls
        # @!attribute [r] apex_uri
        #   @return [::String]
        #     Output only. Oracle Application Express (APEX) URL.
        # @!attribute [r] database_transforms_uri
        #   @return [::String]
        #     Output only. The URL of the Database Transforms for the Autonomous
        #     Database.
        # @!attribute [r] graph_studio_uri
        #   @return [::String]
        #     Output only. The URL of the Graph Studio for the Autonomous Database.
        # @!attribute [r] machine_learning_notebook_uri
        #   @return [::String]
        #     Output only. The URL of the Oracle Machine Learning (OML) Notebook for the
        #     Autonomous Database.
        # @!attribute [r] machine_learning_user_management_uri
        #   @return [::String]
        #     Output only. The URL of Machine Learning user management the Autonomous
        #     Database.
        # @!attribute [r] mongo_db_uri
        #   @return [::String]
        #     Output only. The URL of the MongoDB API for the Autonomous Database.
        # @!attribute [r] ords_uri
        #   @return [::String]
        #     Output only. The Oracle REST Data Services (ORDS) URL of the Web Access for
        #     the Autonomous Database.
        # @!attribute [r] sql_dev_web_uri
        #   @return [::String]
        #     Output only. The URL of the Oracle SQL Developer Web for the Autonomous
        #     Database.
        class AutonomousDatabaseConnectionUrls
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Autonomous Data Guard standby database details.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseStandbySummary
        # @!attribute [r] lag_time_duration
        #   @return [::Google::Protobuf::Duration]
        #     Output only. The amount of time, in seconds, that the data of the standby
        #     database lags in comparison to the data of the primary database.
        # @!attribute [r] lifecycle_details
        #   @return [::String]
        #     Output only. The additional details about the current lifecycle state of
        #     the Autonomous Database.
        # @!attribute [r] state
        #   @return [::Google::Cloud::OracleDatabase::V1::State]
        #     Output only. The current lifecycle state of the Autonomous Database.
        # @!attribute [r] data_guard_role_changed_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time the Autonomous Data Guard role was switched
        #     for the standby Autonomous Database.
        # @!attribute [r] disaster_recovery_role_changed_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The date and time the Disaster Recovery role was switched for
        #     the standby Autonomous Database.
        class AutonomousDatabaseStandbySummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of scheduled operation.
        # https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/ScheduledOperationDetails
        # @!attribute [r] day_of_week
        #   @return [::Google::Type::DayOfWeek]
        #     Output only. Day of week.
        # @!attribute [r] start_time
        #   @return [::Google::Type::TimeOfDay]
        #     Output only. Auto start time.
        # @!attribute [r] stop_time
        #   @return [::Google::Type::TimeOfDay]
        #     Output only. Auto stop time.
        class ScheduledOperationDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The type of wallet generation.
        module GenerateType
          # Default unspecified value.
          GENERATE_TYPE_UNSPECIFIED = 0

          # Used to generate wallet for all databases in the region.
          ALL = 1

          # Used to generate wallet for a single database.
          SINGLE = 2
        end

        # The various lifecycle states of the Autonomous Database.
        module State
          # Default unspecified value.
          STATE_UNSPECIFIED = 0

          # Indicates that the Autonomous Database is in provisioning state.
          PROVISIONING = 1

          # Indicates that the Autonomous Database is in available state.
          AVAILABLE = 2

          # Indicates that the Autonomous Database is in stopping state.
          STOPPING = 3

          # Indicates that the Autonomous Database is in stopped state.
          STOPPED = 4

          # Indicates that the Autonomous Database is in starting state.
          STARTING = 5

          # Indicates that the Autonomous Database is in terminating state.
          TERMINATING = 6

          # Indicates that the Autonomous Database is in terminated state.
          TERMINATED = 7

          # Indicates that the Autonomous Database is in unavailable state.
          UNAVAILABLE = 8

          # Indicates that the Autonomous Database restore is in progress.
          RESTORE_IN_PROGRESS = 9

          # Indicates that the Autonomous Database failed to restore.
          RESTORE_FAILED = 10

          # Indicates that the Autonomous Database backup is in progress.
          BACKUP_IN_PROGRESS = 11

          # Indicates that the Autonomous Database scale is in progress.
          SCALE_IN_PROGRESS = 12

          # Indicates that the Autonomous Database is available but needs attention
          # state.
          AVAILABLE_NEEDS_ATTENTION = 13

          # Indicates that the Autonomous Database is in updating state.
          UPDATING = 14

          # Indicates that the Autonomous Database's maintenance is in progress state.
          MAINTENANCE_IN_PROGRESS = 15

          # Indicates that the Autonomous Database is in restarting state.
          RESTARTING = 16

          # Indicates that the Autonomous Database is in recreating state.
          RECREATING = 17

          # Indicates that the Autonomous Database's role change is in progress state.
          ROLE_CHANGE_IN_PROGRESS = 18

          # Indicates that the Autonomous Database is in upgrading state.
          UPGRADING = 19

          # Indicates that the Autonomous Database is in inaccessible state.
          INACCESSIBLE = 20

          # Indicates that the Autonomous Database is in standby state.
          STANDBY = 21
        end

        # The state of the Operations Insights for this Autonomous Database.
        module OperationsInsightsState
          # Default unspecified value.
          OPERATIONS_INSIGHTS_STATE_UNSPECIFIED = 0

          # Enabling status for operation insights.
          ENABLING = 1

          # Enabled status for operation insights.
          ENABLED = 2

          # Disabling status for operation insights.
          DISABLING = 3

          # Not Enabled status for operation insights.
          NOT_ENABLED = 4

          # Failed enabling status for operation insights.
          FAILED_ENABLING = 5

          # Failed disabling status for operation insights.
          FAILED_DISABLING = 6
        end

        # The various states available for the Autonomous Database workload type.
        module DBWorkload
          # Default unspecified value.
          DB_WORKLOAD_UNSPECIFIED = 0

          # Autonomous Transaction Processing database.
          OLTP = 1

          # Autonomous Data Warehouse database.
          DW = 2

          # Autonomous JSON Database.
          AJD = 3

          # Autonomous Database with the Oracle APEX Application Development workload
          # type.
          APEX = 4
        end
      end
    end
  end
end
