# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/oracledatabase/v1/oracledatabase_pb"
require "google/cloud/oracle_database/v1/oracle_database/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module OracleDatabase
      module V1
        module OracleDatabase
          module Rest
            ##
            # REST client for the OracleDatabase service.
            #
            # Service describing handlers for resources
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "oracledatabase.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :oracle_database_stub

              ##
              # Configure the OracleDatabase Client class.
              #
              # See {::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all OracleDatabase clients
              #   ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "OracleDatabase", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config.rpcs.list_cloud_exadata_infrastructures.timeout = 60.0
                  default_config.rpcs.list_cloud_exadata_infrastructures.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_cloud_exadata_infrastructure.timeout = 60.0
                  default_config.rpcs.get_cloud_exadata_infrastructure.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_cloud_vm_clusters.timeout = 60.0
                  default_config.rpcs.list_cloud_vm_clusters.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_cloud_vm_cluster.timeout = 60.0
                  default_config.rpcs.get_cloud_vm_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_entitlements.timeout = 60.0
                  default_config.rpcs.list_entitlements.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_db_servers.timeout = 60.0
                  default_config.rpcs.list_db_servers.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_db_nodes.timeout = 60.0
                  default_config.rpcs.list_db_nodes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_gi_versions.timeout = 60.0
                  default_config.rpcs.list_gi_versions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_minor_versions.timeout = 60.0
                  default_config.rpcs.list_minor_versions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_db_system_shapes.timeout = 60.0
                  default_config.rpcs.list_db_system_shapes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_autonomous_databases.timeout = 60.0
                  default_config.rpcs.list_autonomous_databases.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_autonomous_database.timeout = 60.0
                  default_config.rpcs.get_autonomous_database.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_autonomous_db_versions.timeout = 60.0
                  default_config.rpcs.list_autonomous_db_versions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_autonomous_database_character_sets.timeout = 60.0
                  default_config.rpcs.list_autonomous_database_character_sets.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_autonomous_database_backups.timeout = 60.0
                  default_config.rpcs.list_autonomous_database_backups.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_odb_networks.timeout = 60.0
                  default_config.rpcs.list_odb_networks.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_odb_network.timeout = 60.0
                  default_config.rpcs.get_odb_network.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_odb_subnets.timeout = 60.0
                  default_config.rpcs.list_odb_subnets.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_odb_subnet.timeout = 60.0
                  default_config.rpcs.get_odb_subnet.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_exadb_vm_clusters.timeout = 60.0
                  default_config.rpcs.list_exadb_vm_clusters.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_exadb_vm_cluster.timeout = 60.0
                  default_config.rpcs.get_exadb_vm_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_exascale_db_storage_vaults.timeout = 60.0
                  default_config.rpcs.list_exascale_db_storage_vaults.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_exascale_db_storage_vault.timeout = 60.0
                  default_config.rpcs.get_exascale_db_storage_vault.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_db_system_initial_storage_sizes.timeout = 60.0
                  default_config.rpcs.list_db_system_initial_storage_sizes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_databases.timeout = 60.0
                  default_config.rpcs.list_databases.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_database.timeout = 60.0
                  default_config.rpcs.get_database.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_pluggable_databases.timeout = 60.0
                  default_config.rpcs.list_pluggable_databases.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_pluggable_database.timeout = 60.0
                  default_config.rpcs.get_pluggable_database.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_db_systems.timeout = 60.0
                  default_config.rpcs.list_db_systems.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_db_system.timeout = 60.0
                  default_config.rpcs.get_db_system.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_db_versions.timeout = 60.0
                  default_config.rpcs.list_db_versions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_database_character_sets.timeout = 60.0
                  default_config.rpcs.list_database_character_sets.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the OracleDatabase Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @oracle_database_stub.universe_domain
              end

              ##
              # Create a new OracleDatabase REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the OracleDatabase client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @oracle_database_stub = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @oracle_database_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @oracle_database_stub.endpoint
                  config.universe_domain = @oracle_database_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @oracle_database_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @oracle_database_stub.logger
              end

              # Service calls

              ##
              # Lists Exadata Infrastructures in a given project and location.
              #
              # @overload list_cloud_exadata_infrastructures(request, options = nil)
              #   Pass arguments to `list_cloud_exadata_infrastructures` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cloud_exadata_infrastructures(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_cloud_exadata_infrastructures` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for CloudExadataInfrastructure in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 Exadata infrastructures will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresRequest.new
              #
              #   # Call the list_cloud_exadata_infrastructures method.
              #   result = client.list_cloud_exadata_infrastructures request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure.
              #     p item
              #   end
              #
              def list_cloud_exadata_infrastructures request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListCloudExadataInfrastructuresRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cloud_exadata_infrastructures.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cloud_exadata_infrastructures.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cloud_exadata_infrastructures.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_cloud_exadata_infrastructures request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_cloud_exadata_infrastructures, "cloud_exadata_infrastructures", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Exadata Infrastructure.
              #
              # @overload get_cloud_exadata_infrastructure(request, options = nil)
              #   Pass arguments to `get_cloud_exadata_infrastructure` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetCloudExadataInfrastructureRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetCloudExadataInfrastructureRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cloud_exadata_infrastructure(name: nil)
              #   Pass arguments to `get_cloud_exadata_infrastructure` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Cloud Exadata Infrastructure in the following
              #     format:
              #     projects/\\{project}/locations/\\{location}/cloudExadataInfrastructures/\\{cloud_exadata_infrastructure}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetCloudExadataInfrastructureRequest.new
              #
              #   # Call the get_cloud_exadata_infrastructure method.
              #   result = client.get_cloud_exadata_infrastructure request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure.
              #   p result
              #
              def get_cloud_exadata_infrastructure request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetCloudExadataInfrastructureRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cloud_exadata_infrastructure.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cloud_exadata_infrastructure.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cloud_exadata_infrastructure.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_cloud_exadata_infrastructure request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Exadata Infrastructure in a given project and location.
              #
              # @overload create_cloud_exadata_infrastructure(request, options = nil)
              #   Pass arguments to `create_cloud_exadata_infrastructure` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateCloudExadataInfrastructureRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateCloudExadataInfrastructureRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cloud_exadata_infrastructure(parent: nil, cloud_exadata_infrastructure_id: nil, cloud_exadata_infrastructure: nil, request_id: nil)
              #   Pass arguments to `create_cloud_exadata_infrastructure` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for CloudExadataInfrastructure in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param cloud_exadata_infrastructure_id [::String]
              #     Required. The ID of the Exadata Infrastructure to create. This value is
              #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
              #     63 characters in length. The value must start with a letter and end with a
              #     letter or a number.
              #   @param cloud_exadata_infrastructure [::Google::Cloud::OracleDatabase::V1::CloudExadataInfrastructure, ::Hash]
              #     Required. Details of the Exadata Infrastructure instance to create.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateCloudExadataInfrastructureRequest.new
              #
              #   # Call the create_cloud_exadata_infrastructure method.
              #   result = client.create_cloud_exadata_infrastructure request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cloud_exadata_infrastructure request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateCloudExadataInfrastructureRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cloud_exadata_infrastructure.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cloud_exadata_infrastructure.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cloud_exadata_infrastructure.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_cloud_exadata_infrastructure request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Exadata Infrastructure.
              #
              # @overload delete_cloud_exadata_infrastructure(request, options = nil)
              #   Pass arguments to `delete_cloud_exadata_infrastructure` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteCloudExadataInfrastructureRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteCloudExadataInfrastructureRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_cloud_exadata_infrastructure(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_cloud_exadata_infrastructure` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Cloud Exadata Infrastructure in the following
              #     format:
              #     projects/\\{project}/locations/\\{location}/cloudExadataInfrastructures/\\{cloud_exadata_infrastructure}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to true, all VM clusters for this Exadata Infrastructure
              #     will be deleted. An Exadata Infrastructure can only be deleted once all its
              #     VM clusters have been deleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteCloudExadataInfrastructureRequest.new
              #
              #   # Call the delete_cloud_exadata_infrastructure method.
              #   result = client.delete_cloud_exadata_infrastructure request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cloud_exadata_infrastructure request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteCloudExadataInfrastructureRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_cloud_exadata_infrastructure.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_cloud_exadata_infrastructure.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_cloud_exadata_infrastructure.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_cloud_exadata_infrastructure request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the VM Clusters in a given project and location.
              #
              # @overload list_cloud_vm_clusters(request, options = nil)
              #   Pass arguments to `list_cloud_vm_clusters` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListCloudVmClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListCloudVmClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cloud_vm_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_cloud_vm_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The number of VM clusters to return.
              #     If unspecified, at most 50 VM clusters will be returned.
              #     The maximum value is 1,000.
              #   @param page_token [::String]
              #     Optional. A token identifying the page of results the server returns.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::CloudVmCluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::CloudVmCluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListCloudVmClustersRequest.new
              #
              #   # Call the list_cloud_vm_clusters method.
              #   result = client.list_cloud_vm_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::CloudVmCluster.
              #     p item
              #   end
              #
              def list_cloud_vm_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListCloudVmClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cloud_vm_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cloud_vm_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cloud_vm_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_cloud_vm_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_cloud_vm_clusters, "cloud_vm_clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single VM Cluster.
              #
              # @overload get_cloud_vm_cluster(request, options = nil)
              #   Pass arguments to `get_cloud_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetCloudVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetCloudVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cloud_vm_cluster(name: nil)
              #   Pass arguments to `get_cloud_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Cloud VM Cluster in the following format:
              #     projects/\\{project}/locations/\\{location}/cloudVmClusters/\\{cloud_vm_cluster}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::CloudVmCluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::CloudVmCluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetCloudVmClusterRequest.new
              #
              #   # Call the get_cloud_vm_cluster method.
              #   result = client.get_cloud_vm_cluster request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::CloudVmCluster.
              #   p result
              #
              def get_cloud_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetCloudVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cloud_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cloud_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cloud_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_cloud_vm_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new VM Cluster in a given project and location.
              #
              # @overload create_cloud_vm_cluster(request, options = nil)
              #   Pass arguments to `create_cloud_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateCloudVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateCloudVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cloud_vm_cluster(parent: nil, cloud_vm_cluster_id: nil, cloud_vm_cluster: nil, request_id: nil)
              #   Pass arguments to `create_cloud_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param cloud_vm_cluster_id [::String]
              #     Required. The ID of the VM Cluster to create. This value is restricted
              #     to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of 63
              #     characters in length. The value must start with a letter and end with
              #     a letter or a number.
              #   @param cloud_vm_cluster [::Google::Cloud::OracleDatabase::V1::CloudVmCluster, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateCloudVmClusterRequest.new
              #
              #   # Call the create_cloud_vm_cluster method.
              #   result = client.create_cloud_vm_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cloud_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateCloudVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cloud_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cloud_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cloud_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_cloud_vm_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single VM Cluster.
              #
              # @overload delete_cloud_vm_cluster(request, options = nil)
              #   Pass arguments to `delete_cloud_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteCloudVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteCloudVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_cloud_vm_cluster(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_cloud_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Cloud VM Cluster in the following format:
              #     projects/\\{project}/locations/\\{location}/cloudVmClusters/\\{cloud_vm_cluster}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to true, all child resources for the VM Cluster will be
              #     deleted. A VM Cluster can only be deleted once all its child resources have
              #     been deleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteCloudVmClusterRequest.new
              #
              #   # Call the delete_cloud_vm_cluster method.
              #   result = client.delete_cloud_vm_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cloud_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteCloudVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_cloud_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_cloud_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_cloud_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_cloud_vm_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the entitlements in a given project.
              #
              # @overload list_entitlements(request, options = nil)
              #   Pass arguments to `list_entitlements` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListEntitlementsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListEntitlementsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_entitlements(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_entitlements` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the entitlement in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 entitlements will be returned.
              #     The maximum value is 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::Entitlement>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::Entitlement>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListEntitlementsRequest.new
              #
              #   # Call the list_entitlements method.
              #   result = client.list_entitlements request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::Entitlement.
              #     p item
              #   end
              #
              def list_entitlements request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListEntitlementsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_entitlements.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_entitlements.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_entitlements.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_entitlements request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_entitlements, "entitlements", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the database servers of an Exadata Infrastructure instance.
              #
              # @overload list_db_servers(request, options = nil)
              #   Pass arguments to `list_db_servers` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDbServersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDbServersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_db_servers(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_db_servers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for database server in the following format:
              #     projects/\\{project}/locations/\\{location}/cloudExadataInfrastructures/\\{cloudExadataInfrastructure}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 db servers will be returned.
              #     The maximum value is 1000; values above 1000 will be reset to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbServer>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbServer>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDbServersRequest.new
              #
              #   # Call the list_db_servers method.
              #   result = client.list_db_servers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DbServer.
              #     p item
              #   end
              #
              def list_db_servers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDbServersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_db_servers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_db_servers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_db_servers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_db_servers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_db_servers, "db_servers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the database nodes of a VM Cluster.
              #
              # @overload list_db_nodes(request, options = nil)
              #   Pass arguments to `list_db_nodes` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDbNodesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDbNodesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_db_nodes(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_db_nodes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for database node in the following format:
              #     projects/\\{project}/locations/\\{location}/cloudVmClusters/\\{cloudVmCluster}.
              #     .
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 db nodes will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the node should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbNode>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbNode>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDbNodesRequest.new
              #
              #   # Call the list_db_nodes method.
              #   result = client.list_db_nodes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DbNode.
              #     p item
              #   end
              #
              def list_db_nodes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDbNodesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_db_nodes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_db_nodes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_db_nodes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_db_nodes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_db_nodes, "db_nodes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the valid Oracle Grid Infrastructure (GI) versions for the given
              # project and location.
              #
              # @overload list_gi_versions(request, options = nil)
              #   Pass arguments to `list_gi_versions` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListGiVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListGiVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_gi_versions(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_gi_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for Grid Infrastructure Version in the following
              #     format: Format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 Oracle Grid Infrastructure (GI) versions
              #     will be returned. The maximum value is 1000; values above 1000 will be
              #     reset to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. Only the
              #     shape, gcp_oracle_zone and gi_version fields are supported in this format:
              #     `shape="{shape}"`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::GiVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::GiVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListGiVersionsRequest.new
              #
              #   # Call the list_gi_versions method.
              #   result = client.list_gi_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::GiVersion.
              #     p item
              #   end
              #
              def list_gi_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListGiVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_gi_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_gi_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_gi_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_gi_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_gi_versions, "gi_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the valid minor versions for the given
              # project, location, gi version and shape family.
              #
              # @overload list_minor_versions(request, options = nil)
              #   Pass arguments to `list_minor_versions` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListMinorVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListMinorVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_minor_versions(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_minor_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the MinorVersion resource with the format:
              #     projects/\\{project}/locations/\\{location}/giVersions/\\{gi_version}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 System Versions will be returned.
              #     The maximum value is 1000; values above 1000 will be reset to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying the requested page of results to return. All
              #     fields except the filter should remain the same as in the request that
              #     provided this page token.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #     Only shapeFamily and gcp_oracle_zone_id are supported in this format:
              #     `shape_family="{shapeFamily}" AND
              #     gcp_oracle_zone_id="\\{gcp_oracle_zone_id}"`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::MinorVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::MinorVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListMinorVersionsRequest.new
              #
              #   # Call the list_minor_versions method.
              #   result = client.list_minor_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::MinorVersion.
              #     p item
              #   end
              #
              def list_minor_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListMinorVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_minor_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_minor_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_minor_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_minor_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_minor_versions, "minor_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the database system shapes available for the project and location.
              #
              # @overload list_db_system_shapes(request, options = nil)
              #   Pass arguments to `list_db_system_shapes` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDbSystemShapesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDbSystemShapesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_db_system_shapes(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_db_system_shapes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for Database System Shapes in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 database system shapes will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. Only the
              #     gcp_oracle_zone_id field is supported in this format:
              #     `gcp_oracle_zone_id="{gcp_oracle_zone_id}"`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbSystemShape>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbSystemShape>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDbSystemShapesRequest.new
              #
              #   # Call the list_db_system_shapes method.
              #   result = client.list_db_system_shapes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DbSystemShape.
              #     p item
              #   end
              #
              def list_db_system_shapes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDbSystemShapesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_db_system_shapes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_db_system_shapes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_db_system_shapes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_db_system_shapes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_db_system_shapes, "db_system_shapes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Autonomous Databases in a given project and location.
              #
              # @overload list_autonomous_databases(request, options = nil)
              #   Pass arguments to `list_autonomous_databases` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_autonomous_databases(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_autonomous_databases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the Autonomous Database in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 Autonomous Database will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDatabase>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDatabase>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesRequest.new
              #
              #   # Call the list_autonomous_databases method.
              #   result = client.list_autonomous_databases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::AutonomousDatabase.
              #     p item
              #   end
              #
              def list_autonomous_databases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_autonomous_databases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_autonomous_databases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_autonomous_databases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_autonomous_databases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_autonomous_databases, "autonomous_databases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a single Autonomous Database.
              #
              # @overload get_autonomous_database(request, options = nil)
              #   Pass arguments to `get_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_autonomous_database(name: nil)
              #   Pass arguments to `get_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::AutonomousDatabase]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::AutonomousDatabase]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetAutonomousDatabaseRequest.new
              #
              #   # Call the get_autonomous_database method.
              #   result = client.get_autonomous_database request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::AutonomousDatabase.
              #   p result
              #
              def get_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_autonomous_database request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Autonomous Database in a given project and location.
              #
              # @overload create_autonomous_database(request, options = nil)
              #   Pass arguments to `create_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_autonomous_database(parent: nil, autonomous_database_id: nil, autonomous_database: nil, request_id: nil)
              #   Pass arguments to `create_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param autonomous_database_id [::String]
              #     Required. The ID of the Autonomous Database to create. This value is
              #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
              #     63 characters in length. The value must start with a letter and end with a
              #     letter or a number.
              #   @param autonomous_database [::Google::Cloud::OracleDatabase::V1::AutonomousDatabase, ::Hash]
              #     Required. The Autonomous Database being created.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateAutonomousDatabaseRequest.new
              #
              #   # Call the create_autonomous_database method.
              #   result = client.create_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Autonomous Database.
              #
              # @overload update_autonomous_database(request, options = nil)
              #   Pass arguments to `update_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::UpdateAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::UpdateAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_autonomous_database(update_mask: nil, autonomous_database: nil, request_id: nil)
              #   Pass arguments to `update_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     Exadata resource by the update. The fields specified in the update_mask are
              #     relative to the resource, not the full request. A field will be overwritten
              #     if it is in the mask. If the user does not provide a mask then all fields
              #     will be overwritten.
              #   @param autonomous_database [::Google::Cloud::OracleDatabase::V1::AutonomousDatabase, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::UpdateAutonomousDatabaseRequest.new
              #
              #   # Call the update_autonomous_database method.
              #   result = client.update_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::UpdateAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.update_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Autonomous Database.
              #
              # @overload delete_autonomous_database(request, options = nil)
              #   Pass arguments to `delete_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_autonomous_database(name: nil, request_id: nil)
              #   Pass arguments to `delete_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteAutonomousDatabaseRequest.new
              #
              #   # Call the delete_autonomous_database method.
              #   result = client.delete_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restores a single Autonomous Database.
              #
              # @overload restore_autonomous_database(request, options = nil)
              #   Pass arguments to `restore_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::RestoreAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::RestoreAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restore_autonomous_database(name: nil, restore_time: nil)
              #   Pass arguments to `restore_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              #   @param restore_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Required. The time and date to restore the database to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::RestoreAutonomousDatabaseRequest.new
              #
              #   # Call the restore_autonomous_database method.
              #   result = client.restore_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::RestoreAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restore_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restore_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restore_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.restore_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates a wallet for an Autonomous Database.
              #
              # @overload generate_autonomous_database_wallet(request, options = nil)
              #   Pass arguments to `generate_autonomous_database_wallet` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_autonomous_database_wallet(name: nil, type: nil, is_regional: nil, password: nil)
              #   Pass arguments to `generate_autonomous_database_wallet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              #   @param type [::Google::Cloud::OracleDatabase::V1::GenerateType]
              #     Optional. The type of wallet generation for the Autonomous Database. The
              #     default value is SINGLE.
              #   @param is_regional [::Boolean]
              #     Optional. True when requesting regional connection strings in PDB connect
              #     info, applicable to cross-region Data Guard only.
              #   @param password [::String]
              #     Required. The password used to encrypt the keys inside the wallet. The
              #     password must be a minimum of 8 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletRequest.new
              #
              #   # Call the generate_autonomous_database_wallet method.
              #   result = client.generate_autonomous_database_wallet request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletResponse.
              #   p result
              #
              def generate_autonomous_database_wallet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GenerateAutonomousDatabaseWalletRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_autonomous_database_wallet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_autonomous_database_wallet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_autonomous_database_wallet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.generate_autonomous_database_wallet request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the available Autonomous Database versions for a project and
              # location.
              #
              # @overload list_autonomous_db_versions(request, options = nil)
              #   Pass arguments to `list_autonomous_db_versions` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_autonomous_db_versions(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_autonomous_db_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the Autonomous Database in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 Autonomous DB Versions will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDbVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDbVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsRequest.new
              #
              #   # Call the list_autonomous_db_versions method.
              #   result = client.list_autonomous_db_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::AutonomousDbVersion.
              #     p item
              #   end
              #
              def list_autonomous_db_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListAutonomousDbVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_autonomous_db_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_autonomous_db_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_autonomous_db_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_autonomous_db_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_autonomous_db_versions, "autonomous_db_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Autonomous Database Character Sets in a given project and location.
              #
              # @overload list_autonomous_database_character_sets(request, options = nil)
              #   Pass arguments to `list_autonomous_database_character_sets` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_autonomous_database_character_sets(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_autonomous_database_character_sets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the Autonomous Database in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 Autonomous DB Character Sets will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. Only the
              #     **character_set_type** field is supported in the following format:
              #     `character_set_type="{characterSetType}"`. Accepted values include
              #     `DATABASE` and `NATIONAL`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseCharacterSet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseCharacterSet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsRequest.new
              #
              #   # Call the list_autonomous_database_character_sets method.
              #   result = client.list_autonomous_database_character_sets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseCharacterSet.
              #     p item
              #   end
              #
              def list_autonomous_database_character_sets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseCharacterSetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_autonomous_database_character_sets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_autonomous_database_character_sets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_autonomous_database_character_sets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_autonomous_database_character_sets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_autonomous_database_character_sets, "autonomous_database_character_sets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the long-term and automatic backups of an Autonomous Database.
              #
              # @overload list_autonomous_database_backups(request, options = nil)
              #   Pass arguments to `list_autonomous_database_backups` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_autonomous_database_backups(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_autonomous_database_backups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for ListAutonomousDatabaseBackups in the
              #     following format: projects/\\{project}/locations/\\{location}.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. Only the
              #     **autonomous_database_id** field is supported in the following format:
              #     `autonomous_database_id="{autonomous_database_id}"`. The accepted values
              #     must be a valid Autonomous Database ID, limited to the naming
              #     restrictions of the ID: ^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$).
              #     The ID must start with a letter, end with a letter or a number, and be
              #     a maximum of 63 characters.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 Autonomous DB Backups will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseBackup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseBackup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsRequest.new
              #
              #   # Call the list_autonomous_database_backups method.
              #   result = client.list_autonomous_database_backups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::AutonomousDatabaseBackup.
              #     p item
              #   end
              #
              def list_autonomous_database_backups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListAutonomousDatabaseBackupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_autonomous_database_backups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_autonomous_database_backups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_autonomous_database_backups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_autonomous_database_backups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_autonomous_database_backups, "autonomous_database_backups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops an Autonomous Database.
              #
              # @overload stop_autonomous_database(request, options = nil)
              #   Pass arguments to `stop_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::StopAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::StopAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_autonomous_database(name: nil)
              #   Pass arguments to `stop_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::StopAutonomousDatabaseRequest.new
              #
              #   # Call the stop_autonomous_database method.
              #   result = client.stop_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::StopAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.stop_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts an Autonomous Database.
              #
              # @overload start_autonomous_database(request, options = nil)
              #   Pass arguments to `start_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::StartAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::StartAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_autonomous_database(name: nil)
              #   Pass arguments to `start_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::StartAutonomousDatabaseRequest.new
              #
              #   # Call the start_autonomous_database method.
              #   result = client.start_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::StartAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.start_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restarts an Autonomous Database.
              #
              # @overload restart_autonomous_database(request, options = nil)
              #   Pass arguments to `restart_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::RestartAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::RestartAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restart_autonomous_database(name: nil)
              #   Pass arguments to `restart_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::RestartAutonomousDatabaseRequest.new
              #
              #   # Call the restart_autonomous_database method.
              #   result = client.restart_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restart_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::RestartAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restart_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restart_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restart_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.restart_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates a switchover of specified autonomous database to the associated
              # peer database.
              #
              # @overload switchover_autonomous_database(request, options = nil)
              #   Pass arguments to `switchover_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::SwitchoverAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::SwitchoverAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload switchover_autonomous_database(name: nil, peer_autonomous_database: nil)
              #   Pass arguments to `switchover_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              #   @param peer_autonomous_database [::String]
              #     Required. The peer database name to switch over to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::SwitchoverAutonomousDatabaseRequest.new
              #
              #   # Call the switchover_autonomous_database method.
              #   result = client.switchover_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def switchover_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::SwitchoverAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.switchover_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.switchover_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.switchover_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.switchover_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates a failover to target autonomous database from the associated
              # primary database.
              #
              # @overload failover_autonomous_database(request, options = nil)
              #   Pass arguments to `failover_autonomous_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::FailoverAutonomousDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::FailoverAutonomousDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload failover_autonomous_database(name: nil, peer_autonomous_database: nil)
              #   Pass arguments to `failover_autonomous_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Autonomous Database in the following format:
              #     projects/\\{project}/locations/\\{location}/autonomousDatabases/\\{autonomous_database}.
              #   @param peer_autonomous_database [::String]
              #     Required. The peer database name to fail over to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::FailoverAutonomousDatabaseRequest.new
              #
              #   # Call the failover_autonomous_database method.
              #   result = client.failover_autonomous_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def failover_autonomous_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::FailoverAutonomousDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.failover_autonomous_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.failover_autonomous_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.failover_autonomous_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.failover_autonomous_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the ODB Networks in a given project and location.
              #
              # @overload list_odb_networks(request, options = nil)
              #   Pass arguments to `list_odb_networks` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListOdbNetworksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListOdbNetworksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_odb_networks(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_odb_networks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the ODB Network in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 ODB Networks will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::OdbNetwork>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::OdbNetwork>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListOdbNetworksRequest.new
              #
              #   # Call the list_odb_networks method.
              #   result = client.list_odb_networks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::OdbNetwork.
              #     p item
              #   end
              #
              def list_odb_networks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListOdbNetworksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_odb_networks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_odb_networks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_odb_networks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_odb_networks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_odb_networks, "odb_networks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ODB Network.
              #
              # @overload get_odb_network(request, options = nil)
              #   Pass arguments to `get_odb_network` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetOdbNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetOdbNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_odb_network(name: nil)
              #   Pass arguments to `get_odb_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the OdbNetwork in the following format:
              #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::OdbNetwork]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::OdbNetwork]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetOdbNetworkRequest.new
              #
              #   # Call the get_odb_network method.
              #   result = client.get_odb_network request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::OdbNetwork.
              #   p result
              #
              def get_odb_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetOdbNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_odb_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_odb_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_odb_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_odb_network request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new ODB Network in a given project and location.
              #
              # @overload create_odb_network(request, options = nil)
              #   Pass arguments to `create_odb_network` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateOdbNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateOdbNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_odb_network(parent: nil, odb_network_id: nil, odb_network: nil, request_id: nil)
              #   Pass arguments to `create_odb_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the OdbNetwork in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param odb_network_id [::String]
              #     Required. The ID of the OdbNetwork to create. This value is restricted
              #     to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of 63
              #     characters in length. The value must start with a letter and end with
              #     a letter or a number.
              #   @param odb_network [::Google::Cloud::OracleDatabase::V1::OdbNetwork, ::Hash]
              #     Required. Details of the OdbNetwork instance to create.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateOdbNetworkRequest.new
              #
              #   # Call the create_odb_network method.
              #   result = client.create_odb_network request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_odb_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateOdbNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_odb_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_odb_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_odb_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_odb_network request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single ODB Network.
              #
              # @overload delete_odb_network(request, options = nil)
              #   Pass arguments to `delete_odb_network` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteOdbNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteOdbNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_odb_network(name: nil, request_id: nil)
              #   Pass arguments to `delete_odb_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource in the following format:
              #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteOdbNetworkRequest.new
              #
              #   # Call the delete_odb_network method.
              #   result = client.delete_odb_network request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_odb_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteOdbNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_odb_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_odb_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_odb_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_odb_network request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the ODB Subnets in a given ODB Network.
              #
              # @overload list_odb_subnets(request, options = nil)
              #   Pass arguments to `list_odb_subnets` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListOdbSubnetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListOdbSubnetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_odb_subnets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_odb_subnets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the OdbSubnet in the following format:
              #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 ODB Networks will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::OdbSubnet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::OdbSubnet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListOdbSubnetsRequest.new
              #
              #   # Call the list_odb_subnets method.
              #   result = client.list_odb_subnets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::OdbSubnet.
              #     p item
              #   end
              #
              def list_odb_subnets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListOdbSubnetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_odb_subnets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_odb_subnets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_odb_subnets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_odb_subnets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_odb_subnets, "odb_subnets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ODB Subnet.
              #
              # @overload get_odb_subnet(request, options = nil)
              #   Pass arguments to `get_odb_subnet` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetOdbSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetOdbSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_odb_subnet(name: nil)
              #   Pass arguments to `get_odb_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the OdbSubnet in the following format:
              #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::OdbSubnet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::OdbSubnet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetOdbSubnetRequest.new
              #
              #   # Call the get_odb_subnet method.
              #   result = client.get_odb_subnet request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::OdbSubnet.
              #   p result
              #
              def get_odb_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetOdbSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_odb_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_odb_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_odb_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_odb_subnet request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new ODB Subnet in a given ODB Network.
              #
              # @overload create_odb_subnet(request, options = nil)
              #   Pass arguments to `create_odb_subnet` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateOdbSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateOdbSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_odb_subnet(parent: nil, odb_subnet_id: nil, odb_subnet: nil, request_id: nil)
              #   Pass arguments to `create_odb_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the OdbSubnet in the following format:
              #     projects/\\{project}/locations/\\{location}/odbNetworks/\\{odb_network}.
              #   @param odb_subnet_id [::String]
              #     Required. The ID of the OdbSubnet to create. This value is restricted
              #     to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of 63
              #     characters in length. The value must start with a letter and end with
              #     a letter or a number.
              #   @param odb_subnet [::Google::Cloud::OracleDatabase::V1::OdbSubnet, ::Hash]
              #     Required. Details of the OdbSubnet instance to create.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateOdbSubnetRequest.new
              #
              #   # Call the create_odb_subnet method.
              #   result = client.create_odb_subnet request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_odb_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateOdbSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_odb_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_odb_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_odb_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_odb_subnet request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single ODB Subnet.
              #
              # @overload delete_odb_subnet(request, options = nil)
              #   Pass arguments to `delete_odb_subnet` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteOdbSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteOdbSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_odb_subnet(name: nil, request_id: nil)
              #   Pass arguments to `delete_odb_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource in the following format:
              #     projects/\\{project}/locations/\\{region}/odbNetworks/\\{odb_network}/odbSubnets/\\{odb_subnet}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteOdbSubnetRequest.new
              #
              #   # Call the delete_odb_subnet method.
              #   result = client.delete_odb_subnet request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_odb_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteOdbSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_odb_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_odb_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_odb_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_odb_subnet request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the Exadb (Exascale) VM Clusters for the given project and
              # location.
              #
              # @overload list_exadb_vm_clusters(request, options = nil)
              #   Pass arguments to `list_exadb_vm_clusters` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListExadbVmClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListExadbVmClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_exadb_vm_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_exadb_vm_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for ExadbVmClusters in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 ExadbVmClusters will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::ExadbVmCluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::ExadbVmCluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListExadbVmClustersRequest.new
              #
              #   # Call the list_exadb_vm_clusters method.
              #   result = client.list_exadb_vm_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::ExadbVmCluster.
              #     p item
              #   end
              #
              def list_exadb_vm_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListExadbVmClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_exadb_vm_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_exadb_vm_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_exadb_vm_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_exadb_vm_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_exadb_vm_clusters, "exadb_vm_clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Exadb (Exascale) VM Cluster.
              #
              # @overload get_exadb_vm_cluster(request, options = nil)
              #   Pass arguments to `get_exadb_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetExadbVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetExadbVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_exadb_vm_cluster(name: nil)
              #   Pass arguments to `get_exadb_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ExadbVmCluster in the following format:
              #     projects/\\{project}/locations/\\{location}/exadbVmClusters/\\{exadb_vm_cluster}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::ExadbVmCluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::ExadbVmCluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetExadbVmClusterRequest.new
              #
              #   # Call the get_exadb_vm_cluster method.
              #   result = client.get_exadb_vm_cluster request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::ExadbVmCluster.
              #   p result
              #
              def get_exadb_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetExadbVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_exadb_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_exadb_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_exadb_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_exadb_vm_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Exadb (Exascale) VM Cluster resource.
              #
              # @overload create_exadb_vm_cluster(request, options = nil)
              #   Pass arguments to `create_exadb_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateExadbVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateExadbVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_exadb_vm_cluster(parent: nil, exadb_vm_cluster_id: nil, exadb_vm_cluster: nil, request_id: nil)
              #   Pass arguments to `create_exadb_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The value for parent of the ExadbVmCluster in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param exadb_vm_cluster_id [::String]
              #     Required. The ID of the ExadbVmCluster to create. This value is
              #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
              #     63 characters in length. The value must start with a letter and end with a
              #     letter or a number.
              #   @param exadb_vm_cluster [::Google::Cloud::OracleDatabase::V1::ExadbVmCluster, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateExadbVmClusterRequest.new
              #
              #   # Call the create_exadb_vm_cluster method.
              #   result = client.create_exadb_vm_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_exadb_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateExadbVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_exadb_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_exadb_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_exadb_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_exadb_vm_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Exadb (Exascale) VM Cluster.
              #
              # @overload delete_exadb_vm_cluster(request, options = nil)
              #   Pass arguments to `delete_exadb_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteExadbVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteExadbVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_exadb_vm_cluster(name: nil, request_id: nil)
              #   Pass arguments to `delete_exadb_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ExadbVmCluster in the following format:
              #     projects/\\{project}/locations/\\{location}/exadbVmClusters/\\{exadb_vm_cluster}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteExadbVmClusterRequest.new
              #
              #   # Call the delete_exadb_vm_cluster method.
              #   result = client.delete_exadb_vm_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_exadb_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteExadbVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_exadb_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_exadb_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_exadb_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_exadb_vm_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a single Exadb (Exascale) VM Cluster. To add virtual machines to
              # existing exadb vm cluster, only pass the node count.
              #
              # @overload update_exadb_vm_cluster(request, options = nil)
              #   Pass arguments to `update_exadb_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::UpdateExadbVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::UpdateExadbVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_exadb_vm_cluster(update_mask: nil, exadb_vm_cluster: nil, request_id: nil)
              #   Pass arguments to `update_exadb_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. A mask specifying which fields in th VM Cluster should be
              #     updated. A field specified in the mask is overwritten. If a mask isn't
              #     provided then all the fields in the VM Cluster are overwritten.
              #   @param exadb_vm_cluster [::Google::Cloud::OracleDatabase::V1::ExadbVmCluster, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::UpdateExadbVmClusterRequest.new
              #
              #   # Call the update_exadb_vm_cluster method.
              #   result = client.update_exadb_vm_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_exadb_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::UpdateExadbVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_exadb_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_exadb_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_exadb_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.update_exadb_vm_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes virtual machines from an existing exadb vm cluster.
              #
              # @overload remove_virtual_machine_exadb_vm_cluster(request, options = nil)
              #   Pass arguments to `remove_virtual_machine_exadb_vm_cluster` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::RemoveVirtualMachineExadbVmClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::RemoveVirtualMachineExadbVmClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload remove_virtual_machine_exadb_vm_cluster(name: nil, request_id: nil, hostnames: nil)
              #   Pass arguments to `remove_virtual_machine_exadb_vm_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ExadbVmCluster in the following format:
              #     projects/\\{project}/locations/\\{location}/exadbVmClusters/\\{exadb_vm_cluster}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param hostnames [::Array<::String>]
              #     Required. The list of host names of db nodes to be removed from the
              #     ExadbVmCluster.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::RemoveVirtualMachineExadbVmClusterRequest.new
              #
              #   # Call the remove_virtual_machine_exadb_vm_cluster method.
              #   result = client.remove_virtual_machine_exadb_vm_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def remove_virtual_machine_exadb_vm_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::RemoveVirtualMachineExadbVmClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.remove_virtual_machine_exadb_vm_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.remove_virtual_machine_exadb_vm_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.remove_virtual_machine_exadb_vm_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.remove_virtual_machine_exadb_vm_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the ExascaleDB Storage Vaults for the given project and
              # location.
              #
              # @overload list_exascale_db_storage_vaults(request, options = nil)
              #   Pass arguments to `list_exascale_db_storage_vaults` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_exascale_db_storage_vaults(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_exascale_db_storage_vaults` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for ExascaleDbStorageVault in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 ExascaleDbStorageVaults will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. Filter
              #     the list as specified in https://google.aip.dev/160.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request. Order
              #     results as specified in https://google.aip.dev/132.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsRequest.new
              #
              #   # Call the list_exascale_db_storage_vaults method.
              #   result = client.list_exascale_db_storage_vaults request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault.
              #     p item
              #   end
              #
              def list_exascale_db_storage_vaults request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListExascaleDbStorageVaultsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_exascale_db_storage_vaults.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_exascale_db_storage_vaults.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_exascale_db_storage_vaults.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_exascale_db_storage_vaults request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_exascale_db_storage_vaults, "exascale_db_storage_vaults", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ExascaleDB Storage Vault.
              #
              # @overload get_exascale_db_storage_vault(request, options = nil)
              #   Pass arguments to `get_exascale_db_storage_vault` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetExascaleDbStorageVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetExascaleDbStorageVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_exascale_db_storage_vault(name: nil)
              #   Pass arguments to `get_exascale_db_storage_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ExascaleDbStorageVault in the following format:
              #     projects/\\{project}/locations/\\{location}/exascaleDbStorageVaults/\\{exascale_db_storage_vault}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetExascaleDbStorageVaultRequest.new
              #
              #   # Call the get_exascale_db_storage_vault method.
              #   result = client.get_exascale_db_storage_vault request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault.
              #   p result
              #
              def get_exascale_db_storage_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetExascaleDbStorageVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_exascale_db_storage_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_exascale_db_storage_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_exascale_db_storage_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_exascale_db_storage_vault request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new ExascaleDB Storage Vault resource.
              #
              # @overload create_exascale_db_storage_vault(request, options = nil)
              #   Pass arguments to `create_exascale_db_storage_vault` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateExascaleDbStorageVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateExascaleDbStorageVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_exascale_db_storage_vault(parent: nil, exascale_db_storage_vault_id: nil, exascale_db_storage_vault: nil, request_id: nil)
              #   Pass arguments to `create_exascale_db_storage_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The value for parent of the ExascaleDbStorageVault in the
              #     following format: projects/\\{project}/locations/\\{location}.
              #   @param exascale_db_storage_vault_id [::String]
              #     Required. The ID of the ExascaleDbStorageVault to create. This value is
              #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
              #     63 characters in length. The value must start with a letter and end with a
              #     letter or a number.
              #   @param exascale_db_storage_vault [::Google::Cloud::OracleDatabase::V1::ExascaleDbStorageVault, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateExascaleDbStorageVaultRequest.new
              #
              #   # Call the create_exascale_db_storage_vault method.
              #   result = client.create_exascale_db_storage_vault request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_exascale_db_storage_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateExascaleDbStorageVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_exascale_db_storage_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_exascale_db_storage_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_exascale_db_storage_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_exascale_db_storage_vault request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single ExascaleDB Storage Vault.
              #
              # @overload delete_exascale_db_storage_vault(request, options = nil)
              #   Pass arguments to `delete_exascale_db_storage_vault` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteExascaleDbStorageVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteExascaleDbStorageVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_exascale_db_storage_vault(name: nil, request_id: nil)
              #   Pass arguments to `delete_exascale_db_storage_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ExascaleDbStorageVault in the following format:
              #     projects/\\{project}/locations/\\{location}/exascaleDbStorageVaults/\\{exascale_db_storage_vault}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteExascaleDbStorageVaultRequest.new
              #
              #   # Call the delete_exascale_db_storage_vault method.
              #   result = client.delete_exascale_db_storage_vault request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_exascale_db_storage_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteExascaleDbStorageVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_exascale_db_storage_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_exascale_db_storage_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_exascale_db_storage_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_exascale_db_storage_vault request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the DbSystemInitialStorageSizes for the given project and
              # location.
              #
              # @overload list_db_system_initial_storage_sizes(request, options = nil)
              #   Pass arguments to `list_db_system_initial_storage_sizes` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_db_system_initial_storage_sizes(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_db_system_initial_storage_sizes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the DbSystemInitialStorageSize resource with
              #     the format: projects/\\{project}/locations/\\{location}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 DbSystemInitialStorageSizes will be
              #     returned. The maximum value is 1000; values above 1000 will be reset to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A token identifying the requested page of results to return. All
              #     fields except the filter should remain the same as in the request that
              #     provided this page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSize>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSize>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesRequest.new
              #
              #   # Call the list_db_system_initial_storage_sizes method.
              #   result = client.list_db_system_initial_storage_sizes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DbSystemInitialStorageSize.
              #     p item
              #   end
              #
              def list_db_system_initial_storage_sizes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDbSystemInitialStorageSizesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_db_system_initial_storage_sizes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_db_system_initial_storage_sizes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_db_system_initial_storage_sizes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_db_system_initial_storage_sizes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_db_system_initial_storage_sizes, "db_system_initial_storage_sizes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the Databases for the given project, location and DbSystem.
              #
              # @overload list_databases(request, options = nil)
              #   Pass arguments to `list_databases` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDatabasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDatabasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_databases(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_databases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name in the following format:
              #     projects/\\{project}/locations/\\{region}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 Databases will be returned.
              #     The maximum value is 1000; values above 1000 will be reset to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying the requested page of results to return. All
              #     fields except the filter should remain the same as in the request that
              #     provided this page token.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. list for
              #     container databases is supported only with a valid dbSystem (full resource
              #     name) filter in this format:
              #     `dbSystem="projects/{project}/locations/{location}/dbSystems/{dbSystemId}"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::Database>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::Database>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDatabasesRequest.new
              #
              #   # Call the list_databases method.
              #   result = client.list_databases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::Database.
              #     p item
              #   end
              #
              def list_databases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDatabasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_databases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_databases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_databases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_databases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_databases, "databases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Database.
              #
              # @overload get_database(request, options = nil)
              #   Pass arguments to `get_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_database(name: nil)
              #   Pass arguments to `get_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Database resource in the following format:
              #     projects/\\{project}/locations/\\{region}/databases/\\{database}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::Database]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::Database]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetDatabaseRequest.new
              #
              #   # Call the get_database method.
              #   result = client.get_database request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::Database.
              #   p result
              #
              def get_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_database request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the PluggableDatabases for the given project, location and
              # Container Database.
              #
              # @overload list_pluggable_databases(request, options = nil)
              #   Pass arguments to `list_pluggable_databases` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_pluggable_databases(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_pluggable_databases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of PluggableDatabases.
              #     Format: projects/\\{project}/locations/\\{location}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of PluggableDatabases to return. The service
              #     may return fewer than this value.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListPluggableDatabases`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListPluggableDatabases`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. List for
              #     pluggable databases is supported only with a valid container database (full
              #     resource name) filter in this format:
              #     `database="projects/{project}/locations/{location}/databases/{database}"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::PluggableDatabase>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::PluggableDatabase>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesRequest.new
              #
              #   # Call the list_pluggable_databases method.
              #   result = client.list_pluggable_databases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::PluggableDatabase.
              #     p item
              #   end
              #
              def list_pluggable_databases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListPluggableDatabasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_pluggable_databases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_pluggable_databases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_pluggable_databases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_pluggable_databases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_pluggable_databases, "pluggable_databases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single PluggableDatabase.
              #
              # @overload get_pluggable_database(request, options = nil)
              #   Pass arguments to `get_pluggable_database` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetPluggableDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetPluggableDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_pluggable_database(name: nil)
              #   Pass arguments to `get_pluggable_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the PluggableDatabase resource in the following
              #     format:
              #     projects/\\{project}/locations/\\{region}/pluggableDatabases/\\{pluggable_database}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::PluggableDatabase]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::PluggableDatabase]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetPluggableDatabaseRequest.new
              #
              #   # Call the get_pluggable_database method.
              #   result = client.get_pluggable_database request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::PluggableDatabase.
              #   p result
              #
              def get_pluggable_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetPluggableDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_pluggable_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_pluggable_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_pluggable_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_pluggable_database request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the DbSystems for the given project and location.
              #
              # @overload list_db_systems(request, options = nil)
              #   Pass arguments to `list_db_systems` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDbSystemsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDbSystemsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_db_systems(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_db_systems` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for DbSystems in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, at most 50 DbSystems will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request.
              #   @param order_by [::String]
              #     Optional. An expression for ordering the results of the request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbSystem>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbSystem>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDbSystemsRequest.new
              #
              #   # Call the list_db_systems method.
              #   result = client.list_db_systems request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DbSystem.
              #     p item
              #   end
              #
              def list_db_systems request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDbSystemsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_db_systems.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_db_systems.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_db_systems.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_db_systems request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_db_systems, "db_systems", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single DbSystem.
              #
              # @overload get_db_system(request, options = nil)
              #   Pass arguments to `get_db_system` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::GetDbSystemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::GetDbSystemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_db_system(name: nil)
              #   Pass arguments to `get_db_system` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DbSystem in the following format:
              #     projects/\\{project}/locations/\\{location}/dbSystems/\\{db_system}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::OracleDatabase::V1::DbSystem]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::OracleDatabase::V1::DbSystem]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::GetDbSystemRequest.new
              #
              #   # Call the get_db_system method.
              #   result = client.get_db_system request
              #
              #   # The returned object is of type Google::Cloud::OracleDatabase::V1::DbSystem.
              #   p result
              #
              def get_db_system request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::GetDbSystemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_db_system.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_db_system.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_db_system.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.get_db_system request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new DbSystem in a given project and location.
              #
              # @overload create_db_system(request, options = nil)
              #   Pass arguments to `create_db_system` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::CreateDbSystemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::CreateDbSystemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_db_system(parent: nil, db_system_id: nil, db_system: nil, request_id: nil)
              #   Pass arguments to `create_db_system` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The value for parent of the DbSystem in the following format:
              #     projects/\\{project}/locations/\\{location}.
              #   @param db_system_id [::String]
              #     Required. The ID of the DbSystem to create. This value is
              #     restricted to (^[a-z]([a-z0-9-]\\{0,61}[a-z0-9])?$) and must be a maximum of
              #     63 characters in length. The value must start with a letter and end with a
              #     letter or a number.
              #   @param db_system [::Google::Cloud::OracleDatabase::V1::DbSystem, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::CreateDbSystemRequest.new
              #
              #   # Call the create_db_system method.
              #   result = client.create_db_system request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_db_system request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::CreateDbSystemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_db_system.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_db_system.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_db_system.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.create_db_system request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DbSystem.
              #
              # @overload delete_db_system(request, options = nil)
              #   Pass arguments to `delete_db_system` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::DeleteDbSystemRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::DeleteDbSystemRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_db_system(name: nil, request_id: nil)
              #   Pass arguments to `delete_db_system` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DbSystem in the following format:
              #     projects/\\{project}/locations/\\{location}/dbSystems/\\{db_system}.
              #   @param request_id [::String]
              #     Optional. An optional ID to identify the request. This value is used to
              #     identify duplicate requests. If you make a request with the same request ID
              #     and the original request is still in progress or completed, the server
              #     ignores the second request. This prevents clients from
              #     accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::DeleteDbSystemRequest.new
              #
              #   # Call the delete_db_system method.
              #   result = client.delete_db_system request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_db_system request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::DeleteDbSystemRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_db_system.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_db_system.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_db_system.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.delete_db_system request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List DbVersions for the given project and location.
              #
              # @overload list_db_versions(request, options = nil)
              #   Pass arguments to `list_db_versions` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDbVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDbVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_db_versions(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_db_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for the DbVersion resource with the
              #     format: projects/\\{project}/locations/\\{location}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #     If unspecified, a maximum of 50 DbVersions will be returned.
              #     The maximum value is 1000; values above 1000 will be reset to 1000.
              #   @param page_token [::String]
              #     Optional. A token identifying the requested page of results to return. All
              #     fields except the filter should remain the same as in the request that
              #     provided this page token.
              #   @param filter [::String]
              #     Optional. Filter expression that matches a subset of the DbVersions to
              #     show. The supported filter for dbSystem creation is `db_system_shape =
              #     \\{db_system_shape} AND storage_management = \\{storage_management}`. If no
              #     filter is provided, all DbVersions will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DbVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDbVersionsRequest.new
              #
              #   # Call the list_db_versions method.
              #   result = client.list_db_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DbVersion.
              #     p item
              #   end
              #
              def list_db_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDbVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_db_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_db_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_db_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_db_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_db_versions, "db_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List DatabaseCharacterSets for the given project and location.
              #
              # @overload list_database_character_sets(request, options = nil)
              #   Pass arguments to `list_database_character_sets` via a request object, either of type
              #   {::Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_database_character_sets(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_database_character_sets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent value for DatabaseCharacterSets in the following
              #     format: projects/\\{project}/locations/\\{location}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of DatabaseCharacterSets to return. The
              #     service may return fewer than this value. If unspecified, at most 50
              #     DatabaseCharacterSets will be returned. The maximum value is 1000; values
              #     above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListDatabaseCharacterSets` call. Provide this to retrieve the subsequent
              #     page.
              #
              #     When paginating, all other parameters provided to
              #     `ListDatabaseCharacterSets` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the request. Only the
              #     **character_set_type** field is supported in the following format:
              #     `character_set_type="{characterSetType}"`. Accepted values include
              #     `DATABASE` and `NATIONAL`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DatabaseCharacterSet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::OracleDatabase::V1::DatabaseCharacterSet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/oracle_database/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsRequest.new
              #
              #   # Call the list_database_character_sets method.
              #   result = client.list_database_character_sets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::OracleDatabase::V1::DatabaseCharacterSet.
              #     p item
              #   end
              #
              def list_database_character_sets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::OracleDatabase::V1::ListDatabaseCharacterSetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_database_character_sets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::OracleDatabase::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_database_character_sets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_database_character_sets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @oracle_database_stub.list_database_character_sets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @oracle_database_stub, :list_database_character_sets, "database_character_sets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the OracleDatabase REST API.
              #
              # This class represents the configuration for OracleDatabase REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_cloud_exadata_infrastructures to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_cloud_exadata_infrastructures.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::OracleDatabase::V1::OracleDatabase::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_cloud_exadata_infrastructures.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "oracledatabase.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the OracleDatabase API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_cloud_exadata_infrastructures`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cloud_exadata_infrastructures
                  ##
                  # RPC-specific configuration for `get_cloud_exadata_infrastructure`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cloud_exadata_infrastructure
                  ##
                  # RPC-specific configuration for `create_cloud_exadata_infrastructure`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cloud_exadata_infrastructure
                  ##
                  # RPC-specific configuration for `delete_cloud_exadata_infrastructure`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cloud_exadata_infrastructure
                  ##
                  # RPC-specific configuration for `list_cloud_vm_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cloud_vm_clusters
                  ##
                  # RPC-specific configuration for `get_cloud_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cloud_vm_cluster
                  ##
                  # RPC-specific configuration for `create_cloud_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cloud_vm_cluster
                  ##
                  # RPC-specific configuration for `delete_cloud_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cloud_vm_cluster
                  ##
                  # RPC-specific configuration for `list_entitlements`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_entitlements
                  ##
                  # RPC-specific configuration for `list_db_servers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_db_servers
                  ##
                  # RPC-specific configuration for `list_db_nodes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_db_nodes
                  ##
                  # RPC-specific configuration for `list_gi_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_gi_versions
                  ##
                  # RPC-specific configuration for `list_minor_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_minor_versions
                  ##
                  # RPC-specific configuration for `list_db_system_shapes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_db_system_shapes
                  ##
                  # RPC-specific configuration for `list_autonomous_databases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_autonomous_databases
                  ##
                  # RPC-specific configuration for `get_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_autonomous_database
                  ##
                  # RPC-specific configuration for `create_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_autonomous_database
                  ##
                  # RPC-specific configuration for `update_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_autonomous_database
                  ##
                  # RPC-specific configuration for `delete_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_autonomous_database
                  ##
                  # RPC-specific configuration for `restore_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_autonomous_database
                  ##
                  # RPC-specific configuration for `generate_autonomous_database_wallet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_autonomous_database_wallet
                  ##
                  # RPC-specific configuration for `list_autonomous_db_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_autonomous_db_versions
                  ##
                  # RPC-specific configuration for `list_autonomous_database_character_sets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_autonomous_database_character_sets
                  ##
                  # RPC-specific configuration for `list_autonomous_database_backups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_autonomous_database_backups
                  ##
                  # RPC-specific configuration for `stop_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_autonomous_database
                  ##
                  # RPC-specific configuration for `start_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_autonomous_database
                  ##
                  # RPC-specific configuration for `restart_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restart_autonomous_database
                  ##
                  # RPC-specific configuration for `switchover_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :switchover_autonomous_database
                  ##
                  # RPC-specific configuration for `failover_autonomous_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :failover_autonomous_database
                  ##
                  # RPC-specific configuration for `list_odb_networks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_odb_networks
                  ##
                  # RPC-specific configuration for `get_odb_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_odb_network
                  ##
                  # RPC-specific configuration for `create_odb_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_odb_network
                  ##
                  # RPC-specific configuration for `delete_odb_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_odb_network
                  ##
                  # RPC-specific configuration for `list_odb_subnets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_odb_subnets
                  ##
                  # RPC-specific configuration for `get_odb_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_odb_subnet
                  ##
                  # RPC-specific configuration for `create_odb_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_odb_subnet
                  ##
                  # RPC-specific configuration for `delete_odb_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_odb_subnet
                  ##
                  # RPC-specific configuration for `list_exadb_vm_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_exadb_vm_clusters
                  ##
                  # RPC-specific configuration for `get_exadb_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_exadb_vm_cluster
                  ##
                  # RPC-specific configuration for `create_exadb_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_exadb_vm_cluster
                  ##
                  # RPC-specific configuration for `delete_exadb_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_exadb_vm_cluster
                  ##
                  # RPC-specific configuration for `update_exadb_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_exadb_vm_cluster
                  ##
                  # RPC-specific configuration for `remove_virtual_machine_exadb_vm_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :remove_virtual_machine_exadb_vm_cluster
                  ##
                  # RPC-specific configuration for `list_exascale_db_storage_vaults`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_exascale_db_storage_vaults
                  ##
                  # RPC-specific configuration for `get_exascale_db_storage_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_exascale_db_storage_vault
                  ##
                  # RPC-specific configuration for `create_exascale_db_storage_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_exascale_db_storage_vault
                  ##
                  # RPC-specific configuration for `delete_exascale_db_storage_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_exascale_db_storage_vault
                  ##
                  # RPC-specific configuration for `list_db_system_initial_storage_sizes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_db_system_initial_storage_sizes
                  ##
                  # RPC-specific configuration for `list_databases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_databases
                  ##
                  # RPC-specific configuration for `get_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_database
                  ##
                  # RPC-specific configuration for `list_pluggable_databases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_pluggable_databases
                  ##
                  # RPC-specific configuration for `get_pluggable_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_pluggable_database
                  ##
                  # RPC-specific configuration for `list_db_systems`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_db_systems
                  ##
                  # RPC-specific configuration for `get_db_system`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_db_system
                  ##
                  # RPC-specific configuration for `create_db_system`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_db_system
                  ##
                  # RPC-specific configuration for `delete_db_system`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_db_system
                  ##
                  # RPC-specific configuration for `list_db_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_db_versions
                  ##
                  # RPC-specific configuration for `list_database_character_sets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_database_character_sets

                  # @private
                  def initialize parent_rpcs = nil
                    list_cloud_exadata_infrastructures_config = parent_rpcs.list_cloud_exadata_infrastructures if parent_rpcs.respond_to? :list_cloud_exadata_infrastructures
                    @list_cloud_exadata_infrastructures = ::Gapic::Config::Method.new list_cloud_exadata_infrastructures_config
                    get_cloud_exadata_infrastructure_config = parent_rpcs.get_cloud_exadata_infrastructure if parent_rpcs.respond_to? :get_cloud_exadata_infrastructure
                    @get_cloud_exadata_infrastructure = ::Gapic::Config::Method.new get_cloud_exadata_infrastructure_config
                    create_cloud_exadata_infrastructure_config = parent_rpcs.create_cloud_exadata_infrastructure if parent_rpcs.respond_to? :create_cloud_exadata_infrastructure
                    @create_cloud_exadata_infrastructure = ::Gapic::Config::Method.new create_cloud_exadata_infrastructure_config
                    delete_cloud_exadata_infrastructure_config = parent_rpcs.delete_cloud_exadata_infrastructure if parent_rpcs.respond_to? :delete_cloud_exadata_infrastructure
                    @delete_cloud_exadata_infrastructure = ::Gapic::Config::Method.new delete_cloud_exadata_infrastructure_config
                    list_cloud_vm_clusters_config = parent_rpcs.list_cloud_vm_clusters if parent_rpcs.respond_to? :list_cloud_vm_clusters
                    @list_cloud_vm_clusters = ::Gapic::Config::Method.new list_cloud_vm_clusters_config
                    get_cloud_vm_cluster_config = parent_rpcs.get_cloud_vm_cluster if parent_rpcs.respond_to? :get_cloud_vm_cluster
                    @get_cloud_vm_cluster = ::Gapic::Config::Method.new get_cloud_vm_cluster_config
                    create_cloud_vm_cluster_config = parent_rpcs.create_cloud_vm_cluster if parent_rpcs.respond_to? :create_cloud_vm_cluster
                    @create_cloud_vm_cluster = ::Gapic::Config::Method.new create_cloud_vm_cluster_config
                    delete_cloud_vm_cluster_config = parent_rpcs.delete_cloud_vm_cluster if parent_rpcs.respond_to? :delete_cloud_vm_cluster
                    @delete_cloud_vm_cluster = ::Gapic::Config::Method.new delete_cloud_vm_cluster_config
                    list_entitlements_config = parent_rpcs.list_entitlements if parent_rpcs.respond_to? :list_entitlements
                    @list_entitlements = ::Gapic::Config::Method.new list_entitlements_config
                    list_db_servers_config = parent_rpcs.list_db_servers if parent_rpcs.respond_to? :list_db_servers
                    @list_db_servers = ::Gapic::Config::Method.new list_db_servers_config
                    list_db_nodes_config = parent_rpcs.list_db_nodes if parent_rpcs.respond_to? :list_db_nodes
                    @list_db_nodes = ::Gapic::Config::Method.new list_db_nodes_config
                    list_gi_versions_config = parent_rpcs.list_gi_versions if parent_rpcs.respond_to? :list_gi_versions
                    @list_gi_versions = ::Gapic::Config::Method.new list_gi_versions_config
                    list_minor_versions_config = parent_rpcs.list_minor_versions if parent_rpcs.respond_to? :list_minor_versions
                    @list_minor_versions = ::Gapic::Config::Method.new list_minor_versions_config
                    list_db_system_shapes_config = parent_rpcs.list_db_system_shapes if parent_rpcs.respond_to? :list_db_system_shapes
                    @list_db_system_shapes = ::Gapic::Config::Method.new list_db_system_shapes_config
                    list_autonomous_databases_config = parent_rpcs.list_autonomous_databases if parent_rpcs.respond_to? :list_autonomous_databases
                    @list_autonomous_databases = ::Gapic::Config::Method.new list_autonomous_databases_config
                    get_autonomous_database_config = parent_rpcs.get_autonomous_database if parent_rpcs.respond_to? :get_autonomous_database
                    @get_autonomous_database = ::Gapic::Config::Method.new get_autonomous_database_config
                    create_autonomous_database_config = parent_rpcs.create_autonomous_database if parent_rpcs.respond_to? :create_autonomous_database
                    @create_autonomous_database = ::Gapic::Config::Method.new create_autonomous_database_config
                    update_autonomous_database_config = parent_rpcs.update_autonomous_database if parent_rpcs.respond_to? :update_autonomous_database
                    @update_autonomous_database = ::Gapic::Config::Method.new update_autonomous_database_config
                    delete_autonomous_database_config = parent_rpcs.delete_autonomous_database if parent_rpcs.respond_to? :delete_autonomous_database
                    @delete_autonomous_database = ::Gapic::Config::Method.new delete_autonomous_database_config
                    restore_autonomous_database_config = parent_rpcs.restore_autonomous_database if parent_rpcs.respond_to? :restore_autonomous_database
                    @restore_autonomous_database = ::Gapic::Config::Method.new restore_autonomous_database_config
                    generate_autonomous_database_wallet_config = parent_rpcs.generate_autonomous_database_wallet if parent_rpcs.respond_to? :generate_autonomous_database_wallet
                    @generate_autonomous_database_wallet = ::Gapic::Config::Method.new generate_autonomous_database_wallet_config
                    list_autonomous_db_versions_config = parent_rpcs.list_autonomous_db_versions if parent_rpcs.respond_to? :list_autonomous_db_versions
                    @list_autonomous_db_versions = ::Gapic::Config::Method.new list_autonomous_db_versions_config
                    list_autonomous_database_character_sets_config = parent_rpcs.list_autonomous_database_character_sets if parent_rpcs.respond_to? :list_autonomous_database_character_sets
                    @list_autonomous_database_character_sets = ::Gapic::Config::Method.new list_autonomous_database_character_sets_config
                    list_autonomous_database_backups_config = parent_rpcs.list_autonomous_database_backups if parent_rpcs.respond_to? :list_autonomous_database_backups
                    @list_autonomous_database_backups = ::Gapic::Config::Method.new list_autonomous_database_backups_config
                    stop_autonomous_database_config = parent_rpcs.stop_autonomous_database if parent_rpcs.respond_to? :stop_autonomous_database
                    @stop_autonomous_database = ::Gapic::Config::Method.new stop_autonomous_database_config
                    start_autonomous_database_config = parent_rpcs.start_autonomous_database if parent_rpcs.respond_to? :start_autonomous_database
                    @start_autonomous_database = ::Gapic::Config::Method.new start_autonomous_database_config
                    restart_autonomous_database_config = parent_rpcs.restart_autonomous_database if parent_rpcs.respond_to? :restart_autonomous_database
                    @restart_autonomous_database = ::Gapic::Config::Method.new restart_autonomous_database_config
                    switchover_autonomous_database_config = parent_rpcs.switchover_autonomous_database if parent_rpcs.respond_to? :switchover_autonomous_database
                    @switchover_autonomous_database = ::Gapic::Config::Method.new switchover_autonomous_database_config
                    failover_autonomous_database_config = parent_rpcs.failover_autonomous_database if parent_rpcs.respond_to? :failover_autonomous_database
                    @failover_autonomous_database = ::Gapic::Config::Method.new failover_autonomous_database_config
                    list_odb_networks_config = parent_rpcs.list_odb_networks if parent_rpcs.respond_to? :list_odb_networks
                    @list_odb_networks = ::Gapic::Config::Method.new list_odb_networks_config
                    get_odb_network_config = parent_rpcs.get_odb_network if parent_rpcs.respond_to? :get_odb_network
                    @get_odb_network = ::Gapic::Config::Method.new get_odb_network_config
                    create_odb_network_config = parent_rpcs.create_odb_network if parent_rpcs.respond_to? :create_odb_network
                    @create_odb_network = ::Gapic::Config::Method.new create_odb_network_config
                    delete_odb_network_config = parent_rpcs.delete_odb_network if parent_rpcs.respond_to? :delete_odb_network
                    @delete_odb_network = ::Gapic::Config::Method.new delete_odb_network_config
                    list_odb_subnets_config = parent_rpcs.list_odb_subnets if parent_rpcs.respond_to? :list_odb_subnets
                    @list_odb_subnets = ::Gapic::Config::Method.new list_odb_subnets_config
                    get_odb_subnet_config = parent_rpcs.get_odb_subnet if parent_rpcs.respond_to? :get_odb_subnet
                    @get_odb_subnet = ::Gapic::Config::Method.new get_odb_subnet_config
                    create_odb_subnet_config = parent_rpcs.create_odb_subnet if parent_rpcs.respond_to? :create_odb_subnet
                    @create_odb_subnet = ::Gapic::Config::Method.new create_odb_subnet_config
                    delete_odb_subnet_config = parent_rpcs.delete_odb_subnet if parent_rpcs.respond_to? :delete_odb_subnet
                    @delete_odb_subnet = ::Gapic::Config::Method.new delete_odb_subnet_config
                    list_exadb_vm_clusters_config = parent_rpcs.list_exadb_vm_clusters if parent_rpcs.respond_to? :list_exadb_vm_clusters
                    @list_exadb_vm_clusters = ::Gapic::Config::Method.new list_exadb_vm_clusters_config
                    get_exadb_vm_cluster_config = parent_rpcs.get_exadb_vm_cluster if parent_rpcs.respond_to? :get_exadb_vm_cluster
                    @get_exadb_vm_cluster = ::Gapic::Config::Method.new get_exadb_vm_cluster_config
                    create_exadb_vm_cluster_config = parent_rpcs.create_exadb_vm_cluster if parent_rpcs.respond_to? :create_exadb_vm_cluster
                    @create_exadb_vm_cluster = ::Gapic::Config::Method.new create_exadb_vm_cluster_config
                    delete_exadb_vm_cluster_config = parent_rpcs.delete_exadb_vm_cluster if parent_rpcs.respond_to? :delete_exadb_vm_cluster
                    @delete_exadb_vm_cluster = ::Gapic::Config::Method.new delete_exadb_vm_cluster_config
                    update_exadb_vm_cluster_config = parent_rpcs.update_exadb_vm_cluster if parent_rpcs.respond_to? :update_exadb_vm_cluster
                    @update_exadb_vm_cluster = ::Gapic::Config::Method.new update_exadb_vm_cluster_config
                    remove_virtual_machine_exadb_vm_cluster_config = parent_rpcs.remove_virtual_machine_exadb_vm_cluster if parent_rpcs.respond_to? :remove_virtual_machine_exadb_vm_cluster
                    @remove_virtual_machine_exadb_vm_cluster = ::Gapic::Config::Method.new remove_virtual_machine_exadb_vm_cluster_config
                    list_exascale_db_storage_vaults_config = parent_rpcs.list_exascale_db_storage_vaults if parent_rpcs.respond_to? :list_exascale_db_storage_vaults
                    @list_exascale_db_storage_vaults = ::Gapic::Config::Method.new list_exascale_db_storage_vaults_config
                    get_exascale_db_storage_vault_config = parent_rpcs.get_exascale_db_storage_vault if parent_rpcs.respond_to? :get_exascale_db_storage_vault
                    @get_exascale_db_storage_vault = ::Gapic::Config::Method.new get_exascale_db_storage_vault_config
                    create_exascale_db_storage_vault_config = parent_rpcs.create_exascale_db_storage_vault if parent_rpcs.respond_to? :create_exascale_db_storage_vault
                    @create_exascale_db_storage_vault = ::Gapic::Config::Method.new create_exascale_db_storage_vault_config
                    delete_exascale_db_storage_vault_config = parent_rpcs.delete_exascale_db_storage_vault if parent_rpcs.respond_to? :delete_exascale_db_storage_vault
                    @delete_exascale_db_storage_vault = ::Gapic::Config::Method.new delete_exascale_db_storage_vault_config
                    list_db_system_initial_storage_sizes_config = parent_rpcs.list_db_system_initial_storage_sizes if parent_rpcs.respond_to? :list_db_system_initial_storage_sizes
                    @list_db_system_initial_storage_sizes = ::Gapic::Config::Method.new list_db_system_initial_storage_sizes_config
                    list_databases_config = parent_rpcs.list_databases if parent_rpcs.respond_to? :list_databases
                    @list_databases = ::Gapic::Config::Method.new list_databases_config
                    get_database_config = parent_rpcs.get_database if parent_rpcs.respond_to? :get_database
                    @get_database = ::Gapic::Config::Method.new get_database_config
                    list_pluggable_databases_config = parent_rpcs.list_pluggable_databases if parent_rpcs.respond_to? :list_pluggable_databases
                    @list_pluggable_databases = ::Gapic::Config::Method.new list_pluggable_databases_config
                    get_pluggable_database_config = parent_rpcs.get_pluggable_database if parent_rpcs.respond_to? :get_pluggable_database
                    @get_pluggable_database = ::Gapic::Config::Method.new get_pluggable_database_config
                    list_db_systems_config = parent_rpcs.list_db_systems if parent_rpcs.respond_to? :list_db_systems
                    @list_db_systems = ::Gapic::Config::Method.new list_db_systems_config
                    get_db_system_config = parent_rpcs.get_db_system if parent_rpcs.respond_to? :get_db_system
                    @get_db_system = ::Gapic::Config::Method.new get_db_system_config
                    create_db_system_config = parent_rpcs.create_db_system if parent_rpcs.respond_to? :create_db_system
                    @create_db_system = ::Gapic::Config::Method.new create_db_system_config
                    delete_db_system_config = parent_rpcs.delete_db_system if parent_rpcs.respond_to? :delete_db_system
                    @delete_db_system = ::Gapic::Config::Method.new delete_db_system_config
                    list_db_versions_config = parent_rpcs.list_db_versions if parent_rpcs.respond_to? :list_db_versions
                    @list_db_versions = ::Gapic::Config::Method.new list_db_versions_config
                    list_database_character_sets_config = parent_rpcs.list_database_character_sets if parent_rpcs.respond_to? :list_database_character_sets
                    @list_database_character_sets = ::Gapic::Config::Method.new list_database_character_sets_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
