# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module OracleDatabase
      module V1
        module OracleDatabase
          # Path helper methods for the OracleDatabase API.
          module Paths
            ##
            # Create a fully-qualified AutonomousDatabase resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/autonomousDatabases/{autonomous_database}`
            #
            # @param project [String]
            # @param location [String]
            # @param autonomous_database [String]
            #
            # @return [::String]
            def autonomous_database_path project:, location:, autonomous_database:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/autonomousDatabases/#{autonomous_database}"
            end

            ##
            # Create a fully-qualified CloudExadataInfrastructure resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}`
            #
            # @param project [String]
            # @param location [String]
            # @param cloud_exadata_infrastructure [String]
            #
            # @return [::String]
            def cloud_exadata_infrastructure_path project:, location:, cloud_exadata_infrastructure:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/cloudExadataInfrastructures/#{cloud_exadata_infrastructure}"
            end

            ##
            # Create a fully-qualified CloudVmCluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param cloud_vm_cluster [String]
            #
            # @return [::String]
            def cloud_vm_cluster_path project:, location:, cloud_vm_cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/cloudVmClusters/#{cloud_vm_cluster}"
            end

            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified Database resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/databases/{database}`
            #
            # @param project [String]
            # @param location [String]
            # @param database [String]
            #
            # @return [::String]
            def database_path project:, location:, database:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/databases/#{database}"
            end

            ##
            # Create a fully-qualified DbSystem resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/dbSystems/{db_system}`
            #
            # @param project [String]
            # @param location [String]
            # @param db_system [String]
            #
            # @return [::String]
            def db_system_path project:, location:, db_system:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/dbSystems/#{db_system}"
            end

            ##
            # Create a fully-qualified ExadbVmCluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param exadb_vm_cluster [String]
            #
            # @return [::String]
            def exadb_vm_cluster_path project:, location:, exadb_vm_cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/exadbVmClusters/#{exadb_vm_cluster}"
            end

            ##
            # Create a fully-qualified ExascaleDbStorageVault resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/exascaleDbStorageVaults/{exascale_db_storage_vault}`
            #
            # @param project [String]
            # @param location [String]
            # @param exascale_db_storage_vault [String]
            #
            # @return [::String]
            def exascale_db_storage_vault_path project:, location:, exascale_db_storage_vault:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/exascaleDbStorageVaults/#{exascale_db_storage_vault}"
            end

            ##
            # Create a fully-qualified GiVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/giVersions/{gi_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param gi_version [String]
            #
            # @return [::String]
            def gi_version_path project:, location:, gi_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/giVersions/#{gi_version}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified OdbNetwork resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/odbNetworks/{odb_network}`
            #
            # @param project [String]
            # @param location [String]
            # @param odb_network [String]
            #
            # @return [::String]
            def odb_network_path project:, location:, odb_network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/odbNetworks/#{odb_network}"
            end

            ##
            # Create a fully-qualified OdbSubnet resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}`
            #
            # @param project [String]
            # @param location [String]
            # @param odb_network [String]
            # @param odb_subnet [String]
            #
            # @return [::String]
            def odb_subnet_path project:, location:, odb_network:, odb_subnet:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "odb_network cannot contain /" if odb_network.to_s.include? "/"

              "projects/#{project}/locations/#{location}/odbNetworks/#{odb_network}/odbSubnets/#{odb_subnet}"
            end

            ##
            # Create a fully-qualified PluggableDatabase resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/pluggableDatabases/{pluggable_database}`
            #
            # @param project [String]
            # @param location [String]
            # @param pluggable_database [String]
            #
            # @return [::String]
            def pluggable_database_path project:, location:, pluggable_database:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/pluggableDatabases/#{pluggable_database}"
            end

            extend self
          end
        end
      end
    end
  end
end
