# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/optimization/v1/fleet_routing_pb"
require "google/cloud/optimization/v1/fleet_routing"

class ::Google::Cloud::Optimization::V1::FleetRouting::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_optimize_tours
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Optimization::V1::OptimizeToursResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    timeout = {}
    model = {}
    solving_mode = :DEFAULT_SOLVE
    search_mode = :SEARCH_MODE_UNSPECIFIED
    injected_first_solution_routes = [{}]
    injected_solution_constraint = {}
    refresh_details_routes = [{}]
    interpret_injected_solutions_using_labels = true
    consider_road_traffic = true
    populate_polylines = true
    populate_transition_polylines = true
    allow_large_deadline_despite_interruption_risk = true
    use_geodesic_distances = true
    geodesic_meters_per_second = 3.5
    max_validation_errors = 42
    label = "hello world"
    populate_travel_step_polylines = true

    optimize_tours_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :optimize_tours, name
      assert_kind_of ::Google::Cloud::Optimization::V1::OptimizeToursRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["timeout"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Optimization::V1::ShipmentModel), request["model"]
      assert_equal :DEFAULT_SOLVE, request["solving_mode"]
      assert_equal :SEARCH_MODE_UNSPECIFIED, request["search_mode"]
      assert_kind_of ::Google::Cloud::Optimization::V1::ShipmentRoute, request["injected_first_solution_routes"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Optimization::V1::InjectedSolutionConstraint), request["injected_solution_constraint"]
      assert_kind_of ::Google::Cloud::Optimization::V1::ShipmentRoute, request["refresh_details_routes"].first
      assert_equal true, request["interpret_injected_solutions_using_labels"]
      assert_equal true, request["consider_road_traffic"]
      assert_equal true, request["populate_polylines"]
      assert_equal true, request["populate_transition_polylines"]
      assert_equal true, request["allow_large_deadline_despite_interruption_risk"]
      assert_equal true, request["use_geodesic_distances"]
      assert_equal 3.5, request["geodesic_meters_per_second"]
      assert request.has_geodesic_meters_per_second?
      assert_equal 42, request["max_validation_errors"]
      assert request.has_max_validation_errors?
      assert_equal "hello world", request["label"]
      assert_equal true, request["populate_travel_step_polylines"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, optimize_tours_client_stub do
      # Create client
      client = ::Google::Cloud::Optimization::V1::FleetRouting::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.optimize_tours({ parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.optimize_tours parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.optimize_tours ::Google::Cloud::Optimization::V1::OptimizeToursRequest.new(parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.optimize_tours({ parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.optimize_tours(::Google::Cloud::Optimization::V1::OptimizeToursRequest.new(parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, optimize_tours_client_stub.call_rpc_count
    end
  end

  def test_batch_optimize_tours
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_configs = [{}]

    batch_optimize_tours_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_optimize_tours, name
      assert_kind_of ::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest::AsyncModelConfig, request["model_configs"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_optimize_tours_client_stub do
      # Create client
      client = ::Google::Cloud::Optimization::V1::FleetRouting::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_optimize_tours({ parent: parent, model_configs: model_configs }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_optimize_tours parent: parent, model_configs: model_configs do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_optimize_tours ::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest.new(parent: parent, model_configs: model_configs) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_optimize_tours({ parent: parent, model_configs: model_configs }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_optimize_tours(::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest.new(parent: parent, model_configs: model_configs), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_optimize_tours_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Optimization::V1::FleetRouting::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Optimization::V1::FleetRouting::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Optimization::V1::FleetRouting::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Optimization::V1::FleetRouting::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Optimization::V1::FleetRouting::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Optimization::V1::FleetRouting::Operations, client.operations_client
  end
end
