# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/optimization/v1/fleet_routing_pb"
require "google/cloud/optimization/v1/fleet_routing/rest"


class ::Google::Cloud::Optimization::V1::FleetRouting::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_optimize_tours
    # Create test objects.
    client_result = ::Google::Cloud::Optimization::V1::OptimizeToursResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    timeout = {}
    model = {}
    solving_mode = :DEFAULT_SOLVE
    search_mode = :SEARCH_MODE_UNSPECIFIED
    injected_first_solution_routes = [{}]
    injected_solution_constraint = {}
    refresh_details_routes = [{}]
    interpret_injected_solutions_using_labels = true
    consider_road_traffic = true
    populate_polylines = true
    populate_transition_polylines = true
    allow_large_deadline_despite_interruption_risk = true
    use_geodesic_distances = true
    geodesic_meters_per_second = 3.5
    max_validation_errors = 42
    label = "hello world"
    populate_travel_step_polylines = true

    optimize_tours_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Optimization::V1::FleetRouting::Rest::ServiceStub.stub :transcode_optimize_tours_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, optimize_tours_client_stub do
        # Create client
        client = ::Google::Cloud::Optimization::V1::FleetRouting::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.optimize_tours({ parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.optimize_tours parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.optimize_tours ::Google::Cloud::Optimization::V1::OptimizeToursRequest.new(parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.optimize_tours({ parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.optimize_tours(::Google::Cloud::Optimization::V1::OptimizeToursRequest.new(parent: parent, timeout: timeout, model: model, solving_mode: solving_mode, search_mode: search_mode, injected_first_solution_routes: injected_first_solution_routes, injected_solution_constraint: injected_solution_constraint, refresh_details_routes: refresh_details_routes, interpret_injected_solutions_using_labels: interpret_injected_solutions_using_labels, consider_road_traffic: consider_road_traffic, populate_polylines: populate_polylines, populate_transition_polylines: populate_transition_polylines, allow_large_deadline_despite_interruption_risk: allow_large_deadline_despite_interruption_risk, use_geodesic_distances: use_geodesic_distances, geodesic_meters_per_second: geodesic_meters_per_second, max_validation_errors: max_validation_errors, label: label, populate_travel_step_polylines: populate_travel_step_polylines), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, optimize_tours_client_stub.call_count
      end
    end
  end

  def test_batch_optimize_tours
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_configs = [{}]

    batch_optimize_tours_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Optimization::V1::FleetRouting::Rest::ServiceStub.stub :transcode_batch_optimize_tours_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_optimize_tours_client_stub do
        # Create client
        client = ::Google::Cloud::Optimization::V1::FleetRouting::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_optimize_tours({ parent: parent, model_configs: model_configs }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_optimize_tours parent: parent, model_configs: model_configs do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_optimize_tours ::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest.new(parent: parent, model_configs: model_configs) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_optimize_tours({ parent: parent, model_configs: model_configs }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_optimize_tours(::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest.new(parent: parent, model_configs: model_configs), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_optimize_tours_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Optimization::V1::FleetRouting::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Optimization::V1::FleetRouting::Rest::Client::Configuration, config
  end
end
