# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/optimization/v1/fleet_routing.proto for package 'google.cloud.optimization.v1'
# Original file comments:
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/optimization/v1/fleet_routing_pb'

module Google
  module Cloud
    module Optimization
      module V1
        module FleetRouting
          # A service for optimizing vehicle tours.
          #
          # Validity of certain types of fields:
          #
          #   * `google.protobuf.Timestamp`
          #     * Times are in Unix time: seconds since 1970-01-01T00:00:00+00:00.
          #     * seconds must be in [0, 253402300799],
          #       i.e. in [1970-01-01T00:00:00+00:00, 9999-12-31T23:59:59+00:00].
          #     * nanos must be unset or set to 0.
          #   * `google.protobuf.Duration`
          #     * seconds must be in [0, 253402300799],
          #       i.e. in [1970-01-01T00:00:00+00:00, 9999-12-31T23:59:59+00:00].
          #     * nanos must be unset or set to 0.
          #   * `google.type.LatLng`
          #     * latitude must be in [-90.0, 90.0].
          #     * longitude must be in [-180.0, 180.0].
          #     * at least one of latitude and longitude must be non-zero.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.optimization.v1.FleetRouting'

            # Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
            # `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
            # routes to be performed by vehicles minimizing the overall cost.
            #
            # A `ShipmentModel` model consists mainly of `Shipment`s that need to be
            # carried out and `Vehicle`s that can be used to transport the `Shipment`s.
            # The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
            # they assign a series of `Visit`s to each vehicle, where a `Visit`
            # corresponds to a `VisitRequest`, which is a pickup or delivery for a
            # `Shipment`.
            #
            # The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
            # minimizes the total cost where cost has many components defined in the
            # `ShipmentModel`.
            rpc :OptimizeTours, ::Google::Cloud::Optimization::V1::OptimizeToursRequest, ::Google::Cloud::Optimization::V1::OptimizeToursResponse
            # Optimizes vehicle tours for one or more `OptimizeToursRequest`
            # messages as a batch.
            #
            # This method is a Long Running Operation (LRO). The inputs for optimization
            # (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
            # messages) are read/written from/to Cloud Storage in user-specified
            # format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
            # contains a `ShipmentModel` and returns an `OptimizeToursResponse`
            # containing `ShipmentRoute`s, which are a set of routes to be performed by
            # vehicles minimizing the overall cost.
            rpc :BatchOptimizeTours, ::Google::Cloud::Optimization::V1::BatchOptimizeToursRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
