# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Notebooks
      module V2
        # The entry of VM image upgrade history.
        # @!attribute [rw] snapshot
        #   @return [::String]
        #     Optional. The snapshot of the boot disk of this notebook instance before
        #     upgrade.
        # @!attribute [rw] vm_image
        #   @return [::String]
        #     Optional. The VM image before this instance upgrade.
        # @!attribute [rw] container_image
        #   @return [::String]
        #     Optional. The container image before this instance upgrade.
        # @!attribute [rw] framework
        #   @return [::String]
        #     Optional. The framework of this notebook instance.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. The version of the notebook instance before this upgrade.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Notebooks::V2::UpgradeHistoryEntry::State]
        #     Output only. The state of this instance upgrade history entry.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Immutable. The time that this instance upgrade history entry is created.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::Notebooks::V2::UpgradeHistoryEntry::Action]
        #     Optional. Action. Rolloback or Upgrade.
        # @!attribute [rw] target_version
        #   @return [::String]
        #     Optional. Target VM Version, like m63.
        class UpgradeHistoryEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The definition of the states of this upgrade history entry.
          module State
            # State is not specified.
            STATE_UNSPECIFIED = 0

            # The instance upgrade is started.
            STARTED = 1

            # The instance upgrade is succeeded.
            SUCCEEDED = 2

            # The instance upgrade is failed.
            FAILED = 3
          end

          # The definition of operations of this upgrade history entry.
          module Action
            # Operation is not specified.
            ACTION_UNSPECIFIED = 0

            # Upgrade.
            UPGRADE = 1

            # Rollback.
            ROLLBACK = 2
          end
        end

        # The definition of a notebook instance.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of this notebook instance. Format:
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
        # @!attribute [rw] gce_setup
        #   @return [::Google::Cloud::Notebooks::V2::GceSetup]
        #     Optional. Compute Engine setup for the notebook. Uses notebook-defined
        #     fields.
        # @!attribute [r] proxy_uri
        #   @return [::String]
        #     Output only. The proxy endpoint that is used to access the Jupyter
        #     notebook.
        # @!attribute [rw] instance_owners
        #   @return [::Array<::String>]
        #     Optional. Input only. The owner of this instance after creation. Format:
        #     `alias@example.com`
        #
        #     Currently supports one owner only. If not specified, all of the service
        #     account users of your VM instance's service account can use
        #     the instance.
        # @!attribute [r] creator
        #   @return [::String]
        #     Output only. Email address of entity that sent original CreateInstance
        #     request.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Notebooks::V2::State]
        #     Output only. The state of this instance.
        # @!attribute [r] upgrade_history
        #   @return [::Array<::Google::Cloud::Notebooks::V2::UpgradeHistoryEntry>]
        #     Output only. The upgrade history of this instance.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. Unique ID of the resource.
        # @!attribute [r] health_state
        #   @return [::Google::Cloud::Notebooks::V2::HealthState]
        #     Output only. Instance health_state.
        # @!attribute [r] health_info
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Additional information about instance health.
        #     Example:
        #
        #         healthInfo": {
        #           "docker_proxy_agent_status": "1",
        #           "docker_status": "1",
        #           "jupyterlab_api_status": "-1",
        #           "jupyterlab_status": "-1",
        #           "updated": "2020-10-18 09:40:03.573409"
        #         }
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Instance creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Instance update time.
        # @!attribute [rw] disable_proxy_access
        #   @return [::Boolean]
        #     Optional. If true, the notebook instance will not register with the proxy.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels to apply to this instance.
        #     These can be later modified by the UpdateInstance method.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class HealthInfoEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The definition of the states of this instance.
        module State
          # State is not specified.
          STATE_UNSPECIFIED = 0

          # The control logic is starting the instance.
          STARTING = 1

          # The control logic is installing required frameworks and registering the
          # instance with notebook proxy
          PROVISIONING = 2

          # The instance is running.
          ACTIVE = 3

          # The control logic is stopping the instance.
          STOPPING = 4

          # The instance is stopped.
          STOPPED = 5

          # The instance is deleted.
          DELETED = 6

          # The instance is upgrading.
          UPGRADING = 7

          # The instance is being created.
          INITIALIZING = 8

          # The instance is suspending.
          SUSPENDING = 9

          # The instance is suspended.
          SUSPENDED = 10
        end

        # The instance health state.
        module HealthState
          # The instance substate is unknown.
          HEALTH_STATE_UNSPECIFIED = 0

          # The instance is known to be in an healthy state
          # (for example, critical daemons are running)
          # Applies to ACTIVE state.
          HEALTHY = 1

          # The instance is known to be in an unhealthy state
          # (for example, critical daemons are not running)
          # Applies to ACTIVE state.
          UNHEALTHY = 2

          # The instance has not installed health monitoring agent.
          # Applies to ACTIVE state.
          AGENT_NOT_INSTALLED = 3

          # The instance health monitoring agent is not running.
          # Applies to ACTIVE state.
          AGENT_NOT_RUNNING = 4
        end
      end
    end
  end
end
