# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Notebooks
      module V1beta1
        # Reservation Affinity for consuming Zonal reservation.
        # @!attribute [rw] consume_reservation_type
        #   @return [::Google::Cloud::Notebooks::V1beta1::ReservationAffinity::Type]
        #     Optional. Type of reservation to consume
        # @!attribute [rw] key
        #   @return [::String]
        #     Optional. Corresponds to the label key of reservation resource.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     Optional. Corresponds to the label values of reservation resource.
        class ReservationAffinity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates whether to consume capacity from an reservation or not.
          module Type
            # Default type.
            TYPE_UNSPECIFIED = 0

            # Do not consume from any allocated capacity.
            NO_RESERVATION = 1

            # Consume any reservation available.
            ANY_RESERVATION = 2

            # Must consume from a specific reservation. Must specify key value fields
            # for specifying the reservations.
            SPECIFIC_RESERVATION = 3
          end
        end

        # The definition of a notebook instance.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of this notebook instance. Format:
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
        # @!attribute [rw] vm_image
        #   @return [::Google::Cloud::Notebooks::V1beta1::VmImage]
        #     Use a Compute Engine VM image to start the notebook instance.
        #
        #     Note: The following fields are mutually exclusive: `vm_image`, `container_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] container_image
        #   @return [::Google::Cloud::Notebooks::V1beta1::ContainerImage]
        #     Use a container image to start the notebook instance.
        #
        #     Note: The following fields are mutually exclusive: `container_image`, `vm_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] post_startup_script
        #   @return [::String]
        #     Path to a Bash script that automatically runs after a notebook instance
        #     fully boots up. The path must be a URL or
        #     Cloud Storage path (`gs://path-to-file/file-name`).
        # @!attribute [r] proxy_uri
        #   @return [::String]
        #     Output only. The proxy endpoint that is used to access the Jupyter notebook.
        # @!attribute [rw] instance_owners
        #   @return [::Array<::String>]
        #     Input only. The owner of this instance after creation. Format: `alias@example.com`
        #
        #     Currently supports one owner only. If not specified, all of the service
        #     account users of your VM instance's service account can use
        #     the instance.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account on this instance, giving access to other Google
        #     Cloud services.
        #     You can use any service account within the same project, but you
        #     must have the service account user permission to use the instance.
        #
        #     If not specified, the [Compute Engine default service
        #     account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
        #     is used.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. The [Compute Engine machine
        #     type](https://cloud.google.com/compute/docs/machine-types) of this
        #     instance.
        # @!attribute [rw] accelerator_config
        #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::AcceleratorConfig]
        #     The hardware accelerator used on this instance. If you use
        #     accelerators, make sure that your configuration has
        #     [enough vCPUs and memory to support the `machine_type` you have
        #     selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
        # @!attribute [r] state
        #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::State]
        #     Output only. The state of this instance.
        # @!attribute [rw] install_gpu_driver
        #   @return [::Boolean]
        #     Whether the end user authorizes Google Cloud to install GPU driver
        #     on this instance.
        #     If this field is empty or set to false, the GPU driver won't be installed.
        #     Only applicable to instances with GPUs.
        # @!attribute [rw] custom_gpu_driver_path
        #   @return [::String]
        #     Specify a custom Cloud Storage path where the GPU driver is stored.
        #     If not specified, we'll automatically choose from official GPU drivers.
        # @!attribute [rw] boot_disk_type
        #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::DiskType]
        #     Input only. The type of the boot disk attached to this instance, defaults to
        #     standard persistent disk (`PD_STANDARD`).
        # @!attribute [rw] boot_disk_size_gb
        #   @return [::Integer]
        #     Input only. The size of the boot disk in GB attached to this instance, up to a maximum
        #     of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not
        #     specified, this defaults to 100.
        # @!attribute [rw] data_disk_type
        #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::DiskType]
        #     Input only. The type of the data disk attached to this instance, defaults to
        #     standard persistent disk (`PD_STANDARD`).
        # @!attribute [rw] data_disk_size_gb
        #   @return [::Integer]
        #     Input only. The size of the data disk in GB attached to this instance, up to a maximum
        #     of 64000 GB (64 TB). You can choose the size of the data disk based on how
        #     big your notebooks and data are. If not specified, this defaults to 100.
        # @!attribute [rw] no_remove_data_disk
        #   @return [::Boolean]
        #     Input only. If true, the data disk will not be auto deleted when deleting the instance.
        # @!attribute [rw] disk_encryption
        #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::DiskEncryption]
        #     Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
        #     is CMEK.
        #     Format:
        #     `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        #
        #     Learn more about [using your own encryption
        #     keys](https://cloud.google.com/kms/docs/quickstart).
        # @!attribute [rw] no_public_ip
        #   @return [::Boolean]
        #     If true, no public IP will be assigned to this instance.
        # @!attribute [rw] no_proxy_access
        #   @return [::Boolean]
        #     If true, the notebook instance will not register with the proxy.
        # @!attribute [rw] network
        #   @return [::String]
        #     The name of the VPC that this instance is in.
        #     Format:
        #     `projects/{project_id}/global/networks/{network_id}`
        # @!attribute [rw] subnet
        #   @return [::String]
        #     The name of the subnet that this instance is in.
        #     Format:
        #     `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to apply to this instance.
        #     These can be later modified by the setLabels method.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Custom metadata to apply to this instance.
        # @!attribute [rw] nic_type
        #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::NicType]
        #     Optional. The type of vNIC to be used on this interface. This may be gVNIC or
        #     VirtioNet.
        # @!attribute [rw] reservation_affinity
        #   @return [::Google::Cloud::Notebooks::V1beta1::ReservationAffinity]
        #     Optional. The optional reservation affinity. Setting this field will apply
        #     the specified [Zonal Compute
        #     Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
        #     to this notebook instance.
        # @!attribute [rw] can_ip_forward
        #   @return [::Boolean]
        #     Optional. Flag to enable ip forwarding or not, default false/off.
        #     https://cloud.google.com/vpc/docs/using-routes#canipforward
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Instance creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Instance update time.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Definition of a hardware accelerator. Note that not all combinations
          # of `type` and `core_count` are valid. Check [GPUs on Compute
          # Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a
          # valid combination. TPUs are not supported.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Notebooks::V1beta1::Instance::AcceleratorType]
          #     Type of this accelerator.
          # @!attribute [rw] core_count
          #   @return [::Integer]
          #     Count of cores of this accelerator.
          class AcceleratorConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Definition of the types of hardware accelerators that can be used on this
          # instance.
          module AcceleratorType
            # Accelerator type is not specified.
            ACCELERATOR_TYPE_UNSPECIFIED = 0

            # Accelerator type is Nvidia Tesla K80.
            NVIDIA_TESLA_K80 = 1

            # Accelerator type is Nvidia Tesla P100.
            NVIDIA_TESLA_P100 = 2

            # Accelerator type is Nvidia Tesla V100.
            NVIDIA_TESLA_V100 = 3

            # Accelerator type is Nvidia Tesla P4.
            NVIDIA_TESLA_P4 = 4

            # Accelerator type is Nvidia Tesla T4.
            NVIDIA_TESLA_T4 = 5

            # Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
            NVIDIA_TESLA_T4_VWS = 8

            # Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
            NVIDIA_TESLA_P100_VWS = 9

            # Accelerator type is NVIDIA Tesla P4 Virtual Workstations.
            NVIDIA_TESLA_P4_VWS = 10

            # (Coming soon) Accelerator type is TPU V2.
            TPU_V2 = 6

            # (Coming soon) Accelerator type is TPU V3.
            TPU_V3 = 7
          end

          # The definition of the states of this instance.
          module State
            # State is not specified.
            STATE_UNSPECIFIED = 0

            # The control logic is starting the instance.
            STARTING = 1

            # The control logic is installing required frameworks and registering the
            # instance with notebook proxy
            PROVISIONING = 2

            # The instance is running.
            ACTIVE = 3

            # The control logic is stopping the instance.
            STOPPING = 4

            # The instance is stopped.
            STOPPED = 5

            # The instance is deleted.
            DELETED = 6

            # The instance is upgrading.
            UPGRADING = 7

            # The instance is being created.
            INITIALIZING = 8

            # The instance is getting registered.
            REGISTERING = 9

            # The instance is suspending.
            SUSPENDING = 10

            # The instance is suspended.
            SUSPENDED = 11
          end

          # Possible disk types for notebook instances.
          module DiskType
            # Disk type not set.
            DISK_TYPE_UNSPECIFIED = 0

            # Standard persistent disk type.
            PD_STANDARD = 1

            # SSD persistent disk type.
            PD_SSD = 2

            # Balanced persistent disk type.
            PD_BALANCED = 3
          end

          # Definition of the disk encryption options.
          module DiskEncryption
            # Disk encryption is not specified.
            DISK_ENCRYPTION_UNSPECIFIED = 0

            # Use Google managed encryption keys to encrypt the boot disk.
            GMEK = 1

            # Use customer managed encryption keys to encrypt the boot disk.
            CMEK = 2
          end

          # The type of vNIC driver.
          module NicType
            # No type specified. Default should be UNSPECIFIED_NIC_TYPE.
            UNSPECIFIED_NIC_TYPE = 0

            # VIRTIO. Default in Notebooks DLVM.
            VIRTIO_NET = 1

            # GVNIC. Alternative to VIRTIO.
            # https://github.com/GoogleCloudPlatform/compute-virtual-ethernet-linux
            GVNIC = 2
          end
        end
      end
    end
  end
end
