# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/notebooks/v1beta1/service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Notebooks
      module V1beta1
        module NotebookService
          ##
          # Client for the NotebookService service.
          #
          # API v1beta1 service for Cloud AI Platform Notebooks.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "notebooks.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :notebook_service_stub

            ##
            # Configure the NotebookService Client class.
            #
            # See {::Google::Cloud::Notebooks::V1beta1::NotebookService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all NotebookService clients
            #   ::Google::Cloud::Notebooks::V1beta1::NotebookService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Notebooks", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_instances.timeout = 60.0

                default_config.rpcs.get_instance.timeout = 60.0

                default_config.rpcs.create_instance.timeout = 60.0

                default_config.rpcs.register_instance.timeout = 60.0

                default_config.rpcs.set_instance_accelerator.timeout = 60.0

                default_config.rpcs.set_instance_machine_type.timeout = 60.0

                default_config.rpcs.set_instance_labels.timeout = 60.0

                default_config.rpcs.delete_instance.timeout = 60.0

                default_config.rpcs.start_instance.timeout = 60.0

                default_config.rpcs.stop_instance.timeout = 60.0

                default_config.rpcs.reset_instance.timeout = 60.0

                default_config.rpcs.report_instance_info.timeout = 60.0

                default_config.rpcs.is_instance_upgradeable.timeout = 60.0

                default_config.rpcs.upgrade_instance.timeout = 60.0

                default_config.rpcs.upgrade_instance_internal.timeout = 60.0

                default_config.rpcs.list_environments.timeout = 60.0

                default_config.rpcs.get_environment.timeout = 60.0

                default_config.rpcs.create_environment.timeout = 60.0

                default_config.rpcs.delete_environment.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the NotebookService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Notebooks::V1beta1::NotebookService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @notebook_service_stub.universe_domain
            end

            ##
            # Create a new NotebookService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the NotebookService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/notebooks/v1beta1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @notebook_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Notebooks::V1beta1::NotebookService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @notebook_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @notebook_service_stub.endpoint
                config.universe_domain = @notebook_service_stub.universe_domain
                config.logger = @notebook_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @notebook_service_stub.endpoint
                config.universe_domain = @notebook_service_stub.universe_domain
                config.logger = @notebook_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Notebooks::V1beta1::NotebookService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @notebook_service_stub.logger
            end

            # Service calls

            ##
            # Lists instances in a given project and location.
            #
            # @overload list_instances(request, options = nil)
            #   Pass arguments to `list_instances` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::ListInstancesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::ListInstancesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_instances(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_instances` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format:
            #     `parent=projects/{project_id}/locations/{location}`
            #   @param page_size [::Integer]
            #     Maximum return size of the list call.
            #   @param page_token [::String]
            #     A previous returned page token that can be used to continue listing
            #     from the last result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Notebooks::V1beta1::Instance>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Notebooks::V1beta1::Instance>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::ListInstancesRequest.new
            #
            #   # Call the list_instances method.
            #   result = client.list_instances request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Notebooks::V1beta1::Instance.
            #     p item
            #   end
            #
            def list_instances request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::ListInstancesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_instances.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_instances.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :list_instances, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @notebook_service_stub, :list_instances, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Instance.
            #
            # @overload get_instance(request, options = nil)
            #   Pass arguments to `get_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::GetInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::GetInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_instance(name: nil)
            #   Pass arguments to `get_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Notebooks::V1beta1::Instance]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Notebooks::V1beta1::Instance]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::GetInstanceRequest.new
            #
            #   # Call the get_instance method.
            #   result = client.get_instance request
            #
            #   # The returned object is of type Google::Cloud::Notebooks::V1beta1::Instance.
            #   p result
            #
            def get_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::GetInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :get_instance, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Instance in a given project and location.
            #
            # @overload create_instance(request, options = nil)
            #   Pass arguments to `create_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::CreateInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::CreateInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_instance(parent: nil, instance_id: nil, instance: nil)
            #   Pass arguments to `create_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format:
            #     `parent=projects/{project_id}/locations/{location}`
            #   @param instance_id [::String]
            #     Required. User-defined unique ID of this instance.
            #   @param instance [::Google::Cloud::Notebooks::V1beta1::Instance, ::Hash]
            #     Required. The instance to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::CreateInstanceRequest.new
            #
            #   # Call the create_instance method.
            #   result = client.create_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::CreateInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :create_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Registers an existing legacy notebook instance to the Notebooks API server.
            # Legacy instances are instances created with the legacy Compute Engine
            # calls. They are not manageable by the Notebooks API out of the box. This
            # call makes these instances manageable by the Notebooks API.
            #
            # @overload register_instance(request, options = nil)
            #   Pass arguments to `register_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::RegisterInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::RegisterInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload register_instance(parent: nil, instance_id: nil)
            #   Pass arguments to `register_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format:
            #     `parent=projects/{project_id}/locations/{location}`
            #   @param instance_id [::String]
            #     Required. User defined unique ID of this instance. The `instance_id` must
            #     be 1 to 63 characters long and contain only lowercase letters,
            #     numeric characters, and dashes. The first character must be a lowercase
            #     letter and the last character cannot be a dash.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::RegisterInstanceRequest.new
            #
            #   # Call the register_instance method.
            #   result = client.register_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def register_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::RegisterInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.register_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.register_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.register_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :register_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the guest accelerators of a single Instance.
            #
            # @overload set_instance_accelerator(request, options = nil)
            #   Pass arguments to `set_instance_accelerator` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::SetInstanceAcceleratorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::SetInstanceAcceleratorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_instance_accelerator(name: nil, type: nil, core_count: nil)
            #   Pass arguments to `set_instance_accelerator` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param type [::Google::Cloud::Notebooks::V1beta1::Instance::AcceleratorType]
            #     Required. Type of this accelerator.
            #   @param core_count [::Integer]
            #     Required. Count of cores of this accelerator. Note that not all combinations
            #     of `type` and `core_count` are valid. Check [GPUs on
            #     Compute Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to
            #     find a valid combination. TPUs are not supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::SetInstanceAcceleratorRequest.new
            #
            #   # Call the set_instance_accelerator method.
            #   result = client.set_instance_accelerator request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def set_instance_accelerator request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::SetInstanceAcceleratorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_instance_accelerator.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_instance_accelerator.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_instance_accelerator.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :set_instance_accelerator, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the machine type of a single Instance.
            #
            # @overload set_instance_machine_type(request, options = nil)
            #   Pass arguments to `set_instance_machine_type` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::SetInstanceMachineTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::SetInstanceMachineTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_instance_machine_type(name: nil, machine_type: nil)
            #   Pass arguments to `set_instance_machine_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param machine_type [::String]
            #     Required. The [Compute Engine machine
            #     type](https://cloud.google.com/compute/docs/machine-types).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::SetInstanceMachineTypeRequest.new
            #
            #   # Call the set_instance_machine_type method.
            #   result = client.set_instance_machine_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def set_instance_machine_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::SetInstanceMachineTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_instance_machine_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_instance_machine_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_instance_machine_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :set_instance_machine_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the labels of an Instance.
            #
            # @overload set_instance_labels(request, options = nil)
            #   Pass arguments to `set_instance_labels` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::SetInstanceLabelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::SetInstanceLabelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_instance_labels(name: nil, labels: nil)
            #   Pass arguments to `set_instance_labels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param labels [::Hash{::String => ::String}]
            #     Labels to apply to this instance.
            #     These can be later modified by the setLabels method
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::SetInstanceLabelsRequest.new
            #
            #   # Call the set_instance_labels method.
            #   result = client.set_instance_labels request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def set_instance_labels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::SetInstanceLabelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_instance_labels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_instance_labels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_instance_labels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :set_instance_labels, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Instance.
            #
            # @overload delete_instance(request, options = nil)
            #   Pass arguments to `delete_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::DeleteInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::DeleteInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_instance(name: nil)
            #   Pass arguments to `delete_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::DeleteInstanceRequest.new
            #
            #   # Call the delete_instance method.
            #   result = client.delete_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::DeleteInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :delete_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts a notebook instance.
            #
            # @overload start_instance(request, options = nil)
            #   Pass arguments to `start_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::StartInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::StartInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload start_instance(name: nil)
            #   Pass arguments to `start_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::StartInstanceRequest.new
            #
            #   # Call the start_instance method.
            #   result = client.start_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def start_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::StartInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.start_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.start_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.start_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :start_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Stops a notebook instance.
            #
            # @overload stop_instance(request, options = nil)
            #   Pass arguments to `stop_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::StopInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::StopInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload stop_instance(name: nil)
            #   Pass arguments to `stop_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::StopInstanceRequest.new
            #
            #   # Call the stop_instance method.
            #   result = client.stop_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def stop_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::StopInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stop_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.stop_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stop_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :stop_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resets a notebook instance.
            #
            # @overload reset_instance(request, options = nil)
            #   Pass arguments to `reset_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::ResetInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::ResetInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reset_instance(name: nil)
            #   Pass arguments to `reset_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::ResetInstanceRequest.new
            #
            #   # Call the reset_instance method.
            #   result = client.reset_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def reset_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::ResetInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reset_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reset_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reset_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :reset_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Allows notebook instances to
            # report their latest instance information to the Notebooks
            # API server. The server will merge the reported information to
            # the instance metadata store. Do not use this method directly.
            #
            # @overload report_instance_info(request, options = nil)
            #   Pass arguments to `report_instance_info` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::ReportInstanceInfoRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::ReportInstanceInfoRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload report_instance_info(name: nil, vm_id: nil, metadata: nil)
            #   Pass arguments to `report_instance_info` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param vm_id [::String]
            #     Required. The VM hardware token for authenticating the VM.
            #     https://cloud.google.com/compute/docs/instances/verifying-instance-identity
            #   @param metadata [::Hash{::String => ::String}]
            #     The metadata reported to Notebooks API. This will be merged to the instance
            #     metadata store
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::ReportInstanceInfoRequest.new
            #
            #   # Call the report_instance_info method.
            #   result = client.report_instance_info request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def report_instance_info request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::ReportInstanceInfoRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.report_instance_info.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.report_instance_info.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.report_instance_info.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :report_instance_info, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Check if a notebook instance is upgradable.
            # Deprecated. Please consider using v1.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload is_instance_upgradeable(request, options = nil)
            #   Pass arguments to `is_instance_upgradeable` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload is_instance_upgradeable(notebook_instance: nil)
            #   Pass arguments to `is_instance_upgradeable` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param notebook_instance [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableRequest.new
            #
            #   # Call the is_instance_upgradeable method.
            #   result = client.is_instance_upgradeable request
            #
            #   # The returned object is of type Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableResponse.
            #   p result
            #
            def is_instance_upgradeable request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::IsInstanceUpgradeableRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.is_instance_upgradeable.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.notebook_instance
                header_params["notebook_instance"] = request.notebook_instance
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.is_instance_upgradeable.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.is_instance_upgradeable.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :is_instance_upgradeable, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Upgrades a notebook instance to the latest version.
            # Deprecated. Please consider using v1.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload upgrade_instance(request, options = nil)
            #   Pass arguments to `upgrade_instance` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::UpgradeInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::UpgradeInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upgrade_instance(name: nil)
            #   Pass arguments to `upgrade_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::UpgradeInstanceRequest.new
            #
            #   # Call the upgrade_instance method.
            #   result = client.upgrade_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def upgrade_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::UpgradeInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upgrade_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upgrade_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upgrade_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :upgrade_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Allows notebook instances to
            # call this endpoint to upgrade themselves. Do not use this method directly.
            # Deprecated. Please consider using v1.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload upgrade_instance_internal(request, options = nil)
            #   Pass arguments to `upgrade_instance_internal` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::UpgradeInstanceInternalRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::UpgradeInstanceInternalRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upgrade_instance_internal(name: nil, vm_id: nil)
            #   Pass arguments to `upgrade_instance_internal` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param vm_id [::String]
            #     Required. The VM hardware token for authenticating the VM.
            #     https://cloud.google.com/compute/docs/instances/verifying-instance-identity
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::UpgradeInstanceInternalRequest.new
            #
            #   # Call the upgrade_instance_internal method.
            #   result = client.upgrade_instance_internal request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def upgrade_instance_internal request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::UpgradeInstanceInternalRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upgrade_instance_internal.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upgrade_instance_internal.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upgrade_instance_internal.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :upgrade_instance_internal, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists environments in a project.
            #
            # @overload list_environments(request, options = nil)
            #   Pass arguments to `list_environments` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::ListEnvironmentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::ListEnvironmentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_environments(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_environments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `projects/{project_id}/locations/{location}`
            #   @param page_size [::Integer]
            #     Maximum return size of the list call.
            #   @param page_token [::String]
            #     A previous returned page token that can be used to continue listing from
            #     the last result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Notebooks::V1beta1::Environment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Notebooks::V1beta1::Environment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::ListEnvironmentsRequest.new
            #
            #   # Call the list_environments method.
            #   result = client.list_environments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Notebooks::V1beta1::Environment.
            #     p item
            #   end
            #
            def list_environments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::ListEnvironmentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_environments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_environments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_environments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :list_environments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @notebook_service_stub, :list_environments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Environment.
            #
            # @overload get_environment(request, options = nil)
            #   Pass arguments to `get_environment` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::GetEnvironmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::GetEnvironmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_environment(name: nil)
            #   Pass arguments to `get_environment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/environments/{environment_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Notebooks::V1beta1::Environment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Notebooks::V1beta1::Environment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::GetEnvironmentRequest.new
            #
            #   # Call the get_environment method.
            #   result = client.get_environment request
            #
            #   # The returned object is of type Google::Cloud::Notebooks::V1beta1::Environment.
            #   p result
            #
            def get_environment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::GetEnvironmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_environment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_environment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_environment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :get_environment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Environment.
            #
            # @overload create_environment(request, options = nil)
            #   Pass arguments to `create_environment` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::CreateEnvironmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::CreateEnvironmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_environment(parent: nil, environment_id: nil, environment: nil)
            #   Pass arguments to `create_environment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `projects/{project_id}/locations/{location}`
            #   @param environment_id [::String]
            #     Required. User-defined unique ID of this environment. The `environment_id` must
            #     be 1 to 63 characters long and contain only lowercase letters,
            #     numeric characters, and dashes. The first character must be a lowercase
            #     letter and the last character cannot be a dash.
            #   @param environment [::Google::Cloud::Notebooks::V1beta1::Environment, ::Hash]
            #     Required. The environment to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::CreateEnvironmentRequest.new
            #
            #   # Call the create_environment method.
            #   result = client.create_environment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_environment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::CreateEnvironmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_environment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_environment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_environment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :create_environment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Environment.
            #
            # @overload delete_environment(request, options = nil)
            #   Pass arguments to `delete_environment` via a request object, either of type
            #   {::Google::Cloud::Notebooks::V1beta1::DeleteEnvironmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Notebooks::V1beta1::DeleteEnvironmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_environment(name: nil)
            #   Pass arguments to `delete_environment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Format:
            #     `projects/{project_id}/locations/{location}/environments/{environment_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/notebooks/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Notebooks::V1beta1::DeleteEnvironmentRequest.new
            #
            #   # Call the delete_environment method.
            #   result = client.delete_environment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_environment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1beta1::DeleteEnvironmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_environment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Notebooks::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_environment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_environment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notebook_service_stub.call_rpc :delete_environment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the NotebookService API.
            #
            # This class represents the configuration for NotebookService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Notebooks::V1beta1::NotebookService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_instances to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Notebooks::V1beta1::NotebookService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_instances.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_instances.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Notebooks::V1beta1::NotebookService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "notebooks.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the NotebookService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_instances`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_instances
                ##
                # RPC-specific configuration for `get_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_instance
                ##
                # RPC-specific configuration for `create_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_instance
                ##
                # RPC-specific configuration for `register_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :register_instance
                ##
                # RPC-specific configuration for `set_instance_accelerator`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_instance_accelerator
                ##
                # RPC-specific configuration for `set_instance_machine_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_instance_machine_type
                ##
                # RPC-specific configuration for `set_instance_labels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_instance_labels
                ##
                # RPC-specific configuration for `delete_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_instance
                ##
                # RPC-specific configuration for `start_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :start_instance
                ##
                # RPC-specific configuration for `stop_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stop_instance
                ##
                # RPC-specific configuration for `reset_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reset_instance
                ##
                # RPC-specific configuration for `report_instance_info`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :report_instance_info
                ##
                # RPC-specific configuration for `is_instance_upgradeable`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :is_instance_upgradeable
                ##
                # RPC-specific configuration for `upgrade_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upgrade_instance
                ##
                # RPC-specific configuration for `upgrade_instance_internal`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upgrade_instance_internal
                ##
                # RPC-specific configuration for `list_environments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_environments
                ##
                # RPC-specific configuration for `get_environment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_environment
                ##
                # RPC-specific configuration for `create_environment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_environment
                ##
                # RPC-specific configuration for `delete_environment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_environment

                # @private
                def initialize parent_rpcs = nil
                  list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                  @list_instances = ::Gapic::Config::Method.new list_instances_config
                  get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                  @get_instance = ::Gapic::Config::Method.new get_instance_config
                  create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                  @create_instance = ::Gapic::Config::Method.new create_instance_config
                  register_instance_config = parent_rpcs.register_instance if parent_rpcs.respond_to? :register_instance
                  @register_instance = ::Gapic::Config::Method.new register_instance_config
                  set_instance_accelerator_config = parent_rpcs.set_instance_accelerator if parent_rpcs.respond_to? :set_instance_accelerator
                  @set_instance_accelerator = ::Gapic::Config::Method.new set_instance_accelerator_config
                  set_instance_machine_type_config = parent_rpcs.set_instance_machine_type if parent_rpcs.respond_to? :set_instance_machine_type
                  @set_instance_machine_type = ::Gapic::Config::Method.new set_instance_machine_type_config
                  set_instance_labels_config = parent_rpcs.set_instance_labels if parent_rpcs.respond_to? :set_instance_labels
                  @set_instance_labels = ::Gapic::Config::Method.new set_instance_labels_config
                  delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                  @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                  start_instance_config = parent_rpcs.start_instance if parent_rpcs.respond_to? :start_instance
                  @start_instance = ::Gapic::Config::Method.new start_instance_config
                  stop_instance_config = parent_rpcs.stop_instance if parent_rpcs.respond_to? :stop_instance
                  @stop_instance = ::Gapic::Config::Method.new stop_instance_config
                  reset_instance_config = parent_rpcs.reset_instance if parent_rpcs.respond_to? :reset_instance
                  @reset_instance = ::Gapic::Config::Method.new reset_instance_config
                  report_instance_info_config = parent_rpcs.report_instance_info if parent_rpcs.respond_to? :report_instance_info
                  @report_instance_info = ::Gapic::Config::Method.new report_instance_info_config
                  is_instance_upgradeable_config = parent_rpcs.is_instance_upgradeable if parent_rpcs.respond_to? :is_instance_upgradeable
                  @is_instance_upgradeable = ::Gapic::Config::Method.new is_instance_upgradeable_config
                  upgrade_instance_config = parent_rpcs.upgrade_instance if parent_rpcs.respond_to? :upgrade_instance
                  @upgrade_instance = ::Gapic::Config::Method.new upgrade_instance_config
                  upgrade_instance_internal_config = parent_rpcs.upgrade_instance_internal if parent_rpcs.respond_to? :upgrade_instance_internal
                  @upgrade_instance_internal = ::Gapic::Config::Method.new upgrade_instance_internal_config
                  list_environments_config = parent_rpcs.list_environments if parent_rpcs.respond_to? :list_environments
                  @list_environments = ::Gapic::Config::Method.new list_environments_config
                  get_environment_config = parent_rpcs.get_environment if parent_rpcs.respond_to? :get_environment
                  @get_environment = ::Gapic::Config::Method.new get_environment_config
                  create_environment_config = parent_rpcs.create_environment if parent_rpcs.respond_to? :create_environment
                  @create_environment = ::Gapic::Config::Method.new create_environment_config
                  delete_environment_config = parent_rpcs.delete_environment if parent_rpcs.respond_to? :delete_environment
                  @delete_environment = ::Gapic::Config::Method.new delete_environment_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
