# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/notebooks/v1/service_pb"
require "google/cloud/notebooks/v1/notebook_service"

class ::Google::Cloud::Notebooks::V1::NotebookService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::ListInstancesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instances, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::ListInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instances_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instances parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instances ::Google::Cloud::Notebooks::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instances(::Google::Cloud::Notebooks::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instances_client_stub.call_rpc_count
    end
  end

  def test_get_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::GetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance ::Google::Cloud::Notebooks::V1::GetInstanceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance(::Google::Cloud::Notebooks::V1::GetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_client_stub.call_rpc_count
    end
  end

  def test_create_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}

    create_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::CreateInstanceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["instance_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::Instance), request["instance"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_instance parent: parent, instance_id: instance_id, instance: instance do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_instance ::Google::Cloud::Notebooks::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_instance({ parent: parent, instance_id: instance_id, instance: instance }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_instance(::Google::Cloud::Notebooks::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_instance_client_stub.call_rpc_count
    end
  end

  def test_register_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"

    register_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :register_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::RegisterInstanceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["instance_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, register_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.register_instance({ parent: parent, instance_id: instance_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.register_instance parent: parent, instance_id: instance_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.register_instance ::Google::Cloud::Notebooks::V1::RegisterInstanceRequest.new(parent: parent, instance_id: instance_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.register_instance({ parent: parent, instance_id: instance_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.register_instance(::Google::Cloud::Notebooks::V1::RegisterInstanceRequest.new(parent: parent, instance_id: instance_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, register_instance_client_stub.call_rpc_count
    end
  end

  def test_set_instance_accelerator
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    type = :ACCELERATOR_TYPE_UNSPECIFIED
    core_count = 42

    set_instance_accelerator_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_instance_accelerator, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :ACCELERATOR_TYPE_UNSPECIFIED, request["type"]
      assert_equal 42, request["core_count"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_instance_accelerator_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_instance_accelerator({ name: name, type: type, core_count: core_count }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_instance_accelerator name: name, type: type, core_count: core_count do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_instance_accelerator ::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest.new(name: name, type: type, core_count: core_count) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_instance_accelerator({ name: name, type: type, core_count: core_count }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_instance_accelerator(::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest.new(name: name, type: type, core_count: core_count), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_instance_accelerator_client_stub.call_rpc_count
    end
  end

  def test_set_instance_machine_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    machine_type = "hello world"

    set_instance_machine_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_instance_machine_type, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["machine_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_instance_machine_type_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_instance_machine_type({ name: name, machine_type: machine_type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_instance_machine_type name: name, machine_type: machine_type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_instance_machine_type ::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest.new(name: name, machine_type: machine_type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_instance_machine_type({ name: name, machine_type: machine_type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_instance_machine_type(::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest.new(name: name, machine_type: machine_type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_instance_machine_type_client_stub.call_rpc_count
    end
  end

  def test_update_instance_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    config = {}

    update_instance_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_instance_config, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::InstanceConfig), request["config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_instance_config_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_instance_config({ name: name, config: config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_instance_config name: name, config: config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_instance_config ::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest.new(name: name, config: config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_instance_config({ name: name, config: config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_instance_config(::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest.new(name: name, config: config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_instance_config_client_stub.call_rpc_count
    end
  end

  def test_update_shielded_instance_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    shielded_instance_config = {}

    update_shielded_instance_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_shielded_instance_config, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::Instance::ShieldedInstanceConfig), request["shielded_instance_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_shielded_instance_config_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_shielded_instance_config({ name: name, shielded_instance_config: shielded_instance_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_shielded_instance_config name: name, shielded_instance_config: shielded_instance_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_shielded_instance_config ::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest.new(name: name, shielded_instance_config: shielded_instance_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_shielded_instance_config({ name: name, shielded_instance_config: shielded_instance_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_shielded_instance_config(::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest.new(name: name, shielded_instance_config: shielded_instance_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_shielded_instance_config_client_stub.call_rpc_count
    end
  end

  def test_set_instance_labels
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    labels = {}

    set_instance_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_instance_labels, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal({}, request["labels"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_instance_labels_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_instance_labels({ name: name, labels: labels }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_instance_labels name: name, labels: labels do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_instance_labels ::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest.new(name: name, labels: labels) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_instance_labels({ name: name, labels: labels }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_instance_labels(::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest.new(name: name, labels: labels), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_instance_labels_client_stub.call_rpc_count
    end
  end

  def test_update_instance_metadata_items
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    items = {}

    update_instance_metadata_items_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_instance_metadata_items, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal({}, request["items"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_instance_metadata_items_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_instance_metadata_items({ name: name, items: items }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_instance_metadata_items name: name, items: items do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_instance_metadata_items ::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest.new(name: name, items: items) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_instance_metadata_items({ name: name, items: items }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_instance_metadata_items(::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest.new(name: name, items: items), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_instance_metadata_items_client_stub.call_rpc_count
    end
  end

  def test_delete_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::DeleteInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_instance ::Google::Cloud::Notebooks::V1::DeleteInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_instance(::Google::Cloud::Notebooks::V1::DeleteInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_instance_client_stub.call_rpc_count
    end
  end

  def test_start_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    start_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::StartInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_instance ::Google::Cloud::Notebooks::V1::StartInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_instance(::Google::Cloud::Notebooks::V1::StartInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_instance_client_stub.call_rpc_count
    end
  end

  def test_stop_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::StopInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_instance ::Google::Cloud::Notebooks::V1::StopInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_instance(::Google::Cloud::Notebooks::V1::StopInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_instance_client_stub.call_rpc_count
    end
  end

  def test_reset_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reset_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::ResetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_instance({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_instance name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_instance ::Google::Cloud::Notebooks::V1::ResetInstanceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_instance({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_instance(::Google::Cloud::Notebooks::V1::ResetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_instance_client_stub.call_rpc_count
    end
  end

  def test_report_instance_info
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    vm_id = "hello world"
    metadata = {}

    report_instance_info_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :report_instance_info, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["vm_id"]
      assert_equal({}, request["metadata"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, report_instance_info_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.report_instance_info({ name: name, vm_id: vm_id, metadata: metadata }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.report_instance_info name: name, vm_id: vm_id, metadata: metadata do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.report_instance_info ::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest.new(name: name, vm_id: vm_id, metadata: metadata) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.report_instance_info({ name: name, vm_id: vm_id, metadata: metadata }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.report_instance_info(::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest.new(name: name, vm_id: vm_id, metadata: metadata), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, report_instance_info_client_stub.call_rpc_count
    end
  end

  def test_is_instance_upgradeable
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    notebook_instance = "hello world"
    type = :UPGRADE_TYPE_UNSPECIFIED

    is_instance_upgradeable_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :is_instance_upgradeable, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest, request
      assert_equal "hello world", request["notebook_instance"]
      assert_equal :UPGRADE_TYPE_UNSPECIFIED, request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, is_instance_upgradeable_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.is_instance_upgradeable({ notebook_instance: notebook_instance, type: type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.is_instance_upgradeable notebook_instance: notebook_instance, type: type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.is_instance_upgradeable ::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest.new(notebook_instance: notebook_instance, type: type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.is_instance_upgradeable({ notebook_instance: notebook_instance, type: type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.is_instance_upgradeable(::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest.new(notebook_instance: notebook_instance, type: type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, is_instance_upgradeable_client_stub.call_rpc_count
    end
  end

  def test_get_instance_health
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::GetInstanceHealthResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_health_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance_health, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_health_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance_health({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance_health name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance_health ::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance_health({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance_health(::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_health_client_stub.call_rpc_count
    end
  end

  def test_upgrade_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    type = :UPGRADE_TYPE_UNSPECIFIED

    upgrade_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upgrade_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :UPGRADE_TYPE_UNSPECIFIED, request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upgrade_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upgrade_instance({ name: name, type: type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upgrade_instance name: name, type: type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upgrade_instance ::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest.new(name: name, type: type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upgrade_instance({ name: name, type: type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upgrade_instance(::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest.new(name: name, type: type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upgrade_instance_client_stub.call_rpc_count
    end
  end

  def test_rollback_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_snapshot = "hello world"

    rollback_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::RollbackInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["target_snapshot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback_instance({ name: name, target_snapshot: target_snapshot }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback_instance name: name, target_snapshot: target_snapshot do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback_instance ::Google::Cloud::Notebooks::V1::RollbackInstanceRequest.new(name: name, target_snapshot: target_snapshot) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback_instance({ name: name, target_snapshot: target_snapshot }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback_instance(::Google::Cloud::Notebooks::V1::RollbackInstanceRequest.new(name: name, target_snapshot: target_snapshot), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_instance_client_stub.call_rpc_count
    end
  end

  def test_diagnose_instance
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    diagnostic_config = {}

    diagnose_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :diagnose_instance, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::DiagnosticConfig), request["diagnostic_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, diagnose_instance_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.diagnose_instance({ name: name, diagnostic_config: diagnostic_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.diagnose_instance name: name, diagnostic_config: diagnostic_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.diagnose_instance ::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest.new(name: name, diagnostic_config: diagnostic_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.diagnose_instance({ name: name, diagnostic_config: diagnostic_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.diagnose_instance(::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest.new(name: name, diagnostic_config: diagnostic_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, diagnose_instance_client_stub.call_rpc_count
    end
  end

  def test_upgrade_instance_internal
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    vm_id = "hello world"
    type = :UPGRADE_TYPE_UNSPECIFIED

    upgrade_instance_internal_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upgrade_instance_internal, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["vm_id"]
      assert_equal :UPGRADE_TYPE_UNSPECIFIED, request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upgrade_instance_internal_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upgrade_instance_internal({ name: name, vm_id: vm_id, type: type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upgrade_instance_internal name: name, vm_id: vm_id, type: type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upgrade_instance_internal ::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest.new(name: name, vm_id: vm_id, type: type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upgrade_instance_internal({ name: name, vm_id: vm_id, type: type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upgrade_instance_internal(::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest.new(name: name, vm_id: vm_id, type: type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upgrade_instance_internal_client_stub.call_rpc_count
    end
  end

  def test_list_environments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::ListEnvironmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_environments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_environments, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_environments_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_environments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_environments ::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_environments(::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_environments_client_stub.call_rpc_count
    end
  end

  def test_get_environment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::Environment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_environment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_environment, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::GetEnvironmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_environment_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_environment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_environment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_environment ::Google::Cloud::Notebooks::V1::GetEnvironmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_environment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_environment(::Google::Cloud::Notebooks::V1::GetEnvironmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_environment_client_stub.call_rpc_count
    end
  end

  def test_create_environment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    environment_id = "hello world"
    environment = {}

    create_environment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_environment, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["environment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::Environment), request["environment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_environment_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_environment({ parent: parent, environment_id: environment_id, environment: environment }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_environment parent: parent, environment_id: environment_id, environment: environment do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_environment ::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest.new(parent: parent, environment_id: environment_id, environment: environment) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_environment({ parent: parent, environment_id: environment_id, environment: environment }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_environment(::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest.new(parent: parent, environment_id: environment_id, environment: environment), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_environment_client_stub.call_rpc_count
    end
  end

  def test_delete_environment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_environment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_environment, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_environment_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_environment({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_environment name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_environment ::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_environment({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_environment(::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_environment_client_stub.call_rpc_count
    end
  end

  def test_list_schedules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::ListSchedulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_schedules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_schedules, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::ListSchedulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_schedules_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_schedules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_schedules parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_schedules ::Google::Cloud::Notebooks::V1::ListSchedulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_schedules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_schedules(::Google::Cloud::Notebooks::V1::ListSchedulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_schedules_client_stub.call_rpc_count
    end
  end

  def test_get_schedule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::Schedule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_schedule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_schedule, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::GetScheduleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_schedule_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_schedule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_schedule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_schedule ::Google::Cloud::Notebooks::V1::GetScheduleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_schedule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_schedule(::Google::Cloud::Notebooks::V1::GetScheduleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_schedule_client_stub.call_rpc_count
    end
  end

  def test_delete_schedule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schedule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_schedule, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::DeleteScheduleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_schedule_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_schedule({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_schedule name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_schedule ::Google::Cloud::Notebooks::V1::DeleteScheduleRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_schedule({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_schedule(::Google::Cloud::Notebooks::V1::DeleteScheduleRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_schedule_client_stub.call_rpc_count
    end
  end

  def test_create_schedule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    schedule_id = "hello world"
    schedule = {}

    create_schedule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_schedule, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::CreateScheduleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["schedule_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::Schedule), request["schedule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_schedule_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_schedule({ parent: parent, schedule_id: schedule_id, schedule: schedule }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_schedule parent: parent, schedule_id: schedule_id, schedule: schedule do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_schedule ::Google::Cloud::Notebooks::V1::CreateScheduleRequest.new(parent: parent, schedule_id: schedule_id, schedule: schedule) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_schedule({ parent: parent, schedule_id: schedule_id, schedule: schedule }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_schedule(::Google::Cloud::Notebooks::V1::CreateScheduleRequest.new(parent: parent, schedule_id: schedule_id, schedule: schedule), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_schedule_client_stub.call_rpc_count
    end
  end

  def test_trigger_schedule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    trigger_schedule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :trigger_schedule, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::TriggerScheduleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, trigger_schedule_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.trigger_schedule({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.trigger_schedule name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.trigger_schedule ::Google::Cloud::Notebooks::V1::TriggerScheduleRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.trigger_schedule({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.trigger_schedule(::Google::Cloud::Notebooks::V1::TriggerScheduleRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, trigger_schedule_client_stub.call_rpc_count
    end
  end

  def test_list_executions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::ListExecutionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_executions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_executions, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::ListExecutionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_executions_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_executions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_executions ::Google::Cloud::Notebooks::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_executions(::Google::Cloud::Notebooks::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_executions_client_stub.call_rpc_count
    end
  end

  def test_get_execution
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Notebooks::V1::Execution.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_execution, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::GetExecutionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_execution_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_execution({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_execution name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_execution ::Google::Cloud::Notebooks::V1::GetExecutionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_execution({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_execution(::Google::Cloud::Notebooks::V1::GetExecutionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_execution_client_stub.call_rpc_count
    end
  end

  def test_delete_execution
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_execution, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::DeleteExecutionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_execution_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_execution({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_execution name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_execution ::Google::Cloud::Notebooks::V1::DeleteExecutionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_execution({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_execution(::Google::Cloud::Notebooks::V1::DeleteExecutionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_execution_client_stub.call_rpc_count
    end
  end

  def test_create_execution
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    execution_id = "hello world"
    execution = {}

    create_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_execution, name
      assert_kind_of ::Google::Cloud::Notebooks::V1::CreateExecutionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["execution_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Notebooks::V1::Execution), request["execution"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_execution_client_stub do
      # Create client
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_execution({ parent: parent, execution_id: execution_id, execution: execution }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_execution parent: parent, execution_id: execution_id, execution: execution do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_execution ::Google::Cloud::Notebooks::V1::CreateExecutionRequest.new(parent: parent, execution_id: execution_id, execution: execution) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_execution({ parent: parent, execution_id: execution_id, execution: execution }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_execution(::Google::Cloud::Notebooks::V1::CreateExecutionRequest.new(parent: parent, execution_id: execution_id, execution: execution), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_execution_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Notebooks::V1::NotebookService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Notebooks::V1::NotebookService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Notebooks::V1::NotebookService::Operations, client.operations_client
  end
end
