# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/notebooks/v1/service_pb"
require "google/cloud/notebooks/v1/notebook_service/rest"


class ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_instances
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::ListInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_instances_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_instances parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_instances ::Google::Cloud::Notebooks::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_instances(::Google::Cloud::Notebooks::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_instances_client_stub.call_count
      end
    end
  end

  def test_get_instance
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance ::Google::Cloud::Notebooks::V1::GetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance(::Google::Cloud::Notebooks::V1::GetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_client_stub.call_count
      end
    end
  end

  def test_create_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"
    instance = {}

    create_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_create_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_instance({ parent: parent, instance_id: instance_id, instance: instance }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_instance parent: parent, instance_id: instance_id, instance: instance do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_instance ::Google::Cloud::Notebooks::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_instance({ parent: parent, instance_id: instance_id, instance: instance }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_instance(::Google::Cloud::Notebooks::V1::CreateInstanceRequest.new(parent: parent, instance_id: instance_id, instance: instance), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_instance_client_stub.call_count
      end
    end
  end

  def test_register_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instance_id = "hello world"

    register_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_register_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, register_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.register_instance({ parent: parent, instance_id: instance_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.register_instance parent: parent, instance_id: instance_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.register_instance ::Google::Cloud::Notebooks::V1::RegisterInstanceRequest.new(parent: parent, instance_id: instance_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.register_instance({ parent: parent, instance_id: instance_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.register_instance(::Google::Cloud::Notebooks::V1::RegisterInstanceRequest.new(parent: parent, instance_id: instance_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, register_instance_client_stub.call_count
      end
    end
  end

  def test_set_instance_accelerator
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    type = :ACCELERATOR_TYPE_UNSPECIFIED
    core_count = 42

    set_instance_accelerator_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_set_instance_accelerator_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_instance_accelerator_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_instance_accelerator({ name: name, type: type, core_count: core_count }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_instance_accelerator name: name, type: type, core_count: core_count do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_instance_accelerator ::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest.new(name: name, type: type, core_count: core_count) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_instance_accelerator({ name: name, type: type, core_count: core_count }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_instance_accelerator(::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest.new(name: name, type: type, core_count: core_count), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_instance_accelerator_client_stub.call_count
      end
    end
  end

  def test_set_instance_machine_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    machine_type = "hello world"

    set_instance_machine_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_set_instance_machine_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_instance_machine_type_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_instance_machine_type({ name: name, machine_type: machine_type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_instance_machine_type name: name, machine_type: machine_type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_instance_machine_type ::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest.new(name: name, machine_type: machine_type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_instance_machine_type({ name: name, machine_type: machine_type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_instance_machine_type(::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest.new(name: name, machine_type: machine_type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_instance_machine_type_client_stub.call_count
      end
    end
  end

  def test_update_instance_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    config = {}

    update_instance_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_update_instance_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_instance_config_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_instance_config({ name: name, config: config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_instance_config name: name, config: config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_instance_config ::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest.new(name: name, config: config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_instance_config({ name: name, config: config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_instance_config(::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest.new(name: name, config: config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_instance_config_client_stub.call_count
      end
    end
  end

  def test_update_shielded_instance_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    shielded_instance_config = {}

    update_shielded_instance_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_update_shielded_instance_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_shielded_instance_config_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_shielded_instance_config({ name: name, shielded_instance_config: shielded_instance_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_shielded_instance_config name: name, shielded_instance_config: shielded_instance_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_shielded_instance_config ::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest.new(name: name, shielded_instance_config: shielded_instance_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_shielded_instance_config({ name: name, shielded_instance_config: shielded_instance_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_shielded_instance_config(::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest.new(name: name, shielded_instance_config: shielded_instance_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_shielded_instance_config_client_stub.call_count
      end
    end
  end

  def test_set_instance_labels
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    labels = {}

    set_instance_labels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_set_instance_labels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_instance_labels_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_instance_labels({ name: name, labels: labels }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_instance_labels name: name, labels: labels do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_instance_labels ::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest.new(name: name, labels: labels) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_instance_labels({ name: name, labels: labels }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_instance_labels(::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest.new(name: name, labels: labels), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_instance_labels_client_stub.call_count
      end
    end
  end

  def test_update_instance_metadata_items
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    items = {}

    update_instance_metadata_items_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_update_instance_metadata_items_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_instance_metadata_items_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_instance_metadata_items({ name: name, items: items }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_instance_metadata_items name: name, items: items do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_instance_metadata_items ::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest.new(name: name, items: items) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_instance_metadata_items({ name: name, items: items }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_instance_metadata_items(::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest.new(name: name, items: items), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_instance_metadata_items_client_stub.call_count
      end
    end
  end

  def test_delete_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_instance ::Google::Cloud::Notebooks::V1::DeleteInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_instance(::Google::Cloud::Notebooks::V1::DeleteInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_instance_client_stub.call_count
      end
    end
  end

  def test_start_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    start_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_start_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_instance ::Google::Cloud::Notebooks::V1::StartInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_instance(::Google::Cloud::Notebooks::V1::StartInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_instance_client_stub.call_count
      end
    end
  end

  def test_stop_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_stop_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_instance ::Google::Cloud::Notebooks::V1::StopInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_instance(::Google::Cloud::Notebooks::V1::StopInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_instance_client_stub.call_count
      end
    end
  end

  def test_reset_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reset_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_reset_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset_instance ::Google::Cloud::Notebooks::V1::ResetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset_instance(::Google::Cloud::Notebooks::V1::ResetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_instance_client_stub.call_count
      end
    end
  end

  def test_report_instance_info
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    vm_id = "hello world"
    metadata = {}

    report_instance_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_report_instance_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, report_instance_info_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.report_instance_info({ name: name, vm_id: vm_id, metadata: metadata }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.report_instance_info name: name, vm_id: vm_id, metadata: metadata do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.report_instance_info ::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest.new(name: name, vm_id: vm_id, metadata: metadata) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.report_instance_info({ name: name, vm_id: vm_id, metadata: metadata }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.report_instance_info(::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest.new(name: name, vm_id: vm_id, metadata: metadata), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, report_instance_info_client_stub.call_count
      end
    end
  end

  def test_is_instance_upgradeable
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    notebook_instance = "hello world"
    type = :UPGRADE_TYPE_UNSPECIFIED

    is_instance_upgradeable_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_is_instance_upgradeable_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, is_instance_upgradeable_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.is_instance_upgradeable({ notebook_instance: notebook_instance, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.is_instance_upgradeable notebook_instance: notebook_instance, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.is_instance_upgradeable ::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest.new(notebook_instance: notebook_instance, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.is_instance_upgradeable({ notebook_instance: notebook_instance, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.is_instance_upgradeable(::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest.new(notebook_instance: notebook_instance, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, is_instance_upgradeable_client_stub.call_count
      end
    end
  end

  def test_get_instance_health
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::GetInstanceHealthResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_health_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_instance_health_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_health_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance_health({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance_health name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance_health ::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance_health({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance_health(::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_health_client_stub.call_count
      end
    end
  end

  def test_upgrade_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    type = :UPGRADE_TYPE_UNSPECIFIED

    upgrade_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_upgrade_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upgrade_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upgrade_instance({ name: name, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upgrade_instance name: name, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upgrade_instance ::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest.new(name: name, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upgrade_instance({ name: name, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upgrade_instance(::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest.new(name: name, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upgrade_instance_client_stub.call_count
      end
    end
  end

  def test_rollback_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_snapshot = "hello world"

    rollback_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_rollback_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_instance({ name: name, target_snapshot: target_snapshot }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_instance name: name, target_snapshot: target_snapshot do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_instance ::Google::Cloud::Notebooks::V1::RollbackInstanceRequest.new(name: name, target_snapshot: target_snapshot) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_instance({ name: name, target_snapshot: target_snapshot }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_instance(::Google::Cloud::Notebooks::V1::RollbackInstanceRequest.new(name: name, target_snapshot: target_snapshot), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_instance_client_stub.call_count
      end
    end
  end

  def test_diagnose_instance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    diagnostic_config = {}

    diagnose_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_diagnose_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, diagnose_instance_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.diagnose_instance({ name: name, diagnostic_config: diagnostic_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.diagnose_instance name: name, diagnostic_config: diagnostic_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.diagnose_instance ::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest.new(name: name, diagnostic_config: diagnostic_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.diagnose_instance({ name: name, diagnostic_config: diagnostic_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.diagnose_instance(::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest.new(name: name, diagnostic_config: diagnostic_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, diagnose_instance_client_stub.call_count
      end
    end
  end

  def test_upgrade_instance_internal
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    vm_id = "hello world"
    type = :UPGRADE_TYPE_UNSPECIFIED

    upgrade_instance_internal_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_upgrade_instance_internal_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upgrade_instance_internal_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upgrade_instance_internal({ name: name, vm_id: vm_id, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upgrade_instance_internal name: name, vm_id: vm_id, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upgrade_instance_internal ::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest.new(name: name, vm_id: vm_id, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upgrade_instance_internal({ name: name, vm_id: vm_id, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upgrade_instance_internal(::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest.new(name: name, vm_id: vm_id, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upgrade_instance_internal_client_stub.call_count
      end
    end
  end

  def test_list_environments
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::ListEnvironmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_environments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_environments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_environments_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_environments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_environments ::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_environments(::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_environments_client_stub.call_count
      end
    end
  end

  def test_get_environment
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::Environment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_environment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_environment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_environment ::Google::Cloud::Notebooks::V1::GetEnvironmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_environment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_environment(::Google::Cloud::Notebooks::V1::GetEnvironmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_environment_client_stub.call_count
      end
    end
  end

  def test_create_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    environment_id = "hello world"
    environment = {}

    create_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_create_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_environment({ parent: parent, environment_id: environment_id, environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_environment parent: parent, environment_id: environment_id, environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_environment ::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest.new(parent: parent, environment_id: environment_id, environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_environment({ parent: parent, environment_id: environment_id, environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_environment(::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest.new(parent: parent, environment_id: environment_id, environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_environment_client_stub.call_count
      end
    end
  end

  def test_delete_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_environment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_environment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_environment ::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_environment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_environment(::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_environment_client_stub.call_count
      end
    end
  end

  def test_list_schedules
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::ListSchedulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_schedules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_schedules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_schedules_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_schedules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_schedules parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_schedules ::Google::Cloud::Notebooks::V1::ListSchedulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_schedules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_schedules(::Google::Cloud::Notebooks::V1::ListSchedulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_schedules_client_stub.call_count
      end
    end
  end

  def test_get_schedule
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::Schedule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_schedule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_schedule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_schedule_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_schedule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_schedule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_schedule ::Google::Cloud::Notebooks::V1::GetScheduleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_schedule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_schedule(::Google::Cloud::Notebooks::V1::GetScheduleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_schedule_client_stub.call_count
      end
    end
  end

  def test_delete_schedule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schedule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_schedule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_schedule_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_schedule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_schedule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_schedule ::Google::Cloud::Notebooks::V1::DeleteScheduleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_schedule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_schedule(::Google::Cloud::Notebooks::V1::DeleteScheduleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_schedule_client_stub.call_count
      end
    end
  end

  def test_create_schedule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    schedule_id = "hello world"
    schedule = {}

    create_schedule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_create_schedule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_schedule_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_schedule({ parent: parent, schedule_id: schedule_id, schedule: schedule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_schedule parent: parent, schedule_id: schedule_id, schedule: schedule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_schedule ::Google::Cloud::Notebooks::V1::CreateScheduleRequest.new(parent: parent, schedule_id: schedule_id, schedule: schedule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_schedule({ parent: parent, schedule_id: schedule_id, schedule: schedule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_schedule(::Google::Cloud::Notebooks::V1::CreateScheduleRequest.new(parent: parent, schedule_id: schedule_id, schedule: schedule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_schedule_client_stub.call_count
      end
    end
  end

  def test_trigger_schedule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    trigger_schedule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_trigger_schedule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, trigger_schedule_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.trigger_schedule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.trigger_schedule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.trigger_schedule ::Google::Cloud::Notebooks::V1::TriggerScheduleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.trigger_schedule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.trigger_schedule(::Google::Cloud::Notebooks::V1::TriggerScheduleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, trigger_schedule_client_stub.call_count
      end
    end
  end

  def test_list_executions
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::ListExecutionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_executions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_executions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_executions_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_executions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_executions ::Google::Cloud::Notebooks::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_executions(::Google::Cloud::Notebooks::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_executions_client_stub.call_count
      end
    end
  end

  def test_get_execution
    # Create test objects.
    client_result = ::Google::Cloud::Notebooks::V1::Execution.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_execution_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_execution({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_execution name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_execution ::Google::Cloud::Notebooks::V1::GetExecutionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_execution({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_execution(::Google::Cloud::Notebooks::V1::GetExecutionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_execution_client_stub.call_count
      end
    end
  end

  def test_delete_execution
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_execution_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_execution({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_execution name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_execution ::Google::Cloud::Notebooks::V1::DeleteExecutionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_execution({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_execution(::Google::Cloud::Notebooks::V1::DeleteExecutionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_execution_client_stub.call_count
      end
    end
  end

  def test_create_execution
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    execution_id = "hello world"
    execution = {}

    create_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.stub :transcode_create_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_execution_client_stub do
        # Create client
        client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_execution({ parent: parent, execution_id: execution_id, execution: execution }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_execution parent: parent, execution_id: execution_id, execution: execution do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_execution ::Google::Cloud::Notebooks::V1::CreateExecutionRequest.new(parent: parent, execution_id: execution_id, execution: execution) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_execution({ parent: parent, execution_id: execution_id, execution: execution }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_execution(::Google::Cloud::Notebooks::V1::CreateExecutionRequest.new(parent: parent, execution_id: execution_id, execution: execution), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_execution_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client::Configuration, config
  end
end
