# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Notebooks
      module V1
        # The definition of a schedule.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of this schedule. Format:
        #     `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name used for UI purposes.
        #     Name can only contain alphanumeric characters, hyphens `-`,
        #     and underscores `_`.
        # @!attribute [rw] description
        #   @return [::String]
        #     A brief description of this environment.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Notebooks::V1::Schedule::State]
        # @!attribute [rw] cron_schedule
        #   @return [::String]
        #     Cron-tab formatted schedule by which the job will execute.
        #     Format: minute, hour, day of month, month, day of week,
        #     e.g. `0 0 * * WED` = every Wednesday
        #     More examples: https://crontab.guru/examples.html
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Timezone on which the cron_schedule.
        #     The value of this field must be a time zone name from the tz database.
        #     TZ Database: https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
        #
        #     Note that some time zones include a provision for daylight savings time.
        #     The rules for daylight saving time are determined by the chosen tz.
        #     For UTC use the string "utc". If a time zone is not specified,
        #     the default will be in UTC (also known as GMT).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the schedule was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the schedule was last updated.
        # @!attribute [rw] execution_template
        #   @return [::Google::Cloud::Notebooks::V1::ExecutionTemplate]
        #     Notebook Execution Template corresponding to this schedule.
        # @!attribute [r] recent_executions
        #   @return [::Array<::Google::Cloud::Notebooks::V1::Execution>]
        #     Output only. The most recent execution names triggered from this schedule and their
        #     corresponding states.
        class Schedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the job.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # The job is executing normally.
            ENABLED = 1

            # The job is paused by the user. It will not execute. A user can
            # intentionally pause the job using
            # [PauseJobRequest][].
            PAUSED = 2

            # The job is disabled by the system due to error. The user
            # cannot directly set a job to be disabled.
            DISABLED = 3

            # The job state resulting from a failed [CloudScheduler.UpdateJob][]
            # operation. To recover a job from this state, retry
            # [CloudScheduler.UpdateJob][] until a successful response is received.
            UPDATE_FAILED = 4

            # The schedule resource is being created.
            INITIALIZING = 5

            # The schedule resource is being deleted.
            DELETING = 6
          end
        end
      end
    end
  end
end
