# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Notebooks
      module V1
        # The definition of a Runtime for a managed notebook instance.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the runtime.
        #     Format:
        #     `projects/{project}/locations/{location}/runtimes/{runtimeId}`
        # @!attribute [rw] virtual_machine
        #   @return [::Google::Cloud::Notebooks::V1::VirtualMachine]
        #     Use a Compute Engine VM image to start the managed notebook instance.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Notebooks::V1::Runtime::State]
        #     Output only. Runtime state.
        # @!attribute [r] health_state
        #   @return [::Google::Cloud::Notebooks::V1::Runtime::HealthState]
        #     Output only. Runtime health_state.
        # @!attribute [rw] access_config
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeAccessConfig]
        #     The config settings for accessing runtime.
        # @!attribute [rw] software_config
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeSoftwareConfig]
        #     The config settings for software inside the runtime.
        # @!attribute [r] metrics
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeMetrics]
        #     Output only. Contains Runtime daemon metrics such as Service status and JupyterLab
        #     stats.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Runtime creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Runtime update time.
        class Runtime
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The definition of the states of this runtime.
          module State
            # State is not specified.
            STATE_UNSPECIFIED = 0

            # The compute layer is starting the runtime. It is not ready for use.
            STARTING = 1

            # The compute layer is installing required frameworks and registering the
            # runtime with notebook proxy. It cannot be used.
            PROVISIONING = 2

            # The runtime is currently running. It is ready for use.
            ACTIVE = 3

            # The control logic is stopping the runtime. It cannot be used.
            STOPPING = 4

            # The runtime is stopped. It cannot be used.
            STOPPED = 5

            # The runtime is being deleted. It cannot be used.
            DELETING = 6

            # The runtime is upgrading. It cannot be used.
            UPGRADING = 7

            # The runtime is being created and set up. It is not ready for use.
            INITIALIZING = 8
          end

          # The runtime substate.
          module HealthState
            # The runtime substate is unknown.
            HEALTH_STATE_UNSPECIFIED = 0

            # The runtime is known to be in an healthy state
            # (for example, critical daemons are running)
            # Applies to ACTIVE state.
            HEALTHY = 1

            # The runtime is known to be in an unhealthy state
            # (for example, critical daemons are not running)
            # Applies to ACTIVE state.
            UNHEALTHY = 2

            # The runtime has not installed health monitoring agent.
            # Applies to ACTIVE state.
            AGENT_NOT_INSTALLED = 3

            # The runtime health monitoring agent is not running.
            # Applies to ACTIVE state.
            AGENT_NOT_RUNNING = 4
          end
        end

        # Definition of the types of hardware accelerators that can be used.
        # Definition of the types of hardware accelerators that can be used.
        # See [Compute Engine
        # AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).
        # Examples:
        #
        # * `nvidia-tesla-k80`
        # * `nvidia-tesla-p100`
        # * `nvidia-tesla-v100`
        # * `nvidia-tesla-p4`
        # * `nvidia-tesla-t4`
        # * `nvidia-tesla-a100`
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeAcceleratorConfig::AcceleratorType]
        #     Accelerator model.
        # @!attribute [rw] core_count
        #   @return [::Integer]
        #     Count of cores of this accelerator.
        class RuntimeAcceleratorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of this accelerator.
          module AcceleratorType
            # Accelerator type is not specified.
            ACCELERATOR_TYPE_UNSPECIFIED = 0

            # Accelerator type is Nvidia Tesla K80.
            NVIDIA_TESLA_K80 = 1

            # Accelerator type is Nvidia Tesla P100.
            NVIDIA_TESLA_P100 = 2

            # Accelerator type is Nvidia Tesla V100.
            NVIDIA_TESLA_V100 = 3

            # Accelerator type is Nvidia Tesla P4.
            NVIDIA_TESLA_P4 = 4

            # Accelerator type is Nvidia Tesla T4.
            NVIDIA_TESLA_T4 = 5

            # Accelerator type is Nvidia Tesla A100.
            NVIDIA_TESLA_A100 = 6

            # (Coming soon) Accelerator type is TPU V2.
            TPU_V2 = 7

            # (Coming soon) Accelerator type is TPU V3.
            TPU_V3 = 8

            # Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
            NVIDIA_TESLA_T4_VWS = 9

            # Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
            NVIDIA_TESLA_P100_VWS = 10

            # Accelerator type is NVIDIA Tesla P4 Virtual Workstations.
            NVIDIA_TESLA_P4_VWS = 11
          end
        end

        # Represents a custom encryption key configuration that can be applied to
        # a resource. This will encrypt all disks in Virtual Machine.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     The Cloud KMS resource identifier of the customer-managed encryption key
        #     used to protect a resource, such as a disks. It has the following
        #     format:
        #     `projects/{PROJECT_ID}/locations/{REGION}/keyRings/{KEY_RING_NAME}/cryptoKeys/{KEY_NAME}`
        class EncryptionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Local attached disk resource.
        # @!attribute [r] auto_delete
        #   @return [::Boolean]
        #     Optional. Output only. Specifies whether the disk will be auto-deleted when the
        #     instance is deleted (but not when the disk is detached from the instance).
        # @!attribute [r] boot
        #   @return [::Boolean]
        #     Optional. Output only. Indicates that this is a boot disk. The virtual machine
        #     will use the first partition of the disk for its root filesystem.
        # @!attribute [r] device_name
        #   @return [::String]
        #     Optional. Output only. Specifies a unique device name
        #     of your choice that is reflected into the
        #     `/dev/disk/by-id/google-*` tree of a Linux operating system running within
        #     the instance. This name can be used to reference the device for mounting,
        #     resizing, and so on, from within the instance.
        #
        #     If not specified, the server chooses a default device name to apply to this
        #     disk, in the form persistent-disk-x, where x is a number assigned by Google
        #     Compute Engine. This field is only applicable for persistent disks.
        # @!attribute [r] guest_os_features
        #   @return [::Array<::Google::Cloud::Notebooks::V1::LocalDisk::RuntimeGuestOsFeature>]
        #     Output only. Indicates a list of features to enable on the guest operating system.
        #     Applicable only for bootable images. Read  Enabling guest operating
        #     system features to see a list of available options.
        # @!attribute [r] index
        #   @return [::Integer]
        #     Output only. A zero-based index to this disk, where 0 is reserved for the
        #     boot disk. If you have many disks attached to an instance, each disk would
        #     have a unique index number.
        # @!attribute [rw] initialize_params
        #   @return [::Google::Cloud::Notebooks::V1::LocalDiskInitializeParams]
        #     Input only. Specifies the parameters for a new disk that will be created
        #     alongside the new instance. Use initialization parameters to create boot
        #     disks or local SSDs attached to the new instance.
        #
        #     This property is mutually exclusive with the source property; you can only
        #     define one or the other, but not both.
        # @!attribute [rw] interface
        #   @return [::String]
        #     Specifies the disk interface to use for attaching this disk, which is
        #     either SCSI or NVME. The default is SCSI. Persistent disks must always use
        #     SCSI and the request will fail if you attempt to attach a persistent disk
        #     in any other format than SCSI. Local SSDs can use either NVME or SCSI. For
        #     performance characteristics of SCSI over NVMe, see Local SSD performance.
        #     Valid values:
        #
        #     * `NVME`
        #     * `SCSI`
        # @!attribute [r] kind
        #   @return [::String]
        #     Output only. Type of the resource. Always compute#attachedDisk for attached disks.
        # @!attribute [r] licenses
        #   @return [::Array<::String>]
        #     Output only. Any valid publicly visible licenses.
        # @!attribute [rw] mode
        #   @return [::String]
        #     The mode in which to attach this disk, either `READ_WRITE` or `READ_ONLY`.
        #     If not specified, the default is to attach the disk in `READ_WRITE` mode.
        #     Valid values:
        #
        #     * `READ_ONLY`
        #     * `READ_WRITE`
        # @!attribute [rw] source
        #   @return [::String]
        #     Specifies a valid partial or full URL to an existing Persistent Disk
        #     resource.
        # @!attribute [rw] type
        #   @return [::String]
        #     Specifies the type of the disk, either `SCRATCH` or `PERSISTENT`. If not
        #     specified, the default is `PERSISTENT`.
        #     Valid values:
        #
        #     * `PERSISTENT`
        #     * `SCRATCH`
        class LocalDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Optional. A list of features to enable on the guest operating system.
          # Applicable only for bootable images.
          # Read [Enabling guest operating system
          # features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features)
          # to see a list of available options.
          # Guest OS features for boot disk.
          # @!attribute [rw] type
          #   @return [::String]
          #     The ID of a supported feature. Read [Enabling guest operating system
          #     features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features)
          #     to see a list of available options.
          #
          #     Valid values:
          #
          #     * `FEATURE_TYPE_UNSPECIFIED`
          #     * `MULTI_IP_SUBNET`
          #     * `SECURE_BOOT`
          #     * `UEFI_COMPATIBLE`
          #     * `VIRTIO_SCSI_MULTIQUEUE`
          #     * `WINDOWS`
          class RuntimeGuestOsFeature
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Input only. Specifies the parameters for a new disk that will be created
        # alongside the new instance. Use initialization parameters to create boot
        # disks or local SSDs attached to the new runtime.
        # This property is mutually exclusive with the source property; you can only
        # define one or the other, but not both.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Provide this property when creating the disk.
        # @!attribute [rw] disk_name
        #   @return [::String]
        #     Optional. Specifies the disk name. If not specified, the default is to use the name
        #     of the instance. If the disk with the instance name exists already in the
        #     given zone/region, a new name will be automatically generated.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk
        #     will be the same size as the image (usually 10GB). If specified, the size
        #     must be equal to or larger than 10GB. Default 100 GB.
        # @!attribute [rw] disk_type
        #   @return [::Google::Cloud::Notebooks::V1::LocalDiskInitializeParams::DiskType]
        #     Input only. The type of the boot disk attached to this instance, defaults to
        #     standard persistent disk (`PD_STANDARD`).
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels to apply to this disk. These can be later modified by the
        #     disks.setLabels method. This field is only applicable for persistent disks.
        class LocalDiskInitializeParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible disk types.
          module DiskType
            # Disk type not set.
            DISK_TYPE_UNSPECIFIED = 0

            # Standard persistent disk type.
            PD_STANDARD = 1

            # SSD persistent disk type.
            PD_SSD = 2

            # Balanced persistent disk type.
            PD_BALANCED = 3

            # Extreme persistent disk type.
            PD_EXTREME = 4
          end
        end

        # Specifies the login configuration for Runtime
        # @!attribute [rw] access_type
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeAccessConfig::RuntimeAccessType]
        #     The type of access mode this instance.
        # @!attribute [rw] runtime_owner
        #   @return [::String]
        #     The owner of this runtime after creation. Format: `alias@example.com`
        #     Currently supports one owner only.
        # @!attribute [r] proxy_uri
        #   @return [::String]
        #     Output only. The proxy endpoint that is used to access the runtime.
        class RuntimeAccessConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible ways to access runtime. Authentication mode.
          # Currently supports: Single User only.
          module RuntimeAccessType
            # Unspecified access.
            RUNTIME_ACCESS_TYPE_UNSPECIFIED = 0

            # Single user login.
            SINGLE_USER = 1

            # Service Account mode.
            # In Service Account mode, Runtime creator will specify a SA that exists
            # in the consumer project. Using Runtime Service Account field.
            # Users accessing the Runtime need ActAs (Service Account User) permission.
            SERVICE_ACCOUNT = 2
          end
        end

        # Specifies the selection and configuration of software inside the runtime.
        # The properties to set on runtime.
        # Properties keys are specified in `key:value` format, for example:
        #
        # * `idle_shutdown: true`
        # * `idle_shutdown_timeout: 180`
        # * `enable_health_monitoring: true`
        # @!attribute [rw] notebook_upgrade_schedule
        #   @return [::String]
        #     Cron expression in UTC timezone, used to schedule instance auto upgrade.
        #     Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
        # @!attribute [rw] enable_health_monitoring
        #   @return [::Boolean]
        #     Verifies core internal services are running.
        #     Default: True
        # @!attribute [rw] idle_shutdown
        #   @return [::Boolean]
        #     Runtime will automatically shutdown after idle_shutdown_time.
        #     Default: True
        # @!attribute [rw] idle_shutdown_timeout
        #   @return [::Integer]
        #     Time in minutes to wait before shutting down runtime. Default: 180 minutes
        # @!attribute [rw] install_gpu_driver
        #   @return [::Boolean]
        #     Install Nvidia Driver automatically.
        #     Default: True
        # @!attribute [rw] custom_gpu_driver_path
        #   @return [::String]
        #     Specify a custom Cloud Storage path where the GPU driver is stored.
        #     If not specified, we'll automatically choose from official GPU drivers.
        # @!attribute [rw] post_startup_script
        #   @return [::String]
        #     Path to a Bash script that automatically runs after a notebook instance
        #     fully boots up. The path must be a URL or
        #     Cloud Storage path (`gs://path-to-file/file-name`).
        # @!attribute [rw] kernels
        #   @return [::Array<::Google::Cloud::Notebooks::V1::ContainerImage>]
        #     Optional. Use a list of container images to use as Kernels in the notebook instance.
        # @!attribute [r] upgradeable
        #   @return [::Boolean]
        #     Output only. Bool indicating whether an newer image is available in an image family.
        # @!attribute [rw] post_startup_script_behavior
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeSoftwareConfig::PostStartupScriptBehavior]
        #     Behavior for the post startup script.
        # @!attribute [rw] disable_terminal
        #   @return [::Boolean]
        #     Bool indicating whether JupyterLab terminal will be available or not.
        #     Default: False
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. version of boot image such as M100, from release label of the image.
        class RuntimeSoftwareConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Behavior for the post startup script.
          module PostStartupScriptBehavior
            # Unspecified post startup script behavior. Will run only once at creation.
            POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED = 0

            # Runs the post startup script provided during creation at every start.
            RUN_EVERY_START = 1

            # Downloads and runs the provided post startup script at every start.
            DOWNLOAD_AND_RUN_EVERY_START = 2
          end
        end

        # Contains runtime daemon metrics, such as OS and kernels and sessions stats.
        # @!attribute [r] system_metrics
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. The system metrics.
        class RuntimeMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SystemMetricsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A set of Shielded Instance options.
        # Check [Images using supported Shielded VM
        # features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        # Not all combinations are valid.
        # @!attribute [rw] enable_secure_boot
        #   @return [::Boolean]
        #     Defines whether the instance has Secure Boot enabled.
        #
        #     Secure Boot helps ensure that the system only runs authentic software by
        #     verifying the digital signature of all boot components, and halting the
        #     boot process if signature verification fails. Disabled by default.
        # @!attribute [rw] enable_vtpm
        #   @return [::Boolean]
        #     Defines whether the instance has the vTPM enabled. Enabled by default.
        # @!attribute [rw] enable_integrity_monitoring
        #   @return [::Boolean]
        #     Defines whether the instance has integrity monitoring enabled.
        #
        #     Enables monitoring and attestation of the boot integrity of the instance.
        #     The attestation is performed against the integrity policy baseline. This
        #     baseline is initially derived from the implicitly trusted boot image when
        #     the instance is created. Enabled by default.
        class RuntimeShieldedInstanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime using Virtual Machine for computing.
        # @!attribute [r] instance_name
        #   @return [::String]
        #     Output only. The user-friendly name of the Managed Compute Engine instance.
        # @!attribute [r] instance_id
        #   @return [::String]
        #     Output only. The unique identifier of the Managed Compute Engine instance.
        # @!attribute [rw] virtual_machine_config
        #   @return [::Google::Cloud::Notebooks::V1::VirtualMachineConfig]
        #     Virtual Machine configuration settings.
        class VirtualMachine
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The config settings for virtual machine.
        # @!attribute [r] zone
        #   @return [::String]
        #     Output only. The zone where the virtual machine is located.
        #     If using regional request, the notebooks service will pick a location
        #     in the corresponding runtime region.
        #     On a get request, zone will always be present. Example:
        #     * `us-central1-b`
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. The Compute Engine machine type used for runtimes.
        #     Short name is valid. Examples:
        #     * `n1-standard-2`
        #     * `e2-standard-8`
        # @!attribute [rw] container_images
        #   @return [::Array<::Google::Cloud::Notebooks::V1::ContainerImage>]
        #     Optional. Use a list of container images to use as Kernels in the notebook instance.
        # @!attribute [rw] data_disk
        #   @return [::Google::Cloud::Notebooks::V1::LocalDisk]
        #     Required. Data disk option configuration settings.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::Notebooks::V1::EncryptionConfig]
        #     Optional. Encryption settings for virtual machine data disk.
        # @!attribute [rw] shielded_instance_config
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeShieldedInstanceConfig]
        #     Optional. Shielded VM Instance configuration settings.
        # @!attribute [rw] accelerator_config
        #   @return [::Google::Cloud::Notebooks::V1::RuntimeAcceleratorConfig]
        #     Optional. The Compute Engine accelerator configuration for this runtime.
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. The Compute Engine network to be used for machine
        #     communications. Cannot be specified with subnetwork. If neither
        #     `network` nor `subnet` is specified, the "default" network of
        #     the project is used, if it exists.
        #
        #     A full URL or partial URI. Examples:
        #
        #     * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
        #     * `projects/[project_id]/global/networks/default`
        #
        #     Runtimes are managed resources inside Google Infrastructure.
        #     Runtimes support the following network configurations:
        #
        #     * Google Managed Network (Network & subnet are empty)
        #     * Consumer Project VPC (network & subnet are required). Requires
        #     configuring Private Service Access.
        #     * Shared VPC (network & subnet are required). Requires configuring Private
        #     Service Access.
        # @!attribute [rw] subnet
        #   @return [::String]
        #     Optional. The Compute Engine subnetwork to be used for machine
        #     communications. Cannot be specified with network.
        #
        #     A full URL or partial URI are valid. Examples:
        #
        #     * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
        #     * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
        # @!attribute [rw] internal_ip_only
        #   @return [::Boolean]
        #     Optional. If true, runtime will only have internal IP
        #     addresses. By default, runtimes are not restricted to internal IP
        #     addresses, and will have ephemeral external IP addresses assigned to each
        #     vm. This `internal_ip_only` restriction can only be enabled for
        #     subnetwork enabled networks, and all dependencies must be
        #     configured to be accessible without external IP addresses.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Optional. The Compute Engine tags to add to runtime (see [Tagging
        #     instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        # @!attribute [r] guest_attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. The Compute Engine guest attributes. (see
        #     [Project and instance
        #     guest
        #     attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The Compute Engine metadata entries to add to virtual machine. (see
        #     [Project and instance
        #     metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels to associate with this runtime.
        #     Label **keys** must contain 1 to 63 characters, and must conform to
        #     [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        #     Label **values** may be empty, but, if present, must contain 1 to 63
        #     characters, and must conform to [RFC
        #     1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
        #     associated with a cluster.
        # @!attribute [rw] nic_type
        #   @return [::Google::Cloud::Notebooks::V1::VirtualMachineConfig::NicType]
        #     Optional. The type of vNIC to be used on this interface. This may be gVNIC or
        #     VirtioNet.
        # @!attribute [rw] reserved_ip_range
        #   @return [::String]
        #     Optional. Reserved IP Range name is used for VPC Peering.
        #     The subnetwork allocation will use the range *name* if it's assigned.
        #
        #     Example: managed-notebooks-range-c
        #
        #         PEERING_RANGE_NAME_3=managed-notebooks-range-c
        #         gcloud compute addresses create $PEERING_RANGE_NAME_3 \
        #           --global \
        #           --prefix-length=24 \
        #           --description="Google Cloud Managed Notebooks Range 24 c" \
        #           --network=$NETWORK \
        #           --addresses=192.168.0.0 \
        #           --purpose=VPC_PEERING
        #
        #     Field value will be: `managed-notebooks-range-c`
        # @!attribute [rw] boot_image
        #   @return [::Google::Cloud::Notebooks::V1::VirtualMachineConfig::BootImage]
        #     Optional. Boot image metadata used for runtime upgradeability.
        class VirtualMachineConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Definition of the boot image used by the Runtime.
          # Used to facilitate runtime upgradeability.
          class BootImage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class GuestAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of vNIC driver.
          # Default should be UNSPECIFIED_NIC_TYPE.
          module NicType
            # No type specified.
            UNSPECIFIED_NIC_TYPE = 0

            # VIRTIO
            VIRTIO_NET = 1

            # GVNIC
            GVNIC = 2
          end
        end
      end
    end
  end
end
