# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/notebooks/v1/service_pb"
require "google/cloud/notebooks/v1/notebook_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Notebooks
      module V1
        module NotebookService
          module Rest
            ##
            # REST client for the NotebookService service.
            #
            # API v1 service for Cloud AI Platform Notebooks.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "notebooks.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :notebook_service_stub

              ##
              # Configure the NotebookService Client class.
              #
              # See {::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all NotebookService clients
              #   ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Notebooks", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_instances.timeout = 60.0

                  default_config.rpcs.get_instance.timeout = 60.0

                  default_config.rpcs.create_instance.timeout = 60.0

                  default_config.rpcs.register_instance.timeout = 60.0

                  default_config.rpcs.set_instance_accelerator.timeout = 60.0

                  default_config.rpcs.set_instance_machine_type.timeout = 60.0

                  default_config.rpcs.update_instance_config.timeout = 60.0

                  default_config.rpcs.update_shielded_instance_config.timeout = 60.0

                  default_config.rpcs.set_instance_labels.timeout = 60.0

                  default_config.rpcs.delete_instance.timeout = 60.0

                  default_config.rpcs.start_instance.timeout = 60.0

                  default_config.rpcs.stop_instance.timeout = 60.0

                  default_config.rpcs.reset_instance.timeout = 60.0

                  default_config.rpcs.report_instance_info.timeout = 60.0

                  default_config.rpcs.is_instance_upgradeable.timeout = 60.0

                  default_config.rpcs.get_instance_health.timeout = 60.0

                  default_config.rpcs.upgrade_instance.timeout = 60.0

                  default_config.rpcs.rollback_instance.timeout = 60.0

                  default_config.rpcs.diagnose_instance.timeout = 60.0

                  default_config.rpcs.upgrade_instance_internal.timeout = 60.0

                  default_config.rpcs.list_environments.timeout = 60.0

                  default_config.rpcs.get_environment.timeout = 60.0

                  default_config.rpcs.create_environment.timeout = 60.0

                  default_config.rpcs.delete_environment.timeout = 60.0

                  default_config.rpcs.list_schedules.timeout = 60.0

                  default_config.rpcs.get_schedule.timeout = 60.0

                  default_config.rpcs.delete_schedule.timeout = 60.0

                  default_config.rpcs.create_schedule.timeout = 60.0

                  default_config.rpcs.list_executions.timeout = 60.0

                  default_config.rpcs.get_execution.timeout = 60.0

                  default_config.rpcs.delete_execution.timeout = 60.0

                  default_config.rpcs.create_execution.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the NotebookService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @notebook_service_stub.universe_domain
              end

              ##
              # Create a new NotebookService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the NotebookService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @notebook_service_stub = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @notebook_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @notebook_service_stub.endpoint
                  config.universe_domain = @notebook_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @notebook_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @notebook_service_stub.endpoint
                  config.universe_domain = @notebook_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @notebook_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Notebooks::V1::NotebookService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @notebook_service_stub.logger
              end

              # Service calls

              ##
              # Lists instances in a given project and location.
              #
              # @overload list_instances(request, options = nil)
              #   Pass arguments to `list_instances` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_instances(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_instances` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param page_size [::Integer]
              #     Maximum return size of the list call.
              #   @param page_token [::String]
              #     A previous returned page token that can be used to continue listing
              #     from the last result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Instance>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Instance>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ListInstancesRequest.new
              #
              #   # Call the list_instances method.
              #   result = client.list_instances request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Notebooks::V1::Instance.
              #     p item
              #   end
              #
              def list_instances request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_instances.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_instances.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_instances request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_instances, "instances", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Instance.
              #
              # @overload get_instance(request, options = nil)
              #   Pass arguments to `get_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::GetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::GetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_instance(name: nil)
              #   Pass arguments to `get_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::Instance]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::Instance]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::GetInstanceRequest.new
              #
              #   # Call the get_instance method.
              #   result = client.get_instance request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::Instance.
              #   p result
              #
              def get_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::GetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_instance request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Instance in a given project and location.
              #
              # @overload create_instance(request, options = nil)
              #   Pass arguments to `create_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::CreateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::CreateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_instance(parent: nil, instance_id: nil, instance: nil)
              #   Pass arguments to `create_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param instance_id [::String]
              #     Required. User-defined unique ID of this instance.
              #   @param instance [::Google::Cloud::Notebooks::V1::Instance, ::Hash]
              #     Required. The instance to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::CreateInstanceRequest.new
              #
              #   # Call the create_instance method.
              #   result = client.create_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::CreateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.create_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Registers an existing legacy notebook instance to the Notebooks API server.
              # Legacy instances are instances created with the legacy Compute Engine
              # calls. They are not manageable by the Notebooks API out of the box. This
              # call makes these instances manageable by the Notebooks API.
              #
              # @overload register_instance(request, options = nil)
              #   Pass arguments to `register_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::RegisterInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::RegisterInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload register_instance(parent: nil, instance_id: nil)
              #   Pass arguments to `register_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param instance_id [::String]
              #     Required. User defined unique ID of this instance. The `instance_id` must
              #     be 1 to 63 characters long and contain only lowercase letters,
              #     numeric characters, and dashes. The first character must be a lowercase
              #     letter and the last character cannot be a dash.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::RegisterInstanceRequest.new
              #
              #   # Call the register_instance method.
              #   result = client.register_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def register_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::RegisterInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.register_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.register_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.register_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.register_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the guest accelerators of a single Instance.
              #
              # @overload set_instance_accelerator(request, options = nil)
              #   Pass arguments to `set_instance_accelerator` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_instance_accelerator(name: nil, type: nil, core_count: nil)
              #   Pass arguments to `set_instance_accelerator` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param type [::Google::Cloud::Notebooks::V1::Instance::AcceleratorType]
              #     Required. Type of this accelerator.
              #   @param core_count [::Integer]
              #     Required. Count of cores of this accelerator. Note that not all combinations
              #     of `type` and `core_count` are valid. Check [GPUs on
              #     Compute Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to
              #     find a valid combination. TPUs are not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest.new
              #
              #   # Call the set_instance_accelerator method.
              #   result = client.set_instance_accelerator request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def set_instance_accelerator request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::SetInstanceAcceleratorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_instance_accelerator.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_instance_accelerator.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_instance_accelerator.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.set_instance_accelerator request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the machine type of a single Instance.
              #
              # @overload set_instance_machine_type(request, options = nil)
              #   Pass arguments to `set_instance_machine_type` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_instance_machine_type(name: nil, machine_type: nil)
              #   Pass arguments to `set_instance_machine_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param machine_type [::String]
              #     Required. The [Compute Engine machine
              #     type](https://cloud.google.com/compute/docs/machine-types).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest.new
              #
              #   # Call the set_instance_machine_type method.
              #   result = client.set_instance_machine_type request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def set_instance_machine_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::SetInstanceMachineTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_instance_machine_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_instance_machine_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_instance_machine_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.set_instance_machine_type request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update Notebook Instance configurations.
              #
              # @overload update_instance_config(request, options = nil)
              #   Pass arguments to `update_instance_config` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_instance_config(name: nil, config: nil)
              #   Pass arguments to `update_instance_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param config [::Google::Cloud::Notebooks::V1::InstanceConfig, ::Hash]
              #     The instance configurations to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest.new
              #
              #   # Call the update_instance_config method.
              #   result = client.update_instance_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_instance_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpdateInstanceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_instance_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_instance_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_instance_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.update_instance_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Shielded instance configuration of a single Instance.
              #
              # @overload update_shielded_instance_config(request, options = nil)
              #   Pass arguments to `update_shielded_instance_config` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_shielded_instance_config(name: nil, shielded_instance_config: nil)
              #   Pass arguments to `update_shielded_instance_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param shielded_instance_config [::Google::Cloud::Notebooks::V1::Instance::ShieldedInstanceConfig, ::Hash]
              #     ShieldedInstance configuration to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest.new
              #
              #   # Call the update_shielded_instance_config method.
              #   result = client.update_shielded_instance_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_shielded_instance_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpdateShieldedInstanceConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_shielded_instance_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_shielded_instance_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_shielded_instance_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.update_shielded_instance_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Replaces all the labels of an Instance.
              #
              # @overload set_instance_labels(request, options = nil)
              #   Pass arguments to `set_instance_labels` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_instance_labels(name: nil, labels: nil)
              #   Pass arguments to `set_instance_labels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param labels [::Hash{::String => ::String}]
              #     Labels to apply to this instance.
              #     These can be later modified by the setLabels method
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest.new
              #
              #   # Call the set_instance_labels method.
              #   result = client.set_instance_labels request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def set_instance_labels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::SetInstanceLabelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_instance_labels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_instance_labels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_instance_labels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.set_instance_labels request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Add/update metadata items for an instance.
              #
              # @overload update_instance_metadata_items(request, options = nil)
              #   Pass arguments to `update_instance_metadata_items` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_instance_metadata_items(name: nil, items: nil)
              #   Pass arguments to `update_instance_metadata_items` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param items [::Hash{::String => ::String}]
              #     Metadata items to add/update for the instance.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest.new
              #
              #   # Call the update_instance_metadata_items method.
              #   result = client.update_instance_metadata_items request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsResponse.
              #   p result
              #
              def update_instance_metadata_items request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpdateInstanceMetadataItemsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_instance_metadata_items.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_instance_metadata_items.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_instance_metadata_items.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.update_instance_metadata_items request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Instance.
              #
              # @overload delete_instance(request, options = nil)
              #   Pass arguments to `delete_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DeleteInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DeleteInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_instance(name: nil)
              #   Pass arguments to `delete_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DeleteInstanceRequest.new
              #
              #   # Call the delete_instance method.
              #   result = client.delete_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DeleteInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a notebook instance.
              #
              # @overload start_instance(request, options = nil)
              #   Pass arguments to `start_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::StartInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::StartInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_instance(name: nil)
              #   Pass arguments to `start_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::StartInstanceRequest.new
              #
              #   # Call the start_instance method.
              #   result = client.start_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::StartInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.start_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a notebook instance.
              #
              # @overload stop_instance(request, options = nil)
              #   Pass arguments to `stop_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::StopInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::StopInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_instance(name: nil)
              #   Pass arguments to `stop_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::StopInstanceRequest.new
              #
              #   # Call the stop_instance method.
              #   result = client.stop_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::StopInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.stop_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resets a notebook instance.
              #
              # @overload reset_instance(request, options = nil)
              #   Pass arguments to `reset_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ResetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ResetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reset_instance(name: nil)
              #   Pass arguments to `reset_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ResetInstanceRequest.new
              #
              #   # Call the reset_instance method.
              #   result = client.reset_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reset_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ResetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reset_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reset_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reset_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.reset_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Allows notebook instances to
              # report their latest instance information to the Notebooks
              # API server. The server will merge the reported information to
              # the instance metadata store. Do not use this method directly.
              #
              # @overload report_instance_info(request, options = nil)
              #   Pass arguments to `report_instance_info` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload report_instance_info(name: nil, vm_id: nil, metadata: nil)
              #   Pass arguments to `report_instance_info` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param vm_id [::String]
              #     Required. The VM hardware token for authenticating the VM.
              #     https://cloud.google.com/compute/docs/instances/verifying-instance-identity
              #   @param metadata [::Hash{::String => ::String}]
              #     The metadata reported to Notebooks API. This will be merged to the instance
              #     metadata store
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest.new
              #
              #   # Call the report_instance_info method.
              #   result = client.report_instance_info request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def report_instance_info request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ReportInstanceInfoRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.report_instance_info.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.report_instance_info.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.report_instance_info.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.report_instance_info request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Check if a notebook instance is upgradable.
              #
              # @overload is_instance_upgradeable(request, options = nil)
              #   Pass arguments to `is_instance_upgradeable` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload is_instance_upgradeable(notebook_instance: nil, type: nil)
              #   Pass arguments to `is_instance_upgradeable` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param notebook_instance [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param type [::Google::Cloud::Notebooks::V1::UpgradeType]
              #     Optional. The optional UpgradeType. Setting this field will search for additional
              #     compute images to upgrade this instance.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest.new
              #
              #   # Call the is_instance_upgradeable method.
              #   result = client.is_instance_upgradeable request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::IsInstanceUpgradeableResponse.
              #   p result
              #
              def is_instance_upgradeable request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::IsInstanceUpgradeableRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.is_instance_upgradeable.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.is_instance_upgradeable.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.is_instance_upgradeable.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.is_instance_upgradeable request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Check if a notebook instance is healthy.
              #
              # @overload get_instance_health(request, options = nil)
              #   Pass arguments to `get_instance_health` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_instance_health(name: nil)
              #   Pass arguments to `get_instance_health` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::GetInstanceHealthResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::GetInstanceHealthResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::GetInstanceHealthRequest.new
              #
              #   # Call the get_instance_health method.
              #   result = client.get_instance_health request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::GetInstanceHealthResponse.
              #   p result
              #
              def get_instance_health request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::GetInstanceHealthRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_instance_health.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_instance_health.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_instance_health.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_instance_health request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Upgrades a notebook instance to the latest version.
              #
              # @overload upgrade_instance(request, options = nil)
              #   Pass arguments to `upgrade_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upgrade_instance(name: nil, type: nil)
              #   Pass arguments to `upgrade_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param type [::Google::Cloud::Notebooks::V1::UpgradeType]
              #     Optional. The optional UpgradeType. Setting this field will search for additional
              #     compute images to upgrade this instance.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpgradeInstanceRequest.new
              #
              #   # Call the upgrade_instance method.
              #   result = client.upgrade_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upgrade_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpgradeInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upgrade_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upgrade_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upgrade_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.upgrade_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Rollbacks a notebook instance to the previous version.
              #
              # @overload rollback_instance(request, options = nil)
              #   Pass arguments to `rollback_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::RollbackInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::RollbackInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rollback_instance(name: nil, target_snapshot: nil)
              #   Pass arguments to `rollback_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param target_snapshot [::String]
              #     Required. The snapshot for rollback.
              #     Example: `projects/test-project/global/snapshots/krwlzipynril`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::RollbackInstanceRequest.new
              #
              #   # Call the rollback_instance method.
              #   result = client.rollback_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def rollback_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::RollbackInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rollback_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rollback_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rollback_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.rollback_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Diagnostic File and runs Diagnostic Tool given an Instance.
              #
              # @overload diagnose_instance(request, options = nil)
              #   Pass arguments to `diagnose_instance` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload diagnose_instance(name: nil, diagnostic_config: nil)
              #   Pass arguments to `diagnose_instance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param diagnostic_config [::Google::Cloud::Notebooks::V1::DiagnosticConfig, ::Hash]
              #     Required. Defines flags that are used to run the diagnostic tool
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest.new
              #
              #   # Call the diagnose_instance method.
              #   result = client.diagnose_instance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def diagnose_instance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DiagnoseInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.diagnose_instance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.diagnose_instance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.diagnose_instance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.diagnose_instance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Allows notebook instances to
              # call this endpoint to upgrade themselves. Do not use this method directly.
              #
              # @overload upgrade_instance_internal(request, options = nil)
              #   Pass arguments to `upgrade_instance_internal` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upgrade_instance_internal(name: nil, vm_id: nil, type: nil)
              #   Pass arguments to `upgrade_instance_internal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
              #   @param vm_id [::String]
              #     Required. The VM hardware token for authenticating the VM.
              #     https://cloud.google.com/compute/docs/instances/verifying-instance-identity
              #   @param type [::Google::Cloud::Notebooks::V1::UpgradeType]
              #     Optional. The optional UpgradeType. Setting this field will search for additional
              #     compute images to upgrade this instance.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest.new
              #
              #   # Call the upgrade_instance_internal method.
              #   result = client.upgrade_instance_internal request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upgrade_instance_internal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpgradeInstanceInternalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upgrade_instance_internal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upgrade_instance_internal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upgrade_instance_internal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.upgrade_instance_internal request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists environments in a project.
              #
              # @overload list_environments(request, options = nil)
              #   Pass arguments to `list_environments` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_environments(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_environments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format: `projects/{project_id}/locations/{location}`
              #   @param page_size [::Integer]
              #     Maximum return size of the list call.
              #   @param page_token [::String]
              #     A previous returned page token that can be used to continue listing from
              #     the last result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Environment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Environment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ListEnvironmentsRequest.new
              #
              #   # Call the list_environments method.
              #   result = client.list_environments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Notebooks::V1::Environment.
              #     p item
              #   end
              #
              def list_environments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ListEnvironmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_environments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_environments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_environments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_environments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_environments, "environments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Environment.
              #
              # @overload get_environment(request, options = nil)
              #   Pass arguments to `get_environment` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::GetEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::GetEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_environment(name: nil)
              #   Pass arguments to `get_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/environments/{environment_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::Environment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::Environment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::GetEnvironmentRequest.new
              #
              #   # Call the get_environment method.
              #   result = client.get_environment request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::Environment.
              #   p result
              #
              def get_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::GetEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_environment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Environment.
              #
              # @overload create_environment(request, options = nil)
              #   Pass arguments to `create_environment` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_environment(parent: nil, environment_id: nil, environment: nil)
              #   Pass arguments to `create_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format: `projects/{project_id}/locations/{location}`
              #   @param environment_id [::String]
              #     Required. User-defined unique ID of this environment. The `environment_id` must
              #     be 1 to 63 characters long and contain only lowercase letters,
              #     numeric characters, and dashes. The first character must be a lowercase
              #     letter and the last character cannot be a dash.
              #   @param environment [::Google::Cloud::Notebooks::V1::Environment, ::Hash]
              #     Required. The environment to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::CreateEnvironmentRequest.new
              #
              #   # Call the create_environment method.
              #   result = client.create_environment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::CreateEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.create_environment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Environment.
              #
              # @overload delete_environment(request, options = nil)
              #   Pass arguments to `delete_environment` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_environment(name: nil)
              #   Pass arguments to `delete_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/environments/{environment_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest.new
              #
              #   # Call the delete_environment method.
              #   result = client.delete_environment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DeleteEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_environment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists schedules in a given project and location.
              #
              # @overload list_schedules(request, options = nil)
              #   Pass arguments to `list_schedules` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ListSchedulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ListSchedulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_schedules(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_schedules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param page_size [::Integer]
              #     Maximum return size of the list call.
              #   @param page_token [::String]
              #     A previous returned page token that can be used to continue listing
              #     from the last result.
              #   @param filter [::String]
              #     Filter applied to resulting schedules.
              #   @param order_by [::String]
              #     Field to order results by.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Schedule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Schedule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ListSchedulesRequest.new
              #
              #   # Call the list_schedules method.
              #   result = client.list_schedules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Notebooks::V1::Schedule.
              #     p item
              #   end
              #
              def list_schedules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ListSchedulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_schedules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_schedules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_schedules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_schedules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_schedules, "schedules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of schedule
              #
              # @overload get_schedule(request, options = nil)
              #   Pass arguments to `get_schedule` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::GetScheduleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::GetScheduleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_schedule(name: nil)
              #   Pass arguments to `get_schedule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::Schedule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::Schedule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::GetScheduleRequest.new
              #
              #   # Call the get_schedule method.
              #   result = client.get_schedule request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::Schedule.
              #   p result
              #
              def get_schedule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::GetScheduleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_schedule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_schedule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_schedule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_schedule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes schedule and all underlying jobs
              #
              # @overload delete_schedule(request, options = nil)
              #   Pass arguments to `delete_schedule` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DeleteScheduleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DeleteScheduleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_schedule(name: nil)
              #   Pass arguments to `delete_schedule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DeleteScheduleRequest.new
              #
              #   # Call the delete_schedule method.
              #   result = client.delete_schedule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_schedule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DeleteScheduleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_schedule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_schedule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_schedule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_schedule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Scheduled Notebook in a given project and location.
              #
              # @overload create_schedule(request, options = nil)
              #   Pass arguments to `create_schedule` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::CreateScheduleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::CreateScheduleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_schedule(parent: nil, schedule_id: nil, schedule: nil)
              #   Pass arguments to `create_schedule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param schedule_id [::String]
              #     Required. User-defined unique ID of this schedule.
              #   @param schedule [::Google::Cloud::Notebooks::V1::Schedule, ::Hash]
              #     Required. The schedule to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::CreateScheduleRequest.new
              #
              #   # Call the create_schedule method.
              #   result = client.create_schedule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_schedule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::CreateScheduleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_schedule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_schedule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_schedule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.create_schedule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Triggers execution of an existing schedule.
              #
              # @overload trigger_schedule(request, options = nil)
              #   Pass arguments to `trigger_schedule` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::TriggerScheduleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::TriggerScheduleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload trigger_schedule(name: nil)
              #   Pass arguments to `trigger_schedule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::TriggerScheduleRequest.new
              #
              #   # Call the trigger_schedule method.
              #   result = client.trigger_schedule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def trigger_schedule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::TriggerScheduleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.trigger_schedule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.trigger_schedule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.trigger_schedule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.trigger_schedule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists executions in a given project and location
              #
              # @overload list_executions(request, options = nil)
              #   Pass arguments to `list_executions` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ListExecutionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ListExecutionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_executions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_executions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param page_size [::Integer]
              #     Maximum return size of the list call.
              #   @param page_token [::String]
              #     A previous returned page token that can be used to continue listing
              #     from the last result.
              #   @param filter [::String]
              #     Filter applied to resulting executions. Currently only supports filtering
              #     executions by a specified `schedule_id`.
              #     Format: `schedule_id=<Schedule_ID>`
              #   @param order_by [::String]
              #     Sort by field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Execution>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Execution>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ListExecutionsRequest.new
              #
              #   # Call the list_executions method.
              #   result = client.list_executions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Notebooks::V1::Execution.
              #     p item
              #   end
              #
              def list_executions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ListExecutionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_executions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_executions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_executions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.list_executions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @notebook_service_stub, :list_executions, "executions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of executions
              #
              # @overload get_execution(request, options = nil)
              #   Pass arguments to `get_execution` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::GetExecutionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::GetExecutionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_execution(name: nil)
              #   Pass arguments to `get_execution` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/executions/{execution_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::Execution]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::Execution]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::GetExecutionRequest.new
              #
              #   # Call the get_execution method.
              #   result = client.get_execution request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::Execution.
              #   p result
              #
              def get_execution request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::GetExecutionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_execution.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_execution.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_execution.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.get_execution request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes execution
              #
              # @overload delete_execution(request, options = nil)
              #   Pass arguments to `delete_execution` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DeleteExecutionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DeleteExecutionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_execution(name: nil)
              #   Pass arguments to `delete_execution` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/executions/{execution_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DeleteExecutionRequest.new
              #
              #   # Call the delete_execution method.
              #   result = client.delete_execution request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_execution request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DeleteExecutionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_execution.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_execution.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_execution.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.delete_execution request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Execution in a given project and location.
              #
              # @overload create_execution(request, options = nil)
              #   Pass arguments to `create_execution` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::CreateExecutionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::CreateExecutionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_execution(parent: nil, execution_id: nil, execution: nil)
              #   Pass arguments to `create_execution` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param execution_id [::String]
              #     Required. User-defined unique ID of this execution.
              #   @param execution [::Google::Cloud::Notebooks::V1::Execution, ::Hash]
              #     Required. The execution to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::CreateExecutionRequest.new
              #
              #   # Call the create_execution method.
              #   result = client.create_execution request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_execution request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::CreateExecutionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_execution.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_execution.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_execution.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @notebook_service_stub.create_execution request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the NotebookService REST API.
              #
              # This class represents the configuration for NotebookService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_instances to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_instances.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Notebooks::V1::NotebookService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_instances.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "notebooks.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the NotebookService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_instances`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_instances
                  ##
                  # RPC-specific configuration for `get_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_instance
                  ##
                  # RPC-specific configuration for `create_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_instance
                  ##
                  # RPC-specific configuration for `register_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :register_instance
                  ##
                  # RPC-specific configuration for `set_instance_accelerator`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_instance_accelerator
                  ##
                  # RPC-specific configuration for `set_instance_machine_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_instance_machine_type
                  ##
                  # RPC-specific configuration for `update_instance_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_instance_config
                  ##
                  # RPC-specific configuration for `update_shielded_instance_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_shielded_instance_config
                  ##
                  # RPC-specific configuration for `set_instance_labels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_instance_labels
                  ##
                  # RPC-specific configuration for `update_instance_metadata_items`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_instance_metadata_items
                  ##
                  # RPC-specific configuration for `delete_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_instance
                  ##
                  # RPC-specific configuration for `start_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_instance
                  ##
                  # RPC-specific configuration for `stop_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_instance
                  ##
                  # RPC-specific configuration for `reset_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reset_instance
                  ##
                  # RPC-specific configuration for `report_instance_info`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :report_instance_info
                  ##
                  # RPC-specific configuration for `is_instance_upgradeable`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :is_instance_upgradeable
                  ##
                  # RPC-specific configuration for `get_instance_health`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_instance_health
                  ##
                  # RPC-specific configuration for `upgrade_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upgrade_instance
                  ##
                  # RPC-specific configuration for `rollback_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rollback_instance
                  ##
                  # RPC-specific configuration for `diagnose_instance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :diagnose_instance
                  ##
                  # RPC-specific configuration for `upgrade_instance_internal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upgrade_instance_internal
                  ##
                  # RPC-specific configuration for `list_environments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_environments
                  ##
                  # RPC-specific configuration for `get_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_environment
                  ##
                  # RPC-specific configuration for `create_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_environment
                  ##
                  # RPC-specific configuration for `delete_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_environment
                  ##
                  # RPC-specific configuration for `list_schedules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_schedules
                  ##
                  # RPC-specific configuration for `get_schedule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_schedule
                  ##
                  # RPC-specific configuration for `delete_schedule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_schedule
                  ##
                  # RPC-specific configuration for `create_schedule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_schedule
                  ##
                  # RPC-specific configuration for `trigger_schedule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :trigger_schedule
                  ##
                  # RPC-specific configuration for `list_executions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_executions
                  ##
                  # RPC-specific configuration for `get_execution`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_execution
                  ##
                  # RPC-specific configuration for `delete_execution`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_execution
                  ##
                  # RPC-specific configuration for `create_execution`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_execution

                  # @private
                  def initialize parent_rpcs = nil
                    list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                    @list_instances = ::Gapic::Config::Method.new list_instances_config
                    get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                    @get_instance = ::Gapic::Config::Method.new get_instance_config
                    create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                    @create_instance = ::Gapic::Config::Method.new create_instance_config
                    register_instance_config = parent_rpcs.register_instance if parent_rpcs.respond_to? :register_instance
                    @register_instance = ::Gapic::Config::Method.new register_instance_config
                    set_instance_accelerator_config = parent_rpcs.set_instance_accelerator if parent_rpcs.respond_to? :set_instance_accelerator
                    @set_instance_accelerator = ::Gapic::Config::Method.new set_instance_accelerator_config
                    set_instance_machine_type_config = parent_rpcs.set_instance_machine_type if parent_rpcs.respond_to? :set_instance_machine_type
                    @set_instance_machine_type = ::Gapic::Config::Method.new set_instance_machine_type_config
                    update_instance_config_config = parent_rpcs.update_instance_config if parent_rpcs.respond_to? :update_instance_config
                    @update_instance_config = ::Gapic::Config::Method.new update_instance_config_config
                    update_shielded_instance_config_config = parent_rpcs.update_shielded_instance_config if parent_rpcs.respond_to? :update_shielded_instance_config
                    @update_shielded_instance_config = ::Gapic::Config::Method.new update_shielded_instance_config_config
                    set_instance_labels_config = parent_rpcs.set_instance_labels if parent_rpcs.respond_to? :set_instance_labels
                    @set_instance_labels = ::Gapic::Config::Method.new set_instance_labels_config
                    update_instance_metadata_items_config = parent_rpcs.update_instance_metadata_items if parent_rpcs.respond_to? :update_instance_metadata_items
                    @update_instance_metadata_items = ::Gapic::Config::Method.new update_instance_metadata_items_config
                    delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                    @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                    start_instance_config = parent_rpcs.start_instance if parent_rpcs.respond_to? :start_instance
                    @start_instance = ::Gapic::Config::Method.new start_instance_config
                    stop_instance_config = parent_rpcs.stop_instance if parent_rpcs.respond_to? :stop_instance
                    @stop_instance = ::Gapic::Config::Method.new stop_instance_config
                    reset_instance_config = parent_rpcs.reset_instance if parent_rpcs.respond_to? :reset_instance
                    @reset_instance = ::Gapic::Config::Method.new reset_instance_config
                    report_instance_info_config = parent_rpcs.report_instance_info if parent_rpcs.respond_to? :report_instance_info
                    @report_instance_info = ::Gapic::Config::Method.new report_instance_info_config
                    is_instance_upgradeable_config = parent_rpcs.is_instance_upgradeable if parent_rpcs.respond_to? :is_instance_upgradeable
                    @is_instance_upgradeable = ::Gapic::Config::Method.new is_instance_upgradeable_config
                    get_instance_health_config = parent_rpcs.get_instance_health if parent_rpcs.respond_to? :get_instance_health
                    @get_instance_health = ::Gapic::Config::Method.new get_instance_health_config
                    upgrade_instance_config = parent_rpcs.upgrade_instance if parent_rpcs.respond_to? :upgrade_instance
                    @upgrade_instance = ::Gapic::Config::Method.new upgrade_instance_config
                    rollback_instance_config = parent_rpcs.rollback_instance if parent_rpcs.respond_to? :rollback_instance
                    @rollback_instance = ::Gapic::Config::Method.new rollback_instance_config
                    diagnose_instance_config = parent_rpcs.diagnose_instance if parent_rpcs.respond_to? :diagnose_instance
                    @diagnose_instance = ::Gapic::Config::Method.new diagnose_instance_config
                    upgrade_instance_internal_config = parent_rpcs.upgrade_instance_internal if parent_rpcs.respond_to? :upgrade_instance_internal
                    @upgrade_instance_internal = ::Gapic::Config::Method.new upgrade_instance_internal_config
                    list_environments_config = parent_rpcs.list_environments if parent_rpcs.respond_to? :list_environments
                    @list_environments = ::Gapic::Config::Method.new list_environments_config
                    get_environment_config = parent_rpcs.get_environment if parent_rpcs.respond_to? :get_environment
                    @get_environment = ::Gapic::Config::Method.new get_environment_config
                    create_environment_config = parent_rpcs.create_environment if parent_rpcs.respond_to? :create_environment
                    @create_environment = ::Gapic::Config::Method.new create_environment_config
                    delete_environment_config = parent_rpcs.delete_environment if parent_rpcs.respond_to? :delete_environment
                    @delete_environment = ::Gapic::Config::Method.new delete_environment_config
                    list_schedules_config = parent_rpcs.list_schedules if parent_rpcs.respond_to? :list_schedules
                    @list_schedules = ::Gapic::Config::Method.new list_schedules_config
                    get_schedule_config = parent_rpcs.get_schedule if parent_rpcs.respond_to? :get_schedule
                    @get_schedule = ::Gapic::Config::Method.new get_schedule_config
                    delete_schedule_config = parent_rpcs.delete_schedule if parent_rpcs.respond_to? :delete_schedule
                    @delete_schedule = ::Gapic::Config::Method.new delete_schedule_config
                    create_schedule_config = parent_rpcs.create_schedule if parent_rpcs.respond_to? :create_schedule
                    @create_schedule = ::Gapic::Config::Method.new create_schedule_config
                    trigger_schedule_config = parent_rpcs.trigger_schedule if parent_rpcs.respond_to? :trigger_schedule
                    @trigger_schedule = ::Gapic::Config::Method.new trigger_schedule_config
                    list_executions_config = parent_rpcs.list_executions if parent_rpcs.respond_to? :list_executions
                    @list_executions = ::Gapic::Config::Method.new list_executions_config
                    get_execution_config = parent_rpcs.get_execution if parent_rpcs.respond_to? :get_execution
                    @get_execution = ::Gapic::Config::Method.new get_execution_config
                    delete_execution_config = parent_rpcs.delete_execution if parent_rpcs.respond_to? :delete_execution
                    @delete_execution = ::Gapic::Config::Method.new delete_execution_config
                    create_execution_config = parent_rpcs.create_execution if parent_rpcs.respond_to? :create_execution
                    @create_execution = ::Gapic::Config::Method.new create_execution_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
