# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Notebooks
      module V1
        module NotebookService
          # Path helper methods for the NotebookService API.
          module Paths
            ##
            # Create a fully-qualified Environment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/environments/{environment}`
            #
            # @param project [String]
            # @param environment [String]
            #
            # @return [::String]
            def environment_path project:, environment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/environments/#{environment}"
            end

            ##
            # Create a fully-qualified Execution resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/location/{location}/executions/{execution}`
            #
            # @param project [String]
            # @param location [String]
            # @param execution [String]
            #
            # @return [::String]
            def execution_path project:, location:, execution:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/location/#{location}/executions/#{execution}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}`
            #
            # @param project [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Schedule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/location/{location}/schedules/{schedule}`
            #
            # @param project [String]
            # @param location [String]
            # @param schedule [String]
            #
            # @return [::String]
            def schedule_path project:, location:, schedule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/location/#{location}/schedules/#{schedule}"
            end

            ##
            # Create a fully-qualified Tensorboard resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
            #
            # @param project [String]
            # @param location [String]
            # @param tensorboard [String]
            #
            # @return [::String]
            def tensorboard_path project:, location:, tensorboard:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tensorboards/#{tensorboard}"
            end

            extend self
          end
        end
      end
    end
  end
end
