# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/notebooks/v1/managed_service_pb"
require "google/cloud/notebooks/v1/managed_notebook_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Notebooks
      module V1
        module ManagedNotebookService
          module Rest
            ##
            # REST client for the ManagedNotebookService service.
            #
            # API v1 service for Managed Notebooks.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "notebooks.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :managed_notebook_service_stub

              ##
              # Configure the ManagedNotebookService Client class.
              #
              # See {::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ManagedNotebookService clients
              #   ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Notebooks", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_runtimes.timeout = 60.0

                  default_config.rpcs.get_runtime.timeout = 60.0

                  default_config.rpcs.create_runtime.timeout = 60.0

                  default_config.rpcs.update_runtime.timeout = 60.0

                  default_config.rpcs.delete_runtime.timeout = 60.0

                  default_config.rpcs.start_runtime.timeout = 60.0

                  default_config.rpcs.stop_runtime.timeout = 60.0

                  default_config.rpcs.switch_runtime.timeout = 60.0

                  default_config.rpcs.report_runtime_event.timeout = 60.0

                  default_config.rpcs.diagnose_runtime.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ManagedNotebookService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @managed_notebook_service_stub.universe_domain
              end

              ##
              # Create a new ManagedNotebookService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ManagedNotebookService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @managed_notebook_service_stub = ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @managed_notebook_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @managed_notebook_service_stub.endpoint
                  config.universe_domain = @managed_notebook_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @managed_notebook_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @managed_notebook_service_stub.endpoint
                  config.universe_domain = @managed_notebook_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @managed_notebook_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @managed_notebook_service_stub.logger
              end

              # Service calls

              ##
              # Lists Runtimes in a given project and location.
              #
              # @overload list_runtimes(request, options = nil)
              #   Pass arguments to `list_runtimes` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ListRuntimesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ListRuntimesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_runtimes(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_runtimes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param page_size [::Integer]
              #     Maximum return size of the list call.
              #   @param page_token [::String]
              #     A previous returned page token that can be used to continue listing
              #     from the last result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Runtime>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Notebooks::V1::Runtime>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ListRuntimesRequest.new
              #
              #   # Call the list_runtimes method.
              #   result = client.list_runtimes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Notebooks::V1::Runtime.
              #     p item
              #   end
              #
              def list_runtimes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ListRuntimesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_runtimes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_runtimes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_runtimes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.list_runtimes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @managed_notebook_service_stub, :list_runtimes, "runtimes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Runtime. The location must be a regional endpoint
              # rather than zonal.
              #
              # @overload get_runtime(request, options = nil)
              #   Pass arguments to `get_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::GetRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::GetRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_runtime(name: nil)
              #   Pass arguments to `get_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::Runtime]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::Runtime]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::GetRuntimeRequest.new
              #
              #   # Call the get_runtime method.
              #   result = client.get_runtime request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::Runtime.
              #   p result
              #
              def get_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::GetRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.get_runtime request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Runtime in a given project and location.
              #
              # @overload create_runtime(request, options = nil)
              #   Pass arguments to `create_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::CreateRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::CreateRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_runtime(parent: nil, runtime_id: nil, runtime: nil, request_id: nil)
              #   Pass arguments to `create_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Format:
              #     `parent=projects/{project_id}/locations/{location}`
              #   @param runtime_id [::String]
              #     Required. User-defined unique ID of this Runtime.
              #   @param runtime [::Google::Cloud::Notebooks::V1::Runtime, ::Hash]
              #     Required. The Runtime to be created.
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::CreateRuntimeRequest.new
              #
              #   # Call the create_runtime method.
              #   result = client.create_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::CreateRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.create_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update Notebook Runtime configuration.
              #
              # @overload update_runtime(request, options = nil)
              #   Pass arguments to `update_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpdateRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpdateRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_runtime(runtime: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param runtime [::Google::Cloud::Notebooks::V1::Runtime, ::Hash]
              #     Required. The Runtime to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Specifies the path, relative to `Runtime`, of
              #     the field to update. For example, to change the software configuration
              #     kernels, the `update_mask` parameter would be
              #     specified as `software_config.kernels`,
              #     and the `PATCH` request body would specify the new value, as follows:
              #
              #         {
              #           "software_config":{
              #             "kernels": [{
              #                'repository':
              #                'gcr.io/deeplearning-platform-release/pytorch-gpu', 'tag':
              #                'latest' }],
              #             }
              #         }
              #
              #
              #     Currently, only the following fields can be updated:
              #     - `software_config.kernels`
              #     - `software_config.post_startup_script`
              #     - `software_config.custom_gpu_driver_path`
              #     - `software_config.idle_shutdown`
              #     - `software_config.idle_shutdown_timeout`
              #     - `software_config.disable_terminal`
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpdateRuntimeRequest.new
              #
              #   # Call the update_runtime method.
              #   result = client.update_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpdateRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.update_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Runtime.
              #
              # @overload delete_runtime(request, options = nil)
              #   Pass arguments to `delete_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DeleteRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DeleteRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_runtime(name: nil, request_id: nil)
              #   Pass arguments to `delete_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DeleteRuntimeRequest.new
              #
              #   # Call the delete_runtime method.
              #   result = client.delete_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DeleteRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.delete_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a Managed Notebook Runtime.
              # Perform "Start" on GPU instances; "Resume" on CPU instances
              # See:
              # https://cloud.google.com/compute/docs/instances/stop-start-instance
              # https://cloud.google.com/compute/docs/instances/suspend-resume-instance
              #
              # @overload start_runtime(request, options = nil)
              #   Pass arguments to `start_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::StartRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::StartRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_runtime(name: nil, request_id: nil)
              #   Pass arguments to `start_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::StartRuntimeRequest.new
              #
              #   # Call the start_runtime method.
              #   result = client.start_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::StartRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.start_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a Managed Notebook Runtime.
              # Perform "Stop" on GPU instances; "Suspend" on CPU instances
              # See:
              # https://cloud.google.com/compute/docs/instances/stop-start-instance
              # https://cloud.google.com/compute/docs/instances/suspend-resume-instance
              #
              # @overload stop_runtime(request, options = nil)
              #   Pass arguments to `stop_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::StopRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::StopRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_runtime(name: nil, request_id: nil)
              #   Pass arguments to `stop_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::StopRuntimeRequest.new
              #
              #   # Call the stop_runtime method.
              #   result = client.stop_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::StopRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.stop_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Switch a Managed Notebook Runtime.
              #
              # @overload switch_runtime(request, options = nil)
              #   Pass arguments to `switch_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::SwitchRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::SwitchRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload switch_runtime(name: nil, machine_type: nil, accelerator_config: nil, request_id: nil)
              #   Pass arguments to `switch_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param machine_type [::String]
              #     machine type.
              #   @param accelerator_config [::Google::Cloud::Notebooks::V1::RuntimeAcceleratorConfig, ::Hash]
              #     accelerator config.
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::SwitchRuntimeRequest.new
              #
              #   # Call the switch_runtime method.
              #   result = client.switch_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def switch_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::SwitchRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.switch_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.switch_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.switch_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.switch_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resets a Managed Notebook Runtime.
              #
              # @overload reset_runtime(request, options = nil)
              #   Pass arguments to `reset_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ResetRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ResetRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reset_runtime(name: nil, request_id: nil)
              #   Pass arguments to `reset_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ResetRuntimeRequest.new
              #
              #   # Call the reset_runtime method.
              #   result = client.reset_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reset_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ResetRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reset_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reset_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reset_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.reset_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Upgrades a Managed Notebook Runtime to the latest version.
              #
              # @overload upgrade_runtime(request, options = nil)
              #   Pass arguments to `upgrade_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::UpgradeRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::UpgradeRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upgrade_runtime(name: nil, request_id: nil)
              #   Pass arguments to `upgrade_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param request_id [::String]
              #     Idempotent request UUID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::UpgradeRuntimeRequest.new
              #
              #   # Call the upgrade_runtime method.
              #   result = client.upgrade_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upgrade_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::UpgradeRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upgrade_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upgrade_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upgrade_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.upgrade_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Report and process a runtime event.
              #
              # @overload report_runtime_event(request, options = nil)
              #   Pass arguments to `report_runtime_event` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::ReportRuntimeEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::ReportRuntimeEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload report_runtime_event(name: nil, vm_id: nil, event: nil)
              #   Pass arguments to `report_runtime_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param vm_id [::String]
              #     Required. The VM hardware token for authenticating the VM.
              #     https://cloud.google.com/compute/docs/instances/verifying-instance-identity
              #   @param event [::Google::Cloud::Notebooks::V1::Event, ::Hash]
              #     Required. The Event to be reported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::ReportRuntimeEventRequest.new
              #
              #   # Call the report_runtime_event method.
              #   result = client.report_runtime_event request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def report_runtime_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::ReportRuntimeEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.report_runtime_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.report_runtime_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.report_runtime_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.report_runtime_event request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an access token for the consumer service account that the customer
              # attached to the runtime. Only accessible from the tenant instance.
              #
              # @overload refresh_runtime_token_internal(request, options = nil)
              #   Pass arguments to `refresh_runtime_token_internal` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload refresh_runtime_token_internal(name: nil, vm_id: nil)
              #   Pass arguments to `refresh_runtime_token_internal` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
              #   @param vm_id [::String]
              #     Required. The VM hardware token for authenticating the VM.
              #     https://cloud.google.com/compute/docs/instances/verifying-instance-identity
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalRequest.new
              #
              #   # Call the refresh_runtime_token_internal method.
              #   result = client.refresh_runtime_token_internal request
              #
              #   # The returned object is of type Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalResponse.
              #   p result
              #
              def refresh_runtime_token_internal request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::RefreshRuntimeTokenInternalRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.refresh_runtime_token_internal.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.refresh_runtime_token_internal.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.refresh_runtime_token_internal.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.refresh_runtime_token_internal request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Diagnostic File and runs Diagnostic Tool given a Runtime.
              #
              # @overload diagnose_runtime(request, options = nil)
              #   Pass arguments to `diagnose_runtime` via a request object, either of type
              #   {::Google::Cloud::Notebooks::V1::DiagnoseRuntimeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Notebooks::V1::DiagnoseRuntimeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload diagnose_runtime(name: nil, diagnostic_config: nil)
              #   Pass arguments to `diagnose_runtime` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `projects/{project_id}/locations/{location}/runtimes/{runtimes_id}`
              #   @param diagnostic_config [::Google::Cloud::Notebooks::V1::DiagnosticConfig, ::Hash]
              #     Required. Defines flags that are used to run the diagnostic tool
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/notebooks/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Notebooks::V1::DiagnoseRuntimeRequest.new
              #
              #   # Call the diagnose_runtime method.
              #   result = client.diagnose_runtime request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def diagnose_runtime request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Notebooks::V1::DiagnoseRuntimeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.diagnose_runtime.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Notebooks::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.diagnose_runtime.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.diagnose_runtime.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_notebook_service_stub.diagnose_runtime request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ManagedNotebookService REST API.
              #
              # This class represents the configuration for ManagedNotebookService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_runtimes to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_runtimes.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Notebooks::V1::ManagedNotebookService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_runtimes.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "notebooks.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ManagedNotebookService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_runtimes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_runtimes
                  ##
                  # RPC-specific configuration for `get_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_runtime
                  ##
                  # RPC-specific configuration for `create_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_runtime
                  ##
                  # RPC-specific configuration for `update_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_runtime
                  ##
                  # RPC-specific configuration for `delete_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_runtime
                  ##
                  # RPC-specific configuration for `start_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_runtime
                  ##
                  # RPC-specific configuration for `stop_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_runtime
                  ##
                  # RPC-specific configuration for `switch_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :switch_runtime
                  ##
                  # RPC-specific configuration for `reset_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reset_runtime
                  ##
                  # RPC-specific configuration for `upgrade_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upgrade_runtime
                  ##
                  # RPC-specific configuration for `report_runtime_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :report_runtime_event
                  ##
                  # RPC-specific configuration for `refresh_runtime_token_internal`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :refresh_runtime_token_internal
                  ##
                  # RPC-specific configuration for `diagnose_runtime`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :diagnose_runtime

                  # @private
                  def initialize parent_rpcs = nil
                    list_runtimes_config = parent_rpcs.list_runtimes if parent_rpcs.respond_to? :list_runtimes
                    @list_runtimes = ::Gapic::Config::Method.new list_runtimes_config
                    get_runtime_config = parent_rpcs.get_runtime if parent_rpcs.respond_to? :get_runtime
                    @get_runtime = ::Gapic::Config::Method.new get_runtime_config
                    create_runtime_config = parent_rpcs.create_runtime if parent_rpcs.respond_to? :create_runtime
                    @create_runtime = ::Gapic::Config::Method.new create_runtime_config
                    update_runtime_config = parent_rpcs.update_runtime if parent_rpcs.respond_to? :update_runtime
                    @update_runtime = ::Gapic::Config::Method.new update_runtime_config
                    delete_runtime_config = parent_rpcs.delete_runtime if parent_rpcs.respond_to? :delete_runtime
                    @delete_runtime = ::Gapic::Config::Method.new delete_runtime_config
                    start_runtime_config = parent_rpcs.start_runtime if parent_rpcs.respond_to? :start_runtime
                    @start_runtime = ::Gapic::Config::Method.new start_runtime_config
                    stop_runtime_config = parent_rpcs.stop_runtime if parent_rpcs.respond_to? :stop_runtime
                    @stop_runtime = ::Gapic::Config::Method.new stop_runtime_config
                    switch_runtime_config = parent_rpcs.switch_runtime if parent_rpcs.respond_to? :switch_runtime
                    @switch_runtime = ::Gapic::Config::Method.new switch_runtime_config
                    reset_runtime_config = parent_rpcs.reset_runtime if parent_rpcs.respond_to? :reset_runtime
                    @reset_runtime = ::Gapic::Config::Method.new reset_runtime_config
                    upgrade_runtime_config = parent_rpcs.upgrade_runtime if parent_rpcs.respond_to? :upgrade_runtime
                    @upgrade_runtime = ::Gapic::Config::Method.new upgrade_runtime_config
                    report_runtime_event_config = parent_rpcs.report_runtime_event if parent_rpcs.respond_to? :report_runtime_event
                    @report_runtime_event = ::Gapic::Config::Method.new report_runtime_event_config
                    refresh_runtime_token_internal_config = parent_rpcs.refresh_runtime_token_internal if parent_rpcs.respond_to? :refresh_runtime_token_internal
                    @refresh_runtime_token_internal = ::Gapic::Config::Method.new refresh_runtime_token_internal_config
                    diagnose_runtime_config = parent_rpcs.diagnose_runtime if parent_rpcs.respond_to? :diagnose_runtime
                    @diagnose_runtime = ::Gapic::Config::Method.new diagnose_runtime_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
