# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/networkservices/v1/network_services_pb"
require "google/cloud/network_services/v1/network_services"

class ::Google::Cloud::NetworkServices::V1::NetworkServices::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_endpoint_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_endpoint_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_endpoint_policies, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_endpoint_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_endpoint_policies({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_endpoint_policies parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_endpoint_policies ::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_endpoint_policies({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_endpoint_policies(::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_endpoint_policies_client_stub.call_rpc_count
    end
  end

  def test_get_endpoint_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::EndpointPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_endpoint_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_endpoint_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_endpoint_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_endpoint_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_endpoint_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_endpoint_policy ::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_endpoint_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_endpoint_policy(::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_endpoint_policy_client_stub.call_rpc_count
    end
  end

  def test_create_endpoint_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    endpoint_policy_id = "hello world"
    endpoint_policy = {}

    create_endpoint_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_endpoint_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["endpoint_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::EndpointPolicy), request["endpoint_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_endpoint_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_endpoint_policy({ parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_endpoint_policy parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_endpoint_policy ::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest.new(parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_endpoint_policy({ parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_endpoint_policy(::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest.new(parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_endpoint_policy_client_stub.call_rpc_count
    end
  end

  def test_update_endpoint_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    endpoint_policy = {}

    update_endpoint_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_endpoint_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::EndpointPolicy), request["endpoint_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_endpoint_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_endpoint_policy({ update_mask: update_mask, endpoint_policy: endpoint_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_endpoint_policy update_mask: update_mask, endpoint_policy: endpoint_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_endpoint_policy ::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest.new(update_mask: update_mask, endpoint_policy: endpoint_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_endpoint_policy({ update_mask: update_mask, endpoint_policy: endpoint_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_endpoint_policy(::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest.new(update_mask: update_mask, endpoint_policy: endpoint_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_endpoint_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_endpoint_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_endpoint_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_endpoint_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_endpoint_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_endpoint_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_endpoint_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_endpoint_policy ::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_endpoint_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_endpoint_policy(::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_endpoint_policy_client_stub.call_rpc_count
    end
  end

  def test_list_wasm_plugin_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_wasm_plugin_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_wasm_plugin_versions, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_wasm_plugin_versions_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_wasm_plugin_versions({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_wasm_plugin_versions parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_wasm_plugin_versions ::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_wasm_plugin_versions({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_wasm_plugin_versions(::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_wasm_plugin_versions_client_stub.call_rpc_count
    end
  end

  def test_get_wasm_plugin_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::WasmPluginVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_wasm_plugin_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_wasm_plugin_version, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_wasm_plugin_version_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_wasm_plugin_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_wasm_plugin_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_wasm_plugin_version ::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_wasm_plugin_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_wasm_plugin_version(::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_wasm_plugin_version_client_stub.call_rpc_count
    end
  end

  def test_create_wasm_plugin_version
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    wasm_plugin_version_id = "hello world"
    wasm_plugin_version = {}

    create_wasm_plugin_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_wasm_plugin_version, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["wasm_plugin_version_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::WasmPluginVersion), request["wasm_plugin_version"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_wasm_plugin_version_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_wasm_plugin_version({ parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_wasm_plugin_version parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_wasm_plugin_version ::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest.new(parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_wasm_plugin_version({ parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_wasm_plugin_version(::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest.new(parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_wasm_plugin_version_client_stub.call_rpc_count
    end
  end

  def test_delete_wasm_plugin_version
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_wasm_plugin_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_wasm_plugin_version, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_wasm_plugin_version_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_wasm_plugin_version({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_wasm_plugin_version name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_wasm_plugin_version ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_wasm_plugin_version({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_wasm_plugin_version(::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_wasm_plugin_version_client_stub.call_rpc_count
    end
  end

  def test_list_wasm_plugins
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListWasmPluginsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_wasm_plugins_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_wasm_plugins, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_wasm_plugins_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_wasm_plugins({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_wasm_plugins parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_wasm_plugins ::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_wasm_plugins({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_wasm_plugins(::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_wasm_plugins_client_stub.call_rpc_count
    end
  end

  def test_get_wasm_plugin
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::WasmPlugin.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :WASM_PLUGIN_VIEW_UNSPECIFIED

    get_wasm_plugin_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_wasm_plugin, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :WASM_PLUGIN_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_wasm_plugin_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_wasm_plugin({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_wasm_plugin name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_wasm_plugin ::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_wasm_plugin({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_wasm_plugin(::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_wasm_plugin_client_stub.call_rpc_count
    end
  end

  def test_create_wasm_plugin
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    wasm_plugin_id = "hello world"
    wasm_plugin = {}

    create_wasm_plugin_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_wasm_plugin, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["wasm_plugin_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::WasmPlugin), request["wasm_plugin"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_wasm_plugin_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_wasm_plugin({ parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_wasm_plugin parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_wasm_plugin ::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest.new(parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_wasm_plugin({ parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_wasm_plugin(::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest.new(parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_wasm_plugin_client_stub.call_rpc_count
    end
  end

  def test_update_wasm_plugin
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    wasm_plugin = {}

    update_wasm_plugin_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_wasm_plugin, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::WasmPlugin), request["wasm_plugin"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_wasm_plugin_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_wasm_plugin({ update_mask: update_mask, wasm_plugin: wasm_plugin }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_wasm_plugin update_mask: update_mask, wasm_plugin: wasm_plugin do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_wasm_plugin ::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest.new(update_mask: update_mask, wasm_plugin: wasm_plugin) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_wasm_plugin({ update_mask: update_mask, wasm_plugin: wasm_plugin }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_wasm_plugin(::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest.new(update_mask: update_mask, wasm_plugin: wasm_plugin), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_wasm_plugin_client_stub.call_rpc_count
    end
  end

  def test_delete_wasm_plugin
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_wasm_plugin_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_wasm_plugin, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_wasm_plugin_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_wasm_plugin({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_wasm_plugin name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_wasm_plugin ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_wasm_plugin({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_wasm_plugin(::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_wasm_plugin_client_stub.call_rpc_count
    end
  end

  def test_list_gateways
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListGatewaysResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_gateways_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_gateways, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListGatewaysRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_gateways_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_gateways({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_gateways parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_gateways ::Google::Cloud::NetworkServices::V1::ListGatewaysRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_gateways({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_gateways(::Google::Cloud::NetworkServices::V1::ListGatewaysRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_gateways_client_stub.call_rpc_count
    end
  end

  def test_get_gateway
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::Gateway.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gateway_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_gateway, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetGatewayRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_gateway_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_gateway({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_gateway name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_gateway ::Google::Cloud::NetworkServices::V1::GetGatewayRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_gateway({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_gateway(::Google::Cloud::NetworkServices::V1::GetGatewayRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_gateway_client_stub.call_rpc_count
    end
  end

  def test_create_gateway
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gateway_id = "hello world"
    gateway = {}

    create_gateway_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_gateway, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateGatewayRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["gateway_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::Gateway), request["gateway"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_gateway_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_gateway({ parent: parent, gateway_id: gateway_id, gateway: gateway }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_gateway parent: parent, gateway_id: gateway_id, gateway: gateway do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_gateway ::Google::Cloud::NetworkServices::V1::CreateGatewayRequest.new(parent: parent, gateway_id: gateway_id, gateway: gateway) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_gateway({ parent: parent, gateway_id: gateway_id, gateway: gateway }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_gateway(::Google::Cloud::NetworkServices::V1::CreateGatewayRequest.new(parent: parent, gateway_id: gateway_id, gateway: gateway), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_gateway_client_stub.call_rpc_count
    end
  end

  def test_update_gateway
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    gateway = {}

    update_gateway_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_gateway, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::Gateway), request["gateway"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_gateway_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_gateway({ update_mask: update_mask, gateway: gateway }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_gateway update_mask: update_mask, gateway: gateway do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_gateway ::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest.new(update_mask: update_mask, gateway: gateway) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_gateway({ update_mask: update_mask, gateway: gateway }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_gateway(::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest.new(update_mask: update_mask, gateway: gateway), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_gateway_client_stub.call_rpc_count
    end
  end

  def test_delete_gateway
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_gateway_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_gateway, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_gateway_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_gateway({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_gateway name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_gateway ::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_gateway({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_gateway(::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_gateway_client_stub.call_rpc_count
    end
  end

  def test_list_grpc_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListGrpcRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_grpc_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_grpc_routes, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_grpc_routes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_grpc_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_grpc_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_grpc_routes ::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_grpc_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_grpc_routes(::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_grpc_routes_client_stub.call_rpc_count
    end
  end

  def test_get_grpc_route
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::GrpcRoute.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_grpc_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_grpc_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_grpc_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_grpc_route({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_grpc_route name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_grpc_route ::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_grpc_route({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_grpc_route(::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_grpc_route_client_stub.call_rpc_count
    end
  end

  def test_create_grpc_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    grpc_route_id = "hello world"
    grpc_route = {}

    create_grpc_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_grpc_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["grpc_route_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::GrpcRoute), request["grpc_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_grpc_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_grpc_route({ parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_grpc_route parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_grpc_route ::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest.new(parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_grpc_route({ parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_grpc_route(::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest.new(parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_grpc_route_client_stub.call_rpc_count
    end
  end

  def test_update_grpc_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    grpc_route = {}

    update_grpc_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_grpc_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::GrpcRoute), request["grpc_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_grpc_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_grpc_route({ update_mask: update_mask, grpc_route: grpc_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_grpc_route update_mask: update_mask, grpc_route: grpc_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_grpc_route ::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest.new(update_mask: update_mask, grpc_route: grpc_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_grpc_route({ update_mask: update_mask, grpc_route: grpc_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_grpc_route(::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest.new(update_mask: update_mask, grpc_route: grpc_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_grpc_route_client_stub.call_rpc_count
    end
  end

  def test_delete_grpc_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_grpc_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_grpc_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_grpc_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_grpc_route({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_grpc_route name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_grpc_route ::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_grpc_route({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_grpc_route(::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_grpc_route_client_stub.call_rpc_count
    end
  end

  def test_list_http_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListHttpRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_http_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_http_routes, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_http_routes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_http_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_http_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_http_routes ::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_http_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_http_routes(::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_http_routes_client_stub.call_rpc_count
    end
  end

  def test_get_http_route
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::HttpRoute.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_http_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_http_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_http_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_http_route({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_http_route name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_http_route ::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_http_route({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_http_route(::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_http_route_client_stub.call_rpc_count
    end
  end

  def test_create_http_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    http_route_id = "hello world"
    http_route = {}

    create_http_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_http_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["http_route_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::HttpRoute), request["http_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_http_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_http_route({ parent: parent, http_route_id: http_route_id, http_route: http_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_http_route parent: parent, http_route_id: http_route_id, http_route: http_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_http_route ::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest.new(parent: parent, http_route_id: http_route_id, http_route: http_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_http_route({ parent: parent, http_route_id: http_route_id, http_route: http_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_http_route(::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest.new(parent: parent, http_route_id: http_route_id, http_route: http_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_http_route_client_stub.call_rpc_count
    end
  end

  def test_update_http_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    http_route = {}

    update_http_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_http_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::HttpRoute), request["http_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_http_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_http_route({ update_mask: update_mask, http_route: http_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_http_route update_mask: update_mask, http_route: http_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_http_route ::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest.new(update_mask: update_mask, http_route: http_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_http_route({ update_mask: update_mask, http_route: http_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_http_route(::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest.new(update_mask: update_mask, http_route: http_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_http_route_client_stub.call_rpc_count
    end
  end

  def test_delete_http_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_http_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_http_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_http_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_http_route({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_http_route name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_http_route ::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_http_route({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_http_route(::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_http_route_client_stub.call_rpc_count
    end
  end

  def test_list_tcp_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListTcpRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_tcp_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tcp_routes, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tcp_routes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tcp_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tcp_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tcp_routes ::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tcp_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tcp_routes(::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tcp_routes_client_stub.call_rpc_count
    end
  end

  def test_get_tcp_route
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::TcpRoute.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tcp_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tcp_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tcp_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tcp_route({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tcp_route name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tcp_route ::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tcp_route({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tcp_route(::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tcp_route_client_stub.call_rpc_count
    end
  end

  def test_create_tcp_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tcp_route_id = "hello world"
    tcp_route = {}

    create_tcp_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tcp_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["tcp_route_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::TcpRoute), request["tcp_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tcp_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tcp_route({ parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tcp_route parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tcp_route ::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest.new(parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tcp_route({ parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tcp_route(::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest.new(parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tcp_route_client_stub.call_rpc_count
    end
  end

  def test_update_tcp_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tcp_route = {}

    update_tcp_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tcp_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::TcpRoute), request["tcp_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tcp_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tcp_route({ update_mask: update_mask, tcp_route: tcp_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tcp_route update_mask: update_mask, tcp_route: tcp_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tcp_route ::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest.new(update_mask: update_mask, tcp_route: tcp_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tcp_route({ update_mask: update_mask, tcp_route: tcp_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tcp_route(::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest.new(update_mask: update_mask, tcp_route: tcp_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tcp_route_client_stub.call_rpc_count
    end
  end

  def test_delete_tcp_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tcp_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tcp_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tcp_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tcp_route({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tcp_route name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tcp_route ::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tcp_route({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tcp_route(::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tcp_route_client_stub.call_rpc_count
    end
  end

  def test_list_tls_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListTlsRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_tls_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tls_routes, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tls_routes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tls_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tls_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tls_routes ::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tls_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tls_routes(::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tls_routes_client_stub.call_rpc_count
    end
  end

  def test_get_tls_route
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::TlsRoute.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tls_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tls_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tls_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tls_route({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tls_route name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tls_route ::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tls_route({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tls_route(::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tls_route_client_stub.call_rpc_count
    end
  end

  def test_create_tls_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tls_route_id = "hello world"
    tls_route = {}

    create_tls_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tls_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["tls_route_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::TlsRoute), request["tls_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tls_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tls_route({ parent: parent, tls_route_id: tls_route_id, tls_route: tls_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tls_route parent: parent, tls_route_id: tls_route_id, tls_route: tls_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tls_route ::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest.new(parent: parent, tls_route_id: tls_route_id, tls_route: tls_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tls_route({ parent: parent, tls_route_id: tls_route_id, tls_route: tls_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tls_route(::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest.new(parent: parent, tls_route_id: tls_route_id, tls_route: tls_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tls_route_client_stub.call_rpc_count
    end
  end

  def test_update_tls_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tls_route = {}

    update_tls_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tls_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::TlsRoute), request["tls_route"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tls_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tls_route({ update_mask: update_mask, tls_route: tls_route }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tls_route update_mask: update_mask, tls_route: tls_route do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tls_route ::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest.new(update_mask: update_mask, tls_route: tls_route) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tls_route({ update_mask: update_mask, tls_route: tls_route }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tls_route(::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest.new(update_mask: update_mask, tls_route: tls_route), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tls_route_client_stub.call_rpc_count
    end
  end

  def test_delete_tls_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tls_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tls_route, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tls_route_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tls_route({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tls_route name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tls_route ::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tls_route({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tls_route(::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tls_route_client_stub.call_rpc_count
    end
  end

  def test_list_service_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListServiceBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_service_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_bindings, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_bindings_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_bindings({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_bindings parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_bindings ::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_bindings({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_bindings(::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_bindings_client_stub.call_rpc_count
    end
  end

  def test_get_service_binding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ServiceBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_binding, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_binding_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_binding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_binding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_binding ::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_binding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_binding(::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_binding_client_stub.call_rpc_count
    end
  end

  def test_create_service_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_binding_id = "hello world"
    service_binding = {}

    create_service_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_service_binding, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["service_binding_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::ServiceBinding), request["service_binding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_service_binding_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_service_binding({ parent: parent, service_binding_id: service_binding_id, service_binding: service_binding }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_service_binding parent: parent, service_binding_id: service_binding_id, service_binding: service_binding do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_service_binding ::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest.new(parent: parent, service_binding_id: service_binding_id, service_binding: service_binding) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_service_binding({ parent: parent, service_binding_id: service_binding_id, service_binding: service_binding }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_service_binding(::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest.new(parent: parent, service_binding_id: service_binding_id, service_binding: service_binding), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_service_binding_client_stub.call_rpc_count
    end
  end

  def test_update_service_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_binding = {}

    update_service_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_service_binding, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::ServiceBinding), request["service_binding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_service_binding_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_service_binding({ update_mask: update_mask, service_binding: service_binding }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_service_binding update_mask: update_mask, service_binding: service_binding do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_service_binding ::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest.new(update_mask: update_mask, service_binding: service_binding) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_service_binding({ update_mask: update_mask, service_binding: service_binding }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_service_binding(::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest.new(update_mask: update_mask, service_binding: service_binding), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_service_binding_client_stub.call_rpc_count
    end
  end

  def test_delete_service_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_service_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_binding, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_binding_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_binding({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_binding name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_binding ::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_binding({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_binding(::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_binding_client_stub.call_rpc_count
    end
  end

  def test_list_meshes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListMeshesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_meshes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_meshes, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListMeshesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_meshes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_meshes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_meshes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_meshes ::Google::Cloud::NetworkServices::V1::ListMeshesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_meshes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_meshes(::Google::Cloud::NetworkServices::V1::ListMeshesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_meshes_client_stub.call_rpc_count
    end
  end

  def test_get_mesh
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::Mesh.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mesh_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_mesh, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetMeshRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_mesh_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_mesh({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_mesh name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_mesh ::Google::Cloud::NetworkServices::V1::GetMeshRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_mesh({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_mesh(::Google::Cloud::NetworkServices::V1::GetMeshRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_mesh_client_stub.call_rpc_count
    end
  end

  def test_create_mesh
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mesh_id = "hello world"
    mesh = {}

    create_mesh_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_mesh, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateMeshRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["mesh_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::Mesh), request["mesh"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_mesh_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_mesh({ parent: parent, mesh_id: mesh_id, mesh: mesh }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_mesh parent: parent, mesh_id: mesh_id, mesh: mesh do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_mesh ::Google::Cloud::NetworkServices::V1::CreateMeshRequest.new(parent: parent, mesh_id: mesh_id, mesh: mesh) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_mesh({ parent: parent, mesh_id: mesh_id, mesh: mesh }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_mesh(::Google::Cloud::NetworkServices::V1::CreateMeshRequest.new(parent: parent, mesh_id: mesh_id, mesh: mesh), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_mesh_client_stub.call_rpc_count
    end
  end

  def test_update_mesh
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    mesh = {}

    update_mesh_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_mesh, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateMeshRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::Mesh), request["mesh"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_mesh_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_mesh({ update_mask: update_mask, mesh: mesh }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_mesh update_mask: update_mask, mesh: mesh do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_mesh ::Google::Cloud::NetworkServices::V1::UpdateMeshRequest.new(update_mask: update_mask, mesh: mesh) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_mesh({ update_mask: update_mask, mesh: mesh }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_mesh(::Google::Cloud::NetworkServices::V1::UpdateMeshRequest.new(update_mask: update_mask, mesh: mesh), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_mesh_client_stub.call_rpc_count
    end
  end

  def test_delete_mesh
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_mesh_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_mesh, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteMeshRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_mesh_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_mesh({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_mesh name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_mesh ::Google::Cloud::NetworkServices::V1::DeleteMeshRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_mesh({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_mesh(::Google::Cloud::NetworkServices::V1::DeleteMeshRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_mesh_client_stub.call_rpc_count
    end
  end

  def test_list_service_lb_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_service_lb_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_lb_policies, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_lb_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_lb_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_lb_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_lb_policies ::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_lb_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_lb_policies(::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_lb_policies_client_stub.call_rpc_count
    end
  end

  def test_get_service_lb_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ServiceLbPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_lb_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_lb_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_lb_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_lb_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_lb_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_lb_policy ::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_lb_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_lb_policy(::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_lb_policy_client_stub.call_rpc_count
    end
  end

  def test_create_service_lb_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_lb_policy_id = "hello world"
    service_lb_policy = {}

    create_service_lb_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_service_lb_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["service_lb_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::ServiceLbPolicy), request["service_lb_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_service_lb_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_service_lb_policy({ parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_service_lb_policy parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_service_lb_policy ::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest.new(parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_service_lb_policy({ parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_service_lb_policy(::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest.new(parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_service_lb_policy_client_stub.call_rpc_count
    end
  end

  def test_update_service_lb_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_lb_policy = {}

    update_service_lb_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_service_lb_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkServices::V1::ServiceLbPolicy), request["service_lb_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_service_lb_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_service_lb_policy({ update_mask: update_mask, service_lb_policy: service_lb_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_service_lb_policy update_mask: update_mask, service_lb_policy: service_lb_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_service_lb_policy ::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest.new(update_mask: update_mask, service_lb_policy: service_lb_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_service_lb_policy({ update_mask: update_mask, service_lb_policy: service_lb_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_service_lb_policy(::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest.new(update_mask: update_mask, service_lb_policy: service_lb_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_service_lb_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_service_lb_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_service_lb_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_lb_policy, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_lb_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_lb_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_lb_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_lb_policy ::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_lb_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_lb_policy(::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_lb_policy_client_stub.call_rpc_count
    end
  end

  def test_get_gateway_route_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::GatewayRouteView.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gateway_route_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_gateway_route_view, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_gateway_route_view_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_gateway_route_view({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_gateway_route_view name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_gateway_route_view ::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_gateway_route_view({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_gateway_route_view(::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_gateway_route_view_client_stub.call_rpc_count
    end
  end

  def test_get_mesh_route_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::MeshRouteView.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mesh_route_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_mesh_route_view, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_mesh_route_view_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_mesh_route_view({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_mesh_route_view name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_mesh_route_view ::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_mesh_route_view({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_mesh_route_view(::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_mesh_route_view_client_stub.call_rpc_count
    end
  end

  def test_list_gateway_route_views
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_gateway_route_views_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_gateway_route_views, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_gateway_route_views_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_gateway_route_views({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_gateway_route_views parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_gateway_route_views ::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_gateway_route_views({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_gateway_route_views(::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_gateway_route_views_client_stub.call_rpc_count
    end
  end

  def test_list_mesh_route_views
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mesh_route_views_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_mesh_route_views, name
      assert_kind_of ::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_mesh_route_views_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_mesh_route_views({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_mesh_route_views parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_mesh_route_views ::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_mesh_route_views({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_mesh_route_views(::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_mesh_route_views_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkServices::V1::NetworkServices::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetworkServices::V1::NetworkServices::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetworkServices::V1::NetworkServices::Operations, client.operations_client
  end
end
