# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/networkservices/v1/network_services_pb"
require "google/cloud/network_services/v1/network_services/rest"


class ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_endpoint_policies
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_endpoint_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_endpoint_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_endpoint_policies_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_endpoint_policies({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_endpoint_policies parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_endpoint_policies ::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_endpoint_policies({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_endpoint_policies(::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_endpoint_policies_client_stub.call_count
      end
    end
  end

  def test_get_endpoint_policy
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::EndpointPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_endpoint_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_endpoint_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_endpoint_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_endpoint_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_endpoint_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_endpoint_policy ::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_endpoint_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_endpoint_policy(::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_endpoint_policy_client_stub.call_count
      end
    end
  end

  def test_create_endpoint_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    endpoint_policy_id = "hello world"
    endpoint_policy = {}

    create_endpoint_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_endpoint_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_endpoint_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_endpoint_policy({ parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_endpoint_policy parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_endpoint_policy ::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest.new(parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_endpoint_policy({ parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_endpoint_policy(::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest.new(parent: parent, endpoint_policy_id: endpoint_policy_id, endpoint_policy: endpoint_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_endpoint_policy_client_stub.call_count
      end
    end
  end

  def test_update_endpoint_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    endpoint_policy = {}

    update_endpoint_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_endpoint_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_endpoint_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_endpoint_policy({ update_mask: update_mask, endpoint_policy: endpoint_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_endpoint_policy update_mask: update_mask, endpoint_policy: endpoint_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_endpoint_policy ::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest.new(update_mask: update_mask, endpoint_policy: endpoint_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_endpoint_policy({ update_mask: update_mask, endpoint_policy: endpoint_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_endpoint_policy(::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest.new(update_mask: update_mask, endpoint_policy: endpoint_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_endpoint_policy_client_stub.call_count
      end
    end
  end

  def test_delete_endpoint_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_endpoint_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_endpoint_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_endpoint_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_endpoint_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_endpoint_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_endpoint_policy ::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_endpoint_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_endpoint_policy(::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_endpoint_policy_client_stub.call_count
      end
    end
  end

  def test_list_wasm_plugin_versions
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_wasm_plugin_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_wasm_plugin_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_wasm_plugin_versions_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_wasm_plugin_versions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_wasm_plugin_versions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_wasm_plugin_versions ::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_wasm_plugin_versions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_wasm_plugin_versions(::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_wasm_plugin_versions_client_stub.call_count
      end
    end
  end

  def test_get_wasm_plugin_version
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::WasmPluginVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_wasm_plugin_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_wasm_plugin_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_wasm_plugin_version_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_wasm_plugin_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_wasm_plugin_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_wasm_plugin_version ::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_wasm_plugin_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_wasm_plugin_version(::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_wasm_plugin_version_client_stub.call_count
      end
    end
  end

  def test_create_wasm_plugin_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    wasm_plugin_version_id = "hello world"
    wasm_plugin_version = {}

    create_wasm_plugin_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_wasm_plugin_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_wasm_plugin_version_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_wasm_plugin_version({ parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_wasm_plugin_version parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_wasm_plugin_version ::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest.new(parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_wasm_plugin_version({ parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_wasm_plugin_version(::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest.new(parent: parent, wasm_plugin_version_id: wasm_plugin_version_id, wasm_plugin_version: wasm_plugin_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_wasm_plugin_version_client_stub.call_count
      end
    end
  end

  def test_delete_wasm_plugin_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_wasm_plugin_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_wasm_plugin_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_wasm_plugin_version_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_wasm_plugin_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_wasm_plugin_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_wasm_plugin_version ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_wasm_plugin_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_wasm_plugin_version(::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_wasm_plugin_version_client_stub.call_count
      end
    end
  end

  def test_list_wasm_plugins
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListWasmPluginsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_wasm_plugins_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_wasm_plugins_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_wasm_plugins_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_wasm_plugins({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_wasm_plugins parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_wasm_plugins ::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_wasm_plugins({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_wasm_plugins(::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_wasm_plugins_client_stub.call_count
      end
    end
  end

  def test_get_wasm_plugin
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::WasmPlugin.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :WASM_PLUGIN_VIEW_UNSPECIFIED

    get_wasm_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_wasm_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_wasm_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_wasm_plugin({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_wasm_plugin name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_wasm_plugin ::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_wasm_plugin({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_wasm_plugin(::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_wasm_plugin_client_stub.call_count
      end
    end
  end

  def test_create_wasm_plugin
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    wasm_plugin_id = "hello world"
    wasm_plugin = {}

    create_wasm_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_wasm_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_wasm_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_wasm_plugin({ parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_wasm_plugin parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_wasm_plugin ::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest.new(parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_wasm_plugin({ parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_wasm_plugin(::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest.new(parent: parent, wasm_plugin_id: wasm_plugin_id, wasm_plugin: wasm_plugin), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_wasm_plugin_client_stub.call_count
      end
    end
  end

  def test_update_wasm_plugin
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    wasm_plugin = {}

    update_wasm_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_wasm_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_wasm_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_wasm_plugin({ update_mask: update_mask, wasm_plugin: wasm_plugin }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_wasm_plugin update_mask: update_mask, wasm_plugin: wasm_plugin do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_wasm_plugin ::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest.new(update_mask: update_mask, wasm_plugin: wasm_plugin) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_wasm_plugin({ update_mask: update_mask, wasm_plugin: wasm_plugin }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_wasm_plugin(::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest.new(update_mask: update_mask, wasm_plugin: wasm_plugin), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_wasm_plugin_client_stub.call_count
      end
    end
  end

  def test_delete_wasm_plugin
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_wasm_plugin_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_wasm_plugin_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_wasm_plugin_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_wasm_plugin({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_wasm_plugin name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_wasm_plugin ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_wasm_plugin({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_wasm_plugin(::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_wasm_plugin_client_stub.call_count
      end
    end
  end

  def test_list_gateways
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListGatewaysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_gateways_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_gateways_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_gateways_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_gateways({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_gateways parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_gateways ::Google::Cloud::NetworkServices::V1::ListGatewaysRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_gateways({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_gateways(::Google::Cloud::NetworkServices::V1::ListGatewaysRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_gateways_client_stub.call_count
      end
    end
  end

  def test_get_gateway
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::Gateway.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_gateway({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_gateway name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_gateway ::Google::Cloud::NetworkServices::V1::GetGatewayRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_gateway({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_gateway(::Google::Cloud::NetworkServices::V1::GetGatewayRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_gateway_client_stub.call_count
      end
    end
  end

  def test_create_gateway
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gateway_id = "hello world"
    gateway = {}

    create_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_gateway({ parent: parent, gateway_id: gateway_id, gateway: gateway }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_gateway parent: parent, gateway_id: gateway_id, gateway: gateway do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_gateway ::Google::Cloud::NetworkServices::V1::CreateGatewayRequest.new(parent: parent, gateway_id: gateway_id, gateway: gateway) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_gateway({ parent: parent, gateway_id: gateway_id, gateway: gateway }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_gateway(::Google::Cloud::NetworkServices::V1::CreateGatewayRequest.new(parent: parent, gateway_id: gateway_id, gateway: gateway), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_gateway_client_stub.call_count
      end
    end
  end

  def test_update_gateway
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    gateway = {}

    update_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_gateway({ update_mask: update_mask, gateway: gateway }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_gateway update_mask: update_mask, gateway: gateway do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_gateway ::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest.new(update_mask: update_mask, gateway: gateway) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_gateway({ update_mask: update_mask, gateway: gateway }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_gateway(::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest.new(update_mask: update_mask, gateway: gateway), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_gateway_client_stub.call_count
      end
    end
  end

  def test_delete_gateway
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_gateway_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_gateway_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_gateway_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_gateway({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_gateway name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_gateway ::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_gateway({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_gateway(::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_gateway_client_stub.call_count
      end
    end
  end

  def test_list_grpc_routes
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListGrpcRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_grpc_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_grpc_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_grpc_routes_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_grpc_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_grpc_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_grpc_routes ::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_grpc_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_grpc_routes(::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_grpc_routes_client_stub.call_count
      end
    end
  end

  def test_get_grpc_route
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::GrpcRoute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_grpc_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_grpc_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_grpc_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_grpc_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_grpc_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_grpc_route ::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_grpc_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_grpc_route(::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_grpc_route_client_stub.call_count
      end
    end
  end

  def test_create_grpc_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    grpc_route_id = "hello world"
    grpc_route = {}

    create_grpc_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_grpc_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_grpc_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_grpc_route({ parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_grpc_route parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_grpc_route ::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest.new(parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_grpc_route({ parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_grpc_route(::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest.new(parent: parent, grpc_route_id: grpc_route_id, grpc_route: grpc_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_grpc_route_client_stub.call_count
      end
    end
  end

  def test_update_grpc_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    grpc_route = {}

    update_grpc_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_grpc_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_grpc_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_grpc_route({ update_mask: update_mask, grpc_route: grpc_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_grpc_route update_mask: update_mask, grpc_route: grpc_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_grpc_route ::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest.new(update_mask: update_mask, grpc_route: grpc_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_grpc_route({ update_mask: update_mask, grpc_route: grpc_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_grpc_route(::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest.new(update_mask: update_mask, grpc_route: grpc_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_grpc_route_client_stub.call_count
      end
    end
  end

  def test_delete_grpc_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_grpc_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_grpc_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_grpc_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_grpc_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_grpc_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_grpc_route ::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_grpc_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_grpc_route(::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_grpc_route_client_stub.call_count
      end
    end
  end

  def test_list_http_routes
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListHttpRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_http_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_http_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_http_routes_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_http_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_http_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_http_routes ::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_http_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_http_routes(::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_http_routes_client_stub.call_count
      end
    end
  end

  def test_get_http_route
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::HttpRoute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_http_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_http_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_http_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_http_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_http_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_http_route ::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_http_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_http_route(::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_http_route_client_stub.call_count
      end
    end
  end

  def test_create_http_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    http_route_id = "hello world"
    http_route = {}

    create_http_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_http_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_http_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_http_route({ parent: parent, http_route_id: http_route_id, http_route: http_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_http_route parent: parent, http_route_id: http_route_id, http_route: http_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_http_route ::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest.new(parent: parent, http_route_id: http_route_id, http_route: http_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_http_route({ parent: parent, http_route_id: http_route_id, http_route: http_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_http_route(::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest.new(parent: parent, http_route_id: http_route_id, http_route: http_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_http_route_client_stub.call_count
      end
    end
  end

  def test_update_http_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    http_route = {}

    update_http_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_http_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_http_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_http_route({ update_mask: update_mask, http_route: http_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_http_route update_mask: update_mask, http_route: http_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_http_route ::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest.new(update_mask: update_mask, http_route: http_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_http_route({ update_mask: update_mask, http_route: http_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_http_route(::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest.new(update_mask: update_mask, http_route: http_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_http_route_client_stub.call_count
      end
    end
  end

  def test_delete_http_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_http_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_http_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_http_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_http_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_http_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_http_route ::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_http_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_http_route(::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_http_route_client_stub.call_count
      end
    end
  end

  def test_list_tcp_routes
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListTcpRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_tcp_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_tcp_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tcp_routes_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tcp_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tcp_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tcp_routes ::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tcp_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tcp_routes(::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tcp_routes_client_stub.call_count
      end
    end
  end

  def test_get_tcp_route
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::TcpRoute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tcp_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_tcp_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tcp_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tcp_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tcp_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tcp_route ::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tcp_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tcp_route(::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tcp_route_client_stub.call_count
      end
    end
  end

  def test_create_tcp_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tcp_route_id = "hello world"
    tcp_route = {}

    create_tcp_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_tcp_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tcp_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tcp_route({ parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tcp_route parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tcp_route ::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest.new(parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tcp_route({ parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tcp_route(::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest.new(parent: parent, tcp_route_id: tcp_route_id, tcp_route: tcp_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tcp_route_client_stub.call_count
      end
    end
  end

  def test_update_tcp_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tcp_route = {}

    update_tcp_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_tcp_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tcp_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tcp_route({ update_mask: update_mask, tcp_route: tcp_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tcp_route update_mask: update_mask, tcp_route: tcp_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tcp_route ::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest.new(update_mask: update_mask, tcp_route: tcp_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tcp_route({ update_mask: update_mask, tcp_route: tcp_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tcp_route(::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest.new(update_mask: update_mask, tcp_route: tcp_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tcp_route_client_stub.call_count
      end
    end
  end

  def test_delete_tcp_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tcp_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_tcp_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tcp_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tcp_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tcp_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tcp_route ::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tcp_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tcp_route(::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tcp_route_client_stub.call_count
      end
    end
  end

  def test_list_tls_routes
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListTlsRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_tls_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_tls_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tls_routes_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tls_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tls_routes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tls_routes ::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tls_routes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tls_routes(::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tls_routes_client_stub.call_count
      end
    end
  end

  def test_get_tls_route
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::TlsRoute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tls_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_tls_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tls_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tls_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tls_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tls_route ::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tls_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tls_route(::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tls_route_client_stub.call_count
      end
    end
  end

  def test_create_tls_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tls_route_id = "hello world"
    tls_route = {}

    create_tls_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_tls_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tls_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tls_route({ parent: parent, tls_route_id: tls_route_id, tls_route: tls_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tls_route parent: parent, tls_route_id: tls_route_id, tls_route: tls_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tls_route ::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest.new(parent: parent, tls_route_id: tls_route_id, tls_route: tls_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tls_route({ parent: parent, tls_route_id: tls_route_id, tls_route: tls_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tls_route(::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest.new(parent: parent, tls_route_id: tls_route_id, tls_route: tls_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tls_route_client_stub.call_count
      end
    end
  end

  def test_update_tls_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    tls_route = {}

    update_tls_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_tls_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tls_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tls_route({ update_mask: update_mask, tls_route: tls_route }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tls_route update_mask: update_mask, tls_route: tls_route do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tls_route ::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest.new(update_mask: update_mask, tls_route: tls_route) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tls_route({ update_mask: update_mask, tls_route: tls_route }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tls_route(::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest.new(update_mask: update_mask, tls_route: tls_route), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tls_route_client_stub.call_count
      end
    end
  end

  def test_delete_tls_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tls_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_tls_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tls_route_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tls_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tls_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tls_route ::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tls_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tls_route(::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tls_route_client_stub.call_count
      end
    end
  end

  def test_list_service_bindings
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListServiceBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_service_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_service_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_service_bindings_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_service_bindings({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_service_bindings parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_service_bindings ::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_service_bindings({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_service_bindings(::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_service_bindings_client_stub.call_count
      end
    end
  end

  def test_get_service_binding
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ServiceBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_service_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_service_binding_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_service_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_service_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_service_binding ::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_service_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_service_binding(::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_service_binding_client_stub.call_count
      end
    end
  end

  def test_create_service_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_binding_id = "hello world"
    service_binding = {}

    create_service_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_service_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_service_binding_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_service_binding({ parent: parent, service_binding_id: service_binding_id, service_binding: service_binding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_service_binding parent: parent, service_binding_id: service_binding_id, service_binding: service_binding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_service_binding ::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest.new(parent: parent, service_binding_id: service_binding_id, service_binding: service_binding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_service_binding({ parent: parent, service_binding_id: service_binding_id, service_binding: service_binding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_service_binding(::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest.new(parent: parent, service_binding_id: service_binding_id, service_binding: service_binding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_service_binding_client_stub.call_count
      end
    end
  end

  def test_update_service_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_binding = {}

    update_service_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_service_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_service_binding_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_service_binding({ update_mask: update_mask, service_binding: service_binding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_service_binding update_mask: update_mask, service_binding: service_binding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_service_binding ::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest.new(update_mask: update_mask, service_binding: service_binding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_service_binding({ update_mask: update_mask, service_binding: service_binding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_service_binding(::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest.new(update_mask: update_mask, service_binding: service_binding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_service_binding_client_stub.call_count
      end
    end
  end

  def test_delete_service_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_service_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_service_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_service_binding_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_service_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_service_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_service_binding ::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_service_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_service_binding(::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_service_binding_client_stub.call_count
      end
    end
  end

  def test_list_meshes
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListMeshesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    return_partial_success = true

    list_meshes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_meshes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_meshes_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_meshes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_meshes parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_meshes ::Google::Cloud::NetworkServices::V1::ListMeshesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_meshes({ parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_meshes(::Google::Cloud::NetworkServices::V1::ListMeshesRequest.new(parent: parent, page_size: page_size, page_token: page_token, return_partial_success: return_partial_success), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_meshes_client_stub.call_count
      end
    end
  end

  def test_get_mesh
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::Mesh.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mesh_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_mesh_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_mesh_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_mesh({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_mesh name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_mesh ::Google::Cloud::NetworkServices::V1::GetMeshRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_mesh({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_mesh(::Google::Cloud::NetworkServices::V1::GetMeshRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_mesh_client_stub.call_count
      end
    end
  end

  def test_create_mesh
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mesh_id = "hello world"
    mesh = {}

    create_mesh_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_mesh_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_mesh_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_mesh({ parent: parent, mesh_id: mesh_id, mesh: mesh }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_mesh parent: parent, mesh_id: mesh_id, mesh: mesh do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_mesh ::Google::Cloud::NetworkServices::V1::CreateMeshRequest.new(parent: parent, mesh_id: mesh_id, mesh: mesh) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_mesh({ parent: parent, mesh_id: mesh_id, mesh: mesh }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_mesh(::Google::Cloud::NetworkServices::V1::CreateMeshRequest.new(parent: parent, mesh_id: mesh_id, mesh: mesh), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_mesh_client_stub.call_count
      end
    end
  end

  def test_update_mesh
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    mesh = {}

    update_mesh_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_mesh_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_mesh_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_mesh({ update_mask: update_mask, mesh: mesh }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_mesh update_mask: update_mask, mesh: mesh do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_mesh ::Google::Cloud::NetworkServices::V1::UpdateMeshRequest.new(update_mask: update_mask, mesh: mesh) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_mesh({ update_mask: update_mask, mesh: mesh }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_mesh(::Google::Cloud::NetworkServices::V1::UpdateMeshRequest.new(update_mask: update_mask, mesh: mesh), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_mesh_client_stub.call_count
      end
    end
  end

  def test_delete_mesh
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_mesh_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_mesh_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_mesh_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_mesh({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_mesh name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_mesh ::Google::Cloud::NetworkServices::V1::DeleteMeshRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_mesh({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_mesh(::Google::Cloud::NetworkServices::V1::DeleteMeshRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_mesh_client_stub.call_count
      end
    end
  end

  def test_list_service_lb_policies
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_service_lb_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_service_lb_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_service_lb_policies_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_service_lb_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_service_lb_policies parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_service_lb_policies ::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_service_lb_policies({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_service_lb_policies(::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_service_lb_policies_client_stub.call_count
      end
    end
  end

  def test_get_service_lb_policy
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ServiceLbPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_lb_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_service_lb_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_service_lb_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_service_lb_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_service_lb_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_service_lb_policy ::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_service_lb_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_service_lb_policy(::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_service_lb_policy_client_stub.call_count
      end
    end
  end

  def test_create_service_lb_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_lb_policy_id = "hello world"
    service_lb_policy = {}

    create_service_lb_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_create_service_lb_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_service_lb_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_service_lb_policy({ parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_service_lb_policy parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_service_lb_policy ::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest.new(parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_service_lb_policy({ parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_service_lb_policy(::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest.new(parent: parent, service_lb_policy_id: service_lb_policy_id, service_lb_policy: service_lb_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_service_lb_policy_client_stub.call_count
      end
    end
  end

  def test_update_service_lb_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_lb_policy = {}

    update_service_lb_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_update_service_lb_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_service_lb_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_service_lb_policy({ update_mask: update_mask, service_lb_policy: service_lb_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_service_lb_policy update_mask: update_mask, service_lb_policy: service_lb_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_service_lb_policy ::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest.new(update_mask: update_mask, service_lb_policy: service_lb_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_service_lb_policy({ update_mask: update_mask, service_lb_policy: service_lb_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_service_lb_policy(::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest.new(update_mask: update_mask, service_lb_policy: service_lb_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_service_lb_policy_client_stub.call_count
      end
    end
  end

  def test_delete_service_lb_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_service_lb_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_delete_service_lb_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_service_lb_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_service_lb_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_service_lb_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_service_lb_policy ::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_service_lb_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_service_lb_policy(::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_service_lb_policy_client_stub.call_count
      end
    end
  end

  def test_get_gateway_route_view
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::GatewayRouteView.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gateway_route_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_gateway_route_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_gateway_route_view_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_gateway_route_view({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_gateway_route_view name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_gateway_route_view ::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_gateway_route_view({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_gateway_route_view(::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_gateway_route_view_client_stub.call_count
      end
    end
  end

  def test_get_mesh_route_view
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::MeshRouteView.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mesh_route_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_get_mesh_route_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_mesh_route_view_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_mesh_route_view({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_mesh_route_view name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_mesh_route_view ::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_mesh_route_view({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_mesh_route_view(::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_mesh_route_view_client_stub.call_count
      end
    end
  end

  def test_list_gateway_route_views
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_gateway_route_views_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_gateway_route_views_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_gateway_route_views_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_gateway_route_views({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_gateway_route_views parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_gateway_route_views ::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_gateway_route_views({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_gateway_route_views(::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_gateway_route_views_client_stub.call_count
      end
    end
  end

  def test_list_mesh_route_views
    # Create test objects.
    client_result = ::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mesh_route_views_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::ServiceStub.stub :transcode_list_mesh_route_views_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_mesh_route_views_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_mesh_route_views({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_mesh_route_views parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_mesh_route_views ::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_mesh_route_views({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_mesh_route_views(::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_mesh_route_views_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkServices::V1::NetworkServices::Rest::Client::Configuration, config
  end
end
