# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/network_services/v1/network_services"

class ::Google::Cloud::NetworkServices::V1::NetworkServices::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_address_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.address_path project: "value0", region: "value1", address: "value2"
      assert_equal "projects/value0/regions/value1/addresses/value2", path
    end
  end

  def test_authorization_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.authorization_policy_path project: "value0", location: "value1", authorization_policy: "value2"
      assert_equal "projects/value0/locations/value1/authorizationPolicies/value2", path
    end
  end

  def test_backend_service_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.backend_service_path project: "value0", location: "value1", backend_service: "value2"
      assert_equal "projects/value0/locations/value1/backendServices/value2", path
    end
  end

  def test_certificate_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.certificate_path project: "value0", location: "value1", certificate: "value2"
      assert_equal "projects/value0/locations/value1/certificates/value2", path
    end
  end

  def test_client_tls_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.client_tls_policy_path project: "value0", location: "value1", client_tls_policy: "value2"
      assert_equal "projects/value0/locations/value1/clientTlsPolicies/value2", path
    end
  end

  def test_endpoint_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.endpoint_policy_path project: "value0", location: "value1", endpoint_policy: "value2"
      assert_equal "projects/value0/locations/value1/endpointPolicies/value2", path
    end
  end

  def test_gateway_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.gateway_path project: "value0", location: "value1", gateway: "value2"
      assert_equal "projects/value0/locations/value1/gateways/value2", path
    end
  end

  def test_gateway_route_view_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.gateway_route_view_path project: "value0", location: "value1", gateway: "value2", route_view: "value3"
      assert_equal "projects/value0/locations/value1/gateways/value2/routeViews/value3", path
    end
  end

  def test_gateway_security_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.gateway_security_policy_path project: "value0", location: "value1", gateway_security_policy: "value2"
      assert_equal "projects/value0/locations/value1/gatewaySecurityPolicies/value2", path
    end
  end

  def test_grpc_route_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.grpc_route_path project: "value0", location: "value1", grpc_route: "value2"
      assert_equal "projects/value0/locations/value1/grpcRoutes/value2", path
    end
  end

  def test_http_route_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.http_route_path project: "value0", location: "value1", http_route: "value2"
      assert_equal "projects/value0/locations/value1/httpRoutes/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_mesh_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.mesh_path project: "value0", location: "value1", mesh: "value2"
      assert_equal "projects/value0/locations/value1/meshes/value2", path
    end
  end

  def test_mesh_route_view_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.mesh_route_view_path project: "value0", location: "value1", mesh: "value2", route_view: "value3"
      assert_equal "projects/value0/locations/value1/meshes/value2/routeViews/value3", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_server_tls_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.server_tls_policy_path project: "value0", location: "value1", server_tls_policy: "value2"
      assert_equal "projects/value0/locations/value1/serverTlsPolicies/value2", path
    end
  end

  def test_service_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_path project: "value0", location: "value1", namespace: "value2", service: "value3"
      assert_equal "projects/value0/locations/value1/namespaces/value2/services/value3", path
    end
  end

  def test_service_binding_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_binding_path project: "value0", location: "value1", service_binding: "value2"
      assert_equal "projects/value0/locations/value1/serviceBindings/value2", path
    end
  end

  def test_service_lb_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_lb_policy_path project: "value0", location: "value1", service_lb_policy: "value2"
      assert_equal "projects/value0/locations/value1/serviceLbPolicies/value2", path
    end
  end

  def test_subnetwork_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.subnetwork_path project: "value0", region: "value1", subnetwork: "value2"
      assert_equal "projects/value0/regions/value1/subnetworks/value2", path
    end
  end

  def test_tcp_route_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.tcp_route_path project: "value0", location: "value1", tcp_route: "value2"
      assert_equal "projects/value0/locations/value1/tcpRoutes/value2", path
    end
  end

  def test_tls_route_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.tls_route_path project: "value0", location: "value1", tls_route: "value2"
      assert_equal "projects/value0/locations/value1/tlsRoutes/value2", path
    end
  end

  def test_wasm_plugin_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.wasm_plugin_path project: "value0", location: "value1", wasm_plugin: "value2"
      assert_equal "projects/value0/locations/value1/wasmPlugins/value2", path
    end
  end

  def test_wasm_plugin_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.wasm_plugin_version_path project: "value0", location: "value1", wasm_plugin: "value2", wasm_plugin_version: "value3"
      assert_equal "projects/value0/locations/value1/wasmPlugins/value2/versions/value3", path
    end
  end
end
