# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # TlsRoute defines how traffic should be routed based on SNI and other matching
        # L3 attributes.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the TlsRoute resource. It matches pattern
        #     `projects/*/locations/global/tlsRoutes/tls_route_name>`.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL of this resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::TlsRoute::RouteRule>]
        #     Required. Rules that define how traffic is routed and handled. At least one
        #     RouteRule must be supplied. If there are multiple rules then the action
        #     taken will be the first rule to match.
        # @!attribute [rw] meshes
        #   @return [::Array<::String>]
        #     Optional. Meshes defines a list of meshes this TlsRoute is attached to, as
        #     one of the routing rules to route the requests served by the mesh.
        #
        #     Each mesh reference should match the pattern:
        #     `projects/*/locations/global/meshes/<mesh_name>`
        #
        #     The attached Mesh should be of a type SIDECAR
        # @!attribute [rw] gateways
        #   @return [::Array<::String>]
        #     Optional. Gateways defines a list of gateways this TlsRoute is attached to,
        #     as one of the routing rules to route the requests served by the gateway.
        #
        #     Each gateway reference should match the pattern:
        #     `projects/*/locations/global/gateways/<gateway_name>`
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the TlsRoute resource.
        class TlsRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how to match traffic and how to route traffic when traffic is
          # matched.
          # @!attribute [rw] matches
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::TlsRoute::RouteMatch>]
          #     Required. RouteMatch defines the predicate used to match requests to a
          #     given action. Multiple match types are "OR"ed for evaluation. Atleast one
          #     RouteMatch must be supplied.
          # @!attribute [rw] action
          #   @return [::Google::Cloud::NetworkServices::V1::TlsRoute::RouteAction]
          #     Required. The detailed rule defining how to route matched traffic.
          class RouteRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # RouteMatch defines the predicate used to match requests to a given action.
          # Multiple match types are "AND"ed for evaluation.
          # @!attribute [rw] sni_host
          #   @return [::Array<::String>]
          #     Optional. SNI (server name indicator) to match against.
          #     SNI will be matched against all wildcard domains, i.e. `www.example.com`
          #     will be first matched against `www.example.com`, then `*.example.com`,
          #     then `*.com.`
          #     Partial wildcards are not supported, and values like *w.example.com are
          #     invalid.
          #     At least one of sni_host and alpn is required.
          #     Up to 100 sni hosts across all matches can be set.
          # @!attribute [rw] alpn
          #   @return [::Array<::String>]
          #     Optional. ALPN (Application-Layer Protocol Negotiation) to match against.
          #     Examples: "http/1.1", "h2".
          #     At least one of sni_host and alpn is required.
          #     Up to 5 alpns across all matches can be set.
          class RouteMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specifications for routing traffic and applying associated policies.
          # @!attribute [rw] destinations
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::TlsRoute::RouteDestination>]
          #     Required. The destination services to which traffic should be forwarded.
          #     At least one destination service is required.
          # @!attribute [rw] idle_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Specifies the idle timeout for the selected route. The idle
          #     timeout is defined as the period in which there are no bytes sent or
          #     received on either the upstream or downstream connection. If not set, the
          #     default idle timeout is 1 hour. If set to 0s, the timeout will be
          #     disabled.
          class RouteAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describe the destination for traffic to be routed to.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     Required. The URL of a BackendService to route traffic to.
          # @!attribute [rw] weight
          #   @return [::Integer]
          #     Optional. Specifies the proportion of requests forwarded to the backend
          #     referenced by the service_name field. This is computed as:
          #     - weight/Sum(weights in destinations)
          #     Weights in all destinations does not need to sum up to 100.
          class RouteDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request used with the ListTlsRoutes method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the TlsRoutes should be
        #     listed, specified in the format `projects/*/locations/global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of TlsRoutes to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListTlsRoutesResponse`
        #     Indicates that this is a continuation of a prior `ListTlsRoutes` call,
        #     and that the system should return the next page of data.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If true, allow partial responses for multi-regional Aggregated
        #     List requests. Otherwise if one of the locations is down or unreachable,
        #     the Aggregated List request will fail.
        class ListTlsRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListTlsRoutes method.
        # @!attribute [rw] tls_routes
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::TlsRoute>]
        #     List of TlsRoute resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request opts into
        #     {::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest#return_partial_success return_partial_success}
        #     and reading across collections e.g. when attempting to list all resources
        #     across all supported locations.
        class ListTlsRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetTlsRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the TlsRoute to get. Must be in the format
        #     `projects/*/locations/global/tlsRoutes/*`.
        class GetTlsRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the TlsRoute method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the TlsRoute. Must be in the
        #     format `projects/*/locations/global`.
        # @!attribute [rw] tls_route_id
        #   @return [::String]
        #     Required. Short name of the TlsRoute resource to be created.
        # @!attribute [rw] tls_route
        #   @return [::Google::Cloud::NetworkServices::V1::TlsRoute]
        #     Required. TlsRoute resource to be created.
        class CreateTlsRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the UpdateTlsRoute method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     TlsRoute resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] tls_route
        #   @return [::Google::Cloud::NetworkServices::V1::TlsRoute]
        #     Required. Updated TlsRoute resource.
        class UpdateTlsRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteTlsRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the TlsRoute to delete. Must be in the format
        #     `projects/*/locations/global/tlsRoutes/*`.
        class DeleteTlsRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
