# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # TcpRoute is the resource defining how TCP traffic should be routed by a
        # Mesh/Gateway resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the TcpRoute resource. It matches pattern
        #     `projects/*/locations/global/tcpRoutes/tcp_route_name>`.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL of this resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::TcpRoute::RouteRule>]
        #     Required. Rules that define how traffic is routed and handled. At least one
        #     RouteRule must be supplied. If there are multiple rules then the action
        #     taken will be the first rule to match.
        # @!attribute [rw] meshes
        #   @return [::Array<::String>]
        #     Optional. Meshes defines a list of meshes this TcpRoute is attached to, as
        #     one of the routing rules to route the requests served by the mesh.
        #
        #     Each mesh reference should match the pattern:
        #     `projects/*/locations/global/meshes/<mesh_name>`
        #
        #     The attached Mesh should be of a type SIDECAR
        # @!attribute [rw] gateways
        #   @return [::Array<::String>]
        #     Optional. Gateways defines a list of gateways this TcpRoute is attached to,
        #     as one of the routing rules to route the requests served by the gateway.
        #
        #     Each gateway reference should match the pattern:
        #     `projects/*/locations/global/gateways/<gateway_name>`
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the TcpRoute resource.
        class TcpRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how to match traffic and how to route traffic when traffic is
          # matched.
          # @!attribute [rw] matches
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::TcpRoute::RouteMatch>]
          #     Optional. RouteMatch defines the predicate used to match requests to a
          #     given action. Multiple match types are "OR"ed for evaluation. If no
          #     routeMatch field is specified, this rule will unconditionally match
          #     traffic.
          # @!attribute [rw] action
          #   @return [::Google::Cloud::NetworkServices::V1::TcpRoute::RouteAction]
          #     Required. The detailed rule defining how to route matched traffic.
          class RouteRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # RouteMatch defines the predicate used to match requests to a given action.
          # Multiple match types are "OR"ed for evaluation.
          # If no routeMatch field is specified, this rule will unconditionally match
          # traffic.
          # @!attribute [rw] address
          #   @return [::String]
          #     Required. Must be specified in the CIDR range format. A CIDR range
          #     consists of an IP Address and a prefix length to construct the subnet
          #     mask. By default, the prefix length is 32 (i.e. matches a single IP
          #     address). Only IPV4 addresses are supported. Examples: "10.0.0.1" -
          #     matches against this exact IP address. "10.0.0.0/8" - matches against any
          #     IP address within the 10.0.0.0 subnet and 255.255.255.0 mask. "0.0.0.0/0"
          #     - matches against any IP address'.
          # @!attribute [rw] port
          #   @return [::String]
          #     Required. Specifies the destination port to match against.
          class RouteMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specifications for routing traffic and applying associated policies.
          # @!attribute [rw] destinations
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::TcpRoute::RouteDestination>]
          #     Optional. The destination services to which traffic should be forwarded.
          #     At least one destination service is required. Only one of route
          #     destination or original destination can be set.
          # @!attribute [rw] original_destination
          #   @return [::Boolean]
          #     Optional. If true, Router will use the destination IP and port of the
          #     original connection as the destination of the request. Default is false.
          #     Only one of route destinations or original destination can be set.
          # @!attribute [rw] idle_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Specifies the idle timeout for the selected route. The idle
          #     timeout is defined as the period in which there are no bytes sent or
          #     received on either the upstream or downstream connection. If not set, the
          #     default idle timeout is 30 seconds. If set to 0s, the timeout will be
          #     disabled.
          class RouteAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describe the destination for traffic to be routed to.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     Required. The URL of a BackendService to route traffic to.
          # @!attribute [rw] weight
          #   @return [::Integer]
          #     Optional. Specifies the proportion of requests forwarded to the backend
          #     referenced by the serviceName field. This is computed as:
          #     - weight/Sum(weights in this destination list).
          #     For non-zero values, there may be some epsilon from the exact proportion
          #     defined here depending on the precision an implementation supports.
          #
          #     If only one serviceName is specified and it has a weight greater than 0,
          #     100% of the traffic is forwarded to that backend.
          #
          #     If weights are specified for any one service name, they need to be
          #     specified for all of them.
          #
          #     If weights are unspecified for all services, then, traffic is distributed
          #     in equal proportions to all of them.
          class RouteDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request used with the ListTcpRoutes method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the TcpRoutes should be
        #     listed, specified in the format `projects/*/locations/global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of TcpRoutes to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListTcpRoutesResponse`
        #     Indicates that this is a continuation of a prior `ListTcpRoutes` call,
        #     and that the system should return the next page of data.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If true, allow partial responses for multi-regional Aggregated
        #     List requests. Otherwise if one of the locations is down or unreachable,
        #     the Aggregated List request will fail.
        class ListTcpRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListTcpRoutes method.
        # @!attribute [rw] tcp_routes
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::TcpRoute>]
        #     List of TcpRoute resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request opts into
        #     {::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest#return_partial_success return_partial_success}
        #     and reading across collections e.g. when attempting to list all resources
        #     across all supported locations.
        class ListTcpRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetTcpRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the TcpRoute to get. Must be in the format
        #     `projects/*/locations/global/tcpRoutes/*`.
        class GetTcpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the TcpRoute method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the TcpRoute. Must be in the
        #     format `projects/*/locations/global`.
        # @!attribute [rw] tcp_route_id
        #   @return [::String]
        #     Required. Short name of the TcpRoute resource to be created.
        # @!attribute [rw] tcp_route
        #   @return [::Google::Cloud::NetworkServices::V1::TcpRoute]
        #     Required. TcpRoute resource to be created.
        class CreateTcpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the UpdateTcpRoute method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     TcpRoute resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] tcp_route
        #   @return [::Google::Cloud::NetworkServices::V1::TcpRoute]
        #     Required. Updated TcpRoute resource.
        class UpdateTcpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteTcpRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the TcpRoute to delete. Must be in the format
        #     `projects/*/locations/global/tcpRoutes/*`.
        class DeleteTcpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
