# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # ServiceLbPolicy holds global load balancing and traffic distribution
        # configuration that can be applied to a BackendService.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the ServiceLbPolicy resource. It matches pattern
        #     `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when this resource was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the ServiceLbPolicy resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [rw] load_balancing_algorithm
        #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy::LoadBalancingAlgorithm]
        #     Optional. The type of load balancing algorithm to be used. The default
        #     behavior is WATERFALL_BY_REGION.
        # @!attribute [rw] auto_capacity_drain
        #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy::AutoCapacityDrain]
        #     Optional. Configuration to automatically move traffic away for unhealthy
        #     IG/NEG for the associated Backend Service.
        # @!attribute [rw] failover_config
        #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy::FailoverConfig]
        #     Optional. Configuration related to health based failover.
        # @!attribute [rw] isolation_config
        #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy::IsolationConfig]
        #     Optional. Configuration to provide isolation support for the associated
        #     Backend Service.
        class ServiceLbPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Option to specify if an unhealthy IG/NEG should be considered for global
          # load balancing and traffic routing.
          # @!attribute [rw] enable
          #   @return [::Boolean]
          #     Optional. If set to 'True', an unhealthy IG/NEG will be set as drained.
          #     - An IG/NEG is considered unhealthy if less than 25% of the
          #     instances/endpoints in the IG/NEG are healthy.
          #     - This option will never result in draining more than 50% of the
          #     configured IGs/NEGs for the Backend Service.
          class AutoCapacityDrain
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Option to specify health based failover behavior.
          # This is not related to Network load balancer FailoverPolicy.
          # @!attribute [rw] failover_health_threshold
          #   @return [::Integer]
          #     Optional. The percentage threshold that a load balancer will begin to
          #     send traffic to failover backends. If the percentage of endpoints in a
          #     MIG/NEG is smaller than this value, traffic would be sent to failover
          #     backends if possible. This field should be set to a value between 1
          #     and 99. The default value is 50 for Global external HTTP(S) load balancer
          #     (classic) and Proxyless service mesh, and 70 for others.
          class FailoverConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration to provide isolation support for the associated Backend
          # Service.
          # @!attribute [rw] isolation_granularity
          #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy::IsolationGranularity]
          #     Optional. The isolation granularity of the load balancer.
          # @!attribute [rw] isolation_mode
          #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy::IsolationMode]
          #     Optional. The isolation mode of the load balancer.
          class IsolationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The global load balancing algorithm to be used.
          module LoadBalancingAlgorithm
            # The type of the loadbalancing algorithm is unspecified.
            LOAD_BALANCING_ALGORITHM_UNSPECIFIED = 0

            # Balance traffic across all backends across the world proportionally based
            # on capacity.
            SPRAY_TO_WORLD = 3

            # Direct traffic to the nearest region with endpoints and capacity before
            # spilling over to other regions and spread the traffic from each client to
            # all the MIGs/NEGs in a region.
            SPRAY_TO_REGION = 4

            # Direct traffic to the nearest region with endpoints and capacity before
            # spilling over to other regions. All MIGs/NEGs within a region are evenly
            # loaded but each client might not spread the traffic to all the MIGs/NEGs
            # in the region.
            WATERFALL_BY_REGION = 5

            # Attempt to keep traffic in a single zone closest to the client, before
            # spilling over to other zones.
            WATERFALL_BY_ZONE = 6
          end

          # The granularity of this isolation restriction.
          module IsolationGranularity
            # No isolation is configured for the backend service. Traffic can overflow
            # based on the load balancing algorithm.
            ISOLATION_GRANULARITY_UNSPECIFIED = 0

            # Traffic for this service will be isolated at the cloud region level.
            REGION = 1
          end

          # The mode of this isolation restriction, defining whether clients in a given
          # region are allowed to reach out to another region.
          module IsolationMode
            # No isolation mode is configured for the backend service.
            ISOLATION_MODE_UNSPECIFIED = 0

            # Traffic will be sent to the nearest region.
            NEAREST = 1

            # Traffic will fail if no serving backends are available in the same region
            # as the load balancer.
            STRICT = 2
          end
        end

        # Request used with the ListServiceLbPolicies method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the ServiceLbPolicies should
        #     be listed, specified in the format
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of ServiceLbPolicies to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListServiceLbPoliciesResponse`
        #     Indicates that this is a continuation of a prior `ListRouters` call,
        #     and that the system should return the next page of data.
        class ListServiceLbPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListServiceLbPolicies method.
        # @!attribute [rw] service_lb_policies
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::ServiceLbPolicy>]
        #     List of ServiceLbPolicy resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request attempts to list all
        #     resources across all supported locations, while some locations are
        #     temporarily unavailable.
        class ListServiceLbPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetServiceLbPolicy method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the ServiceLbPolicy to get. Must be in the format
        #     `projects/{project}/locations/{location}/serviceLbPolicies/*`.
        class GetServiceLbPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the ServiceLbPolicy method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the ServiceLbPolicy. Must be in the
        #     format `projects/{project}/locations/{location}`.
        # @!attribute [rw] service_lb_policy_id
        #   @return [::String]
        #     Required. Short name of the ServiceLbPolicy resource to be created.
        #     E.g. for resource name
        #     `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
        #     the id is value of \\{service_lb_policy_name}
        # @!attribute [rw] service_lb_policy
        #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy]
        #     Required. ServiceLbPolicy resource to be created.
        class CreateServiceLbPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the UpdateServiceLbPolicy method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     ServiceLbPolicy resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] service_lb_policy
        #   @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy]
        #     Required. Updated ServiceLbPolicy resource.
        class UpdateServiceLbPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteServiceLbPolicy method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the ServiceLbPolicy to delete. Must be in the format
        #     `projects/{project}/locations/{location}/serviceLbPolicies/*`.
        class DeleteServiceLbPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
