# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # GatewayRouteView defines view-only resource for Routes to a Gateway
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Full path name of the GatewayRouteView resource.
        #     Format:
        #       projects/\\{project_number}/locations/\\{location}/gateways/\\{gateway}/routeViews/\\{route_view}
        # @!attribute [r] route_project_number
        #   @return [::Integer]
        #     Output only. Project number where the route exists.
        # @!attribute [r] route_location
        #   @return [::String]
        #     Output only. Location where the route exists.
        # @!attribute [r] route_type
        #   @return [::String]
        #     Output only. Type of the route: HttpRoute,GrpcRoute,TcpRoute, or TlsRoute
        # @!attribute [r] route_id
        #   @return [::String]
        #     Output only. The resource id for the route.
        class GatewayRouteView
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MeshRouteView defines view-only resource for Routes to a Mesh
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Full path name of the MeshRouteView resource.
        #     Format:
        #       projects/\\{project}/locations/\\{location}/meshes/\\{mesh}/routeViews/\\{route_view}
        # @!attribute [r] route_project_number
        #   @return [::Integer]
        #     Output only. Project number where the route exists.
        # @!attribute [r] route_location
        #   @return [::String]
        #     Output only. Location where the route exists.
        # @!attribute [r] route_type
        #   @return [::String]
        #     Output only. Type of the route: HttpRoute,GrpcRoute,TcpRoute, or TlsRoute
        # @!attribute [r] route_id
        #   @return [::String]
        #     Output only. The resource id for the route.
        class MeshRouteView
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the GetGatewayRouteView method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the GatewayRouteView resource.
        #     Formats:
        #       projects/\\{project}/locations/\\{location}/gateways/\\{gateway}/routeViews/\\{route_view}
        class GetGatewayRouteViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the GetMeshRouteView method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the MeshRouteView resource.
        #     Format:
        #       projects/\\{project}/locations/\\{location}/meshes/\\{mesh}/routeViews/\\{route_view}
        class GetMeshRouteViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the ListGatewayRouteViews method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Gateway to which a Route is associated.
        #     Formats:
        #       projects/\\{project}/locations/\\{location}/gateways/\\{gateway}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of GatewayRouteViews to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListGatewayRouteViewsResponse`
        #     Indicates that this is a continuation of a prior `ListGatewayRouteViews`
        #     call, and that the system should return the next page of data.
        class ListGatewayRouteViewsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the ListMeshRouteViews method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Mesh to which a Route is associated.
        #     Format:
        #       projects/\\{project}/locations/\\{location}/meshes/\\{mesh}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of MeshRouteViews to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListMeshRouteViewsResponse`
        #     Indicates that this is a continuation of a prior `ListMeshRouteViews` call,
        #     and that the system should return the next page of data.
        class ListMeshRouteViewsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListGatewayRouteViews method.
        # @!attribute [rw] gateway_route_views
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::GatewayRouteView>]
        #     List of GatewayRouteView resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request attempts to list all
        #     resources across all supported locations, while some locations are
        #     temporarily unavailable.
        class ListGatewayRouteViewsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListMeshRouteViews method.
        # @!attribute [rw] mesh_route_views
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::MeshRouteView>]
        #     List of MeshRouteView resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request attempts to list all
        #     resources across all supported locations, while some locations are
        #     temporarily unavailable.
        class ListMeshRouteViewsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
