# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # HttpRoute is the resource defining how HTTP traffic should be routed by a
        # Mesh or Gateway resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the HttpRoute resource. It matches pattern
        #     `projects/*/locations/global/httpRoutes/http_route_name>`.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL of this resource
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] hostnames
        #   @return [::Array<::String>]
        #     Required. Hostnames define a set of hosts that should match against the
        #     HTTP host header to select a HttpRoute to process the request. Hostname is
        #     the fully qualified domain name of a network host, as defined by RFC 1123
        #     with the exception that:
        #      - IPs are not allowed.
        #      - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
        #        label must appear by itself as the first label.
        #
        #     Hostname can be "precise" which is a domain name without the terminating
        #     dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
        #     domain name prefixed with a single wildcard label (e.g. `*.example.com`).
        #
        #     Note that as per RFC1035 and RFC1123, a label must consist of lower case
        #     alphanumeric characters or '-', and must start and end with an alphanumeric
        #     character. No other punctuation is allowed.
        #
        #     The routes associated with a Mesh or Gateways  must have unique hostnames.
        #     If you attempt to attach multiple routes with conflicting hostnames,
        #     the configuration will be rejected.
        #
        #     For example, while it is acceptable for routes for the hostnames
        #     `*.foo.bar.com` and `*.bar.com` to be associated with the same Mesh (or
        #     Gateways under the same scope), it is not possible to associate two routes
        #     both with `*.bar.com` or both with `bar.com`.
        # @!attribute [rw] meshes
        #   @return [::Array<::String>]
        #     Optional. Meshes defines a list of meshes this HttpRoute is attached to, as
        #     one of the routing rules to route the requests served by the mesh.
        #
        #     Each mesh reference should match the pattern:
        #     `projects/*/locations/global/meshes/<mesh_name>`
        #
        #     The attached Mesh should be of a type SIDECAR
        # @!attribute [rw] gateways
        #   @return [::Array<::String>]
        #     Optional. Gateways defines a list of gateways this HttpRoute is attached
        #     to, as one of the routing rules to route the requests served by the
        #     gateway.
        #
        #     Each gateway reference should match the pattern:
        #     `projects/*/locations/global/gateways/<gateway_name>`
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the HttpRoute resource.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::HttpRoute::RouteRule>]
        #     Required. Rules that define how traffic is routed and handled.
        #     Rules will be matched sequentially based on the RouteMatch specified for
        #     the rule.
        class HttpRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how to select a route rule based on HTTP request headers.
          # @!attribute [rw] exact_match
          #   @return [::String]
          #     The value of the header should match exactly the content of
          #     exact_match.
          #
          #     Note: The following fields are mutually exclusive: `exact_match`, `regex_match`, `prefix_match`, `present_match`, `suffix_match`, `range_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] regex_match
          #   @return [::String]
          #     The value of the header must match the regular expression specified in
          #     regex_match. For regular expression grammar, please see:
          #     https://github.com/google/re2/wiki/Syntax
          #
          #     Note: The following fields are mutually exclusive: `regex_match`, `exact_match`, `prefix_match`, `present_match`, `suffix_match`, `range_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] prefix_match
          #   @return [::String]
          #     The value of the header must start with the contents of prefix_match.
          #
          #     Note: The following fields are mutually exclusive: `prefix_match`, `exact_match`, `regex_match`, `present_match`, `suffix_match`, `range_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] present_match
          #   @return [::Boolean]
          #     A header with header_name must exist. The match takes place whether or
          #     not the header has a value.
          #
          #     Note: The following fields are mutually exclusive: `present_match`, `exact_match`, `regex_match`, `prefix_match`, `suffix_match`, `range_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] suffix_match
          #   @return [::String]
          #     The value of the header must end with the contents of suffix_match.
          #
          #     Note: The following fields are mutually exclusive: `suffix_match`, `exact_match`, `regex_match`, `prefix_match`, `present_match`, `range_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] range_match
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::HeaderMatch::IntegerRange]
          #     If specified, the rule will match if the request header value is within
          #     the range.
          #
          #     Note: The following fields are mutually exclusive: `range_match`, `exact_match`, `regex_match`, `prefix_match`, `present_match`, `suffix_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] header
          #   @return [::String]
          #     The name of the HTTP header to match against.
          # @!attribute [rw] invert_match
          #   @return [::Boolean]
          #     If specified, the match result will be inverted before checking. Default
          #     value is set to false.
          class HeaderMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents an integer value range.
            # @!attribute [rw] start
            #   @return [::Integer]
            #     Start of the range (inclusive)
            # @!attribute [rw] end
            #   @return [::Integer]
            #     End of the range (exclusive)
            class IntegerRange
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Specifications to match a query parameter in the request.
          # @!attribute [rw] exact_match
          #   @return [::String]
          #     The value of the query parameter must exactly match the contents of
          #     exact_match.
          #
          #     Only one of exact_match, regex_match, or present_match must be set.
          #
          #     Note: The following fields are mutually exclusive: `exact_match`, `regex_match`, `present_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] regex_match
          #   @return [::String]
          #     The value of the query parameter must match the regular expression
          #     specified by regex_match. For regular expression grammar, please see
          #     https://github.com/google/re2/wiki/Syntax
          #
          #     Only one of exact_match, regex_match, or present_match must be set.
          #
          #     Note: The following fields are mutually exclusive: `regex_match`, `exact_match`, `present_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] present_match
          #   @return [::Boolean]
          #     Specifies that the QueryParameterMatcher matches if request contains
          #     query parameter, irrespective of whether the parameter has a value or
          #     not.
          #
          #     Only one of exact_match, regex_match, or present_match must be set.
          #
          #     Note: The following fields are mutually exclusive: `present_match`, `exact_match`, `regex_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] query_parameter
          #   @return [::String]
          #     The name of the query parameter to match.
          class QueryParameterMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # RouteMatch defines specifications used to match requests. If multiple match
          # types are set, this RouteMatch will match if ALL type of matches are
          # matched.
          # @!attribute [rw] full_path_match
          #   @return [::String]
          #     The HTTP request path value should exactly match this value.
          #
          #     Only one of full_path_match, prefix_match, or regex_match should be
          #     used.
          #
          #     Note: The following fields are mutually exclusive: `full_path_match`, `prefix_match`, `regex_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] prefix_match
          #   @return [::String]
          #     The HTTP request path value must begin with specified prefix_match.
          #     prefix_match must begin with a /.
          #
          #     Only one of full_path_match, prefix_match, or regex_match should be
          #     used.
          #
          #     Note: The following fields are mutually exclusive: `prefix_match`, `full_path_match`, `regex_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] regex_match
          #   @return [::String]
          #     The HTTP request path value must satisfy the regular expression
          #     specified by regex_match after removing any query parameters and anchor
          #     supplied with the original URL. For regular expression grammar, please
          #     see https://github.com/google/re2/wiki/Syntax
          #
          #     Only one of full_path_match, prefix_match, or regex_match should be
          #     used.
          #
          #     Note: The following fields are mutually exclusive: `regex_match`, `full_path_match`, `prefix_match`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] ignore_case
          #   @return [::Boolean]
          #     Specifies if prefix_match and full_path_match matches are case sensitive.
          #     The default value is false.
          # @!attribute [rw] headers
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::HttpRoute::HeaderMatch>]
          #     Specifies a list of HTTP request headers to match against. ALL of the
          #     supplied headers must be matched.
          # @!attribute [rw] query_parameters
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::HttpRoute::QueryParameterMatch>]
          #     Specifies a list of query parameters to match against. ALL of the query
          #     parameters must be matched.
          class RouteMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifications of a destination to which the request should be routed to.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     The URL of a BackendService to route traffic to.
          # @!attribute [rw] weight
          #   @return [::Integer]
          #     Specifies the proportion of requests forwarded to the backend referenced
          #     by the serviceName field. This is computed as:
          #     - weight/Sum(weights in this destination list).
          #     For non-zero values, there may be some epsilon from the exact proportion
          #     defined here depending on the precision an implementation supports.
          #
          #     If only one serviceName is specified and it has a weight greater than 0,
          #     100% of the traffic is forwarded to that backend.
          #
          #     If weights are specified for any one service name, they need to be
          #     specified for all of them.
          #
          #     If weights are unspecified for all services, then, traffic is distributed
          #     in equal proportions to all of them.
          # @!attribute [rw] request_header_modifier
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::HeaderModifier]
          #     Optional. The specification for modifying the headers of a matching
          #     request prior to delivery of the request to the destination. If
          #     HeaderModifiers are set on both the Destination and the RouteAction, they
          #     will be merged. Conflicts between the two will not be resolved on the
          #     configuration.
          # @!attribute [rw] response_header_modifier
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::HeaderModifier]
          #     Optional. The specification for modifying the headers of a response prior
          #     to sending the response back to the client. If HeaderModifiers are set on
          #     both the Destination and the RouteAction, they will be merged. Conflicts
          #     between the two will not be resolved on the configuration.
          class Destination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specification for redirecting traffic.
          # @!attribute [rw] host_redirect
          #   @return [::String]
          #     The host that will be used in the redirect response instead of the one
          #     that was supplied in the request.
          # @!attribute [rw] path_redirect
          #   @return [::String]
          #     The path that will be used in the redirect response instead of the one
          #     that was supplied in the request.
          #     path_redirect can not be supplied together with prefix_redirect. Supply
          #     one alone or neither. If neither is supplied, the path of the original
          #     request will be used for the redirect.
          # @!attribute [rw] prefix_rewrite
          #   @return [::String]
          #     Indicates that during redirection, the matched prefix (or path) should be
          #     swapped with this value. This option allows URLs be dynamically created
          #     based on the request.
          # @!attribute [rw] response_code
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::Redirect::ResponseCode]
          #     The HTTP Status code to use for the redirect.
          # @!attribute [rw] https_redirect
          #   @return [::Boolean]
          #     If set to true, the URL scheme in the redirected request is set to https.
          #     If set to false, the URL scheme of the redirected request will remain the
          #     same as that of the request.
          #
          #     The default is set to false.
          # @!attribute [rw] strip_query
          #   @return [::Boolean]
          #     if set to true, any accompanying query portion of the original URL is
          #     removed prior to redirecting the request. If set to false, the query
          #     portion of the original URL is retained.
          #
          #     The default is set to false.
          # @!attribute [rw] port_redirect
          #   @return [::Integer]
          #     The port that will be used in the redirected request instead of the one
          #     that was supplied in the request.
          class Redirect
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Supported HTTP response code.
            module ResponseCode
              # Default value
              RESPONSE_CODE_UNSPECIFIED = 0

              # Corresponds to 301.
              MOVED_PERMANENTLY_DEFAULT = 1

              # Corresponds to 302.
              FOUND = 2

              # Corresponds to 303.
              SEE_OTHER = 3

              # Corresponds to 307. In this case, the request method will be retained.
              TEMPORARY_REDIRECT = 4

              # Corresponds to 308. In this case, the request method will be retained.
              PERMANENT_REDIRECT = 5
            end
          end

          # The specification for fault injection introduced into traffic to test the
          # resiliency of clients to destination service failure. As part of fault
          # injection, when clients send requests to a destination, delays can be
          # introduced by client proxy on a percentage of requests before sending those
          # requests to the destination service. Similarly requests can be aborted by
          # client proxy for a percentage of requests.
          # @!attribute [rw] delay
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::FaultInjectionPolicy::Delay]
          #     The specification for injecting delay to client requests.
          # @!attribute [rw] abort
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::FaultInjectionPolicy::Abort]
          #     The specification for aborting to client requests.
          class FaultInjectionPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Specification of how client requests are delayed as part of fault
            # injection before being sent to a destination.
            # @!attribute [rw] fixed_delay
            #   @return [::Google::Protobuf::Duration]
            #     Specify a fixed delay before forwarding the request.
            # @!attribute [rw] percentage
            #   @return [::Integer]
            #     The percentage of traffic on which delay will be injected.
            #
            #     The value must be between [0, 100]
            class Delay
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specification of how client requests are aborted as part of fault
            # injection before being sent to a destination.
            # @!attribute [rw] http_status
            #   @return [::Integer]
            #     The HTTP status code used to abort the request.
            #
            #     The value must be between 200 and 599 inclusive.
            # @!attribute [rw] percentage
            #   @return [::Integer]
            #     The percentage of traffic which will be aborted.
            #
            #     The value must be between [0, 100]
            class Abort
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The specification for cookie-based stateful session affinity where the
          # date plane supplies a “session cookie”  with the name "GSSA" which encodes
          # a specific destination host and each request containing that cookie will
          # be directed to that host as long as the destination host remains up and
          # healthy.
          #
          # The gRPC proxyless mesh library or sidecar proxy will manage the session
          # cookie but the client application code is responsible for copying the
          # cookie from each RPC in the session to the next.
          # @!attribute [rw] cookie_ttl
          #   @return [::Google::Protobuf::Duration]
          #     Required. The cookie TTL value for the Set-Cookie header generated by
          #     the data plane. The lifetime of the cookie may be set to a value from 0
          #     to 86400 seconds (24 hours) inclusive.
          #
          #     Set this to 0s to use a session cookie and disable cookie expiration.
          class StatefulSessionAffinityPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specification for modifying HTTP header in HTTP request and HTTP
          # response.
          # @!attribute [rw] set
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Completely overwrite/replace the headers with given map where key is the
          #     name of the header, value is the value of the header.
          # @!attribute [rw] add
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Add the headers with given map where key is the name of the header, value
          #     is the value of the header.
          # @!attribute [rw] remove
          #   @return [::Array<::String>]
          #     Remove headers (matching by header names) specified in the list.
          class HeaderModifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class SetEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AddEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The specification for modifying the URL of the request, prior to forwarding
          # the request to the destination.
          # @!attribute [rw] path_prefix_rewrite
          #   @return [::String]
          #     Prior to forwarding the request to the selected destination, the matching
          #     portion of the requests path is replaced by this value.
          # @!attribute [rw] host_rewrite
          #   @return [::String]
          #     Prior to forwarding the request to the selected destination, the requests
          #     host header is replaced by this value.
          class URLRewrite
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specifications for retries.
          # @!attribute [rw] retry_conditions
          #   @return [::Array<::String>]
          #     Specifies one or more conditions when this retry policy applies. Valid
          #     values are:
          #       5xx: Proxy will attempt a retry if the destination service responds
          #         with any 5xx response code, of if the destination service does not
          #         respond at all, example: disconnect, reset, read timeout, connection
          #         failure and refused streams.
          #
          #       gateway-error: Similar to 5xx, but only applies to response codes 502,
          #         503, 504.
          #
          #       reset: Proxy will attempt a retry if the destination service does not
          #         respond at all (disconnect/reset/read timeout)
          #
          #       connect-failure: Proxy will retry on failures connecting to destination
          #         for example due to connection timeouts.
          #
          #       retriable-4xx: Proxy will retry fro retriable 4xx response codes.
          #         Currently the only retriable error supported is 409.
          #
          #       refused-stream: Proxy will retry if the destination resets the stream
          #         with a REFUSED_STREAM error code. This reset type indicates that it
          #         is safe to retry.
          # @!attribute [rw] num_retries
          #   @return [::Integer]
          #     Specifies the allowed number of retries. This number must be > 0. If not
          #     specified, default to 1.
          # @!attribute [rw] per_try_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Specifies a non-zero timeout per retry attempt.
          class RetryPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the policy on how requests are shadowed to a separate mirrored
          # destination service. The proxy does not wait for responses from the
          # shadow service. Prior to sending traffic to the shadow service, the
          # host/authority header is suffixed with -shadow.
          # Mirroring is currently not supported for Cloud Run destinations.
          # @!attribute [rw] destination
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::Destination]
          #     The destination the requests will be mirrored to. The weight of the
          #     destination will be ignored.
          # @!attribute [rw] mirror_percent
          #   @return [::Float]
          #     Optional. The percentage of requests to get mirrored to the desired
          #     destination.
          class RequestMirrorPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Specification for allowing client side cross-origin requests.
          # @!attribute [rw] allow_origins
          #   @return [::Array<::String>]
          #     Specifies the list of origins that will be allowed to do CORS requests.
          #     An origin is allowed if it matches either an item in allow_origins or
          #     an item in allow_origin_regexes.
          # @!attribute [rw] allow_origin_regexes
          #   @return [::Array<::String>]
          #     Specifies the regular expression patterns that match allowed origins. For
          #     regular expression grammar, please see
          #     https://github.com/google/re2/wiki/Syntax.
          # @!attribute [rw] allow_methods
          #   @return [::Array<::String>]
          #     Specifies the content for Access-Control-Allow-Methods header.
          # @!attribute [rw] allow_headers
          #   @return [::Array<::String>]
          #     Specifies the content for Access-Control-Allow-Headers header.
          # @!attribute [rw] expose_headers
          #   @return [::Array<::String>]
          #     Specifies the content for Access-Control-Expose-Headers header.
          # @!attribute [rw] max_age
          #   @return [::String]
          #     Specifies how long result of a preflight request can be cached in
          #     seconds. This translates to the Access-Control-Max-Age header.
          # @!attribute [rw] allow_credentials
          #   @return [::Boolean]
          #     In response to a preflight request, setting this to true indicates that
          #     the actual request can include user credentials. This translates to the
          #     Access-Control-Allow-Credentials header.
          #
          #     Default value is false.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     If true, the CORS policy is disabled. The default value is false, which
          #     indicates that the CORS policy is in effect.
          class CorsPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Static HTTP response object to be returned.
          # @!attribute [rw] string_body
          #   @return [::String]
          #     Optional. Response body as a string. Maximum body length is 1024
          #     characters.
          #
          #     Note: The following fields are mutually exclusive: `string_body`, `bytes_body`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] bytes_body
          #   @return [::String]
          #     Optional. Response body as bytes. Maximum body size is 4096B.
          #
          #     Note: The following fields are mutually exclusive: `bytes_body`, `string_body`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] status
          #   @return [::Integer]
          #     Required. Status to return as part of HTTP Response. Must be a positive
          #     integer.
          class HttpDirectResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specifications for routing traffic and applying associated policies.
          # @!attribute [rw] destinations
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::HttpRoute::Destination>]
          #     The destination to which traffic should be forwarded.
          # @!attribute [rw] redirect
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::Redirect]
          #     If set, the request is directed as configured by this field.
          # @!attribute [rw] fault_injection_policy
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::FaultInjectionPolicy]
          #     The specification for fault injection introduced into traffic to test the
          #     resiliency of clients to backend service failure. As part of fault
          #     injection, when clients send requests to a backend service, delays can be
          #     introduced  on a percentage of requests before sending those requests to
          #     the backend service. Similarly requests from clients can be aborted for a
          #     percentage of requests.
          #
          #     timeout and retry_policy will be ignored by clients that are configured
          #     with a fault_injection_policy
          # @!attribute [rw] request_header_modifier
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::HeaderModifier]
          #     The specification for modifying the headers of a matching request prior
          #     to delivery of the request to the destination. If HeaderModifiers are set
          #     on both the Destination and the RouteAction, they will be merged.
          #     Conflicts between the two will not be resolved on the configuration.
          # @!attribute [rw] response_header_modifier
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::HeaderModifier]
          #     The specification for modifying the headers of a response prior to
          #     sending the response back to the client. If HeaderModifiers are set
          #     on both the Destination and the RouteAction, they will be merged.
          #     Conflicts between the two will not be resolved on the configuration.
          # @!attribute [rw] url_rewrite
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::URLRewrite]
          #     The specification for rewrite URL before forwarding requests to the
          #     destination.
          # @!attribute [rw] timeout
          #   @return [::Google::Protobuf::Duration]
          #     Specifies the timeout for selected route. Timeout is computed from the
          #     time the request has been fully processed (i.e. end of stream) up until
          #     the response has been completely processed. Timeout includes all retries.
          # @!attribute [rw] retry_policy
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::RetryPolicy]
          #     Specifies the retry policy associated with this route.
          # @!attribute [rw] request_mirror_policy
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::RequestMirrorPolicy]
          #     Specifies the policy on how requests intended for the routes destination
          #     are shadowed to a separate mirrored destination. Proxy will not wait for
          #     the shadow destination to respond before returning the response. Prior to
          #     sending traffic to the shadow service, the host/authority header is
          #     suffixed with -shadow.
          # @!attribute [rw] cors_policy
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::CorsPolicy]
          #     The specification for allowing client side cross-origin requests.
          # @!attribute [rw] stateful_session_affinity
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::StatefulSessionAffinityPolicy]
          #     Optional. Specifies cookie-based stateful session affinity.
          # @!attribute [rw] direct_response
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::HttpDirectResponse]
          #     Optional. Static HTTP Response object to be returned regardless of the
          #     request.
          # @!attribute [rw] idle_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Specifies the idle timeout for the selected route. The idle
          #     timeout is defined as the period in which there are no bytes sent or
          #     received on either the upstream or downstream connection. If not set, the
          #     default idle timeout is 1 hour. If set to 0s, the timeout will be
          #     disabled.
          class RouteAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies how to match traffic and how to route traffic when traffic is
          # matched.
          # @!attribute [rw] matches
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::HttpRoute::RouteMatch>]
          #     A list of matches define conditions used for matching the rule against
          #     incoming HTTP requests. Each match is independent, i.e. this rule will be
          #     matched if ANY one of the matches is satisfied.
          #
          #     If no matches field is specified, this rule will unconditionally match
          #     traffic.
          #
          #     If a default rule is desired to be configured, add a rule with no matches
          #     specified to the end of the rules list.
          # @!attribute [rw] action
          #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute::RouteAction]
          #     The detailed rule defining how to route matched traffic.
          class RouteRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request used with the ListHttpRoutes method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the HttpRoutes should be
        #     listed, specified in the format `projects/*/locations/global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of HttpRoutes to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListHttpRoutesResponse`
        #     Indicates that this is a continuation of a prior `ListHttpRoutes` call,
        #     and that the system should return the next page of data.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If true, allow partial responses for multi-regional Aggregated
        #     List requests. Otherwise if one of the locations is down or unreachable,
        #     the Aggregated List request will fail.
        class ListHttpRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListHttpRoutes method.
        # @!attribute [rw] http_routes
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::HttpRoute>]
        #     List of HttpRoute resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request opts into
        #     {::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest#return_partial_success return_partial_success}
        #     and reading across collections e.g. when attempting to list all resources
        #     across all supported locations.
        class ListHttpRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetHttpRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the HttpRoute to get. Must be in the format
        #     `projects/*/locations/global/httpRoutes/*`.
        class GetHttpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the HttpRoute method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the HttpRoute. Must be in the
        #     format `projects/*/locations/global`.
        # @!attribute [rw] http_route_id
        #   @return [::String]
        #     Required. Short name of the HttpRoute resource to be created.
        # @!attribute [rw] http_route
        #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute]
        #     Required. HttpRoute resource to be created.
        class CreateHttpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the UpdateHttpRoute method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     HttpRoute resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] http_route
        #   @return [::Google::Cloud::NetworkServices::V1::HttpRoute]
        #     Required. Updated HttpRoute resource.
        class UpdateHttpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteHttpRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the HttpRoute to delete. Must be in the format
        #     `projects/*/locations/global/httpRoutes/*`.
        class DeleteHttpRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
