# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # GrpcRoute is the resource defining how gRPC traffic routed by a Mesh
        # or Gateway resource is routed.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the GrpcRoute resource. It matches pattern
        #     `projects/*/locations/global/grpcRoutes/<grpc_route_name>`
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL of this resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the GrpcRoute resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [rw] hostnames
        #   @return [::Array<::String>]
        #     Required. Service hostnames with an optional port for which this route
        #     describes traffic.
        #
        #     Format: <hostname>[:<port>]
        #
        #     Hostname is the fully qualified domain name of a network host. This matches
        #     the RFC 1123 definition of a hostname with 2 notable exceptions:
        #      - IPs are not allowed.
        #      - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
        #        label must appear by itself as the first label.
        #
        #     Hostname can be "precise" which is a domain name without the terminating
        #     dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
        #     domain name prefixed with a single wildcard label (e.g. `*.example.com`).
        #
        #     Note that as per RFC1035 and RFC1123, a label must consist of lower case
        #     alphanumeric characters or '-', and must start and end with an alphanumeric
        #     character. No other punctuation is allowed.
        #
        #     The routes associated with a Mesh or Gateway must have unique hostnames. If
        #     you attempt to attach multiple routes with conflicting hostnames, the
        #     configuration will be rejected.
        #
        #     For example, while it is acceptable for routes for the hostnames
        #     `*.foo.bar.com` and `*.bar.com` to be associated with the same route, it is
        #     not possible to associate two routes both with `*.bar.com` or both with
        #     `bar.com`.
        #
        #     If a port is specified, then gRPC clients must use the channel URI with the
        #     port to match this rule (i.e. "xds:///service:123"), otherwise they must
        #     supply the URI without a port (i.e. "xds:///service").
        # @!attribute [rw] meshes
        #   @return [::Array<::String>]
        #     Optional. Meshes defines a list of meshes this GrpcRoute is attached to, as
        #     one of the routing rules to route the requests served by the mesh.
        #
        #     Each mesh reference should match the pattern:
        #     `projects/*/locations/global/meshes/<mesh_name>`
        # @!attribute [rw] gateways
        #   @return [::Array<::String>]
        #     Optional. Gateways defines a list of gateways this GrpcRoute is attached
        #     to, as one of the routing rules to route the requests served by the
        #     gateway.
        #
        #     Each gateway reference should match the pattern:
        #     `projects/*/locations/global/gateways/<gateway_name>`
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::GrpcRoute::RouteRule>]
        #     Required. A list of detailed rules defining how to route traffic.
        #
        #     Within a single GrpcRoute, the GrpcRoute.RouteAction associated with the
        #     first matching GrpcRoute.RouteRule will be executed. At least one rule
        #     must be supplied.
        class GrpcRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies a match against a method.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::MethodMatch::Type]
          #     Optional. Specifies how to match against the name. If not specified, a
          #     default value of "EXACT" is used.
          # @!attribute [rw] grpc_service
          #   @return [::String]
          #     Required. Name of the service to match against. If unspecified, will
          #     match all services.
          # @!attribute [rw] grpc_method
          #   @return [::String]
          #     Required. Name of the method to match against. If unspecified, will match
          #     all methods.
          # @!attribute [rw] case_sensitive
          #   @return [::Boolean]
          #     Optional. Specifies that matches are case sensitive.  The default value
          #     is true. case_sensitive must not be used with a type of
          #     REGULAR_EXPRESSION.
          class MethodMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the match.
            module Type
              # Unspecified.
              TYPE_UNSPECIFIED = 0

              # Will only match the exact name provided.
              EXACT = 1

              # Will interpret grpc_method and grpc_service as regexes. RE2 syntax is
              # supported.
              REGULAR_EXPRESSION = 2
            end
          end

          # A match against a collection of headers.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::HeaderMatch::Type]
          #     Optional. Specifies how to match against the value of the header. If not
          #     specified, a default value of EXACT is used.
          # @!attribute [rw] key
          #   @return [::String]
          #     Required. The key of the header.
          # @!attribute [rw] value
          #   @return [::String]
          #     Required. The value of the header.
          class HeaderMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of match.
            module Type
              # Unspecified.
              TYPE_UNSPECIFIED = 0

              # Will only match the exact value provided.
              EXACT = 1

              # Will match paths conforming to the prefix specified by value. RE2
              # syntax is supported.
              REGULAR_EXPRESSION = 2
            end
          end

          # Criteria for matching traffic. A RouteMatch will be considered to match
          # when all supplied fields match.
          # @!attribute [rw] method
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::MethodMatch]
          #     Optional. A gRPC method to match against. If this field is empty or
          #     omitted, will match all methods.
          # @!attribute [rw] headers
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::GrpcRoute::HeaderMatch>]
          #     Optional. Specifies a collection of headers to match.
          class RouteMatch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The destination to which traffic will be routed.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     Required. The URL of a destination service to which to route traffic.
          #     Must refer to either a BackendService or ServiceDirectoryService.
          # @!attribute [rw] weight
          #   @return [::Integer]
          #     Optional. Specifies the proportion of requests forwarded to the backend
          #     referenced by the serviceName field. This is computed as:
          #     - weight/Sum(weights in this destination list).
          #     For non-zero values, there may be some epsilon from the exact proportion
          #     defined here depending on the precision an implementation supports.
          #
          #     If only one serviceName is specified and it has a weight greater than 0,
          #     100% of the traffic is forwarded to that backend.
          #
          #     If weights are specified for any one service name, they need to be
          #     specified for all of them.
          #
          #     If weights are unspecified for all services, then, traffic is distributed
          #     in equal proportions to all of them.
          class Destination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specification for fault injection introduced into traffic to test the
          # resiliency of clients to destination service failure. As part of fault
          # injection, when clients send requests to a destination, delays can be
          # introduced on a percentage of requests before sending those requests to the
          # destination service. Similarly requests from clients can be aborted by for
          # a percentage of requests.
          # @!attribute [rw] delay
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::FaultInjectionPolicy::Delay]
          #     The specification for injecting delay to client requests.
          # @!attribute [rw] abort
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::FaultInjectionPolicy::Abort]
          #     The specification for aborting to client requests.
          class FaultInjectionPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Specification of how client requests are delayed as part of fault
            # injection before being sent to a destination.
            # @!attribute [rw] fixed_delay
            #   @return [::Google::Protobuf::Duration]
            #     Specify a fixed delay before forwarding the request.
            # @!attribute [rw] percentage
            #   @return [::Integer]
            #     The percentage of traffic on which delay will be injected.
            #
            #     The value must be between [0, 100]
            class Delay
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specification of how client requests are aborted as part of fault
            # injection before being sent to a destination.
            # @!attribute [rw] http_status
            #   @return [::Integer]
            #     The HTTP status code used to abort the request.
            #
            #     The value must be between 200 and 599 inclusive.
            # @!attribute [rw] percentage
            #   @return [::Integer]
            #     The percentage of traffic which will be aborted.
            #
            #     The value must be between [0, 100]
            class Abort
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The specification for cookie-based stateful session affinity where the
          # date plane supplies a “session cookie”  with the name "GSSA" which encodes
          # a specific destination host and each request containing that cookie will
          # be directed to that host as long as the destination host remains up and
          # healthy.
          #
          # The gRPC proxyless mesh library or sidecar proxy will manage the session
          # cookie but the client application code is responsible for copying the
          # cookie from each RPC in the session to the next.
          # @!attribute [rw] cookie_ttl
          #   @return [::Google::Protobuf::Duration]
          #     Required. The cookie TTL value for the Set-Cookie header generated by the
          #     data plane. The lifetime of the cookie may be set to a value from 0 to
          #     86400 seconds (24 hours) inclusive.
          #
          #     Set this to 0s to use a session cookie and disable cookie expiration.
          class StatefulSessionAffinityPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specifications for retries.
          # Specifies one or more conditions for which this retry rule applies. Valid
          # values are:
          # @!attribute [rw] retry_conditions
          #   @return [::Array<::String>]
          #     - connect-failure: Router will retry on failures connecting to Backend
          #        Services, for example due to connection timeouts.
          #     - refused-stream: Router will retry if the backend service resets the
          #     stream
          #        with a REFUSED_STREAM error code. This reset type indicates that it is
          #        safe to retry.
          #     - cancelled: Router will retry if the gRPC status code in the response
          #     header
          #        is set to cancelled
          #     - deadline-exceeded: Router will retry if the gRPC status code in the
          #     response
          #        header is set to deadline-exceeded
          #     - resource-exhausted: Router will retry if the gRPC status code in the
          #        response header is set to resource-exhausted
          #     - unavailable: Router will retry if the gRPC status code in the response
          #        header is set to unavailable
          # @!attribute [rw] num_retries
          #   @return [::Integer]
          #     Specifies the allowed number of retries. This number must be > 0. If not
          #     specified, default to 1.
          class RetryPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies how to route matched traffic.
          # @!attribute [rw] destinations
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::GrpcRoute::Destination>]
          #     Optional. The destination services to which traffic should be forwarded.
          #     If multiple destinations are specified, traffic will be split between
          #     Backend Service(s) according to the weight field of these destinations.
          # @!attribute [rw] fault_injection_policy
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::FaultInjectionPolicy]
          #     Optional. The specification for fault injection introduced into traffic
          #     to test the resiliency of clients to destination service failure. As part
          #     of fault injection, when clients send requests to a destination, delays
          #     can be introduced on a percentage of requests before sending those
          #     requests to the destination service. Similarly requests from clients can
          #     be aborted by for a percentage of requests.
          #
          #     timeout and retry_policy will be ignored by clients that are configured
          #     with a fault_injection_policy
          # @!attribute [rw] timeout
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Specifies the timeout for selected route. Timeout is computed
          #     from the time the request has been fully processed (i.e. end of stream)
          #     up until the response has been completely processed. Timeout includes all
          #     retries.
          # @!attribute [rw] retry_policy
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::RetryPolicy]
          #     Optional. Specifies the retry policy associated with this route.
          # @!attribute [rw] stateful_session_affinity
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::StatefulSessionAffinityPolicy]
          #     Optional. Specifies cookie-based stateful session affinity.
          # @!attribute [rw] idle_timeout
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Specifies the idle timeout for the selected route. The idle
          #     timeout is defined as the period in which there are no bytes sent or
          #     received on either the upstream or downstream connection. If not set, the
          #     default idle timeout is 1 hour. If set to 0s, the timeout will be
          #     disabled.
          class RouteAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes how to route traffic.
          # @!attribute [rw] matches
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::GrpcRoute::RouteMatch>]
          #     Optional. Matches define conditions used for matching the rule against
          #     incoming gRPC requests. Each match is independent, i.e. this rule will be
          #     matched if ANY one of the matches is satisfied.  If no matches field is
          #     specified, this rule will unconditionally match traffic.
          # @!attribute [rw] action
          #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute::RouteAction]
          #     Required. A detailed rule defining how to route traffic. This field is
          #     required.
          class RouteRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request used with the ListGrpcRoutes method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the GrpcRoutes should be
        #     listed, specified in the format `projects/*/locations/global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of GrpcRoutes to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListGrpcRoutesResponse`
        #     Indicates that this is a continuation of a prior `ListGrpcRoutes` call,
        #     and that the system should return the next page of data.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If true, allow partial responses for multi-regional Aggregated
        #     List requests. Otherwise if one of the locations is down or unreachable,
        #     the Aggregated List request will fail.
        class ListGrpcRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListGrpcRoutes method.
        # @!attribute [rw] grpc_routes
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::GrpcRoute>]
        #     List of GrpcRoute resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request opts into
        #     {::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest#return_partial_success return_partial_success}
        #     and reading across collections e.g. when attempting to list all resources
        #     across all supported locations.
        class ListGrpcRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetGrpcRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the GrpcRoute to get. Must be in the format
        #     `projects/*/locations/global/grpcRoutes/*`.
        class GetGrpcRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the CreateGrpcRoute method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the GrpcRoute. Must be in the
        #     format `projects/*/locations/global`.
        # @!attribute [rw] grpc_route_id
        #   @return [::String]
        #     Required. Short name of the GrpcRoute resource to be created.
        # @!attribute [rw] grpc_route
        #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute]
        #     Required. GrpcRoute resource to be created.
        class CreateGrpcRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the UpdateGrpcRoute method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     GrpcRoute resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] grpc_route
        #   @return [::Google::Cloud::NetworkServices::V1::GrpcRoute]
        #     Required. Updated GrpcRoute resource.
        class UpdateGrpcRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteGrpcRoute method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the GrpcRoute to delete. Must be in the format
        #     `projects/*/locations/global/grpcRoutes/*`.
        class DeleteGrpcRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
