# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # Gateway represents the configuration for a proxy, typically a load balancer.
        # It captures the ip:port over which the services are exposed by the proxy,
        # along with any policy configurations. Routes have reference to to Gateways to
        # dictate how requests should be routed by this Gateway.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the Gateway resource. It matches pattern
        #     `projects/*/locations/*/gateways/<gateway_name>`.
        # @!attribute [r] self_link
        #   @return [::String]
        #     Output only. Server-defined URL of this resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the Gateway resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::NetworkServices::V1::Gateway::Type]
        #     Immutable. The type of the customer managed gateway.
        #     This field is required. If unspecified, an error is returned.
        # @!attribute [rw] addresses
        #   @return [::Array<::String>]
        #     Optional. Zero or one IPv4 or IPv6 address on which the Gateway will
        #     receive the traffic. When no address is provided, an IP from the subnetwork
        #     is allocated
        #
        #     This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        #     Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
        # @!attribute [rw] ports
        #   @return [::Array<::Integer>]
        #     Required. One or more port numbers (1-65535), on which the Gateway will
        #     receive traffic. The proxy binds to the specified ports.
        #     Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
        #     Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and
        #     support multiple ports.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Optional. Scope determines how configuration across multiple Gateway
        #     instances are merged. The configuration for multiple Gateway instances with
        #     the same scope will be merged as presented as a single configuration to the
        #     proxy/load balancer.
        #
        #     Max length 64 characters.
        #     Scope should start with a letter and can only have letters, numbers,
        #     hyphens.
        # @!attribute [rw] server_tls_policy
        #   @return [::String]
        #     Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
        #     TLS traffic is terminated. If empty, TLS termination is disabled.
        # @!attribute [rw] certificate_urls
        #   @return [::Array<::String>]
        #     Optional. A fully-qualified Certificates URL reference. The proxy presents
        #     a Certificate (selected based on SNI) when establishing a TLS connection.
        #     This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
        # @!attribute [rw] gateway_security_policy
        #   @return [::String]
        #     Optional. A fully-qualified GatewaySecurityPolicy URL reference.
        #     Defines how a server should apply security policy to inbound
        #     (VM to Proxy) initiated connections.
        #
        #     For example:
        #     `projects/*/locations/*/gatewaySecurityPolicies/swg-policy`.
        #
        #     This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. The relative resource name identifying the VPC network that is
        #     using this configuration. For example:
        #     `projects/*/global/networks/network-1`.
        #
        #     Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Optional. The relative resource name identifying  the subnetwork in which
        #     this SWG is allocated. For example:
        #     `projects/*/regions/us-central1/subnetworks/network-1`
        #
        #     Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY".
        # @!attribute [rw] ip_version
        #   @return [::Google::Cloud::NetworkServices::V1::Gateway::IpVersion]
        #     Optional. The IP Version that will be used by this gateway. Valid options
        #     are IPV4 or IPV6. Default is IPV4.
        # @!attribute [rw] envoy_headers
        #   @return [::Google::Cloud::NetworkServices::V1::EnvoyHeaders]
        #     Optional. Determines if envoy will insert internal debug headers into
        #     upstream requests. Other Envoy headers may still be injected. By default,
        #     envoy will not insert any debug headers.
        # @!attribute [rw] routing_mode
        #   @return [::Google::Cloud::NetworkServices::V1::Gateway::RoutingMode]
        #     Optional. The routing mode of the Gateway.
        #     This field is configurable only for gateways of type SECURE_WEB_GATEWAY.
        #     This field is required for gateways of type SECURE_WEB_GATEWAY.
        class Gateway
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the customer-managed gateway.
          # Possible values are:
          # * OPEN_MESH
          # * SECURE_WEB_GATEWAY
          module Type
            # The type of the customer managed gateway is unspecified.
            TYPE_UNSPECIFIED = 0

            # The type of the customer managed gateway is TrafficDirector Open
            # Mesh.
            OPEN_MESH = 1

            # The type of the customer managed gateway is SecureWebGateway (SWG).
            SECURE_WEB_GATEWAY = 2
          end

          # The types of IP version for the gateway.
          # Possible values are:
          # * IPV4
          # * IPV6
          module IpVersion
            # The type when IP version is not specified. Defaults to IPV4.
            IP_VERSION_UNSPECIFIED = 0

            # The type for IP version 4.
            IPV4 = 1

            # The type for IP version 6.
            IPV6 = 2
          end

          # The routing mode of the Gateway, to determine how the Gateway routes
          # traffic. Today, this field only applies to Gateways of type
          # SECURE_WEB_GATEWAY. Possible values are:
          # * EXPLICIT_ROUTING_MODE
          # * NEXT_HOP_ROUTING_MODE
          module RoutingMode
            # The routing mode is explicit; clients are configured to send
            # traffic through the gateway. This is the default routing mode.
            EXPLICIT_ROUTING_MODE = 0

            # The routing mode is next-hop. Clients are unaware of the gateway,
            # and a route (advanced route or other route type)
            # can be configured to direct traffic from client to gateway.
            # The gateway then acts as a next-hop to the destination.
            NEXT_HOP_ROUTING_MODE = 1
          end
        end

        # Request used with the ListGateways method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the Gateways should be
        #     listed, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of Gateways to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListGatewaysResponse`
        #     Indicates that this is a continuation of a prior `ListGateways` call,
        #     and that the system should return the next page of data.
        class ListGatewaysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListGateways method.
        # @!attribute [rw] gateways
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::Gateway>]
        #     List of Gateway resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListGatewaysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetGateway method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the Gateway to get. Must be in the format
        #     `projects/*/locations/*/gateways/*`.
        class GetGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the CreateGateway method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the Gateway. Must be in the
        #     format `projects/*/locations/*`.
        # @!attribute [rw] gateway_id
        #   @return [::String]
        #     Required. Short name of the Gateway resource to be created.
        # @!attribute [rw] gateway
        #   @return [::Google::Cloud::NetworkServices::V1::Gateway]
        #     Required. Gateway resource to be created.
        class CreateGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the UpdateGateway method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Gateway resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] gateway
        #   @return [::Google::Cloud::NetworkServices::V1::Gateway]
        #     Required. Updated Gateway resource.
        class UpdateGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteGateway method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the Gateway to delete. Must be in the format
        #     `projects/*/locations/*/gateways/*`.
        class DeleteGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
