# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # EndpointPolicy is a resource that helps apply desired configuration
        # on the endpoints that match specific criteria.
        # For example, this resource can be used to apply "authentication config"
        # an all endpoints that serve on port 8080.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the EndpointPolicy resource. It matches pattern
        #     `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the EndpointPolicy resource.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::NetworkServices::V1::EndpointPolicy::EndpointPolicyType]
        #     Required. The type of endpoint policy. This is primarily used to validate
        #     the configuration.
        # @!attribute [rw] authorization_policy
        #   @return [::String]
        #     Optional. This field specifies the URL of AuthorizationPolicy resource that
        #     applies authorization policies to the inbound traffic at the
        #     matched endpoints. Refer to Authorization. If this field is not
        #     specified, authorization is disabled(no authz checks) for this
        #     endpoint.
        # @!attribute [rw] endpoint_matcher
        #   @return [::Google::Cloud::NetworkServices::V1::EndpointMatcher]
        #     Required. A matcher that selects endpoints to which the policies should be
        #     applied.
        # @!attribute [rw] traffic_port_selector
        #   @return [::Google::Cloud::NetworkServices::V1::TrafficPortSelector]
        #     Optional. Port selector for the (matched) endpoints. If no port selector is
        #     provided, the matched config is applied to all ports.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A free-text description of the resource. Max length 1024
        #     characters.
        # @!attribute [rw] server_tls_policy
        #   @return [::String]
        #     Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is
        #     used to determine the authentication policy to be applied to terminate the
        #     inbound traffic at the identified backends. If this field is not set,
        #     authentication is disabled(open) for this endpoint.
        # @!attribute [rw] client_tls_policy
        #   @return [::String]
        #     Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy
        #     can be set to specify the authentication for traffic from the proxy to the
        #     actual endpoints. More specifically, it is applied to the outgoing traffic
        #     from the proxy to the endpoint. This is typically used for sidecar model
        #     where the proxy identifies itself as endpoint to the control plane, with
        #     the connection between sidecar and endpoint requiring authentication. If
        #     this field is not set, authentication is disabled(open). Applicable only
        #     when EndpointPolicyType is SIDECAR_PROXY.
        class EndpointPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of endpoint policy.
          module EndpointPolicyType
            # Default value. Must not be used.
            ENDPOINT_POLICY_TYPE_UNSPECIFIED = 0

            # Represents a proxy deployed as a sidecar.
            SIDECAR_PROXY = 1

            # Represents a proxyless gRPC backend.
            GRPC_SERVER = 2
          end
        end

        # Request used with the ListEndpointPolicies method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the EndpointPolicies should
        #     be listed, specified in the format `projects/*/locations/global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of EndpointPolicies to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListEndpointPoliciesResponse`
        #     Indicates that this is a continuation of a prior
        #     `ListEndpointPolicies` call, and that the system should return the
        #     next page of data.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If true, allow partial responses for multi-regional Aggregated
        #     List requests. Otherwise if one of the locations is down or unreachable,
        #     the Aggregated List request will fail.
        class ListEndpointPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListEndpointPolicies method.
        # @!attribute [rw] endpoint_policies
        #   @return [::Array<::Google::Cloud::NetworkServices::V1::EndpointPolicy>]
        #     List of EndpointPolicy resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources. Populated when the request opts into
        #     {::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest#return_partial_success return_partial_success}
        #     and reading across collections e.g. when
        #     attempting to list all resources across all supported locations.
        class ListEndpointPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the GetEndpointPolicy method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the EndpointPolicy to get. Must be in the format
        #     `projects/*/locations/global/endpointPolicies/*`.
        class GetEndpointPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the CreateEndpointPolicy method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the EndpointPolicy. Must be in the
        #     format `projects/*/locations/global`.
        # @!attribute [rw] endpoint_policy_id
        #   @return [::String]
        #     Required. Short name of the EndpointPolicy resource to be created.
        #     E.g. "CustomECS".
        # @!attribute [rw] endpoint_policy
        #   @return [::Google::Cloud::NetworkServices::V1::EndpointPolicy]
        #     Required. EndpointPolicy resource to be created.
        class CreateEndpointPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the UpdateEndpointPolicy method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     EndpointPolicy resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] endpoint_policy
        #   @return [::Google::Cloud::NetworkServices::V1::EndpointPolicy]
        #     Required. Updated EndpointPolicy resource.
        class UpdateEndpointPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used with the DeleteEndpointPolicy method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the EndpointPolicy to delete. Must be in the format
        #     `projects/*/locations/global/endpointPolicies/*`.
        class DeleteEndpointPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
