# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification of a port-based selector.
        # @!attribute [rw] ports
        #   @return [::Array<::String>]
        #     Optional. A list of ports. Can be port numbers or port range
        #     (example, [80-90] specifies all ports from 80 to 90, including
        #     80 and 90) or named ports or * to specify all ports. If the
        #     list is empty, all ports are selected.
        class TrafficPortSelector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A definition of a matcher that selects endpoints to which the policies
        # should be applied.
        # @!attribute [rw] metadata_label_matcher
        #   @return [::Google::Cloud::NetworkServices::V1::EndpointMatcher::MetadataLabelMatcher]
        #     The matcher is based on node metadata presented by xDS clients.
        class EndpointMatcher
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The matcher that is based on node metadata presented by xDS clients.
          # @!attribute [rw] metadata_label_match_criteria
          #   @return [::Google::Cloud::NetworkServices::V1::EndpointMatcher::MetadataLabelMatcher::MetadataLabelMatchCriteria]
          #     Specifies how matching should be done.
          #
          #     Supported values are:
          #     MATCH_ANY: At least one of the Labels specified in the
          #       matcher should match the metadata presented by xDS client.
          #     MATCH_ALL: The metadata presented by the xDS client should
          #       contain all of the labels specified here.
          #
          #     The selection is determined based on the best match. For
          #     example, suppose there are three EndpointPolicy
          #     resources P1, P2 and P3 and if P1 has a the matcher as
          #     MATCH_ANY <A:1, B:1>, P2 has MATCH_ALL <A:1,B:1>, and P3 has
          #     MATCH_ALL <A:1,B:1,C:1>.
          #
          #     If a client with label <A:1> connects, the config from P1
          #     will be selected.
          #
          #     If a client with label <A:1,B:1> connects, the config from P2
          #     will be selected.
          #
          #     If a client with label <A:1,B:1,C:1> connects, the config
          #     from P3 will be selected.
          #
          #     If there is more than one best match, (for example, if a
          #     config P4 with selector <A:1,D:1> exists and if a client with
          #     label <A:1,B:1,D:1> connects), pick up the one with older creation time.
          # @!attribute [rw] metadata_labels
          #   @return [::Array<::Google::Cloud::NetworkServices::V1::EndpointMatcher::MetadataLabelMatcher::MetadataLabels>]
          #     The list of label value pairs that must match labels in the
          #     provided metadata based on filterMatchCriteria This list can
          #     have at most 64 entries. The list can be empty if the match
          #     criteria is MATCH_ANY, to specify a wildcard match (i.e this
          #     matches any client).
          class MetadataLabelMatcher
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines a name-pair value for a single label.
            # @!attribute [rw] label_name
            #   @return [::String]
            #     Required. Label name presented as key in xDS Node Metadata.
            # @!attribute [rw] label_value
            #   @return [::String]
            #     Required. Label value presented as value corresponding to the above
            #     key, in xDS Node Metadata.
            class MetadataLabels
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible criteria values that define logic of how matching is made.
            module MetadataLabelMatchCriteria
              # Default value. Should not be used.
              METADATA_LABEL_MATCH_CRITERIA_UNSPECIFIED = 0

              # At least one of the Labels specified in the matcher should match the
              # metadata presented by xDS client.
              MATCH_ANY = 1

              # The metadata presented by the xDS client should contain all of the
              # labels specified here.
              MATCH_ALL = 2
            end
          end
        end

        # EnvoyHeader configuration for Mesh and Gateway
        module EnvoyHeaders
          # Defaults to NONE.
          ENVOY_HEADERS_UNSPECIFIED = 0

          # Suppress envoy debug headers.
          NONE = 1

          # Envoy will insert default internal debug headers into upstream requests:
          # x-envoy-attempt-count
          # x-envoy-is-timeout-retry
          # x-envoy-expected-rq-timeout-ms
          # x-envoy-original-path
          # x-envoy-upstream-stream-duration-ms
          DEBUG_HEADERS = 2
        end
      end
    end
  end
end
