# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        module NetworkServices
          # Path helper methods for the NetworkServices API.
          module Paths
            ##
            # Create a fully-qualified Address resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/addresses/{address}`
            #
            # @param project [String]
            # @param region [String]
            # @param address [String]
            #
            # @return [::String]
            def address_path project:, region:, address:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/addresses/#{address}"
            end

            ##
            # Create a fully-qualified AuthorizationPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param authorization_policy [String]
            #
            # @return [::String]
            def authorization_policy_path project:, location:, authorization_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/authorizationPolicies/#{authorization_policy}"
            end

            ##
            # Create a fully-qualified BackendService resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backendServices/{backend_service}`
            #
            # @param project [String]
            # @param location [String]
            # @param backend_service [String]
            #
            # @return [::String]
            def backend_service_path project:, location:, backend_service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backendServices/#{backend_service}"
            end

            ##
            # Create a fully-qualified Certificate resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/certificates/{certificate}`
            #
            # @param project [String]
            # @param location [String]
            # @param certificate [String]
            #
            # @return [::String]
            def certificate_path project:, location:, certificate:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/certificates/#{certificate}"
            end

            ##
            # Create a fully-qualified ClientTlsPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param client_tls_policy [String]
            #
            # @return [::String]
            def client_tls_policy_path project:, location:, client_tls_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clientTlsPolicies/#{client_tls_policy}"
            end

            ##
            # Create a fully-qualified EndpointPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/endpointPolicies/{endpoint_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param endpoint_policy [String]
            #
            # @return [::String]
            def endpoint_policy_path project:, location:, endpoint_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/endpointPolicies/#{endpoint_policy}"
            end

            ##
            # Create a fully-qualified Gateway resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/gateways/{gateway}`
            #
            # @param project [String]
            # @param location [String]
            # @param gateway [String]
            #
            # @return [::String]
            def gateway_path project:, location:, gateway:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/gateways/#{gateway}"
            end

            ##
            # Create a fully-qualified GatewayRouteView resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/gateways/{gateway}/routeViews/{route_view}`
            #
            # @param project [String]
            # @param location [String]
            # @param gateway [String]
            # @param route_view [String]
            #
            # @return [::String]
            def gateway_route_view_path project:, location:, gateway:, route_view:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "gateway cannot contain /" if gateway.to_s.include? "/"

              "projects/#{project}/locations/#{location}/gateways/#{gateway}/routeViews/#{route_view}"
            end

            ##
            # Create a fully-qualified GatewaySecurityPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/gatewaySecurityPolicies/{gateway_security_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param gateway_security_policy [String]
            #
            # @return [::String]
            def gateway_security_policy_path project:, location:, gateway_security_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/gatewaySecurityPolicies/#{gateway_security_policy}"
            end

            ##
            # Create a fully-qualified GrpcRoute resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/grpcRoutes/{grpc_route}`
            #
            # @param project [String]
            # @param location [String]
            # @param grpc_route [String]
            #
            # @return [::String]
            def grpc_route_path project:, location:, grpc_route:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/grpcRoutes/#{grpc_route}"
            end

            ##
            # Create a fully-qualified HttpRoute resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/httpRoutes/{http_route}`
            #
            # @param project [String]
            # @param location [String]
            # @param http_route [String]
            #
            # @return [::String]
            def http_route_path project:, location:, http_route:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/httpRoutes/#{http_route}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Mesh resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/meshes/{mesh}`
            #
            # @param project [String]
            # @param location [String]
            # @param mesh [String]
            #
            # @return [::String]
            def mesh_path project:, location:, mesh:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/meshes/#{mesh}"
            end

            ##
            # Create a fully-qualified MeshRouteView resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/meshes/{mesh}/routeViews/{route_view}`
            #
            # @param project [String]
            # @param location [String]
            # @param mesh [String]
            # @param route_view [String]
            #
            # @return [::String]
            def mesh_route_view_path project:, location:, mesh:, route_view:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "mesh cannot contain /" if mesh.to_s.include? "/"

              "projects/#{project}/locations/#{location}/meshes/#{mesh}/routeViews/#{route_view}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified ServerTlsPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param server_tls_policy [String]
            #
            # @return [::String]
            def server_tls_policy_path project:, location:, server_tls_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serverTlsPolicies/#{server_tls_policy}"
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`
            #
            # @param project [String]
            # @param location [String]
            # @param namespace [String]
            # @param service [String]
            #
            # @return [::String]
            def service_path project:, location:, namespace:, service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "namespace cannot contain /" if namespace.to_s.include? "/"

              "projects/#{project}/locations/#{location}/namespaces/#{namespace}/services/#{service}"
            end

            ##
            # Create a fully-qualified ServiceBinding resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serviceBindings/{service_binding}`
            #
            # @param project [String]
            # @param location [String]
            # @param service_binding [String]
            #
            # @return [::String]
            def service_binding_path project:, location:, service_binding:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serviceBindings/#{service_binding}"
            end

            ##
            # Create a fully-qualified ServiceLbPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param service_lb_policy [String]
            #
            # @return [::String]
            def service_lb_policy_path project:, location:, service_lb_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serviceLbPolicies/#{service_lb_policy}"
            end

            ##
            # Create a fully-qualified Subnetwork resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
            #
            # @param project [String]
            # @param region [String]
            # @param subnetwork [String]
            #
            # @return [::String]
            def subnetwork_path project:, region:, subnetwork:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/subnetworks/#{subnetwork}"
            end

            ##
            # Create a fully-qualified TcpRoute resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tcpRoutes/{tcp_route}`
            #
            # @param project [String]
            # @param location [String]
            # @param tcp_route [String]
            #
            # @return [::String]
            def tcp_route_path project:, location:, tcp_route:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tcpRoutes/#{tcp_route}"
            end

            ##
            # Create a fully-qualified TlsRoute resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tlsRoutes/{tls_route}`
            #
            # @param project [String]
            # @param location [String]
            # @param tls_route [String]
            #
            # @return [::String]
            def tls_route_path project:, location:, tls_route:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tlsRoutes/#{tls_route}"
            end

            ##
            # Create a fully-qualified WasmPlugin resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}`
            #
            # @param project [String]
            # @param location [String]
            # @param wasm_plugin [String]
            #
            # @return [::String]
            def wasm_plugin_path project:, location:, wasm_plugin:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/wasmPlugins/#{wasm_plugin}"
            end

            ##
            # Create a fully-qualified WasmPluginVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}/versions/{wasm_plugin_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param wasm_plugin [String]
            # @param wasm_plugin_version [String]
            #
            # @return [::String]
            def wasm_plugin_version_path project:, location:, wasm_plugin:, wasm_plugin_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "wasm_plugin cannot contain /" if wasm_plugin.to_s.include? "/"

              "projects/#{project}/locations/#{location}/wasmPlugins/#{wasm_plugin}/versions/#{wasm_plugin_version}"
            end

            extend self
          end
        end
      end
    end
  end
end
