# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networkservices/v1/network_services_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkServices
      module V1
        module NetworkServices
          ##
          # Client for the NetworkServices service.
          #
          # Service describing handlers for resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networkservices.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :network_services_stub

            ##
            # Configure the NetworkServices Client class.
            #
            # See {::Google::Cloud::NetworkServices::V1::NetworkServices::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all NetworkServices clients
            #   ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkServices", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the NetworkServices Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkServices::V1::NetworkServices::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @network_services_stub.universe_domain
            end

            ##
            # Create a new NetworkServices client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the NetworkServices client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networkservices/v1/network_services_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @network_services_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkServices::V1::NetworkServices::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @network_services_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @network_services_stub.endpoint
                config.universe_domain = @network_services_stub.universe_domain
                config.logger = @network_services_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @network_services_stub.endpoint
                config.universe_domain = @network_services_stub.universe_domain
                config.logger = @network_services_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::NetworkServices::V1::NetworkServices::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @network_services_stub.logger
            end

            # Service calls

            ##
            # Lists EndpointPolicies in a given project and location.
            #
            # @overload list_endpoint_policies(request, options = nil)
            #   Pass arguments to `list_endpoint_policies` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_endpoint_policies(parent: nil, page_size: nil, page_token: nil, return_partial_success: nil)
            #   Pass arguments to `list_endpoint_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the EndpointPolicies should
            #     be listed, specified in the format `projects/*/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of EndpointPolicies to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListEndpointPoliciesResponse`
            #     Indicates that this is a continuation of a prior
            #     `ListEndpointPolicies` call, and that the system should return the
            #     next page of data.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests. Otherwise if one of the locations is down or unreachable,
            #     the Aggregated List request will fail.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::EndpointPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::EndpointPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest.new
            #
            #   # Call the list_endpoint_policies method.
            #   result = client.list_endpoint_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::EndpointPolicy.
            #     p item
            #   end
            #
            def list_endpoint_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListEndpointPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_endpoint_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_endpoint_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_endpoint_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_endpoint_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_endpoint_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single EndpointPolicy.
            #
            # @overload get_endpoint_policy(request, options = nil)
            #   Pass arguments to `get_endpoint_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_endpoint_policy(name: nil)
            #   Pass arguments to `get_endpoint_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the EndpointPolicy to get. Must be in the format
            #     `projects/*/locations/global/endpointPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::EndpointPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::EndpointPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest.new
            #
            #   # Call the get_endpoint_policy method.
            #   result = client.get_endpoint_policy request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::EndpointPolicy.
            #   p result
            #
            def get_endpoint_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetEndpointPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_endpoint_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_endpoint_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_endpoint_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_endpoint_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new EndpointPolicy in a given project and location.
            #
            # @overload create_endpoint_policy(request, options = nil)
            #   Pass arguments to `create_endpoint_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_endpoint_policy(parent: nil, endpoint_policy_id: nil, endpoint_policy: nil)
            #   Pass arguments to `create_endpoint_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the EndpointPolicy. Must be in the
            #     format `projects/*/locations/global`.
            #   @param endpoint_policy_id [::String]
            #     Required. Short name of the EndpointPolicy resource to be created.
            #     E.g. "CustomECS".
            #   @param endpoint_policy [::Google::Cloud::NetworkServices::V1::EndpointPolicy, ::Hash]
            #     Required. EndpointPolicy resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest.new
            #
            #   # Call the create_endpoint_policy method.
            #   result = client.create_endpoint_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_endpoint_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateEndpointPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_endpoint_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_endpoint_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_endpoint_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_endpoint_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single EndpointPolicy.
            #
            # @overload update_endpoint_policy(request, options = nil)
            #   Pass arguments to `update_endpoint_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_endpoint_policy(update_mask: nil, endpoint_policy: nil)
            #   Pass arguments to `update_endpoint_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     EndpointPolicy resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param endpoint_policy [::Google::Cloud::NetworkServices::V1::EndpointPolicy, ::Hash]
            #     Required. Updated EndpointPolicy resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest.new
            #
            #   # Call the update_endpoint_policy method.
            #   result = client.update_endpoint_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_endpoint_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateEndpointPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_endpoint_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.endpoint_policy&.name
                header_params["endpoint_policy.name"] = request.endpoint_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_endpoint_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_endpoint_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_endpoint_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single EndpointPolicy.
            #
            # @overload delete_endpoint_policy(request, options = nil)
            #   Pass arguments to `delete_endpoint_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_endpoint_policy(name: nil)
            #   Pass arguments to `delete_endpoint_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the EndpointPolicy to delete. Must be in the format
            #     `projects/*/locations/global/endpointPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest.new
            #
            #   # Call the delete_endpoint_policy method.
            #   result = client.delete_endpoint_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_endpoint_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteEndpointPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_endpoint_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_endpoint_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_endpoint_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_endpoint_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `WasmPluginVersion` resources in a given project and
            # location.
            #
            # @overload list_wasm_plugin_versions(request, options = nil)
            #   Pass arguments to `list_wasm_plugin_versions` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_wasm_plugin_versions(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_wasm_plugin_versions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The `WasmPlugin` resource whose `WasmPluginVersion`s
            #     are listed, specified in the following format:
            #     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
            #   @param page_size [::Integer]
            #     Maximum number of `WasmPluginVersion` resources to return per
            #     call. If not specified, at most 50 `WasmPluginVersion` resources are
            #     returned. The maximum value is 1000; values above 1000 are coerced to
            #     1000.
            #   @param page_token [::String]
            #     The value returned by the last `ListWasmPluginVersionsResponse` call.
            #     Indicates that this is a continuation of a prior
            #     `ListWasmPluginVersions` call, and that the
            #     next page of data is to be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::WasmPluginVersion>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::WasmPluginVersion>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest.new
            #
            #   # Call the list_wasm_plugin_versions method.
            #   result = client.list_wasm_plugin_versions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::WasmPluginVersion.
            #     p item
            #   end
            #
            def list_wasm_plugin_versions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListWasmPluginVersionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_wasm_plugin_versions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_wasm_plugin_versions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_wasm_plugin_versions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_wasm_plugin_versions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_wasm_plugin_versions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of the specified `WasmPluginVersion` resource.
            #
            # @overload get_wasm_plugin_version(request, options = nil)
            #   Pass arguments to `get_wasm_plugin_version` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_wasm_plugin_version(name: nil)
            #   Pass arguments to `get_wasm_plugin_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the `WasmPluginVersion` resource to get. Must be in
            #     the format
            #     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}/versions/{wasm_plugin_version}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::WasmPluginVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::WasmPluginVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest.new
            #
            #   # Call the get_wasm_plugin_version method.
            #   result = client.get_wasm_plugin_version request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::WasmPluginVersion.
            #   p result
            #
            def get_wasm_plugin_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetWasmPluginVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_wasm_plugin_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_wasm_plugin_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_wasm_plugin_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_wasm_plugin_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new `WasmPluginVersion` resource in a given project
            # and location.
            #
            # @overload create_wasm_plugin_version(request, options = nil)
            #   Pass arguments to `create_wasm_plugin_version` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_wasm_plugin_version(parent: nil, wasm_plugin_version_id: nil, wasm_plugin_version: nil)
            #   Pass arguments to `create_wasm_plugin_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the `WasmPluginVersion` resource. Must be
            #     in the format
            #     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
            #   @param wasm_plugin_version_id [::String]
            #     Required. User-provided ID of the `WasmPluginVersion` resource to be
            #     created.
            #   @param wasm_plugin_version [::Google::Cloud::NetworkServices::V1::WasmPluginVersion, ::Hash]
            #     Required. `WasmPluginVersion` resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest.new
            #
            #   # Call the create_wasm_plugin_version method.
            #   result = client.create_wasm_plugin_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_wasm_plugin_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateWasmPluginVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_wasm_plugin_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_wasm_plugin_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_wasm_plugin_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_wasm_plugin_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified `WasmPluginVersion` resource.
            #
            # @overload delete_wasm_plugin_version(request, options = nil)
            #   Pass arguments to `delete_wasm_plugin_version` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_wasm_plugin_version(name: nil)
            #   Pass arguments to `delete_wasm_plugin_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the `WasmPluginVersion` resource to delete. Must be in
            #     the format
            #     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}/versions/{wasm_plugin_version}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest.new
            #
            #   # Call the delete_wasm_plugin_version method.
            #   result = client.delete_wasm_plugin_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_wasm_plugin_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_wasm_plugin_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_wasm_plugin_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_wasm_plugin_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_wasm_plugin_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `WasmPlugin` resources in a given project and
            # location.
            #
            # @overload list_wasm_plugins(request, options = nil)
            #   Pass arguments to `list_wasm_plugins` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_wasm_plugins(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_wasm_plugins` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the `WasmPlugin` resources
            #     are listed, specified in the following format:
            #     `projects/{project}/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of `WasmPlugin` resources to return per call.
            #     If not specified, at most 50 `WasmPlugin` resources are returned.
            #     The maximum value is 1000; values above 1000 are coerced to 1000.
            #   @param page_token [::String]
            #     The value returned by the last `ListWasmPluginsResponse` call.
            #     Indicates that this is a continuation of a prior
            #     `ListWasmPlugins` call, and that the
            #     next page of data is to be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::WasmPlugin>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::WasmPlugin>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest.new
            #
            #   # Call the list_wasm_plugins method.
            #   result = client.list_wasm_plugins request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::WasmPlugin.
            #     p item
            #   end
            #
            def list_wasm_plugins request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListWasmPluginsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_wasm_plugins.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_wasm_plugins.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_wasm_plugins.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_wasm_plugins, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_wasm_plugins, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of the specified `WasmPlugin` resource.
            #
            # @overload get_wasm_plugin(request, options = nil)
            #   Pass arguments to `get_wasm_plugin` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_wasm_plugin(name: nil, view: nil)
            #   Pass arguments to `get_wasm_plugin` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the `WasmPlugin` resource to get. Must be in the
            #     format `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
            #   @param view [::Google::Cloud::NetworkServices::V1::WasmPluginView]
            #     Determines how much data must be returned in the response. See
            #     [AIP-157](https://google.aip.dev/157).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::WasmPlugin]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::WasmPlugin]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetWasmPluginRequest.new
            #
            #   # Call the get_wasm_plugin method.
            #   result = client.get_wasm_plugin request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::WasmPlugin.
            #   p result
            #
            def get_wasm_plugin request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetWasmPluginRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_wasm_plugin.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_wasm_plugin.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_wasm_plugin.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_wasm_plugin, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new `WasmPlugin` resource in a given project
            # and location.
            #
            # @overload create_wasm_plugin(request, options = nil)
            #   Pass arguments to `create_wasm_plugin` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_wasm_plugin(parent: nil, wasm_plugin_id: nil, wasm_plugin: nil)
            #   Pass arguments to `create_wasm_plugin` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the `WasmPlugin` resource. Must be in the
            #     format `projects/{project}/locations/global`.
            #   @param wasm_plugin_id [::String]
            #     Required. User-provided ID of the `WasmPlugin` resource to be created.
            #   @param wasm_plugin [::Google::Cloud::NetworkServices::V1::WasmPlugin, ::Hash]
            #     Required. `WasmPlugin` resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest.new
            #
            #   # Call the create_wasm_plugin method.
            #   result = client.create_wasm_plugin request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_wasm_plugin request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateWasmPluginRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_wasm_plugin.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_wasm_plugin.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_wasm_plugin.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_wasm_plugin, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of the specified `WasmPlugin` resource.
            #
            # @overload update_wasm_plugin(request, options = nil)
            #   Pass arguments to `update_wasm_plugin` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_wasm_plugin(update_mask: nil, wasm_plugin: nil)
            #   Pass arguments to `update_wasm_plugin` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Used to specify the fields to be overwritten in the
            #     `WasmPlugin` resource by the update.
            #     The fields specified in the `update_mask` field are relative to the
            #     resource, not the full request.
            #     An omitted `update_mask` field is treated as an implied `update_mask`
            #     field equivalent to all fields that are populated (that have a non-empty
            #     value).
            #     The `update_mask` field supports a special value `*`, which means that
            #     each field in the given `WasmPlugin` resource (including the empty ones)
            #     replaces the current value.
            #   @param wasm_plugin [::Google::Cloud::NetworkServices::V1::WasmPlugin, ::Hash]
            #     Required. Updated `WasmPlugin` resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest.new
            #
            #   # Call the update_wasm_plugin method.
            #   result = client.update_wasm_plugin request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_wasm_plugin request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateWasmPluginRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_wasm_plugin.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.wasm_plugin&.name
                header_params["wasm_plugin.name"] = request.wasm_plugin.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_wasm_plugin.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_wasm_plugin.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_wasm_plugin, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified `WasmPlugin` resource.
            #
            # @overload delete_wasm_plugin(request, options = nil)
            #   Pass arguments to `delete_wasm_plugin` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_wasm_plugin(name: nil)
            #   Pass arguments to `delete_wasm_plugin` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the `WasmPlugin` resource to delete. Must be in the
            #     format `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest.new
            #
            #   # Call the delete_wasm_plugin method.
            #   result = client.delete_wasm_plugin request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_wasm_plugin request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteWasmPluginRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_wasm_plugin.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_wasm_plugin.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_wasm_plugin.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_wasm_plugin, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Gateways in a given project and location.
            #
            # @overload list_gateways(request, options = nil)
            #   Pass arguments to `list_gateways` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListGatewaysRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListGatewaysRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_gateways(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_gateways` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the Gateways should be
            #     listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of Gateways to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListGatewaysResponse`
            #     Indicates that this is a continuation of a prior `ListGateways` call,
            #     and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::Gateway>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::Gateway>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListGatewaysRequest.new
            #
            #   # Call the list_gateways method.
            #   result = client.list_gateways request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::Gateway.
            #     p item
            #   end
            #
            def list_gateways request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListGatewaysRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_gateways.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_gateways.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_gateways.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_gateways, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_gateways, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Gateway.
            #
            # @overload get_gateway(request, options = nil)
            #   Pass arguments to `get_gateway` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetGatewayRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetGatewayRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_gateway(name: nil)
            #   Pass arguments to `get_gateway` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the Gateway to get. Must be in the format
            #     `projects/*/locations/*/gateways/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::Gateway]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::Gateway]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetGatewayRequest.new
            #
            #   # Call the get_gateway method.
            #   result = client.get_gateway request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::Gateway.
            #   p result
            #
            def get_gateway request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetGatewayRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_gateway.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_gateway.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_gateway.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_gateway, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Gateway in a given project and location.
            #
            # @overload create_gateway(request, options = nil)
            #   Pass arguments to `create_gateway` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateGatewayRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateGatewayRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_gateway(parent: nil, gateway_id: nil, gateway: nil)
            #   Pass arguments to `create_gateway` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the Gateway. Must be in the
            #     format `projects/*/locations/*`.
            #   @param gateway_id [::String]
            #     Required. Short name of the Gateway resource to be created.
            #   @param gateway [::Google::Cloud::NetworkServices::V1::Gateway, ::Hash]
            #     Required. Gateway resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateGatewayRequest.new
            #
            #   # Call the create_gateway method.
            #   result = client.create_gateway request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_gateway request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateGatewayRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_gateway.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_gateway.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_gateway.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_gateway, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Gateway.
            #
            # @overload update_gateway(request, options = nil)
            #   Pass arguments to `update_gateway` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_gateway(update_mask: nil, gateway: nil)
            #   Pass arguments to `update_gateway` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     Gateway resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param gateway [::Google::Cloud::NetworkServices::V1::Gateway, ::Hash]
            #     Required. Updated Gateway resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateGatewayRequest.new
            #
            #   # Call the update_gateway method.
            #   result = client.update_gateway request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_gateway request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateGatewayRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_gateway.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.gateway&.name
                header_params["gateway.name"] = request.gateway.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_gateway.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_gateway.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_gateway, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Gateway.
            #
            # @overload delete_gateway(request, options = nil)
            #   Pass arguments to `delete_gateway` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_gateway(name: nil)
            #   Pass arguments to `delete_gateway` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the Gateway to delete. Must be in the format
            #     `projects/*/locations/*/gateways/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteGatewayRequest.new
            #
            #   # Call the delete_gateway method.
            #   result = client.delete_gateway request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_gateway request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteGatewayRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_gateway.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_gateway.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_gateway.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_gateway, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists GrpcRoutes in a given project and location.
            #
            # @overload list_grpc_routes(request, options = nil)
            #   Pass arguments to `list_grpc_routes` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_grpc_routes(parent: nil, page_size: nil, page_token: nil, return_partial_success: nil)
            #   Pass arguments to `list_grpc_routes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the GrpcRoutes should be
            #     listed, specified in the format `projects/*/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of GrpcRoutes to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListGrpcRoutesResponse`
            #     Indicates that this is a continuation of a prior `ListGrpcRoutes` call,
            #     and that the system should return the next page of data.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests. Otherwise if one of the locations is down or unreachable,
            #     the Aggregated List request will fail.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::GrpcRoute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::GrpcRoute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest.new
            #
            #   # Call the list_grpc_routes method.
            #   result = client.list_grpc_routes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::GrpcRoute.
            #     p item
            #   end
            #
            def list_grpc_routes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListGrpcRoutesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_grpc_routes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_grpc_routes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_grpc_routes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_grpc_routes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_grpc_routes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single GrpcRoute.
            #
            # @overload get_grpc_route(request, options = nil)
            #   Pass arguments to `get_grpc_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_grpc_route(name: nil)
            #   Pass arguments to `get_grpc_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the GrpcRoute to get. Must be in the format
            #     `projects/*/locations/global/grpcRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::GrpcRoute]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::GrpcRoute]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest.new
            #
            #   # Call the get_grpc_route method.
            #   result = client.get_grpc_route request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::GrpcRoute.
            #   p result
            #
            def get_grpc_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetGrpcRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_grpc_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_grpc_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_grpc_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_grpc_route, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new GrpcRoute in a given project and location.
            #
            # @overload create_grpc_route(request, options = nil)
            #   Pass arguments to `create_grpc_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_grpc_route(parent: nil, grpc_route_id: nil, grpc_route: nil)
            #   Pass arguments to `create_grpc_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the GrpcRoute. Must be in the
            #     format `projects/*/locations/global`.
            #   @param grpc_route_id [::String]
            #     Required. Short name of the GrpcRoute resource to be created.
            #   @param grpc_route [::Google::Cloud::NetworkServices::V1::GrpcRoute, ::Hash]
            #     Required. GrpcRoute resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest.new
            #
            #   # Call the create_grpc_route method.
            #   result = client.create_grpc_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_grpc_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateGrpcRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_grpc_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_grpc_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_grpc_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_grpc_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single GrpcRoute.
            #
            # @overload update_grpc_route(request, options = nil)
            #   Pass arguments to `update_grpc_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_grpc_route(update_mask: nil, grpc_route: nil)
            #   Pass arguments to `update_grpc_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     GrpcRoute resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param grpc_route [::Google::Cloud::NetworkServices::V1::GrpcRoute, ::Hash]
            #     Required. Updated GrpcRoute resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest.new
            #
            #   # Call the update_grpc_route method.
            #   result = client.update_grpc_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_grpc_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateGrpcRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_grpc_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.grpc_route&.name
                header_params["grpc_route.name"] = request.grpc_route.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_grpc_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_grpc_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_grpc_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single GrpcRoute.
            #
            # @overload delete_grpc_route(request, options = nil)
            #   Pass arguments to `delete_grpc_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_grpc_route(name: nil)
            #   Pass arguments to `delete_grpc_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the GrpcRoute to delete. Must be in the format
            #     `projects/*/locations/global/grpcRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest.new
            #
            #   # Call the delete_grpc_route method.
            #   result = client.delete_grpc_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_grpc_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteGrpcRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_grpc_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_grpc_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_grpc_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_grpc_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists HttpRoute in a given project and location.
            #
            # @overload list_http_routes(request, options = nil)
            #   Pass arguments to `list_http_routes` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_http_routes(parent: nil, page_size: nil, page_token: nil, return_partial_success: nil)
            #   Pass arguments to `list_http_routes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the HttpRoutes should be
            #     listed, specified in the format `projects/*/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of HttpRoutes to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListHttpRoutesResponse`
            #     Indicates that this is a continuation of a prior `ListHttpRoutes` call,
            #     and that the system should return the next page of data.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests. Otherwise if one of the locations is down or unreachable,
            #     the Aggregated List request will fail.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::HttpRoute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::HttpRoute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest.new
            #
            #   # Call the list_http_routes method.
            #   result = client.list_http_routes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::HttpRoute.
            #     p item
            #   end
            #
            def list_http_routes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListHttpRoutesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_http_routes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_http_routes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_http_routes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_http_routes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_http_routes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single HttpRoute.
            #
            # @overload get_http_route(request, options = nil)
            #   Pass arguments to `get_http_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_http_route(name: nil)
            #   Pass arguments to `get_http_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the HttpRoute to get. Must be in the format
            #     `projects/*/locations/global/httpRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::HttpRoute]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::HttpRoute]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetHttpRouteRequest.new
            #
            #   # Call the get_http_route method.
            #   result = client.get_http_route request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::HttpRoute.
            #   p result
            #
            def get_http_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetHttpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_http_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_http_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_http_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_http_route, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new HttpRoute in a given project and location.
            #
            # @overload create_http_route(request, options = nil)
            #   Pass arguments to `create_http_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_http_route(parent: nil, http_route_id: nil, http_route: nil)
            #   Pass arguments to `create_http_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the HttpRoute. Must be in the
            #     format `projects/*/locations/global`.
            #   @param http_route_id [::String]
            #     Required. Short name of the HttpRoute resource to be created.
            #   @param http_route [::Google::Cloud::NetworkServices::V1::HttpRoute, ::Hash]
            #     Required. HttpRoute resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest.new
            #
            #   # Call the create_http_route method.
            #   result = client.create_http_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_http_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateHttpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_http_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_http_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_http_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_http_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single HttpRoute.
            #
            # @overload update_http_route(request, options = nil)
            #   Pass arguments to `update_http_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_http_route(update_mask: nil, http_route: nil)
            #   Pass arguments to `update_http_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     HttpRoute resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param http_route [::Google::Cloud::NetworkServices::V1::HttpRoute, ::Hash]
            #     Required. Updated HttpRoute resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest.new
            #
            #   # Call the update_http_route method.
            #   result = client.update_http_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_http_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateHttpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_http_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.http_route&.name
                header_params["http_route.name"] = request.http_route.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_http_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_http_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_http_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single HttpRoute.
            #
            # @overload delete_http_route(request, options = nil)
            #   Pass arguments to `delete_http_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_http_route(name: nil)
            #   Pass arguments to `delete_http_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the HttpRoute to delete. Must be in the format
            #     `projects/*/locations/global/httpRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest.new
            #
            #   # Call the delete_http_route method.
            #   result = client.delete_http_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_http_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteHttpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_http_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_http_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_http_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_http_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists TcpRoute in a given project and location.
            #
            # @overload list_tcp_routes(request, options = nil)
            #   Pass arguments to `list_tcp_routes` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_tcp_routes(parent: nil, page_size: nil, page_token: nil, return_partial_success: nil)
            #   Pass arguments to `list_tcp_routes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the TcpRoutes should be
            #     listed, specified in the format `projects/*/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of TcpRoutes to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListTcpRoutesResponse`
            #     Indicates that this is a continuation of a prior `ListTcpRoutes` call,
            #     and that the system should return the next page of data.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests. Otherwise if one of the locations is down or unreachable,
            #     the Aggregated List request will fail.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::TcpRoute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::TcpRoute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest.new
            #
            #   # Call the list_tcp_routes method.
            #   result = client.list_tcp_routes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::TcpRoute.
            #     p item
            #   end
            #
            def list_tcp_routes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListTcpRoutesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_tcp_routes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_tcp_routes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_tcp_routes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_tcp_routes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_tcp_routes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single TcpRoute.
            #
            # @overload get_tcp_route(request, options = nil)
            #   Pass arguments to `get_tcp_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_tcp_route(name: nil)
            #   Pass arguments to `get_tcp_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the TcpRoute to get. Must be in the format
            #     `projects/*/locations/global/tcpRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::TcpRoute]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::TcpRoute]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetTcpRouteRequest.new
            #
            #   # Call the get_tcp_route method.
            #   result = client.get_tcp_route request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::TcpRoute.
            #   p result
            #
            def get_tcp_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetTcpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_tcp_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_tcp_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_tcp_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_tcp_route, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new TcpRoute in a given project and location.
            #
            # @overload create_tcp_route(request, options = nil)
            #   Pass arguments to `create_tcp_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_tcp_route(parent: nil, tcp_route_id: nil, tcp_route: nil)
            #   Pass arguments to `create_tcp_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the TcpRoute. Must be in the
            #     format `projects/*/locations/global`.
            #   @param tcp_route_id [::String]
            #     Required. Short name of the TcpRoute resource to be created.
            #   @param tcp_route [::Google::Cloud::NetworkServices::V1::TcpRoute, ::Hash]
            #     Required. TcpRoute resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest.new
            #
            #   # Call the create_tcp_route method.
            #   result = client.create_tcp_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_tcp_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateTcpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_tcp_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_tcp_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_tcp_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_tcp_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single TcpRoute.
            #
            # @overload update_tcp_route(request, options = nil)
            #   Pass arguments to `update_tcp_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_tcp_route(update_mask: nil, tcp_route: nil)
            #   Pass arguments to `update_tcp_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     TcpRoute resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param tcp_route [::Google::Cloud::NetworkServices::V1::TcpRoute, ::Hash]
            #     Required. Updated TcpRoute resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest.new
            #
            #   # Call the update_tcp_route method.
            #   result = client.update_tcp_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_tcp_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateTcpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_tcp_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.tcp_route&.name
                header_params["tcp_route.name"] = request.tcp_route.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_tcp_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_tcp_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_tcp_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single TcpRoute.
            #
            # @overload delete_tcp_route(request, options = nil)
            #   Pass arguments to `delete_tcp_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_tcp_route(name: nil)
            #   Pass arguments to `delete_tcp_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the TcpRoute to delete. Must be in the format
            #     `projects/*/locations/global/tcpRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest.new
            #
            #   # Call the delete_tcp_route method.
            #   result = client.delete_tcp_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_tcp_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteTcpRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_tcp_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_tcp_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_tcp_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_tcp_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists TlsRoute in a given project and location.
            #
            # @overload list_tls_routes(request, options = nil)
            #   Pass arguments to `list_tls_routes` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_tls_routes(parent: nil, page_size: nil, page_token: nil, return_partial_success: nil)
            #   Pass arguments to `list_tls_routes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the TlsRoutes should be
            #     listed, specified in the format `projects/*/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of TlsRoutes to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListTlsRoutesResponse`
            #     Indicates that this is a continuation of a prior `ListTlsRoutes` call,
            #     and that the system should return the next page of data.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests. Otherwise if one of the locations is down or unreachable,
            #     the Aggregated List request will fail.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::TlsRoute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::TlsRoute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest.new
            #
            #   # Call the list_tls_routes method.
            #   result = client.list_tls_routes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::TlsRoute.
            #     p item
            #   end
            #
            def list_tls_routes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListTlsRoutesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_tls_routes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_tls_routes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_tls_routes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_tls_routes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_tls_routes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single TlsRoute.
            #
            # @overload get_tls_route(request, options = nil)
            #   Pass arguments to `get_tls_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_tls_route(name: nil)
            #   Pass arguments to `get_tls_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the TlsRoute to get. Must be in the format
            #     `projects/*/locations/global/tlsRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::TlsRoute]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::TlsRoute]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetTlsRouteRequest.new
            #
            #   # Call the get_tls_route method.
            #   result = client.get_tls_route request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::TlsRoute.
            #   p result
            #
            def get_tls_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetTlsRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_tls_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_tls_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_tls_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_tls_route, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new TlsRoute in a given project and location.
            #
            # @overload create_tls_route(request, options = nil)
            #   Pass arguments to `create_tls_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_tls_route(parent: nil, tls_route_id: nil, tls_route: nil)
            #   Pass arguments to `create_tls_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the TlsRoute. Must be in the
            #     format `projects/*/locations/global`.
            #   @param tls_route_id [::String]
            #     Required. Short name of the TlsRoute resource to be created.
            #   @param tls_route [::Google::Cloud::NetworkServices::V1::TlsRoute, ::Hash]
            #     Required. TlsRoute resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest.new
            #
            #   # Call the create_tls_route method.
            #   result = client.create_tls_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_tls_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateTlsRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_tls_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_tls_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_tls_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_tls_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single TlsRoute.
            #
            # @overload update_tls_route(request, options = nil)
            #   Pass arguments to `update_tls_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_tls_route(update_mask: nil, tls_route: nil)
            #   Pass arguments to `update_tls_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     TlsRoute resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param tls_route [::Google::Cloud::NetworkServices::V1::TlsRoute, ::Hash]
            #     Required. Updated TlsRoute resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest.new
            #
            #   # Call the update_tls_route method.
            #   result = client.update_tls_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_tls_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateTlsRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_tls_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.tls_route&.name
                header_params["tls_route.name"] = request.tls_route.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_tls_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_tls_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_tls_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single TlsRoute.
            #
            # @overload delete_tls_route(request, options = nil)
            #   Pass arguments to `delete_tls_route` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_tls_route(name: nil)
            #   Pass arguments to `delete_tls_route` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the TlsRoute to delete. Must be in the format
            #     `projects/*/locations/global/tlsRoutes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest.new
            #
            #   # Call the delete_tls_route method.
            #   result = client.delete_tls_route request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_tls_route request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteTlsRouteRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_tls_route.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_tls_route.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_tls_route.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_tls_route, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ServiceBinding in a given project and location.
            #
            # @overload list_service_bindings(request, options = nil)
            #   Pass arguments to `list_service_bindings` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_bindings(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_service_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the ServiceBindings should be
            #     listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of ServiceBindings to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListServiceBindingsResponse`
            #     Indicates that this is a continuation of a prior `ListRouters` call,
            #     and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::ServiceBinding>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::ServiceBinding>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest.new
            #
            #   # Call the list_service_bindings method.
            #   result = client.list_service_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::ServiceBinding.
            #     p item
            #   end
            #
            def list_service_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListServiceBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_bindings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_service_bindings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_service_bindings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServiceBinding.
            #
            # @overload get_service_binding(request, options = nil)
            #   Pass arguments to `get_service_binding` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_binding(name: nil)
            #   Pass arguments to `get_service_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ServiceBinding to get. Must be in the format
            #     `projects/*/locations/*/serviceBindings/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::ServiceBinding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::ServiceBinding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetServiceBindingRequest.new
            #
            #   # Call the get_service_binding method.
            #   result = client.get_service_binding request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::ServiceBinding.
            #   p result
            #
            def get_service_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetServiceBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_service_binding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ServiceBinding in a given project and location.
            #
            # @overload create_service_binding(request, options = nil)
            #   Pass arguments to `create_service_binding` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_binding(parent: nil, service_binding_id: nil, service_binding: nil)
            #   Pass arguments to `create_service_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the ServiceBinding. Must be in the
            #     format `projects/*/locations/*`.
            #   @param service_binding_id [::String]
            #     Required. Short name of the ServiceBinding resource to be created.
            #   @param service_binding [::Google::Cloud::NetworkServices::V1::ServiceBinding, ::Hash]
            #     Required. ServiceBinding resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest.new
            #
            #   # Call the create_service_binding method.
            #   result = client.create_service_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateServiceBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_service_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ServiceBinding.
            #
            # @overload update_service_binding(request, options = nil)
            #   Pass arguments to `update_service_binding` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service_binding(update_mask: nil, service_binding: nil)
            #   Pass arguments to `update_service_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ServiceBinding resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param service_binding [::Google::Cloud::NetworkServices::V1::ServiceBinding, ::Hash]
            #     Required. Updated ServiceBinding resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest.new
            #
            #   # Call the update_service_binding method.
            #   result = client.update_service_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_service_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateServiceBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service_binding&.name
                header_params["service_binding.name"] = request.service_binding.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_service_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServiceBinding.
            #
            # @overload delete_service_binding(request, options = nil)
            #   Pass arguments to `delete_service_binding` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_binding(name: nil)
            #   Pass arguments to `delete_service_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ServiceBinding to delete. Must be in the format
            #     `projects/*/locations/*/serviceBindings/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest.new
            #
            #   # Call the delete_service_binding method.
            #   result = client.delete_service_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteServiceBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_service_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Meshes in a given project and location.
            #
            # @overload list_meshes(request, options = nil)
            #   Pass arguments to `list_meshes` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListMeshesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListMeshesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_meshes(parent: nil, page_size: nil, page_token: nil, return_partial_success: nil)
            #   Pass arguments to `list_meshes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the Meshes should be
            #     listed, specified in the format `projects/*/locations/global`.
            #   @param page_size [::Integer]
            #     Maximum number of Meshes to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListMeshesResponse`
            #     Indicates that this is a continuation of a prior `ListMeshes` call,
            #     and that the system should return the next page of data.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests. Otherwise if one of the locations is down or unreachable,
            #     the Aggregated List request will fail.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::Mesh>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::Mesh>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListMeshesRequest.new
            #
            #   # Call the list_meshes method.
            #   result = client.list_meshes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::Mesh.
            #     p item
            #   end
            #
            def list_meshes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListMeshesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_meshes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_meshes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_meshes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_meshes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_meshes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Mesh.
            #
            # @overload get_mesh(request, options = nil)
            #   Pass arguments to `get_mesh` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetMeshRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetMeshRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_mesh(name: nil)
            #   Pass arguments to `get_mesh` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the Mesh to get. Must be in the format
            #     `projects/*/locations/global/meshes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::Mesh]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::Mesh]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetMeshRequest.new
            #
            #   # Call the get_mesh method.
            #   result = client.get_mesh request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::Mesh.
            #   p result
            #
            def get_mesh request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetMeshRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_mesh.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_mesh.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_mesh.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_mesh, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Mesh in a given project and location.
            #
            # @overload create_mesh(request, options = nil)
            #   Pass arguments to `create_mesh` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateMeshRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateMeshRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_mesh(parent: nil, mesh_id: nil, mesh: nil)
            #   Pass arguments to `create_mesh` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the Mesh. Must be in the
            #     format `projects/*/locations/global`.
            #   @param mesh_id [::String]
            #     Required. Short name of the Mesh resource to be created.
            #   @param mesh [::Google::Cloud::NetworkServices::V1::Mesh, ::Hash]
            #     Required. Mesh resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateMeshRequest.new
            #
            #   # Call the create_mesh method.
            #   result = client.create_mesh request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_mesh request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateMeshRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_mesh.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_mesh.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_mesh.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_mesh, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Mesh.
            #
            # @overload update_mesh(request, options = nil)
            #   Pass arguments to `update_mesh` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateMeshRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateMeshRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_mesh(update_mask: nil, mesh: nil)
            #   Pass arguments to `update_mesh` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     Mesh resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param mesh [::Google::Cloud::NetworkServices::V1::Mesh, ::Hash]
            #     Required. Updated Mesh resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateMeshRequest.new
            #
            #   # Call the update_mesh method.
            #   result = client.update_mesh request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_mesh request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateMeshRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_mesh.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.mesh&.name
                header_params["mesh.name"] = request.mesh.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_mesh.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_mesh.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_mesh, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Mesh.
            #
            # @overload delete_mesh(request, options = nil)
            #   Pass arguments to `delete_mesh` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteMeshRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteMeshRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_mesh(name: nil)
            #   Pass arguments to `delete_mesh` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the Mesh to delete. Must be in the format
            #     `projects/*/locations/global/meshes/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteMeshRequest.new
            #
            #   # Call the delete_mesh method.
            #   result = client.delete_mesh request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_mesh request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteMeshRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_mesh.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_mesh.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_mesh.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_mesh, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ServiceLbPolicies in a given project and location.
            #
            # @overload list_service_lb_policies(request, options = nil)
            #   Pass arguments to `list_service_lb_policies` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_lb_policies(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_service_lb_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the ServiceLbPolicies should
            #     be listed, specified in the format
            #     `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Maximum number of ServiceLbPolicies to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListServiceLbPoliciesResponse`
            #     Indicates that this is a continuation of a prior `ListRouters` call,
            #     and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::ServiceLbPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::ServiceLbPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest.new
            #
            #   # Call the list_service_lb_policies method.
            #   result = client.list_service_lb_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::ServiceLbPolicy.
            #     p item
            #   end
            #
            def list_service_lb_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListServiceLbPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_lb_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_lb_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_lb_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_service_lb_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_service_lb_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServiceLbPolicy.
            #
            # @overload get_service_lb_policy(request, options = nil)
            #   Pass arguments to `get_service_lb_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_lb_policy(name: nil)
            #   Pass arguments to `get_service_lb_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ServiceLbPolicy to get. Must be in the format
            #     `projects/{project}/locations/{location}/serviceLbPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest.new
            #
            #   # Call the get_service_lb_policy method.
            #   result = client.get_service_lb_policy request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::ServiceLbPolicy.
            #   p result
            #
            def get_service_lb_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetServiceLbPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_lb_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_lb_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_lb_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_service_lb_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ServiceLbPolicy in a given project and location.
            #
            # @overload create_service_lb_policy(request, options = nil)
            #   Pass arguments to `create_service_lb_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_lb_policy(parent: nil, service_lb_policy_id: nil, service_lb_policy: nil)
            #   Pass arguments to `create_service_lb_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the ServiceLbPolicy. Must be in the
            #     format `projects/{project}/locations/{location}`.
            #   @param service_lb_policy_id [::String]
            #     Required. Short name of the ServiceLbPolicy resource to be created.
            #     E.g. for resource name
            #     `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy_name}`.
            #     the id is value of \\{service_lb_policy_name}
            #   @param service_lb_policy [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy, ::Hash]
            #     Required. ServiceLbPolicy resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest.new
            #
            #   # Call the create_service_lb_policy method.
            #   result = client.create_service_lb_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service_lb_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateServiceLbPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_lb_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_lb_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_lb_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :create_service_lb_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ServiceLbPolicy.
            #
            # @overload update_service_lb_policy(request, options = nil)
            #   Pass arguments to `update_service_lb_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service_lb_policy(update_mask: nil, service_lb_policy: nil)
            #   Pass arguments to `update_service_lb_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ServiceLbPolicy resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param service_lb_policy [::Google::Cloud::NetworkServices::V1::ServiceLbPolicy, ::Hash]
            #     Required. Updated ServiceLbPolicy resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest.new
            #
            #   # Call the update_service_lb_policy method.
            #   result = client.update_service_lb_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_service_lb_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateServiceLbPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service_lb_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service_lb_policy&.name
                header_params["service_lb_policy.name"] = request.service_lb_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service_lb_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service_lb_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :update_service_lb_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServiceLbPolicy.
            #
            # @overload delete_service_lb_policy(request, options = nil)
            #   Pass arguments to `delete_service_lb_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_lb_policy(name: nil)
            #   Pass arguments to `delete_service_lb_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ServiceLbPolicy to delete. Must be in the format
            #     `projects/{project}/locations/{location}/serviceLbPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest.new
            #
            #   # Call the delete_service_lb_policy method.
            #   result = client.delete_service_lb_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_lb_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteServiceLbPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_lb_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_lb_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_lb_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :delete_service_lb_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single RouteView of a Gateway.
            #
            # @overload get_gateway_route_view(request, options = nil)
            #   Pass arguments to `get_gateway_route_view` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_gateway_route_view(name: nil)
            #   Pass arguments to `get_gateway_route_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the GatewayRouteView resource.
            #     Formats:
            #       projects/\\{project}/locations/\\{location}/gateways/\\{gateway}/routeViews/\\{route_view}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::GatewayRouteView]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::GatewayRouteView]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest.new
            #
            #   # Call the get_gateway_route_view method.
            #   result = client.get_gateway_route_view request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::GatewayRouteView.
            #   p result
            #
            def get_gateway_route_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetGatewayRouteViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_gateway_route_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_gateway_route_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_gateway_route_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_gateway_route_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single RouteView of a Mesh.
            #
            # @overload get_mesh_route_view(request, options = nil)
            #   Pass arguments to `get_mesh_route_view` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_mesh_route_view(name: nil)
            #   Pass arguments to `get_mesh_route_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the MeshRouteView resource.
            #     Format:
            #       projects/\\{project}/locations/\\{location}/meshes/\\{mesh}/routeViews/\\{route_view}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkServices::V1::MeshRouteView]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkServices::V1::MeshRouteView]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest.new
            #
            #   # Call the get_mesh_route_view method.
            #   result = client.get_mesh_route_view request
            #
            #   # The returned object is of type Google::Cloud::NetworkServices::V1::MeshRouteView.
            #   p result
            #
            def get_mesh_route_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetMeshRouteViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_mesh_route_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_mesh_route_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_mesh_route_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :get_mesh_route_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists RouteViews
            #
            # @overload list_gateway_route_views(request, options = nil)
            #   Pass arguments to `list_gateway_route_views` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_gateway_route_views(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_gateway_route_views` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Gateway to which a Route is associated.
            #     Formats:
            #       projects/\\{project}/locations/\\{location}/gateways/\\{gateway}
            #   @param page_size [::Integer]
            #     Maximum number of GatewayRouteViews to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListGatewayRouteViewsResponse`
            #     Indicates that this is a continuation of a prior `ListGatewayRouteViews`
            #     call, and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::GatewayRouteView>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::GatewayRouteView>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest.new
            #
            #   # Call the list_gateway_route_views method.
            #   result = client.list_gateway_route_views request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::GatewayRouteView.
            #     p item
            #   end
            #
            def list_gateway_route_views request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListGatewayRouteViewsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_gateway_route_views.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_gateway_route_views.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_gateway_route_views.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_gateway_route_views, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_gateway_route_views, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists RouteViews
            #
            # @overload list_mesh_route_views(request, options = nil)
            #   Pass arguments to `list_mesh_route_views` via a request object, either of type
            #   {::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_mesh_route_views(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_mesh_route_views` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Mesh to which a Route is associated.
            #     Format:
            #       projects/\\{project}/locations/\\{location}/meshes/\\{mesh}
            #   @param page_size [::Integer]
            #     Maximum number of MeshRouteViews to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListMeshRouteViewsResponse`
            #     Indicates that this is a continuation of a prior `ListMeshRouteViews` call,
            #     and that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::MeshRouteView>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkServices::V1::MeshRouteView>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_services/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkServices::V1::NetworkServices::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest.new
            #
            #   # Call the list_mesh_route_views method.
            #   result = client.list_mesh_route_views request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkServices::V1::MeshRouteView.
            #     p item
            #   end
            #
            def list_mesh_route_views request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListMeshRouteViewsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_mesh_route_views.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_mesh_route_views.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_mesh_route_views.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_services_stub.call_rpc :list_mesh_route_views, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_services_stub, :list_mesh_route_views, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the NetworkServices API.
            #
            # This class represents the configuration for NetworkServices,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkServices::V1::NetworkServices::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_endpoint_policies to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_endpoint_policies.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_endpoint_policies.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkServices::V1::NetworkServices::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networkservices.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the NetworkServices API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_endpoint_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_endpoint_policies
                ##
                # RPC-specific configuration for `get_endpoint_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_endpoint_policy
                ##
                # RPC-specific configuration for `create_endpoint_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_endpoint_policy
                ##
                # RPC-specific configuration for `update_endpoint_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_endpoint_policy
                ##
                # RPC-specific configuration for `delete_endpoint_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_endpoint_policy
                ##
                # RPC-specific configuration for `list_wasm_plugin_versions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_wasm_plugin_versions
                ##
                # RPC-specific configuration for `get_wasm_plugin_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_wasm_plugin_version
                ##
                # RPC-specific configuration for `create_wasm_plugin_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_wasm_plugin_version
                ##
                # RPC-specific configuration for `delete_wasm_plugin_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_wasm_plugin_version
                ##
                # RPC-specific configuration for `list_wasm_plugins`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_wasm_plugins
                ##
                # RPC-specific configuration for `get_wasm_plugin`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_wasm_plugin
                ##
                # RPC-specific configuration for `create_wasm_plugin`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_wasm_plugin
                ##
                # RPC-specific configuration for `update_wasm_plugin`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_wasm_plugin
                ##
                # RPC-specific configuration for `delete_wasm_plugin`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_wasm_plugin
                ##
                # RPC-specific configuration for `list_gateways`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_gateways
                ##
                # RPC-specific configuration for `get_gateway`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_gateway
                ##
                # RPC-specific configuration for `create_gateway`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_gateway
                ##
                # RPC-specific configuration for `update_gateway`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_gateway
                ##
                # RPC-specific configuration for `delete_gateway`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_gateway
                ##
                # RPC-specific configuration for `list_grpc_routes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_grpc_routes
                ##
                # RPC-specific configuration for `get_grpc_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_grpc_route
                ##
                # RPC-specific configuration for `create_grpc_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_grpc_route
                ##
                # RPC-specific configuration for `update_grpc_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_grpc_route
                ##
                # RPC-specific configuration for `delete_grpc_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_grpc_route
                ##
                # RPC-specific configuration for `list_http_routes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_http_routes
                ##
                # RPC-specific configuration for `get_http_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_http_route
                ##
                # RPC-specific configuration for `create_http_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_http_route
                ##
                # RPC-specific configuration for `update_http_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_http_route
                ##
                # RPC-specific configuration for `delete_http_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_http_route
                ##
                # RPC-specific configuration for `list_tcp_routes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_tcp_routes
                ##
                # RPC-specific configuration for `get_tcp_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_tcp_route
                ##
                # RPC-specific configuration for `create_tcp_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_tcp_route
                ##
                # RPC-specific configuration for `update_tcp_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_tcp_route
                ##
                # RPC-specific configuration for `delete_tcp_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_tcp_route
                ##
                # RPC-specific configuration for `list_tls_routes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_tls_routes
                ##
                # RPC-specific configuration for `get_tls_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_tls_route
                ##
                # RPC-specific configuration for `create_tls_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_tls_route
                ##
                # RPC-specific configuration for `update_tls_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_tls_route
                ##
                # RPC-specific configuration for `delete_tls_route`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_tls_route
                ##
                # RPC-specific configuration for `list_service_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_bindings
                ##
                # RPC-specific configuration for `get_service_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_binding
                ##
                # RPC-specific configuration for `create_service_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_binding
                ##
                # RPC-specific configuration for `update_service_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service_binding
                ##
                # RPC-specific configuration for `delete_service_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_binding
                ##
                # RPC-specific configuration for `list_meshes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_meshes
                ##
                # RPC-specific configuration for `get_mesh`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_mesh
                ##
                # RPC-specific configuration for `create_mesh`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_mesh
                ##
                # RPC-specific configuration for `update_mesh`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_mesh
                ##
                # RPC-specific configuration for `delete_mesh`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_mesh
                ##
                # RPC-specific configuration for `list_service_lb_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_lb_policies
                ##
                # RPC-specific configuration for `get_service_lb_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_lb_policy
                ##
                # RPC-specific configuration for `create_service_lb_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_lb_policy
                ##
                # RPC-specific configuration for `update_service_lb_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service_lb_policy
                ##
                # RPC-specific configuration for `delete_service_lb_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_lb_policy
                ##
                # RPC-specific configuration for `get_gateway_route_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_gateway_route_view
                ##
                # RPC-specific configuration for `get_mesh_route_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_mesh_route_view
                ##
                # RPC-specific configuration for `list_gateway_route_views`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_gateway_route_views
                ##
                # RPC-specific configuration for `list_mesh_route_views`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_mesh_route_views

                # @private
                def initialize parent_rpcs = nil
                  list_endpoint_policies_config = parent_rpcs.list_endpoint_policies if parent_rpcs.respond_to? :list_endpoint_policies
                  @list_endpoint_policies = ::Gapic::Config::Method.new list_endpoint_policies_config
                  get_endpoint_policy_config = parent_rpcs.get_endpoint_policy if parent_rpcs.respond_to? :get_endpoint_policy
                  @get_endpoint_policy = ::Gapic::Config::Method.new get_endpoint_policy_config
                  create_endpoint_policy_config = parent_rpcs.create_endpoint_policy if parent_rpcs.respond_to? :create_endpoint_policy
                  @create_endpoint_policy = ::Gapic::Config::Method.new create_endpoint_policy_config
                  update_endpoint_policy_config = parent_rpcs.update_endpoint_policy if parent_rpcs.respond_to? :update_endpoint_policy
                  @update_endpoint_policy = ::Gapic::Config::Method.new update_endpoint_policy_config
                  delete_endpoint_policy_config = parent_rpcs.delete_endpoint_policy if parent_rpcs.respond_to? :delete_endpoint_policy
                  @delete_endpoint_policy = ::Gapic::Config::Method.new delete_endpoint_policy_config
                  list_wasm_plugin_versions_config = parent_rpcs.list_wasm_plugin_versions if parent_rpcs.respond_to? :list_wasm_plugin_versions
                  @list_wasm_plugin_versions = ::Gapic::Config::Method.new list_wasm_plugin_versions_config
                  get_wasm_plugin_version_config = parent_rpcs.get_wasm_plugin_version if parent_rpcs.respond_to? :get_wasm_plugin_version
                  @get_wasm_plugin_version = ::Gapic::Config::Method.new get_wasm_plugin_version_config
                  create_wasm_plugin_version_config = parent_rpcs.create_wasm_plugin_version if parent_rpcs.respond_to? :create_wasm_plugin_version
                  @create_wasm_plugin_version = ::Gapic::Config::Method.new create_wasm_plugin_version_config
                  delete_wasm_plugin_version_config = parent_rpcs.delete_wasm_plugin_version if parent_rpcs.respond_to? :delete_wasm_plugin_version
                  @delete_wasm_plugin_version = ::Gapic::Config::Method.new delete_wasm_plugin_version_config
                  list_wasm_plugins_config = parent_rpcs.list_wasm_plugins if parent_rpcs.respond_to? :list_wasm_plugins
                  @list_wasm_plugins = ::Gapic::Config::Method.new list_wasm_plugins_config
                  get_wasm_plugin_config = parent_rpcs.get_wasm_plugin if parent_rpcs.respond_to? :get_wasm_plugin
                  @get_wasm_plugin = ::Gapic::Config::Method.new get_wasm_plugin_config
                  create_wasm_plugin_config = parent_rpcs.create_wasm_plugin if parent_rpcs.respond_to? :create_wasm_plugin
                  @create_wasm_plugin = ::Gapic::Config::Method.new create_wasm_plugin_config
                  update_wasm_plugin_config = parent_rpcs.update_wasm_plugin if parent_rpcs.respond_to? :update_wasm_plugin
                  @update_wasm_plugin = ::Gapic::Config::Method.new update_wasm_plugin_config
                  delete_wasm_plugin_config = parent_rpcs.delete_wasm_plugin if parent_rpcs.respond_to? :delete_wasm_plugin
                  @delete_wasm_plugin = ::Gapic::Config::Method.new delete_wasm_plugin_config
                  list_gateways_config = parent_rpcs.list_gateways if parent_rpcs.respond_to? :list_gateways
                  @list_gateways = ::Gapic::Config::Method.new list_gateways_config
                  get_gateway_config = parent_rpcs.get_gateway if parent_rpcs.respond_to? :get_gateway
                  @get_gateway = ::Gapic::Config::Method.new get_gateway_config
                  create_gateway_config = parent_rpcs.create_gateway if parent_rpcs.respond_to? :create_gateway
                  @create_gateway = ::Gapic::Config::Method.new create_gateway_config
                  update_gateway_config = parent_rpcs.update_gateway if parent_rpcs.respond_to? :update_gateway
                  @update_gateway = ::Gapic::Config::Method.new update_gateway_config
                  delete_gateway_config = parent_rpcs.delete_gateway if parent_rpcs.respond_to? :delete_gateway
                  @delete_gateway = ::Gapic::Config::Method.new delete_gateway_config
                  list_grpc_routes_config = parent_rpcs.list_grpc_routes if parent_rpcs.respond_to? :list_grpc_routes
                  @list_grpc_routes = ::Gapic::Config::Method.new list_grpc_routes_config
                  get_grpc_route_config = parent_rpcs.get_grpc_route if parent_rpcs.respond_to? :get_grpc_route
                  @get_grpc_route = ::Gapic::Config::Method.new get_grpc_route_config
                  create_grpc_route_config = parent_rpcs.create_grpc_route if parent_rpcs.respond_to? :create_grpc_route
                  @create_grpc_route = ::Gapic::Config::Method.new create_grpc_route_config
                  update_grpc_route_config = parent_rpcs.update_grpc_route if parent_rpcs.respond_to? :update_grpc_route
                  @update_grpc_route = ::Gapic::Config::Method.new update_grpc_route_config
                  delete_grpc_route_config = parent_rpcs.delete_grpc_route if parent_rpcs.respond_to? :delete_grpc_route
                  @delete_grpc_route = ::Gapic::Config::Method.new delete_grpc_route_config
                  list_http_routes_config = parent_rpcs.list_http_routes if parent_rpcs.respond_to? :list_http_routes
                  @list_http_routes = ::Gapic::Config::Method.new list_http_routes_config
                  get_http_route_config = parent_rpcs.get_http_route if parent_rpcs.respond_to? :get_http_route
                  @get_http_route = ::Gapic::Config::Method.new get_http_route_config
                  create_http_route_config = parent_rpcs.create_http_route if parent_rpcs.respond_to? :create_http_route
                  @create_http_route = ::Gapic::Config::Method.new create_http_route_config
                  update_http_route_config = parent_rpcs.update_http_route if parent_rpcs.respond_to? :update_http_route
                  @update_http_route = ::Gapic::Config::Method.new update_http_route_config
                  delete_http_route_config = parent_rpcs.delete_http_route if parent_rpcs.respond_to? :delete_http_route
                  @delete_http_route = ::Gapic::Config::Method.new delete_http_route_config
                  list_tcp_routes_config = parent_rpcs.list_tcp_routes if parent_rpcs.respond_to? :list_tcp_routes
                  @list_tcp_routes = ::Gapic::Config::Method.new list_tcp_routes_config
                  get_tcp_route_config = parent_rpcs.get_tcp_route if parent_rpcs.respond_to? :get_tcp_route
                  @get_tcp_route = ::Gapic::Config::Method.new get_tcp_route_config
                  create_tcp_route_config = parent_rpcs.create_tcp_route if parent_rpcs.respond_to? :create_tcp_route
                  @create_tcp_route = ::Gapic::Config::Method.new create_tcp_route_config
                  update_tcp_route_config = parent_rpcs.update_tcp_route if parent_rpcs.respond_to? :update_tcp_route
                  @update_tcp_route = ::Gapic::Config::Method.new update_tcp_route_config
                  delete_tcp_route_config = parent_rpcs.delete_tcp_route if parent_rpcs.respond_to? :delete_tcp_route
                  @delete_tcp_route = ::Gapic::Config::Method.new delete_tcp_route_config
                  list_tls_routes_config = parent_rpcs.list_tls_routes if parent_rpcs.respond_to? :list_tls_routes
                  @list_tls_routes = ::Gapic::Config::Method.new list_tls_routes_config
                  get_tls_route_config = parent_rpcs.get_tls_route if parent_rpcs.respond_to? :get_tls_route
                  @get_tls_route = ::Gapic::Config::Method.new get_tls_route_config
                  create_tls_route_config = parent_rpcs.create_tls_route if parent_rpcs.respond_to? :create_tls_route
                  @create_tls_route = ::Gapic::Config::Method.new create_tls_route_config
                  update_tls_route_config = parent_rpcs.update_tls_route if parent_rpcs.respond_to? :update_tls_route
                  @update_tls_route = ::Gapic::Config::Method.new update_tls_route_config
                  delete_tls_route_config = parent_rpcs.delete_tls_route if parent_rpcs.respond_to? :delete_tls_route
                  @delete_tls_route = ::Gapic::Config::Method.new delete_tls_route_config
                  list_service_bindings_config = parent_rpcs.list_service_bindings if parent_rpcs.respond_to? :list_service_bindings
                  @list_service_bindings = ::Gapic::Config::Method.new list_service_bindings_config
                  get_service_binding_config = parent_rpcs.get_service_binding if parent_rpcs.respond_to? :get_service_binding
                  @get_service_binding = ::Gapic::Config::Method.new get_service_binding_config
                  create_service_binding_config = parent_rpcs.create_service_binding if parent_rpcs.respond_to? :create_service_binding
                  @create_service_binding = ::Gapic::Config::Method.new create_service_binding_config
                  update_service_binding_config = parent_rpcs.update_service_binding if parent_rpcs.respond_to? :update_service_binding
                  @update_service_binding = ::Gapic::Config::Method.new update_service_binding_config
                  delete_service_binding_config = parent_rpcs.delete_service_binding if parent_rpcs.respond_to? :delete_service_binding
                  @delete_service_binding = ::Gapic::Config::Method.new delete_service_binding_config
                  list_meshes_config = parent_rpcs.list_meshes if parent_rpcs.respond_to? :list_meshes
                  @list_meshes = ::Gapic::Config::Method.new list_meshes_config
                  get_mesh_config = parent_rpcs.get_mesh if parent_rpcs.respond_to? :get_mesh
                  @get_mesh = ::Gapic::Config::Method.new get_mesh_config
                  create_mesh_config = parent_rpcs.create_mesh if parent_rpcs.respond_to? :create_mesh
                  @create_mesh = ::Gapic::Config::Method.new create_mesh_config
                  update_mesh_config = parent_rpcs.update_mesh if parent_rpcs.respond_to? :update_mesh
                  @update_mesh = ::Gapic::Config::Method.new update_mesh_config
                  delete_mesh_config = parent_rpcs.delete_mesh if parent_rpcs.respond_to? :delete_mesh
                  @delete_mesh = ::Gapic::Config::Method.new delete_mesh_config
                  list_service_lb_policies_config = parent_rpcs.list_service_lb_policies if parent_rpcs.respond_to? :list_service_lb_policies
                  @list_service_lb_policies = ::Gapic::Config::Method.new list_service_lb_policies_config
                  get_service_lb_policy_config = parent_rpcs.get_service_lb_policy if parent_rpcs.respond_to? :get_service_lb_policy
                  @get_service_lb_policy = ::Gapic::Config::Method.new get_service_lb_policy_config
                  create_service_lb_policy_config = parent_rpcs.create_service_lb_policy if parent_rpcs.respond_to? :create_service_lb_policy
                  @create_service_lb_policy = ::Gapic::Config::Method.new create_service_lb_policy_config
                  update_service_lb_policy_config = parent_rpcs.update_service_lb_policy if parent_rpcs.respond_to? :update_service_lb_policy
                  @update_service_lb_policy = ::Gapic::Config::Method.new update_service_lb_policy_config
                  delete_service_lb_policy_config = parent_rpcs.delete_service_lb_policy if parent_rpcs.respond_to? :delete_service_lb_policy
                  @delete_service_lb_policy = ::Gapic::Config::Method.new delete_service_lb_policy_config
                  get_gateway_route_view_config = parent_rpcs.get_gateway_route_view if parent_rpcs.respond_to? :get_gateway_route_view
                  @get_gateway_route_view = ::Gapic::Config::Method.new get_gateway_route_view_config
                  get_mesh_route_view_config = parent_rpcs.get_mesh_route_view if parent_rpcs.respond_to? :get_mesh_route_view
                  @get_mesh_route_view = ::Gapic::Config::Method.new get_mesh_route_view_config
                  list_gateway_route_views_config = parent_rpcs.list_gateway_route_views if parent_rpcs.respond_to? :list_gateway_route_views
                  @list_gateway_route_views = ::Gapic::Config::Method.new list_gateway_route_views_config
                  list_mesh_route_views_config = parent_rpcs.list_mesh_route_views if parent_rpcs.respond_to? :list_mesh_route_views
                  @list_mesh_route_views = ::Gapic::Config::Method.new list_mesh_route_views_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
