# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networkservices/v1/dep_pb"
require "google/cloud/network_services/v1/dep_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module NetworkServices
      module V1
        module DepService
          module Rest
            ##
            # REST client for the DepService service.
            #
            # Service describing handlers for resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "networkservices.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :dep_service_stub

              ##
              # Configure the DepService Client class.
              #
              # See {::Google::Cloud::NetworkServices::V1::DepService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DepService clients
              #   ::Google::Cloud::NetworkServices::V1::DepService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "NetworkServices", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DepService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::NetworkServices::V1::DepService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @dep_service_stub.universe_domain
              end

              ##
              # Create a new DepService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DepService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::NetworkServices::V1::DepService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @dep_service_stub = ::Google::Cloud::NetworkServices::V1::DepService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @dep_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dep_service_stub.endpoint
                  config.universe_domain = @dep_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dep_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dep_service_stub.endpoint
                  config.universe_domain = @dep_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dep_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::NetworkServices::V1::DepService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @dep_service_stub.logger
              end

              # Service calls

              ##
              # Lists `LbTrafficExtension` resources in a given project and location.
              #
              # @overload list_lb_traffic_extensions(request, options = nil)
              #   Pass arguments to `list_lb_traffic_extensions` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::ListLbTrafficExtensionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::ListLbTrafficExtensionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_lb_traffic_extensions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_lb_traffic_extensions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location from which the `LbTrafficExtension`
              #     resources are listed. These values are specified in the following format:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server might return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results that the server returns.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint about how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::LbTrafficExtension>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::LbTrafficExtension>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::ListLbTrafficExtensionsRequest.new
              #
              #   # Call the list_lb_traffic_extensions method.
              #   result = client.list_lb_traffic_extensions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetworkServices::V1::LbTrafficExtension.
              #     p item
              #   end
              #
              def list_lb_traffic_extensions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListLbTrafficExtensionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_lb_traffic_extensions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_lb_traffic_extensions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_lb_traffic_extensions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.list_lb_traffic_extensions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dep_service_stub, :list_lb_traffic_extensions, "lb_traffic_extensions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified `LbTrafficExtension` resource.
              #
              # @overload get_lb_traffic_extension(request, options = nil)
              #   Pass arguments to `get_lb_traffic_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::GetLbTrafficExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::GetLbTrafficExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_lb_traffic_extension(name: nil)
              #   Pass arguments to `get_lb_traffic_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. A name of the `LbTrafficExtension` resource to get. Must be in
              #     the format
              #     `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetworkServices::V1::LbTrafficExtension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetworkServices::V1::LbTrafficExtension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::GetLbTrafficExtensionRequest.new
              #
              #   # Call the get_lb_traffic_extension method.
              #   result = client.get_lb_traffic_extension request
              #
              #   # The returned object is of type Google::Cloud::NetworkServices::V1::LbTrafficExtension.
              #   p result
              #
              def get_lb_traffic_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetLbTrafficExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_lb_traffic_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_lb_traffic_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_lb_traffic_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.get_lb_traffic_extension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new `LbTrafficExtension` resource in a given project and
              # location.
              #
              # @overload create_lb_traffic_extension(request, options = nil)
              #   Pass arguments to `create_lb_traffic_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::CreateLbTrafficExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::CreateLbTrafficExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_lb_traffic_extension(parent: nil, lb_traffic_extension_id: nil, lb_traffic_extension: nil, request_id: nil)
              #   Pass arguments to `create_lb_traffic_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the `LbTrafficExtension` resource. Must be
              #     in the format `projects/{project}/locations/{location}`.
              #   @param lb_traffic_extension_id [::String]
              #     Required. User-provided ID of the `LbTrafficExtension` resource to be
              #     created.
              #   @param lb_traffic_extension [::Google::Cloud::NetworkServices::V1::LbTrafficExtension, ::Hash]
              #     Required. `LbTrafficExtension` resource to be created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::CreateLbTrafficExtensionRequest.new
              #
              #   # Call the create_lb_traffic_extension method.
              #   result = client.create_lb_traffic_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_lb_traffic_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateLbTrafficExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_lb_traffic_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_lb_traffic_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_lb_traffic_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.create_lb_traffic_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of the specified `LbTrafficExtension` resource.
              #
              # @overload update_lb_traffic_extension(request, options = nil)
              #   Pass arguments to `update_lb_traffic_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::UpdateLbTrafficExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::UpdateLbTrafficExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_lb_traffic_extension(update_mask: nil, lb_traffic_extension: nil, request_id: nil)
              #   Pass arguments to `update_lb_traffic_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Used to specify the fields to be overwritten in the
              #     `LbTrafficExtension` resource by the update.
              #     The fields specified in the `update_mask` are relative to the resource, not
              #     the full request. A field is overwritten if it is in the mask. If the
              #     user does not specify a mask, then all fields are overwritten.
              #   @param lb_traffic_extension [::Google::Cloud::NetworkServices::V1::LbTrafficExtension, ::Hash]
              #     Required. `LbTrafficExtension` resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::UpdateLbTrafficExtensionRequest.new
              #
              #   # Call the update_lb_traffic_extension method.
              #   result = client.update_lb_traffic_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_lb_traffic_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateLbTrafficExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_lb_traffic_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_lb_traffic_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_lb_traffic_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.update_lb_traffic_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified `LbTrafficExtension` resource.
              #
              # @overload delete_lb_traffic_extension(request, options = nil)
              #   Pass arguments to `delete_lb_traffic_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::DeleteLbTrafficExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::DeleteLbTrafficExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_lb_traffic_extension(name: nil, request_id: nil)
              #   Pass arguments to `delete_lb_traffic_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `LbTrafficExtension` resource to delete. Must be
              #     in the format
              #     `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}`.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::DeleteLbTrafficExtensionRequest.new
              #
              #   # Call the delete_lb_traffic_extension method.
              #   result = client.delete_lb_traffic_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_lb_traffic_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteLbTrafficExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_lb_traffic_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_lb_traffic_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_lb_traffic_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.delete_lb_traffic_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists `LbRouteExtension` resources in a given project and location.
              #
              # @overload list_lb_route_extensions(request, options = nil)
              #   Pass arguments to `list_lb_route_extensions` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::ListLbRouteExtensionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::ListLbRouteExtensionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_lb_route_extensions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_lb_route_extensions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location from which the `LbRouteExtension`
              #     resources are listed. These values are specified in the following format:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server might return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results that the server returns.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint about how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::LbRouteExtension>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::LbRouteExtension>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::ListLbRouteExtensionsRequest.new
              #
              #   # Call the list_lb_route_extensions method.
              #   result = client.list_lb_route_extensions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetworkServices::V1::LbRouteExtension.
              #     p item
              #   end
              #
              def list_lb_route_extensions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListLbRouteExtensionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_lb_route_extensions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_lb_route_extensions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_lb_route_extensions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.list_lb_route_extensions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dep_service_stub, :list_lb_route_extensions, "lb_route_extensions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified `LbRouteExtension` resource.
              #
              # @overload get_lb_route_extension(request, options = nil)
              #   Pass arguments to `get_lb_route_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::GetLbRouteExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::GetLbRouteExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_lb_route_extension(name: nil)
              #   Pass arguments to `get_lb_route_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. A name of the `LbRouteExtension` resource to get. Must be in the
              #     format
              #     `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetworkServices::V1::LbRouteExtension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetworkServices::V1::LbRouteExtension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::GetLbRouteExtensionRequest.new
              #
              #   # Call the get_lb_route_extension method.
              #   result = client.get_lb_route_extension request
              #
              #   # The returned object is of type Google::Cloud::NetworkServices::V1::LbRouteExtension.
              #   p result
              #
              def get_lb_route_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetLbRouteExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_lb_route_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_lb_route_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_lb_route_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.get_lb_route_extension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new `LbRouteExtension` resource in a given project and location.
              #
              # @overload create_lb_route_extension(request, options = nil)
              #   Pass arguments to `create_lb_route_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::CreateLbRouteExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::CreateLbRouteExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_lb_route_extension(parent: nil, lb_route_extension_id: nil, lb_route_extension: nil, request_id: nil)
              #   Pass arguments to `create_lb_route_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the `LbRouteExtension` resource. Must be
              #     in the format `projects/{project}/locations/{location}`.
              #   @param lb_route_extension_id [::String]
              #     Required. User-provided ID of the `LbRouteExtension` resource to be
              #     created.
              #   @param lb_route_extension [::Google::Cloud::NetworkServices::V1::LbRouteExtension, ::Hash]
              #     Required. `LbRouteExtension` resource to be created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::CreateLbRouteExtensionRequest.new
              #
              #   # Call the create_lb_route_extension method.
              #   result = client.create_lb_route_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_lb_route_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateLbRouteExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_lb_route_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_lb_route_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_lb_route_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.create_lb_route_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of the specified `LbRouteExtension` resource.
              #
              # @overload update_lb_route_extension(request, options = nil)
              #   Pass arguments to `update_lb_route_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::UpdateLbRouteExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::UpdateLbRouteExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_lb_route_extension(update_mask: nil, lb_route_extension: nil, request_id: nil)
              #   Pass arguments to `update_lb_route_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Used to specify the fields to be overwritten in the
              #     `LbRouteExtension` resource by the update.
              #     The fields specified in the `update_mask` are relative to the resource, not
              #     the full request. A field is overwritten if it is in the mask. If the
              #     user does not specify a mask, then all fields are overwritten.
              #   @param lb_route_extension [::Google::Cloud::NetworkServices::V1::LbRouteExtension, ::Hash]
              #     Required. `LbRouteExtension` resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::UpdateLbRouteExtensionRequest.new
              #
              #   # Call the update_lb_route_extension method.
              #   result = client.update_lb_route_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_lb_route_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateLbRouteExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_lb_route_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_lb_route_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_lb_route_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.update_lb_route_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified `LbRouteExtension` resource.
              #
              # @overload delete_lb_route_extension(request, options = nil)
              #   Pass arguments to `delete_lb_route_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::DeleteLbRouteExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::DeleteLbRouteExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_lb_route_extension(name: nil, request_id: nil)
              #   Pass arguments to `delete_lb_route_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `LbRouteExtension` resource to delete. Must be in
              #     the format
              #     `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}`.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::DeleteLbRouteExtensionRequest.new
              #
              #   # Call the delete_lb_route_extension method.
              #   result = client.delete_lb_route_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_lb_route_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteLbRouteExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_lb_route_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_lb_route_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_lb_route_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.delete_lb_route_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists `LbEdgeExtension` resources in a given project and location.
              #
              # @overload list_lb_edge_extensions(request, options = nil)
              #   Pass arguments to `list_lb_edge_extensions` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::ListLbEdgeExtensionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::ListLbEdgeExtensionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_lb_edge_extensions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_lb_edge_extensions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location from which the `LbEdgeExtension`
              #     resources are listed. These values are specified in the following format:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server might return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results that the server returns.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint about how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::LbEdgeExtension>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::LbEdgeExtension>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::ListLbEdgeExtensionsRequest.new
              #
              #   # Call the list_lb_edge_extensions method.
              #   result = client.list_lb_edge_extensions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetworkServices::V1::LbEdgeExtension.
              #     p item
              #   end
              #
              def list_lb_edge_extensions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListLbEdgeExtensionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_lb_edge_extensions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_lb_edge_extensions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_lb_edge_extensions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.list_lb_edge_extensions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dep_service_stub, :list_lb_edge_extensions, "lb_edge_extensions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified `LbEdgeExtension` resource.
              #
              # @overload get_lb_edge_extension(request, options = nil)
              #   Pass arguments to `get_lb_edge_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::GetLbEdgeExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::GetLbEdgeExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_lb_edge_extension(name: nil)
              #   Pass arguments to `get_lb_edge_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. A name of the `LbEdgeExtension` resource to get. Must be in the
              #     format
              #     `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extension}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetworkServices::V1::LbEdgeExtension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetworkServices::V1::LbEdgeExtension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::GetLbEdgeExtensionRequest.new
              #
              #   # Call the get_lb_edge_extension method.
              #   result = client.get_lb_edge_extension request
              #
              #   # The returned object is of type Google::Cloud::NetworkServices::V1::LbEdgeExtension.
              #   p result
              #
              def get_lb_edge_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetLbEdgeExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_lb_edge_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_lb_edge_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_lb_edge_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.get_lb_edge_extension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new `LbEdgeExtension` resource in a given project and location.
              #
              # @overload create_lb_edge_extension(request, options = nil)
              #   Pass arguments to `create_lb_edge_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::CreateLbEdgeExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::CreateLbEdgeExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_lb_edge_extension(parent: nil, lb_edge_extension_id: nil, lb_edge_extension: nil, request_id: nil)
              #   Pass arguments to `create_lb_edge_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the `LbEdgeExtension` resource. Must be in
              #     the format `projects/{project}/locations/{location}`.
              #   @param lb_edge_extension_id [::String]
              #     Required. User-provided ID of the `LbEdgeExtension` resource to be created.
              #   @param lb_edge_extension [::Google::Cloud::NetworkServices::V1::LbEdgeExtension, ::Hash]
              #     Required. `LbEdgeExtension` resource to be created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::CreateLbEdgeExtensionRequest.new
              #
              #   # Call the create_lb_edge_extension method.
              #   result = client.create_lb_edge_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_lb_edge_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateLbEdgeExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_lb_edge_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_lb_edge_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_lb_edge_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.create_lb_edge_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of the specified `LbEdgeExtension` resource.
              #
              # @overload update_lb_edge_extension(request, options = nil)
              #   Pass arguments to `update_lb_edge_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::UpdateLbEdgeExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::UpdateLbEdgeExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_lb_edge_extension(update_mask: nil, lb_edge_extension: nil, request_id: nil)
              #   Pass arguments to `update_lb_edge_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Used to specify the fields to be overwritten in the
              #     `LbEdgeExtension` resource by the update.
              #     The fields specified in the `update_mask` are relative to the resource, not
              #     the full request. A field is overwritten if it is in the mask. If the
              #     user does not specify a mask, then all fields are overwritten.
              #   @param lb_edge_extension [::Google::Cloud::NetworkServices::V1::LbEdgeExtension, ::Hash]
              #     Required. `LbEdgeExtension` resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::UpdateLbEdgeExtensionRequest.new
              #
              #   # Call the update_lb_edge_extension method.
              #   result = client.update_lb_edge_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_lb_edge_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateLbEdgeExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_lb_edge_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_lb_edge_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_lb_edge_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.update_lb_edge_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified `LbEdgeExtension` resource.
              #
              # @overload delete_lb_edge_extension(request, options = nil)
              #   Pass arguments to `delete_lb_edge_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::DeleteLbEdgeExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::DeleteLbEdgeExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_lb_edge_extension(name: nil, request_id: nil)
              #   Pass arguments to `delete_lb_edge_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `LbEdgeExtension` resource to delete. Must be in
              #     the format
              #     `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extension}`.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::DeleteLbEdgeExtensionRequest.new
              #
              #   # Call the delete_lb_edge_extension method.
              #   result = client.delete_lb_edge_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_lb_edge_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteLbEdgeExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_lb_edge_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_lb_edge_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_lb_edge_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.delete_lb_edge_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists `AuthzExtension` resources in a given project and location.
              #
              # @overload list_authz_extensions(request, options = nil)
              #   Pass arguments to `list_authz_extensions` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::ListAuthzExtensionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::ListAuthzExtensionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_authz_extensions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_authz_extensions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location from which the `AuthzExtension`
              #     resources are listed. These values are specified in the following format:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. The server might return fewer items than
              #     requested. If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results that the server returns.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint about how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::AuthzExtension>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetworkServices::V1::AuthzExtension>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::ListAuthzExtensionsRequest.new
              #
              #   # Call the list_authz_extensions method.
              #   result = client.list_authz_extensions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetworkServices::V1::AuthzExtension.
              #     p item
              #   end
              #
              def list_authz_extensions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::ListAuthzExtensionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_authz_extensions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_authz_extensions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_authz_extensions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.list_authz_extensions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dep_service_stub, :list_authz_extensions, "authz_extensions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified `AuthzExtension` resource.
              #
              # @overload get_authz_extension(request, options = nil)
              #   Pass arguments to `get_authz_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::GetAuthzExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::GetAuthzExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_authz_extension(name: nil)
              #   Pass arguments to `get_authz_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. A name of the `AuthzExtension` resource to get. Must be in
              #     the format
              #     `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetworkServices::V1::AuthzExtension]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetworkServices::V1::AuthzExtension]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::GetAuthzExtensionRequest.new
              #
              #   # Call the get_authz_extension method.
              #   result = client.get_authz_extension request
              #
              #   # The returned object is of type Google::Cloud::NetworkServices::V1::AuthzExtension.
              #   p result
              #
              def get_authz_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::GetAuthzExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_authz_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_authz_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_authz_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.get_authz_extension request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new `AuthzExtension` resource in a given project
              # and location.
              #
              # @overload create_authz_extension(request, options = nil)
              #   Pass arguments to `create_authz_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::CreateAuthzExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::CreateAuthzExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_authz_extension(parent: nil, authz_extension_id: nil, authz_extension: nil, request_id: nil)
              #   Pass arguments to `create_authz_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the `AuthzExtension` resource. Must
              #     be in the format `projects/{project}/locations/{location}`.
              #   @param authz_extension_id [::String]
              #     Required. User-provided ID of the `AuthzExtension` resource to be
              #     created.
              #   @param authz_extension [::Google::Cloud::NetworkServices::V1::AuthzExtension, ::Hash]
              #     Required. `AuthzExtension` resource to be created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::CreateAuthzExtensionRequest.new
              #
              #   # Call the create_authz_extension method.
              #   result = client.create_authz_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_authz_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::CreateAuthzExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_authz_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_authz_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_authz_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.create_authz_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of the specified `AuthzExtension`
              # resource.
              #
              # @overload update_authz_extension(request, options = nil)
              #   Pass arguments to `update_authz_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::UpdateAuthzExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::UpdateAuthzExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_authz_extension(update_mask: nil, authz_extension: nil, request_id: nil)
              #   Pass arguments to `update_authz_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Used to specify the fields to be overwritten in the
              #     `AuthzExtension` resource by the update.
              #     The fields specified in the `update_mask` are relative to the resource, not
              #     the full request. A field is overwritten if it is in the mask. If the
              #     user does not specify a mask, then all fields are overwritten.
              #   @param authz_extension [::Google::Cloud::NetworkServices::V1::AuthzExtension, ::Hash]
              #     Required. `AuthzExtension` resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::UpdateAuthzExtensionRequest.new
              #
              #   # Call the update_authz_extension method.
              #   result = client.update_authz_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_authz_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::UpdateAuthzExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_authz_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_authz_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_authz_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.update_authz_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified `AuthzExtension` resource.
              #
              # @overload delete_authz_extension(request, options = nil)
              #   Pass arguments to `delete_authz_extension` via a request object, either of type
              #   {::Google::Cloud::NetworkServices::V1::DeleteAuthzExtensionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetworkServices::V1::DeleteAuthzExtensionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_authz_extension(name: nil, request_id: nil)
              #   Pass arguments to `delete_authz_extension` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `AuthzExtension` resource to delete. Must
              #     be in the format
              #     `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server can ignore
              #     the request if it has already been completed. The server guarantees
              #     that for 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request
              #     ID, the server ignores the second request This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/network_services/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetworkServices::V1::DeleteAuthzExtensionRequest.new
              #
              #   # Call the delete_authz_extension method.
              #   result = client.delete_authz_extension request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_authz_extension request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkServices::V1::DeleteAuthzExtensionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_authz_extension.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetworkServices::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_authz_extension.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_authz_extension.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dep_service_stub.delete_authz_extension request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DepService REST API.
              #
              # This class represents the configuration for DepService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::NetworkServices::V1::DepService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_lb_traffic_extensions to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::NetworkServices::V1::DepService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_lb_traffic_extensions.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::NetworkServices::V1::DepService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_lb_traffic_extensions.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "networkservices.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DepService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_lb_traffic_extensions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_lb_traffic_extensions
                  ##
                  # RPC-specific configuration for `get_lb_traffic_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_lb_traffic_extension
                  ##
                  # RPC-specific configuration for `create_lb_traffic_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_lb_traffic_extension
                  ##
                  # RPC-specific configuration for `update_lb_traffic_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_lb_traffic_extension
                  ##
                  # RPC-specific configuration for `delete_lb_traffic_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_lb_traffic_extension
                  ##
                  # RPC-specific configuration for `list_lb_route_extensions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_lb_route_extensions
                  ##
                  # RPC-specific configuration for `get_lb_route_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_lb_route_extension
                  ##
                  # RPC-specific configuration for `create_lb_route_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_lb_route_extension
                  ##
                  # RPC-specific configuration for `update_lb_route_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_lb_route_extension
                  ##
                  # RPC-specific configuration for `delete_lb_route_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_lb_route_extension
                  ##
                  # RPC-specific configuration for `list_lb_edge_extensions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_lb_edge_extensions
                  ##
                  # RPC-specific configuration for `get_lb_edge_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_lb_edge_extension
                  ##
                  # RPC-specific configuration for `create_lb_edge_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_lb_edge_extension
                  ##
                  # RPC-specific configuration for `update_lb_edge_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_lb_edge_extension
                  ##
                  # RPC-specific configuration for `delete_lb_edge_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_lb_edge_extension
                  ##
                  # RPC-specific configuration for `list_authz_extensions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_authz_extensions
                  ##
                  # RPC-specific configuration for `get_authz_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_authz_extension
                  ##
                  # RPC-specific configuration for `create_authz_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_authz_extension
                  ##
                  # RPC-specific configuration for `update_authz_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_authz_extension
                  ##
                  # RPC-specific configuration for `delete_authz_extension`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_authz_extension

                  # @private
                  def initialize parent_rpcs = nil
                    list_lb_traffic_extensions_config = parent_rpcs.list_lb_traffic_extensions if parent_rpcs.respond_to? :list_lb_traffic_extensions
                    @list_lb_traffic_extensions = ::Gapic::Config::Method.new list_lb_traffic_extensions_config
                    get_lb_traffic_extension_config = parent_rpcs.get_lb_traffic_extension if parent_rpcs.respond_to? :get_lb_traffic_extension
                    @get_lb_traffic_extension = ::Gapic::Config::Method.new get_lb_traffic_extension_config
                    create_lb_traffic_extension_config = parent_rpcs.create_lb_traffic_extension if parent_rpcs.respond_to? :create_lb_traffic_extension
                    @create_lb_traffic_extension = ::Gapic::Config::Method.new create_lb_traffic_extension_config
                    update_lb_traffic_extension_config = parent_rpcs.update_lb_traffic_extension if parent_rpcs.respond_to? :update_lb_traffic_extension
                    @update_lb_traffic_extension = ::Gapic::Config::Method.new update_lb_traffic_extension_config
                    delete_lb_traffic_extension_config = parent_rpcs.delete_lb_traffic_extension if parent_rpcs.respond_to? :delete_lb_traffic_extension
                    @delete_lb_traffic_extension = ::Gapic::Config::Method.new delete_lb_traffic_extension_config
                    list_lb_route_extensions_config = parent_rpcs.list_lb_route_extensions if parent_rpcs.respond_to? :list_lb_route_extensions
                    @list_lb_route_extensions = ::Gapic::Config::Method.new list_lb_route_extensions_config
                    get_lb_route_extension_config = parent_rpcs.get_lb_route_extension if parent_rpcs.respond_to? :get_lb_route_extension
                    @get_lb_route_extension = ::Gapic::Config::Method.new get_lb_route_extension_config
                    create_lb_route_extension_config = parent_rpcs.create_lb_route_extension if parent_rpcs.respond_to? :create_lb_route_extension
                    @create_lb_route_extension = ::Gapic::Config::Method.new create_lb_route_extension_config
                    update_lb_route_extension_config = parent_rpcs.update_lb_route_extension if parent_rpcs.respond_to? :update_lb_route_extension
                    @update_lb_route_extension = ::Gapic::Config::Method.new update_lb_route_extension_config
                    delete_lb_route_extension_config = parent_rpcs.delete_lb_route_extension if parent_rpcs.respond_to? :delete_lb_route_extension
                    @delete_lb_route_extension = ::Gapic::Config::Method.new delete_lb_route_extension_config
                    list_lb_edge_extensions_config = parent_rpcs.list_lb_edge_extensions if parent_rpcs.respond_to? :list_lb_edge_extensions
                    @list_lb_edge_extensions = ::Gapic::Config::Method.new list_lb_edge_extensions_config
                    get_lb_edge_extension_config = parent_rpcs.get_lb_edge_extension if parent_rpcs.respond_to? :get_lb_edge_extension
                    @get_lb_edge_extension = ::Gapic::Config::Method.new get_lb_edge_extension_config
                    create_lb_edge_extension_config = parent_rpcs.create_lb_edge_extension if parent_rpcs.respond_to? :create_lb_edge_extension
                    @create_lb_edge_extension = ::Gapic::Config::Method.new create_lb_edge_extension_config
                    update_lb_edge_extension_config = parent_rpcs.update_lb_edge_extension if parent_rpcs.respond_to? :update_lb_edge_extension
                    @update_lb_edge_extension = ::Gapic::Config::Method.new update_lb_edge_extension_config
                    delete_lb_edge_extension_config = parent_rpcs.delete_lb_edge_extension if parent_rpcs.respond_to? :delete_lb_edge_extension
                    @delete_lb_edge_extension = ::Gapic::Config::Method.new delete_lb_edge_extension_config
                    list_authz_extensions_config = parent_rpcs.list_authz_extensions if parent_rpcs.respond_to? :list_authz_extensions
                    @list_authz_extensions = ::Gapic::Config::Method.new list_authz_extensions_config
                    get_authz_extension_config = parent_rpcs.get_authz_extension if parent_rpcs.respond_to? :get_authz_extension
                    @get_authz_extension = ::Gapic::Config::Method.new get_authz_extension_config
                    create_authz_extension_config = parent_rpcs.create_authz_extension if parent_rpcs.respond_to? :create_authz_extension
                    @create_authz_extension = ::Gapic::Config::Method.new create_authz_extension_config
                    update_authz_extension_config = parent_rpcs.update_authz_extension if parent_rpcs.respond_to? :update_authz_extension
                    @update_authz_extension = ::Gapic::Config::Method.new update_authz_extension_config
                    delete_authz_extension_config = parent_rpcs.delete_authz_extension if parent_rpcs.respond_to? :delete_authz_extension
                    @delete_authz_extension = ::Gapic::Config::Method.new delete_authz_extension_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
