# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkServices
      module V1
        module DepService
          # Path helper methods for the DepService API.
          module Paths
            ##
            # Create a fully-qualified AuthzExtension resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`
            #
            # @param project [String]
            # @param location [String]
            # @param authz_extension [String]
            #
            # @return [::String]
            def authz_extension_path project:, location:, authz_extension:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/authzExtensions/#{authz_extension}"
            end

            ##
            # Create a fully-qualified LbEdgeExtension resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extension}`
            #
            # @param project [String]
            # @param location [String]
            # @param lb_edge_extension [String]
            #
            # @return [::String]
            def lb_edge_extension_path project:, location:, lb_edge_extension:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lbEdgeExtensions/#{lb_edge_extension}"
            end

            ##
            # Create a fully-qualified LbRouteExtension resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}`
            #
            # @param project [String]
            # @param location [String]
            # @param lb_route_extension [String]
            #
            # @return [::String]
            def lb_route_extension_path project:, location:, lb_route_extension:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lbRouteExtensions/#{lb_route_extension}"
            end

            ##
            # Create a fully-qualified LbTrafficExtension resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}`
            #
            # @param project [String]
            # @param location [String]
            # @param lb_traffic_extension [String]
            #
            # @return [::String]
            def lb_traffic_extension_path project:, location:, lb_traffic_extension:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lbTrafficExtensions/#{lb_traffic_extension}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
