# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/networksecurity/v1beta1/network_security_pb"
require "google/cloud/network_security/v1beta1/network_security"

class ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_authorization_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_authorization_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_authorization_policies, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_authorization_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_authorization_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_authorization_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_authorization_policies ::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_authorization_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_authorization_policies(::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_authorization_policies_client_stub.call_rpc_count
    end
  end

  def test_get_authorization_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_authorization_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_authorization_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_authorization_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_authorization_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_authorization_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_authorization_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_authorization_policy_client_stub.call_rpc_count
    end
  end

  def test_create_authorization_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    authorization_policy_id = "hello world"
    authorization_policy = {}

    create_authorization_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_authorization_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["authorization_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy), request["authorization_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_authorization_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_authorization_policy({ parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_authorization_policy parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest.new(parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_authorization_policy({ parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest.new(parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_authorization_policy_client_stub.call_rpc_count
    end
  end

  def test_update_authorization_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    authorization_policy = {}

    update_authorization_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_authorization_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy), request["authorization_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_authorization_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_authorization_policy({ update_mask: update_mask, authorization_policy: authorization_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_authorization_policy update_mask: update_mask, authorization_policy: authorization_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest.new(update_mask: update_mask, authorization_policy: authorization_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_authorization_policy({ update_mask: update_mask, authorization_policy: authorization_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest.new(update_mask: update_mask, authorization_policy: authorization_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_authorization_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_authorization_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_authorization_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_authorization_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_authorization_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_authorization_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_authorization_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_authorization_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_authorization_policy_client_stub.call_rpc_count
    end
  end

  def test_list_server_tls_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_server_tls_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_server_tls_policies, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_server_tls_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_server_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_server_tls_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_server_tls_policies ::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_server_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_server_tls_policies(::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_server_tls_policies_client_stub.call_rpc_count
    end
  end

  def test_get_server_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_server_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_server_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_server_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_server_tls_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_server_tls_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_server_tls_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_server_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_create_server_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    server_tls_policy_id = "hello world"
    server_tls_policy = {}

    create_server_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_server_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["server_tls_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy), request["server_tls_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_server_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_server_tls_policy({ parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_server_tls_policy parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest.new(parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_server_tls_policy({ parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest.new(parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_server_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_update_server_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    server_tls_policy = {}

    update_server_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_server_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy), request["server_tls_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_server_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_server_tls_policy({ update_mask: update_mask, server_tls_policy: server_tls_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_server_tls_policy update_mask: update_mask, server_tls_policy: server_tls_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest.new(update_mask: update_mask, server_tls_policy: server_tls_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_server_tls_policy({ update_mask: update_mask, server_tls_policy: server_tls_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest.new(update_mask: update_mask, server_tls_policy: server_tls_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_server_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_server_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_server_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_server_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_server_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_server_tls_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_server_tls_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_server_tls_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_server_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_list_client_tls_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_client_tls_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_client_tls_policies, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_client_tls_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_client_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_client_tls_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_client_tls_policies ::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_client_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_client_tls_policies(::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_client_tls_policies_client_stub.call_rpc_count
    end
  end

  def test_get_client_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_client_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_client_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_client_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_client_tls_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_client_tls_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_client_tls_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_client_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_create_client_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    client_tls_policy_id = "hello world"
    client_tls_policy = {}

    create_client_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_client_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["client_tls_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy), request["client_tls_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_client_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_client_tls_policy({ parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_client_tls_policy parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest.new(parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_client_tls_policy({ parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest.new(parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_client_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_update_client_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    client_tls_policy = {}

    update_client_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_client_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy), request["client_tls_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_client_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_client_tls_policy({ update_mask: update_mask, client_tls_policy: client_tls_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_client_tls_policy update_mask: update_mask, client_tls_policy: client_tls_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest.new(update_mask: update_mask, client_tls_policy: client_tls_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_client_tls_policy({ update_mask: update_mask, client_tls_policy: client_tls_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest.new(update_mask: update_mask, client_tls_policy: client_tls_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_client_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_client_tls_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_client_tls_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_client_tls_policy, name
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_client_tls_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_client_tls_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_client_tls_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_client_tls_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_client_tls_policy_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Operations, client.operations_client
  end
end
