# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/networksecurity/v1beta1/network_security_pb"
require "google/cloud/network_security/v1beta1/network_security/rest"


class ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_authorization_policies
    # Create test objects.
    client_result = ::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_authorization_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_list_authorization_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_authorization_policies_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_authorization_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_authorization_policies parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_authorization_policies ::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_authorization_policies({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_authorization_policies(::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_authorization_policies_client_stub.call_count
      end
    end
  end

  def test_get_authorization_policy
    # Create test objects.
    client_result = ::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_authorization_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_get_authorization_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_authorization_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_authorization_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_authorization_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_authorization_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_authorization_policy_client_stub.call_count
      end
    end
  end

  def test_create_authorization_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    authorization_policy_id = "hello world"
    authorization_policy = {}

    create_authorization_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_create_authorization_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_authorization_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_authorization_policy({ parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_authorization_policy parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest.new(parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_authorization_policy({ parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest.new(parent: parent, authorization_policy_id: authorization_policy_id, authorization_policy: authorization_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_authorization_policy_client_stub.call_count
      end
    end
  end

  def test_update_authorization_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    authorization_policy = {}

    update_authorization_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_update_authorization_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_authorization_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_authorization_policy({ update_mask: update_mask, authorization_policy: authorization_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_authorization_policy update_mask: update_mask, authorization_policy: authorization_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest.new(update_mask: update_mask, authorization_policy: authorization_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_authorization_policy({ update_mask: update_mask, authorization_policy: authorization_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest.new(update_mask: update_mask, authorization_policy: authorization_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_authorization_policy_client_stub.call_count
      end
    end
  end

  def test_delete_authorization_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_authorization_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_delete_authorization_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_authorization_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_authorization_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_authorization_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_authorization_policy ::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_authorization_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_authorization_policy(::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_authorization_policy_client_stub.call_count
      end
    end
  end

  def test_list_server_tls_policies
    # Create test objects.
    client_result = ::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_server_tls_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_list_server_tls_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_server_tls_policies_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_server_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_server_tls_policies parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_server_tls_policies ::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_server_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_server_tls_policies(::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_server_tls_policies_client_stub.call_count
      end
    end
  end

  def test_get_server_tls_policy
    # Create test objects.
    client_result = ::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_server_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_get_server_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_server_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_server_tls_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_server_tls_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_server_tls_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_server_tls_policy_client_stub.call_count
      end
    end
  end

  def test_create_server_tls_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    server_tls_policy_id = "hello world"
    server_tls_policy = {}

    create_server_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_create_server_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_server_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_server_tls_policy({ parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_server_tls_policy parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest.new(parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_server_tls_policy({ parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest.new(parent: parent, server_tls_policy_id: server_tls_policy_id, server_tls_policy: server_tls_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_server_tls_policy_client_stub.call_count
      end
    end
  end

  def test_update_server_tls_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    server_tls_policy = {}

    update_server_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_update_server_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_server_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_server_tls_policy({ update_mask: update_mask, server_tls_policy: server_tls_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_server_tls_policy update_mask: update_mask, server_tls_policy: server_tls_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest.new(update_mask: update_mask, server_tls_policy: server_tls_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_server_tls_policy({ update_mask: update_mask, server_tls_policy: server_tls_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest.new(update_mask: update_mask, server_tls_policy: server_tls_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_server_tls_policy_client_stub.call_count
      end
    end
  end

  def test_delete_server_tls_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_server_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_delete_server_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_server_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_server_tls_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_server_tls_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_server_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_server_tls_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_server_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_server_tls_policy_client_stub.call_count
      end
    end
  end

  def test_list_client_tls_policies
    # Create test objects.
    client_result = ::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_client_tls_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_list_client_tls_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_client_tls_policies_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_client_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_client_tls_policies parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_client_tls_policies ::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_client_tls_policies({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_client_tls_policies(::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_client_tls_policies_client_stub.call_count
      end
    end
  end

  def test_get_client_tls_policy
    # Create test objects.
    client_result = ::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_client_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_get_client_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_client_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_client_tls_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_client_tls_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_client_tls_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_client_tls_policy_client_stub.call_count
      end
    end
  end

  def test_create_client_tls_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    client_tls_policy_id = "hello world"
    client_tls_policy = {}

    create_client_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_create_client_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_client_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_client_tls_policy({ parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_client_tls_policy parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest.new(parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_client_tls_policy({ parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest.new(parent: parent, client_tls_policy_id: client_tls_policy_id, client_tls_policy: client_tls_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_client_tls_policy_client_stub.call_count
      end
    end
  end

  def test_update_client_tls_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    client_tls_policy = {}

    update_client_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_update_client_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_client_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_client_tls_policy({ update_mask: update_mask, client_tls_policy: client_tls_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_client_tls_policy update_mask: update_mask, client_tls_policy: client_tls_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest.new(update_mask: update_mask, client_tls_policy: client_tls_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_client_tls_policy({ update_mask: update_mask, client_tls_policy: client_tls_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest.new(update_mask: update_mask, client_tls_policy: client_tls_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_client_tls_policy_client_stub.call_count
      end
    end
  end

  def test_delete_client_tls_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_client_tls_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::ServiceStub.stub :transcode_delete_client_tls_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_client_tls_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_client_tls_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_client_tls_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_client_tls_policy ::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_client_tls_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_client_tls_policy(::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_client_tls_policy_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Rest::Client::Configuration, config
  end
end
