# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkSecurity
      module V1beta1
        # A DNS threat detector sends DNS query logs to a _provider_ that then
        # analyzes the logs to identify threat events in the DNS queries.
        # By default, all VPC networks in your projects are included. You can exclude
        # specific networks by supplying `excluded_networks`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. Identifier. Name of the DnsThreatDetector resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Any labels associated with the DnsThreatDetector, listed as key
        #     value pairs.
        # @!attribute [rw] excluded_networks
        #   @return [::Array<::String>]
        #     Optional. A list of network resource names which aren't monitored by this
        #     DnsThreatDetector.
        #
        #     Example:
        #     `projects/PROJECT_ID/global/networks/NETWORK_NAME`.
        # @!attribute [rw] provider
        #   @return [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector::Provider]
        #     Required. The provider used for DNS threat analysis.
        class DnsThreatDetector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Name of the provider used for DNS threat analysis.
          module Provider
            # An unspecified provider.
            PROVIDER_UNSPECIFIED = 0

            # The Infoblox DNS threat detector provider.
            INFOBLOX = 1
          end
        end

        # The message for requesting a list of DnsThreatDetectors in the project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent value for `ListDnsThreatDetectorsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The requested page size. The server may return fewer items than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token received from a previous
        #     `ListDnsThreatDetectorsRequest` call. Provide this to retrieve the
        #     subsequent page.
        class ListDnsThreatDetectorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message to requesting a list of DnsThreatDetectors.
        # @!attribute [rw] dns_threat_detectors
        #   @return [::Array<::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector>]
        #     The list of DnsThreatDetector resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token`, to retrieve the next page.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Unreachable `DnsThreatDetector` resources.
        class ListDnsThreatDetectorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message sent to get a DnsThreatDetector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the DnsThreatDetector resource.
        class GetDnsThreatDetectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message to create a DnsThreatDetector.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The value for the parent of the DnsThreatDetector resource.
        # @!attribute [rw] dns_threat_detector_id
        #   @return [::String]
        #     Optional. The ID of the requesting DnsThreatDetector object.
        #     If this field is not supplied, the service generates an identifier.
        # @!attribute [rw] dns_threat_detector
        #   @return [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
        #     Required. The `DnsThreatDetector` resource to create.
        class CreateDnsThreatDetectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message for updating a DnsThreatDetector.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The field mask is used to specify the fields to be overwritten in
        #     the DnsThreatDetector resource by the update. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field
        #     will be overwritten if it is in the mask. If the mask is not provided then
        #     all fields present in the request will be overwritten.
        # @!attribute [rw] dns_threat_detector
        #   @return [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
        #     Required. The DnsThreatDetector resource being updated.
        class UpdateDnsThreatDetectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message for deleting a DnsThreatDetector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the DnsThreatDetector resource.
        class DeleteDnsThreatDetectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
